/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.gen;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;

public class AggregatePropagation {
    public static final Trigger trig = new Trigger();
    private LirNode structRetVar;
    private LirNode structRetPtrVar;
    private LirFactory lir;
    private int typeAddress;

    public void doIt(Function func) {
        this.lir = func.newLir;
        this.typeAddress = func.module.targetMachine.typeAddress;
        this.structRetVar = null;
        BiLink p = func.flowGraph().exitBlk().instrList().first();
        while (!p.atEnd()) {
            LirNode op = (LirNode)p.elem();
            if (op.opCode == 55 && op.nKids() == 2 && op.kid((int)1).opCode == 47 && Type.isAggregate(op.kid((int)1).type) && op.kid((int)1).kid((int)0).opCode == 5) {
                this.structRetVar = op.kid(1).kid(0);
                p.setElem(this.lir.node(55, 0, op.kid(0)));
                break;
            }
            p = p.next();
        }
        if (this.structRetVar == null) {
            return;
        }
        func.touch();
        this.structRetPtrVar = func.newReg(".strretp", this.typeAddress);
        p = func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode stmt = (LirNode)q.elem();
                LirNode newStmt = this.testAndRewrite(stmt);
                if (newStmt != stmt) {
                    q.setElem(newStmt);
                }
                q = q.next();
            }
            p = p.next();
        }
        func.localSymtab.remove(((LirSymRef)this.structRetVar).symbol);
    }

    private LirNode testAndRewrite(LirNode node) {
        int n = node.nKids();
        for (int i = 0; i < n; ++i) {
            node.setKid(i, this.testAndRewrite(node.kid(i)));
        }
        if (node.opCode == 5 && ((LirSymRef)node).symbol == ((LirSymRef)this.structRetVar).symbol) {
            return this.structRetPtrVar;
        }
        return node;
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new AggregatePropagation().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "AggregatePropagation";
        }

        public String subject() {
            return "Aggregate Copy Propagation";
        }
    }
}

