/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.gen;

import coins.backend.CantHappenException;
import coins.backend.Function;
import coins.backend.SyntaxError;
import coins.backend.Transformer;
import coins.backend.Type;
import coins.backend.ana.SaveRegisters;
import coins.backend.gen.AggregatePropagation;
import coins.backend.gen.CodeGenerator;
import coins.backend.gen.Rule;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.SymAuto;
import coins.backend.sym.SymStatic;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.Misc;
import coins.backend.util.NumberSet;
import java.io.PrintWriter;

public class CodeGenerator_x86
extends CodeGenerator {
    State[] stateVec;
    private RewrState[] rewrStates;
    private static final Rule[] rulev = new Rule[338];
    ImList regCallClobbers = ImList.list(ImList.list("REG", "I32", "%eax"), ImList.list("REG", "I32", "%ecx"), ImList.list("REG", "I32", "%edx"));
    static final int MAXREGPARAM = 6;

    void initRewriteLabeling() {
        this.rewrStates = new RewrState[0];
    }

    private void setRewrStates(int index, RewrState v) {
        if (index >= this.rewrStates.length) {
            RewrState[] w = new RewrState[Misc.clp2(index + 1)];
            for (int i = 0; i < this.rewrStates.length; ++i) {
                w[i] = this.rewrStates[i];
            }
            this.rewrStates = w;
        }
        this.rewrStates[index] = v;
    }

    private RewrState getRewrStates(int index) {
        if (index < this.rewrStates.length) {
            return this.rewrStates[index];
        }
        return null;
    }

    LirNode rewriteTree(LirNode tree, String phase, BiList pre, BiList post) {
        RewrState s = this.getRewrStates(tree.id);
        if (s != null && !s.rewritten) {
            return tree;
        }
        while (true) {
            int n = this.nActualOperands(tree);
            RewrState[] kidst = new RewrState[n];
            for (int i = 0; i < n; ++i) {
                LirNode r = this.rewriteTree(tree.kid(i), phase, pre, post);
                if (r != tree.kid(i)) {
                    tree.setKid(i, r);
                }
                kidst[i] = this.getRewrStates(tree.kid((int)i).id);
            }
            s = new RewrState();
            this.setRewrStates(tree.id, s);
            if (this.disableRewrite.contains(tree.id)) {
                return tree;
            }
            LirNode newTree = s.labelAndRewrite(tree, kidst, phase, pre, post);
            if (newTree == null) {
                return tree;
            }
            tree = newTree;
        }
    }

    private static void rrinit0() {
        CodeGenerator_x86.rulev[76] = new Rule(76, true, false, 42, "76: mregq -> regq", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I64*"});
        CodeGenerator_x86.rulev[143] = new Rule(143, true, false, 61, "143: shfct -> regq", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-ebxecx-I64*"});
        CodeGenerator_x86.rulev[31] = new Rule(31, true, false, 19, "31: base -> regl", null, ImList.list(ImList.list("base", ImList.list(), "$1")), null, 0L, false, false, new int[]{2}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[35] = new Rule(35, true, false, 20, "35: index -> regl", null, ImList.list(ImList.list("index", "$1", "1")), null, 0L, false, false, new int[]{2}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[57] = new Rule(57, true, false, 33, "57: rcl -> regl", null, null, null, 0L, false, false, new int[]{2}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[66] = new Rule(66, true, false, 37, "66: mregl -> regl", null, null, null, 0L, false, false, new int[]{2}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[80] = new Rule(80, true, false, 44, "80: callarg -> regl", null, ImList.list(ImList.list("ind", "$1")), null, 0L, false, false, new int[]{2}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[144] = new Rule(144, true, false, 61, "144: shfct -> regl", null, null, null, 0L, false, false, new int[]{2}, new String[]{null, "*reg-ecx-I32*"});
        CodeGenerator_x86.rulev[189] = new Rule(189, true, false, 3, "189: reglb -> regl", null, null, null, 0L, false, false, new int[]{2}, new String[]{"*reg-I32*", "*reg-I32*"});
        CodeGenerator_x86.rulev[59] = new Rule(59, true, false, 34, "59: rcw -> regw", null, null, null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-I16*"});
        CodeGenerator_x86.rulev[70] = new Rule(70, true, false, 39, "70: mregw -> regw", null, null, null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-I16*"});
        CodeGenerator_x86.rulev[145] = new Rule(145, true, false, 61, "145: shfct -> regw", null, null, null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-cx-I16*"});
        CodeGenerator_x86.rulev[61] = new Rule(61, true, false, 35, "61: rcb -> regb", null, null, null, 0L, false, false, new int[]{5}, new String[]{null, "*reg-I8*"});
        CodeGenerator_x86.rulev[74] = new Rule(74, true, false, 41, "74: mregb -> regb", null, null, null, 0L, false, false, new int[]{5}, new String[]{null, "*reg-I8*"});
        CodeGenerator_x86.rulev[146] = new Rule(146, true, false, 61, "146: shfct -> regb", null, null, null, 0L, false, false, new int[]{5}, new String[]{null, "*reg-cl-I8*"});
        CodeGenerator_x86.rulev[190] = new Rule(190, true, false, 3, "190: reglb -> regb", ImList.list(ImList.list("movsbl", "$1", "$0")), null, null, 0L, false, false, new int[]{5}, new String[]{"*reg-I32*", "*reg-I8*"});
        CodeGenerator_x86.rulev[177] = new Rule(177, true, false, 63, "177: regmemf -> regf", null, null, null, 0L, false, false, new int[]{6}, new String[]{null, "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[175] = new Rule(175, true, false, 62, "175: regmemd -> regd", null, null, null, 0L, false, false, new int[]{7}, new String[]{null, "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[13] = new Rule(13, true, false, 5, "13: regb -> xregb", null, null, null, 0L, false, false, new int[]{9}, new String[]{"*reg-I8*", null});
        CodeGenerator_x86.rulev[14] = new Rule(14, true, false, 4, "14: regw -> xregw", null, null, null, 0L, false, false, new int[]{10}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86.rulev[15] = new Rule(15, true, false, 2, "15: regl -> xregl", null, null, null, 0L, false, false, new int[]{11}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86.rulev[16] = new Rule(16, true, false, 1, "16: regq -> xregq", null, null, null, 0L, false, false, new int[]{12}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86.rulev[17] = new Rule(17, true, false, 6, "17: regf -> xregf", null, null, null, 0L, false, false, new int[]{13}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[18] = new Rule(18, true, false, 7, "18: regd -> xregd", null, null, null, 0L, false, false, new int[]{14}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[25] = new Rule(25, true, false, 17, "25: asmcon -> con", null, null, null, 0L, false, false, new int[]{15}, new String[]{null, null});
        CodeGenerator_x86.rulev[60] = new Rule(60, true, false, 34, "60: rcw -> con", null, ImList.list(ImList.list("imm", "$1")), null, 0L, false, false, new int[]{15}, new String[]{null, null});
        CodeGenerator_x86.rulev[62] = new Rule(62, true, false, 35, "62: rcb -> con", null, ImList.list(ImList.list("imm", "$1")), null, 0L, false, false, new int[]{15}, new String[]{null, null});
        CodeGenerator_x86.rulev[78] = new Rule(78, true, false, 43, "78: mrcq -> con", null, ImList.list(ImList.list("imm", "$1")), null, 0L, false, false, new int[]{15}, new String[]{null, null});
        CodeGenerator_x86.rulev[26] = new Rule(26, true, false, 17, "26: asmcon -> sta", null, null, null, 0L, false, false, new int[]{16}, new String[]{null, null});
        CodeGenerator_x86.rulev[79] = new Rule(79, true, false, 44, "79: callarg -> sta", null, null, null, 0L, false, false, new int[]{16}, new String[]{null, null});
        CodeGenerator_x86.rulev[30] = new Rule(30, true, false, 19, "30: base -> asmcon", null, ImList.list(ImList.list("base", "$1", ImList.list())), null, 0L, false, false, new int[]{17}, new String[]{null, null});
        CodeGenerator_x86.rulev[58] = new Rule(58, true, false, 33, "58: rcl -> asmcon", null, ImList.list(ImList.list("imm", "$1")), null, 0L, false, false, new int[]{17}, new String[]{null, null});
        CodeGenerator_x86.rulev[47] = new Rule(47, true, false, 26, "47: addr -> base", null, ImList.list(ImList.list("addr", "$1", ImList.list())), null, 0L, false, false, new int[]{19}, new String[]{null, null});
        CodeGenerator_x86.rulev[48] = new Rule(48, true, false, 26, "48: addr -> index", null, ImList.list(ImList.list("addr", ImList.list(), "$1")), null, 0L, false, false, new int[]{20}, new String[]{null, null});
        CodeGenerator_x86.rulev[81] = new Rule(81, true, false, 2, "81: regl -> addr", ImList.list(ImList.list("leal", "$1", "$0")), null, null, 0L, false, false, new int[]{26}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86.rulev[75] = new Rule(75, true, false, 42, "75: mregq -> memq", null, null, null, 0L, false, false, new int[]{27}, new String[]{null, null});
        CodeGenerator_x86.rulev[142] = new Rule(142, true, false, 61, "142: shfct -> memq", ImList.list(ImList.list("movb", "$1", "$0")), null, null, 0L, false, false, new int[]{27}, new String[]{"*reg-cl-I8*", null});
        CodeGenerator_x86.rulev[63] = new Rule(63, true, false, 36, "63: mrcl -> meml", null, null, null, 0L, false, false, new int[]{28}, new String[]{null, null});
        CodeGenerator_x86.rulev[65] = new Rule(65, true, false, 37, "65: mregl -> meml", null, null, null, 0L, false, false, new int[]{28}, new String[]{null, null});
        CodeGenerator_x86.rulev[67] = new Rule(67, true, false, 38, "67: mrcw -> memw", null, null, null, 0L, false, false, new int[]{29}, new String[]{null, null});
        CodeGenerator_x86.rulev[69] = new Rule(69, true, false, 39, "69: mregw -> memw", null, null, null, 0L, false, false, new int[]{29}, new String[]{null, null});
        CodeGenerator_x86.rulev[71] = new Rule(71, true, false, 40, "71: mrcb -> memb", null, null, null, 0L, false, false, new int[]{30}, new String[]{null, null});
        CodeGenerator_x86.rulev[73] = new Rule(73, true, false, 41, "73: mregb -> memb", null, null, null, 0L, false, false, new int[]{30}, new String[]{null, null});
        CodeGenerator_x86.rulev[87] = new Rule(87, true, false, 6, "87: regf -> memf", ImList.list(ImList.list("flds", "$1", "$0")), null, null, 0L, false, false, new int[]{31}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[178] = new Rule(178, true, false, 63, "178: regmemf -> memf", null, null, null, 0L, false, false, new int[]{31}, new String[]{null, null});
        CodeGenerator_x86.rulev[86] = new Rule(86, true, false, 7, "86: regd -> memd", ImList.list(ImList.list("fldl", "$1", "$0")), null, null, 0L, false, false, new int[]{32}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[176] = new Rule(176, true, false, 62, "176: regmemd -> memd", null, null, null, 0L, false, false, new int[]{32}, new String[]{null, null});
        CodeGenerator_x86.rulev[64] = new Rule(64, true, false, 36, "64: mrcl -> rcl", null, null, null, 0L, false, false, new int[]{33}, new String[]{null, null});
        CodeGenerator_x86.rulev[68] = new Rule(68, true, false, 38, "68: mrcw -> rcw", null, null, null, 0L, false, false, new int[]{34}, new String[]{null, null});
        CodeGenerator_x86.rulev[72] = new Rule(72, true, false, 40, "72: mrcb -> rcb", null, null, null, 0L, false, false, new int[]{35}, new String[]{null, null});
        CodeGenerator_x86.rulev[83] = new Rule(83, true, false, 2, "83: regl -> mrcl", ImList.list(ImList.list("movl", "$1", "$0")), null, null, 0L, false, false, new int[]{36}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86.rulev[84] = new Rule(84, true, false, 4, "84: regw -> mrcw", ImList.list(ImList.list("movw", "$1", "$0")), null, null, 0L, false, false, new int[]{38}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86.rulev[85] = new Rule(85, true, false, 5, "85: regb -> mrcb", ImList.list(ImList.list("movb", "$1", "$0")), null, null, 0L, false, false, new int[]{40}, new String[]{"*reg-I8*", null});
        CodeGenerator_x86.rulev[77] = new Rule(77, true, false, 43, "77: mrcq -> mregq", null, null, null, 0L, false, false, new int[]{42}, new String[]{null, null});
        CodeGenerator_x86.rulev[82] = new Rule(82, true, false, 1, "82: regq -> mrcq", ImList.list(ImList.list("movl", ImList.list("qlow", "$1"), ImList.list("qlow", "$0")), ImList.list("movl", ImList.list("qhigh", "$1"), ImList.list("qhigh", "$0"))), null, null, 0L, true, false, new int[]{43}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86.rulev[19] = new Rule(19, false, false, 15, "19: con -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[36] = new Rule(36, false, true, 21, "36: _1 -> (INTCONST I32 2)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86.rulev[38] = new Rule(38, false, true, 22, "38: _2 -> (INTCONST I32 4)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86.rulev[40] = new Rule(40, false, true, 23, "40: _3 -> (INTCONST I32 8)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86.rulev[42] = new Rule(42, false, true, 24, "42: _4 -> (INTCONST I32 1)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86.rulev[45] = new Rule(45, false, true, 25, "45: _5 -> (INTCONST I32 3)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86.rulev[23] = new Rule(23, false, false, 6, "23: regf -> (FLOATCONST F32 0.0)", ImList.list(ImList.list("fldz", "$0")), null, null, 0L, false, false, new int[0], new String[]{"*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[24] = new Rule(24, false, false, 6, "24: regf -> (FLOATCONST F32 1.0)", ImList.list(ImList.list("fld1", "$0")), null, null, 0L, false, false, new int[0], new String[]{"*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[21] = new Rule(21, false, false, 7, "21: regd -> (FLOATCONST F64 0.0)", ImList.list(ImList.list("fldz", "$0")), null, null, 0L, false, false, new int[0], new String[]{"*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[22] = new Rule(22, false, false, 7, "22: regd -> (FLOATCONST F64 1.0)", ImList.list(ImList.list("fld1", "$0")), null, null, 0L, false, false, new int[0], new String[]{"*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[20] = new Rule(20, false, false, 16, "20: sta -> (STATIC I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[1] = new Rule(1, false, false, 9, "1: xregb -> (REG I8)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[3] = new Rule(3, false, false, 10, "3: xregw -> (REG I16)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[5] = new Rule(5, false, false, 11, "5: xregl -> (REG I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[100] = new Rule(100, false, true, 45, "100: _6 -> (REG I32 \"%esp\")", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86.rulev[9] = new Rule(9, false, false, 13, "9: xregf -> (REG F32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[7] = new Rule(7, false, false, 12, "7: xregq -> (REG I64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[11] = new Rule(11, false, false, 14, "11: xregd -> (REG F64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[2] = new Rule(2, false, false, 9, "2: xregb -> (SUBREG I8)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[4] = new Rule(4, false, false, 10, "4: xregw -> (SUBREG I16)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[6] = new Rule(6, false, false, 11, "6: xregl -> (SUBREG I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[10] = new Rule(10, false, false, 13, "10: xregf -> (SUBREG F32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[8] = new Rule(8, false, false, 12, "8: xregq -> (SUBREG I64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[12] = new Rule(12, false, false, 14, "12: xregd -> (SUBREG F64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[29] = new Rule(29, false, false, 18, "29: lab -> (LABEL I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86.rulev[161] = new Rule(161, false, false, 2, "161: regl -> (NEG I32 regl)", ImList.list(ImList.list("negl", "$0")), null, null, 2L, false, false, new int[]{2}, new String[]{"*reg-I32*", "*reg-I32*"});
        CodeGenerator_x86.rulev[188] = new Rule(188, false, false, 6, "188: regf -> (NEG F32 regf)", ImList.list(ImList.list("fchs", "$1", "$0")), null, null, 0L, false, false, new int[]{6}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[128] = new Rule(128, false, false, 1, "128: regq -> (NEG I64 regq)", ImList.list(ImList.list("negl", ImList.list("qlow", "$0")), ImList.list("adcl", ImList.list("imm", "0"), ImList.list("qhigh", "$0")), ImList.list("negl", ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1}, new String[]{"*reg-I64*", "*reg-I64*"});
        CodeGenerator_x86.rulev[183] = new Rule(183, false, false, 7, "183: regd -> (NEG F64 regd)", ImList.list(ImList.list("fchs", "$1", "$0")), null, null, 0L, false, false, new int[]{7}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[27] = new Rule(27, false, false, 17, "27: asmcon -> (ADD I32 asmcon con)", null, ImList.list(ImList.list("+", "$1", "$2")), null, 0L, false, false, new int[]{17, 15}, new String[]{null, null, null});
        CodeGenerator_x86.rulev[32] = new Rule(32, false, false, 19, "32: base -> (ADD I32 regl asmcon)", null, ImList.list(ImList.list("base", "$2", "$1")), null, 0L, false, false, new int[]{2, 17}, new String[]{null, "*reg-I32*", null});
        CodeGenerator_x86.rulev[33] = new Rule(33, false, false, 19, "33: base -> (ADD I32 asmcon regl)", null, ImList.list(ImList.list("base", "$1", "$2")), null, 0L, false, false, new int[]{17, 2}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86.rulev[49] = new Rule(49, false, false, 26, "49: addr -> (ADD I32 base index)", null, ImList.list(ImList.list("addr", "$1", "$2")), null, 0L, false, false, new int[]{19, 20}, new String[]{null, null, null});
        CodeGenerator_x86.rulev[50] = new Rule(50, false, false, 26, "50: addr -> (ADD I32 index base)", null, ImList.list(ImList.list("addr", "$2", "$1")), null, 0L, false, false, new int[]{20, 19}, new String[]{null, null, null});
        CodeGenerator_x86.rulev[152] = new Rule(152, false, false, 2, "152: regl -> (ADD I32 regl mrcl)", ImList.list(ImList.list("addl", "$2", "$0")), null, null, 2L, false, false, new int[]{2, 36}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[157] = new Rule(157, false, false, 2, "157: regl -> (ADD I32 mrcl regl)", ImList.list(ImList.list("addl", "$1", "$0")), null, null, 4L, false, false, new int[]{36, 2}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86.rulev[184] = new Rule(184, false, false, 6, "184: regf -> (ADD F32 regf regmemf)", ImList.list(ImList.list("fadd", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{6, 63}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[123] = new Rule(123, false, false, 1, "123: regq -> (ADD I64 regq mrcq)", ImList.list(ImList.list("addl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("adcl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 43}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[179] = new Rule(179, false, false, 7, "179: regd -> (ADD F64 regd regmemd)", ImList.list(ImList.list("fadd", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{7, 62}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[28] = new Rule(28, false, false, 17, "28: asmcon -> (SUB I32 asmcon con)", null, ImList.list(ImList.list("-", "$1", "$2")), null, 0L, false, false, new int[]{17, 15}, new String[]{null, null, null});
        CodeGenerator_x86.rulev[34] = new Rule(34, false, false, 19, "34: base -> (SUB I32 regl con)", null, ImList.list(ImList.list("base", ImList.list("minus", "$2"), "$1")), null, 0L, false, false, new int[]{2, 15}, new String[]{null, "*reg-I32*", null});
        CodeGenerator_x86.rulev[101] = new Rule(101, false, true, 46, "101: _7 -> (SUB I32 _6 regl)", null, null, null, 0L, false, false, new int[]{45, 2}, null);
        CodeGenerator_x86.rulev[103] = new Rule(103, false, true, 47, "103: _8 -> (SUB I32 _6 _3)", null, null, null, 0L, false, false, new int[]{45, 23}, null);
        CodeGenerator_x86.rulev[108] = new Rule(108, false, true, 51, "108: _12 -> (SUB I32 _6 _2)", null, null, null, 0L, false, false, new int[]{45, 22}, null);
        CodeGenerator_x86.rulev[153] = new Rule(153, false, false, 2, "153: regl -> (SUB I32 regl mrcl)", ImList.list(ImList.list("subl", "$2", "$0")), null, null, 2L, false, false, new int[]{2, 36}, new String[]{"*reg-I32*", "*reg-I32*", null});
    }

    private static void rrinit100() {
        CodeGenerator_x86.rulev[185] = new Rule(185, false, false, 6, "185: regf -> (SUB F32 regf regmemf)", ImList.list(ImList.list("fsub", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{6, 63}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[124] = new Rule(124, false, false, 1, "124: regq -> (SUB I64 regq mrcq)", ImList.list(ImList.list("subl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("sbbl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 43}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[180] = new Rule(180, false, false, 7, "180: regd -> (SUB F64 regd regmemd)", ImList.list(ImList.list("fsub", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{7, 62}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[37] = new Rule(37, false, false, 20, "37: index -> (MUL I32 regl _1)", null, ImList.list(ImList.list("index", "$1", "2")), null, 0L, false, false, new int[]{2, 21}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[39] = new Rule(39, false, false, 20, "39: index -> (MUL I32 regl _2)", null, ImList.list(ImList.list("index", "$1", "4")), null, 0L, false, false, new int[]{2, 22}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[41] = new Rule(41, false, false, 20, "41: index -> (MUL I32 regl _3)", null, ImList.list(ImList.list("index", "$1", "8")), null, 0L, false, false, new int[]{2, 23}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[169] = new Rule(169, false, false, 2, "169: regl -> (MUL I32 regl mrcl)", ImList.list(ImList.list("imull", "$2", "$0")), null, null, 2L, false, false, new int[]{2, 36}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[170] = new Rule(170, false, false, 2, "170: regl -> (MUL I32 mrcl regl)", ImList.list(ImList.list("imull", "$1", "$0")), null, null, 4L, false, false, new int[]{36, 2}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86.rulev[186] = new Rule(186, false, false, 6, "186: regf -> (MUL F32 regf regmemf)", ImList.list(ImList.list("fmul", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{6, 63}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[147] = new Rule(147, false, false, 1, "147: regq -> (MUL I64 regq regq)", new ImList(ImList.list("movl", ImList.list("qhigh", "$2"), "%ebx"), ImList.list(ImList.list("imull", "%eax", "%ebx"), ImList.list("imull", ImList.list("qlow", "$2"), "%edx"), ImList.list("addl", "%edx", "%ebx"), ImList.list("mull", ImList.list("qlow", "$2")), ImList.list("addl", "%ebx", "%edx"))), null, ImList.list(ImList.list("REG", "I32", "%ebx")), 0L, false, false, new int[]{1, 1}, new String[]{"*reg-edxeax-I64*", "*reg-edxeax-I64*", "*reg-I64*"});
        CodeGenerator_x86.rulev[181] = new Rule(181, false, false, 7, "181: regd -> (MUL F64 regd regmemd)", ImList.list(ImList.list("fmul", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{7, 62}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[171] = new Rule(171, false, false, 2, "171: regl -> (DIVS I32 regl regl)", ImList.list(ImList.list("cdq"), ImList.list("idivl", "$2")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 2L, false, false, new int[]{2, 2}, new String[]{"*reg-eax-I32*", "*reg-I32*", "*reg-mod$2-I32*"});
        CodeGenerator_x86.rulev[187] = new Rule(187, false, false, 6, "187: regf -> (DIVS F32 regf regmemf)", ImList.list(ImList.list("fdiv", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{6, 63}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[148] = new Rule(148, false, false, 1, "148: regq -> (DIVS I64 mrcq mrcq)", new ImList(ImList.list("pushl", ImList.list("qhigh", "$2")), ImList.list(ImList.list("pushl", ImList.list("qlow", "$2")), ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1")), ImList.list("call", ImList.list("symbol", "__divdi3")), ImList.list("addl", ImList.list("imm", "16"), "%esp"))), null, null, 0L, false, false, new int[]{43, 43}, new String[]{"*reg-edxeax-I64*", null, null});
        CodeGenerator_x86.rulev[182] = new Rule(182, false, false, 7, "182: regd -> (DIVS F64 regd regmemd)", ImList.list(ImList.list("fdiv", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{7, 62}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[172] = new Rule(172, false, false, 2, "172: regl -> (DIVU I32 regl regl)", ImList.list(ImList.list("xorl", "%edx", "%edx"), ImList.list("divl", "$2")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 2L, false, false, new int[]{2, 2}, new String[]{"*reg-eax-I32*", "*reg-I32*", "*reg-mod$2-I32*"});
        CodeGenerator_x86.rulev[149] = new Rule(149, false, false, 1, "149: regq -> (DIVU I64 mrcq mrcq)", new ImList(ImList.list("pushl", ImList.list("qhigh", "$2")), ImList.list(ImList.list("pushl", ImList.list("qlow", "$2")), ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1")), ImList.list("call", ImList.list("symbol", "__udivdi3")), ImList.list("addl", ImList.list("imm", "16"), "%esp"))), null, null, 0L, false, false, new int[]{43, 43}, new String[]{"*reg-edxeax-I64*", null, null});
        CodeGenerator_x86.rulev[173] = new Rule(173, false, false, 2, "173: regl -> (MODS I32 regl regl)", ImList.list(ImList.list("cdq"), ImList.list("idivl", "$2")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{2, 2}, new String[]{"*reg-edx-I32*", "*reg-eax-I32*", "*reg-mod$2-I32*"});
        CodeGenerator_x86.rulev[150] = new Rule(150, false, false, 1, "150: regq -> (MODS I64 mrcq mrcq)", new ImList(ImList.list("pushl", ImList.list("qhigh", "$2")), ImList.list(ImList.list("pushl", ImList.list("qlow", "$2")), ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1")), ImList.list("call", ImList.list("symbol", "__moddi3")), ImList.list("addl", ImList.list("imm", "16"), "%esp"))), null, null, 0L, false, false, new int[]{43, 43}, new String[]{"*reg-edxeax-I64*", null, null});
        CodeGenerator_x86.rulev[174] = new Rule(174, false, false, 2, "174: regl -> (MODU I32 regl regl)", ImList.list(ImList.list("xorl", "%edx", "%edx"), ImList.list("divl", "$2")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{2, 2}, new String[]{"*reg-edx-I32*", "*reg-eax-I32*", "*reg-mod$2-I32*"});
        CodeGenerator_x86.rulev[151] = new Rule(151, false, false, 1, "151: regq -> (MODU I64 mrcq mrcq)", new ImList(ImList.list("pushl", ImList.list("qhigh", "$2")), ImList.list(ImList.list("pushl", ImList.list("qlow", "$2")), ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1")), ImList.list("call", ImList.list("symbol", "__umoddi3")), ImList.list("addl", ImList.list("imm", "16"), "%esp"))), null, null, 0L, false, false, new int[]{43, 43}, new String[]{"*reg-edxeax-I64*", null, null});
        CodeGenerator_x86.rulev[196] = new Rule(196, false, false, 4, "196: regw -> (CONVSX I16 mregb)", ImList.list(ImList.list("movsbw", "$1", "$0")), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86.rulev[194] = new Rule(194, false, false, 2, "194: regl -> (CONVSX I32 mregw)", ImList.list(ImList.list("movswl", "$1", "$0")), null, null, 0L, false, false, new int[]{39}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86.rulev[195] = new Rule(195, false, false, 2, "195: regl -> (CONVSX I32 mregb)", ImList.list(ImList.list("movsbl", "$1", "$0")), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86.rulev[191] = new Rule(191, false, false, 1, "191: regq -> (CONVSX I64 regl)", ImList.list(ImList.list("cdq")), null, null, 0L, false, false, new int[]{2}, new String[]{"*reg-edxeax-I64*", "*reg-eax-I32*"});
        CodeGenerator_x86.rulev[192] = new Rule(192, false, false, 1, "192: regq -> (CONVSX I64 regw)", ImList.list(ImList.list("cwde"), ImList.list("cdq")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-edxeax-I64*", "*reg-ax-I16*"});
        CodeGenerator_x86.rulev[193] = new Rule(193, false, false, 1, "193: regq -> (CONVSX I64 regb)", ImList.list(ImList.list("movsbl", "%al", "%eax"), ImList.list("cdq")), null, null, 0L, false, false, new int[]{5}, new String[]{"*reg-edxeax-I64*", "*reg-al-I8*"});
        CodeGenerator_x86.rulev[203] = new Rule(203, false, false, 4, "203: regw -> (CONVZX I16 mregb)", ImList.list(ImList.list("movzbw", "$1", "$0")), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86.rulev[201] = new Rule(201, false, false, 2, "201: regl -> (CONVZX I32 mregw)", ImList.list(ImList.list("movzwl", "$1", "$0")), null, null, 0L, false, false, new int[]{39}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86.rulev[202] = new Rule(202, false, false, 2, "202: regl -> (CONVZX I32 mregb)", ImList.list(ImList.list("movzbl", "$1", "$0")), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86.rulev[197] = new Rule(197, false, false, 1, "197: regq -> (CONVZX I64 mregl)", ImList.list(ImList.list("movl", "$1", ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 0L, false, false, new int[]{37}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86.rulev[198] = new Rule(198, false, false, 1, "198: regq -> (CONVZX I64 mregw)", ImList.list(ImList.list("movzwl", "$1", ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 0L, false, false, new int[]{39}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86.rulev[199] = new Rule(199, false, false, 1, "199: regq -> (CONVZX I64 mregb)", ImList.list(ImList.list("movzwl", "$1", ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86.rulev[200] = new Rule(200, false, false, 1, "200: regq -> (CONVZX I64 mregb)", ImList.list(ImList.list("movl", "$1", ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86.rulev[206] = new Rule(206, false, false, 5, "206: regb -> (CONVIT I8 regq)", ImList.list(ImList.list("movb", ImList.list("regblow", ImList.list("qlow", "$1")), "$0")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-I8*", "*reg-bytable-I64*"});
        CodeGenerator_x86.rulev[208] = new Rule(208, false, false, 5, "208: regb -> (CONVIT I8 regl)", ImList.list(ImList.list("movb", ImList.list("regblow", "$1"), "$0")), null, null, 0L, false, false, new int[]{2}, new String[]{"*reg-I8*", "*reg-bytable-I32*"});
        CodeGenerator_x86.rulev[209] = new Rule(209, false, false, 5, "209: regb -> (CONVIT I8 regw)", ImList.list(ImList.list("movb", ImList.list("regblow", "$1"), "$0")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-I8*", "*reg-bytable-I16*"});
        CodeGenerator_x86.rulev[205] = new Rule(205, false, false, 4, "205: regw -> (CONVIT I16 regq)", ImList.list(ImList.list("movw", ImList.list("regwlow", ImList.list("qlow", "$1")), "$0")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-I16*", "*reg-I64*"});
        CodeGenerator_x86.rulev[207] = new Rule(207, false, false, 4, "207: regw -> (CONVIT I16 regl)", ImList.list(ImList.list("movw", ImList.list("regwlow", "$1"), "$0")), null, null, 0L, false, false, new int[]{2}, new String[]{"*reg-I16*", "*reg-I32*"});
        CodeGenerator_x86.rulev[204] = new Rule(204, false, false, 2, "204: regl -> (CONVIT I32 regq)", ImList.list(ImList.list("movl", ImList.list("qlow", "$1"), "$0")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-I32*", "*reg-I64*"});
        CodeGenerator_x86.rulev[222] = new Rule(222, false, false, 7, "222: regd -> (CONVFX F64 regf)", ImList.list(ImList.list("fmov", "$1", "$0")), null, null, 0L, false, false, new int[]{6}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[223] = new Rule(223, false, false, 6, "223: regf -> (CONVFT F32 regd)", ImList.list(ImList.list("fstps", "$1", ImList.list("reserve-tmpl")), ImList.list("flds", ImList.list("reserve-tmpl"), "$0")), null, null, 0L, false, false, new int[]{7}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[227] = new Rule(227, false, false, 5, "227: regb -> (CONVFS I8 regd)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "%ax"), new ImList(ImList.list("orw", ImList.list("imm", "3072"), "%ax"), ImList.list(ImList.list("movw", "%ax", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpl", "$1", ImList.list("reserve-tmpl")), ImList.list("movb", ImList.list("reserve-tmpl"), "$0"), ImList.list("fldcw", ImList.list("reserve-cw0")))))), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7}, new String[]{"*reg-I8*", "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[237] = new Rule(237, false, false, 5, "237: regb -> (CONVFS I8 regf)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "%ax"), new ImList(ImList.list("orw", ImList.list("imm", "3072"), "%ax"), ImList.list(ImList.list("movw", "%ax", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpl", "$1", ImList.list("reserve-tmpl")), ImList.list("movb", ImList.list("reserve-tmpl"), "$0"), ImList.list("fldcw", ImList.list("reserve-cw0")))))), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6}, new String[]{"*reg-I8*", "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[226] = new Rule(226, false, false, 4, "226: regw -> (CONVFS I16 regd)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "$0"), new ImList(ImList.list("orw", ImList.list("imm", "3072"), "$0"), ImList.list(ImList.list("movw", "$0", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpl", "$1", ImList.list("reserve-tmpl")), ImList.list("movw", ImList.list("reserve-tmpl"), "$0"), ImList.list("fldcw", ImList.list("reserve-cw0")))))), null, null, 0L, false, false, new int[]{7}, new String[]{"*reg-I16*", "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[232] = new Rule(232, false, true, 66, "232: _24 -> (CONVFS I16 regd)", null, null, null, 0L, false, false, new int[]{7}, null);
        CodeGenerator_x86.rulev[236] = new Rule(236, false, false, 4, "236: regw -> (CONVFS I16 regf)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "$0"), new ImList(ImList.list("orw", ImList.list("imm", "3072"), "$0"), ImList.list(ImList.list("movw", "$0", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpl", "$1", ImList.list("reserve-tmpl")), ImList.list("movw", ImList.list("reserve-tmpl"), "$0"), ImList.list("fldcw", ImList.list("reserve-cw0")))))), null, null, 0L, false, false, new int[]{6}, new String[]{"*reg-I16*", "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[242] = new Rule(242, false, true, 69, "242: _27 -> (CONVFS I16 regf)", null, null, null, 0L, false, false, new int[]{6}, null);
        CodeGenerator_x86.rulev[225] = new Rule(225, false, false, 2, "225: regl -> (CONVFS I32 regd)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), ImList.list("regwlow", "$0")), new ImList(ImList.list("orw", ImList.list("imm", "3072"), ImList.list("regwlow", "$0")), ImList.list(ImList.list("movw", ImList.list("regwlow", "$0"), ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpl", "$1", ImList.list("reserve-tmpl")), ImList.list("movl", ImList.list("reserve-tmpl"), "$0"), ImList.list("fldcw", ImList.list("reserve-cw0")))))), null, null, 0L, false, false, new int[]{7}, new String[]{"*reg-I32*", "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[230] = new Rule(230, false, true, 65, "230: _23 -> (CONVFS I32 regd)", null, null, null, 0L, false, false, new int[]{7}, null);
        CodeGenerator_x86.rulev[235] = new Rule(235, false, false, 2, "235: regl -> (CONVFS I32 regf)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), ImList.list("regwlow", "$0")), new ImList(ImList.list("orw", ImList.list("imm", "3072"), ImList.list("regwlow", "$0")), ImList.list(ImList.list("movw", ImList.list("regwlow", "$0"), ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpl", "$1", ImList.list("reserve-tmpl")), ImList.list("movl", ImList.list("reserve-tmpl"), "$0"), ImList.list("fldcw", ImList.list("reserve-cw0")))))), null, null, 0L, false, false, new int[]{6}, new String[]{"*reg-I32*", "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[240] = new Rule(240, false, true, 68, "240: _26 -> (CONVFS I32 regf)", null, null, null, 0L, false, false, new int[]{6}, null);
        CodeGenerator_x86.rulev[224] = new Rule(224, false, false, 1, "224: regq -> (CONVFS I64 regd)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), ImList.list("regwlow", ImList.list("qlow", "$0"))), new ImList(ImList.list("orw", ImList.list("imm", "3072"), ImList.list("regwlow", ImList.list("qlow", "$0"))), new ImList(ImList.list("movw", ImList.list("regwlow", ImList.list("qlow", "$0")), ImList.list("reserve-cw1")), ImList.list(ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpll", "$1", ImList.list("reserve-tmpq")), ImList.list("movl", ImList.list("qlow", ImList.list("reserve-tmpq")), ImList.list("qlow", "$0")), ImList.list("movl", ImList.list("qhigh", ImList.list("reserve-tmpq")), ImList.list("qhigh", "$0")), ImList.list("fldcw", ImList.list("reserve-cw0"))))))), null, null, 0L, false, false, new int[]{7}, new String[]{"*reg-I64*", "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[228] = new Rule(228, false, true, 64, "228: _22 -> (CONVFS I64 regd)", null, null, null, 0L, false, false, new int[]{7}, null);
        CodeGenerator_x86.rulev[234] = new Rule(234, false, false, 1, "234: regq -> (CONVFS I64 regf)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), ImList.list("regwlow", ImList.list("qlow", "$0"))), new ImList(ImList.list("orw", ImList.list("imm", "3072"), ImList.list("regwlow", ImList.list("qlow", "$0"))), new ImList(ImList.list("movw", ImList.list("regwlow", ImList.list("qlow", "$0")), ImList.list("reserve-cw1")), ImList.list(ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpll", "$1", ImList.list("reserve-tmpq")), ImList.list("movl", ImList.list("qlow", ImList.list("reserve-tmpq")), ImList.list("qlow", "$0")), ImList.list("movl", ImList.list("qhigh", ImList.list("reserve-tmpq")), ImList.list("qhigh", "$0")), ImList.list("fldcw", ImList.list("reserve-cw0"))))))), null, null, 0L, false, false, new int[]{6}, new String[]{"*reg-I64*", "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[238] = new Rule(238, false, true, 67, "238: _25 -> (CONVFS I64 regf)", null, null, null, 0L, false, false, new int[]{6}, null);
        CodeGenerator_x86.rulev[216] = new Rule(216, false, false, 6, "216: regf -> (CONVSF F32 memq)", ImList.list(ImList.list("fildll", "$1", "$0")), null, null, 0L, false, false, new int[]{27}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[217] = new Rule(217, false, false, 6, "217: regf -> (CONVSF F32 regq)", ImList.list(ImList.list("movl", ImList.list("qlow", "$1"), ImList.list("qlow", ImList.list("reserve-tmpq"))), ImList.list("movl", ImList.list("qhigh", "$1"), ImList.list("qhigh", ImList.list("reserve-tmpq"))), ImList.list("fildll", ImList.list("reserve-tmpq"), "$0")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-tmp-F32*", "*reg-I64*"});
        CodeGenerator_x86.rulev[218] = new Rule(218, false, false, 6, "218: regf -> (CONVSF F32 meml)", ImList.list(ImList.list("fildl", "$1", "$0")), null, null, 0L, false, false, new int[]{28}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[219] = new Rule(219, false, false, 6, "219: regf -> (CONVSF F32 reglb)", ImList.list(ImList.list("movl", "$1", ImList.list("reserve-tmpl")), ImList.list("fildl", ImList.list("reserve-tmpl"), "$0")), null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-tmp-F32*", "*reg-I32*"});
        CodeGenerator_x86.rulev[220] = new Rule(220, false, false, 6, "220: regf -> (CONVSF F32 memw)", ImList.list(ImList.list("filds", "$1", "$0")), null, null, 0L, false, false, new int[]{29}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86.rulev[221] = new Rule(221, false, false, 6, "221: regf -> (CONVSF F32 regw)", ImList.list(ImList.list("movw", "$1", ImList.list("reserve-tmpl")), ImList.list("filds", ImList.list("reserve-tmpl"), "$0")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-tmp-F32*", "*reg-I16*"});
        CodeGenerator_x86.rulev[210] = new Rule(210, false, false, 7, "210: regd -> (CONVSF F64 memq)", ImList.list(ImList.list("fildll", "$1", "$0")), null, null, 0L, false, false, new int[]{27}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[211] = new Rule(211, false, false, 7, "211: regd -> (CONVSF F64 regq)", ImList.list(ImList.list("movl", ImList.list("qlow", "$1"), ImList.list("qlow", ImList.list("reserve-tmpq"))), ImList.list("movl", ImList.list("qhigh", "$1"), ImList.list("qhigh", ImList.list("reserve-tmpq"))), ImList.list("fildll", ImList.list("reserve-tmpq"), "$0")), null, null, 0L, false, false, new int[]{1}, new String[]{"*reg-tmp-F64*", "*reg-I64*"});
        CodeGenerator_x86.rulev[212] = new Rule(212, false, false, 7, "212: regd -> (CONVSF F64 meml)", ImList.list(ImList.list("fildl", "$1", "$0")), null, null, 0L, false, false, new int[]{28}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[213] = new Rule(213, false, false, 7, "213: regd -> (CONVSF F64 reglb)", ImList.list(ImList.list("movl", "$1", ImList.list("reserve-tmpl")), ImList.list("fildl", ImList.list("reserve-tmpl"), "$0")), null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-tmp-F64*", "*reg-I32*"});
        CodeGenerator_x86.rulev[214] = new Rule(214, false, false, 7, "214: regd -> (CONVSF F64 memw)", ImList.list(ImList.list("filds", "$1", "$0")), null, null, 0L, false, false, new int[]{29}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86.rulev[215] = new Rule(215, false, false, 7, "215: regd -> (CONVSF F64 regw)", ImList.list(ImList.list("movw", "$1", ImList.list("reserve-tmpl")), ImList.list("filds", ImList.list("reserve-tmpl"), "$0")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-tmp-F64*", "*reg-I16*"});
        CodeGenerator_x86.rulev[154] = new Rule(154, false, false, 2, "154: regl -> (BAND I32 regl mrcl)", ImList.list(ImList.list("andl", "$2", "$0")), null, null, 2L, false, false, new int[]{2, 36}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[158] = new Rule(158, false, false, 2, "158: regl -> (BAND I32 mrcl regl)", ImList.list(ImList.list("andl", "$1", "$0")), null, null, 4L, false, false, new int[]{36, 2}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86.rulev[125] = new Rule(125, false, false, 1, "125: regq -> (BAND I64 regq mrcq)", ImList.list(ImList.list("andl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("andl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 43}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[155] = new Rule(155, false, false, 2, "155: regl -> (BOR I32 regl mrcl)", ImList.list(ImList.list("orl", "$2", "$0")), null, null, 2L, false, false, new int[]{2, 36}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[159] = new Rule(159, false, false, 2, "159: regl -> (BOR I32 mrcl regl)", ImList.list(ImList.list("orl", "$1", "$0")), null, null, 4L, false, false, new int[]{36, 2}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86.rulev[126] = new Rule(126, false, false, 1, "126: regq -> (BOR I64 regq mrcq)", ImList.list(ImList.list("orl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("orl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 43}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[156] = new Rule(156, false, false, 2, "156: regl -> (BXOR I32 regl mrcl)", ImList.list(ImList.list("xorl", "$2", "$0")), null, null, 2L, false, false, new int[]{2, 36}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[160] = new Rule(160, false, false, 2, "160: regl -> (BXOR I32 mrcl regl)", ImList.list(ImList.list("xorl", "$1", "$0")), null, null, 4L, false, false, new int[]{36, 2}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86.rulev[127] = new Rule(127, false, false, 1, "127: regq -> (BXOR I64 regq mrcq)", ImList.list(ImList.list("xorl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 43}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[162] = new Rule(162, false, false, 2, "162: regl -> (BNOT I32 regl)", ImList.list(ImList.list("notl", "$0")), null, null, 2L, false, false, new int[]{2}, new String[]{"*reg-I32*", "*reg-I32*"});
        CodeGenerator_x86.rulev[129] = new Rule(129, false, false, 1, "129: regq -> (BNOT I64 regq)", ImList.list(ImList.list("notl", ImList.list("qlow", "$0")), ImList.list("notl", ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1}, new String[]{"*reg-I64*", "*reg-I64*"});
        CodeGenerator_x86.rulev[43] = new Rule(43, false, false, 20, "43: index -> (LSHS I32 regl _4)", null, ImList.list(ImList.list("index", "$1", "2")), null, 0L, false, false, new int[]{2, 24}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[44] = new Rule(44, false, false, 20, "44: index -> (LSHS I32 regl _1)", null, ImList.list(ImList.list("index", "$1", "4")), null, 0L, false, false, new int[]{2, 21}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[46] = new Rule(46, false, false, 20, "46: index -> (LSHS I32 regl _5)", null, ImList.list(ImList.list("index", "$1", "8")), null, 0L, false, false, new int[]{2, 25}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86.rulev[163] = new Rule(163, false, false, 2, "163: regl -> (LSHS I32 regl con)", ImList.list(ImList.list("sall", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{2, 15}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[166] = new Rule(166, false, false, 2, "166: regl -> (LSHS I32 regl shfct)", ImList.list(ImList.list("sall", "%cl", "$0")), null, null, 2L, false, false, new int[]{2, 61}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[130] = new Rule(130, false, false, 1, "130: regq -> (LSHS I64 regq con)", ImList.list(ImList.list("shldl", ImList.list("imm", "$2"), ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), ImList.list("shll", ImList.list("imm", "$2"), ImList.list("qlow", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[131] = new Rule(131, false, false, 1, "131: regq -> (LSHS I64 regq con)", ImList.list(ImList.list("movl", ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), ImList.list("xorl", ImList.list("qlow", "$0"), ImList.list("qlow", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[132] = new Rule(132, false, false, 1, "132: regq -> (LSHS I64 regq con)", ImList.list(ImList.list("movl", ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), ImList.list("xorl", ImList.list("qlow", "$0"), ImList.list("qlow", "$0")), ImList.list("shll", ImList.list("imm", ImList.list("-32", "$2")), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[133] = new Rule(133, false, false, 1, "133: regq -> (LSHS I64 regq shfct)", new ImList(ImList.list("shldl", ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), new ImList(ImList.list("shll", "%cl", ImList.list("qlow", "$0")), ImList.list(ImList.list("testb", ImList.list("imm", "32"), "%cl"), ImList.list("je", "$L1"), ImList.list("movl", ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), ImList.list("xorl", ImList.list("qlow", "$0"), ImList.list("qlow", "$0")), ImList.list("deflabel", "$L1")))), null, null, 2L, false, false, new int[]{1, 61}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[164] = new Rule(164, false, false, 2, "164: regl -> (RSHS I32 regl con)", ImList.list(ImList.list("sarl", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{2, 15}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[167] = new Rule(167, false, false, 2, "167: regl -> (RSHS I32 regl shfct)", ImList.list(ImList.list("sarl", "%cl", "$0")), null, null, 2L, false, false, new int[]{2, 61}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[134] = new Rule(134, false, false, 1, "134: regq -> (RSHS I64 regq con)", ImList.list(ImList.list("shrdl", ImList.list("imm", "$2"), ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("sarl", ImList.list("imm", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[135] = new Rule(135, false, false, 1, "135: regq -> (RSHS I64 regq con)", ImList.list(ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("sarl", ImList.list("imm", "31"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[136] = new Rule(136, false, false, 1, "136: regq -> (RSHS I64 regq con)", ImList.list(ImList.list("sarl", ImList.list("imm", ImList.list("-32", "$2")), ImList.list("qhigh", "$0")), ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("sarl", ImList.list("imm", "31"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[137] = new Rule(137, false, false, 1, "137: regq -> (RSHS I64 regq shfct)", new ImList(ImList.list("shrdl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), new ImList(ImList.list("sarl", "%cl", ImList.list("qhigh", "$0")), ImList.list(ImList.list("testb", ImList.list("imm", "32"), "%cl"), ImList.list("je", "$L1"), ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("sarl", ImList.list("imm", "31"), ImList.list("qhigh", "$0")), ImList.list("deflabel", "$L1")))), null, null, 2L, false, false, new int[]{1, 61}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[165] = new Rule(165, false, false, 2, "165: regl -> (RSHU I32 regl con)", ImList.list(ImList.list("shrl", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{2, 15}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[168] = new Rule(168, false, false, 2, "168: regl -> (RSHU I32 regl shfct)", ImList.list(ImList.list("shrl", "%cl", "$0")), null, null, 2L, false, false, new int[]{2, 61}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86.rulev[138] = new Rule(138, false, false, 1, "138: regq -> (RSHU I64 regq con)", ImList.list(ImList.list("shrdl", ImList.list("imm", "$2"), ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("shrl", ImList.list("imm", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[139] = new Rule(139, false, false, 1, "139: regq -> (RSHU I64 regq con)", ImList.list(ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("xor", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[140] = new Rule(140, false, false, 1, "140: regq -> (RSHU I64 regq con)", ImList.list(ImList.list("shrl", ImList.list("imm", ImList.list("-32", "$2")), ImList.list("qhigh", "$0")), ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("xor", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{1, 15}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86.rulev[141] = new Rule(141, false, false, 1, "141: regq -> (RSHU I64 regq shfct)", new ImList(ImList.list("shrdl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), new ImList(ImList.list("shrl", "%cl", ImList.list("qhigh", "$0")), ImList.list(ImList.list("testb", ImList.list("imm", "32"), "%cl"), ImList.list("je", "$L1"), ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0")), ImList.list("deflabel", "$L1")))), null, null, 2L, false, false, new int[]{1, 61}, new String[]{"*reg-I64*", "*reg-I64*", null});
    }

    private static void rrinit200() {
        CodeGenerator_x86.rulev[245] = new Rule(245, false, true, 70, "245: _28 -> (TSTEQ I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[265] = new Rule(265, false, true, 80, "265: _38 -> (TSTEQ I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[285] = new Rule(285, false, true, 90, "285: _48 -> (TSTEQ I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[305] = new Rule(305, false, true, 100, "305: _58 -> (TSTEQ I32 regb mrcb)", null, null, null, 0L, false, false, new int[]{5, 40}, null);
        CodeGenerator_x86.rulev[309] = new Rule(309, false, true, 102, "309: _60 -> (TSTEQ I32 mrcb regb)", null, null, null, 0L, false, false, new int[]{40, 5}, null);
        CodeGenerator_x86.rulev[313] = new Rule(313, false, true, 104, "313: _62 -> (TSTEQ I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{7, 62}, null);
        CodeGenerator_x86.rulev[317] = new Rule(317, false, true, 106, "317: _64 -> (TSTEQ I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{6, 63}, null);
        CodeGenerator_x86.rulev[247] = new Rule(247, false, true, 71, "247: _29 -> (TSTNE I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[267] = new Rule(267, false, true, 81, "267: _39 -> (TSTNE I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[287] = new Rule(287, false, true, 91, "287: _49 -> (TSTNE I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[307] = new Rule(307, false, true, 101, "307: _59 -> (TSTNE I32 regb mrcb)", null, null, null, 0L, false, false, new int[]{5, 40}, null);
        CodeGenerator_x86.rulev[311] = new Rule(311, false, true, 103, "311: _61 -> (TSTNE I32 mrcb regb)", null, null, null, 0L, false, false, new int[]{40, 5}, null);
        CodeGenerator_x86.rulev[315] = new Rule(315, false, true, 105, "315: _63 -> (TSTNE I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{7, 62}, null);
        CodeGenerator_x86.rulev[319] = new Rule(319, false, true, 107, "319: _65 -> (TSTNE I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{6, 63}, null);
        CodeGenerator_x86.rulev[249] = new Rule(249, false, true, 72, "249: _30 -> (TSTLTS I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[269] = new Rule(269, false, true, 82, "269: _40 -> (TSTLTS I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[289] = new Rule(289, false, true, 92, "289: _50 -> (TSTLTS I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[321] = new Rule(321, false, true, 108, "321: _66 -> (TSTLTS I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{7, 62}, null);
        CodeGenerator_x86.rulev[325] = new Rule(325, false, true, 110, "325: _68 -> (TSTLTS I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{6, 63}, null);
        CodeGenerator_x86.rulev[251] = new Rule(251, false, true, 73, "251: _31 -> (TSTLES I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[271] = new Rule(271, false, true, 83, "271: _41 -> (TSTLES I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[291] = new Rule(291, false, true, 93, "291: _51 -> (TSTLES I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[331] = new Rule(331, false, true, 113, "331: _71 -> (TSTLES I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{7, 62}, null);
        CodeGenerator_x86.rulev[335] = new Rule(335, false, true, 115, "335: _73 -> (TSTLES I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{6, 63}, null);
        CodeGenerator_x86.rulev[253] = new Rule(253, false, true, 74, "253: _32 -> (TSTGTS I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[273] = new Rule(273, false, true, 84, "273: _42 -> (TSTGTS I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[293] = new Rule(293, false, true, 94, "293: _52 -> (TSTGTS I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[329] = new Rule(329, false, true, 112, "329: _70 -> (TSTGTS I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{7, 62}, null);
        CodeGenerator_x86.rulev[333] = new Rule(333, false, true, 114, "333: _72 -> (TSTGTS I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{6, 63}, null);
        CodeGenerator_x86.rulev[255] = new Rule(255, false, true, 75, "255: _33 -> (TSTGES I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[275] = new Rule(275, false, true, 85, "275: _43 -> (TSTGES I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[295] = new Rule(295, false, true, 95, "295: _53 -> (TSTGES I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[323] = new Rule(323, false, true, 109, "323: _67 -> (TSTGES I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{7, 62}, null);
        CodeGenerator_x86.rulev[327] = new Rule(327, false, true, 111, "327: _69 -> (TSTGES I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{6, 63}, null);
        CodeGenerator_x86.rulev[257] = new Rule(257, false, true, 76, "257: _34 -> (TSTLTU I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[277] = new Rule(277, false, true, 86, "277: _44 -> (TSTLTU I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[297] = new Rule(297, false, true, 96, "297: _54 -> (TSTLTU I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[259] = new Rule(259, false, true, 77, "259: _35 -> (TSTLEU I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[279] = new Rule(279, false, true, 87, "279: _45 -> (TSTLEU I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[299] = new Rule(299, false, true, 97, "299: _55 -> (TSTLEU I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[261] = new Rule(261, false, true, 78, "261: _36 -> (TSTGTU I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[281] = new Rule(281, false, true, 88, "281: _46 -> (TSTGTU I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[301] = new Rule(301, false, true, 98, "301: _56 -> (TSTGTU I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[263] = new Rule(263, false, true, 79, "263: _37 -> (TSTGEU I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{1, 43}, null);
        CodeGenerator_x86.rulev[283] = new Rule(283, false, true, 89, "283: _47 -> (TSTGEU I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{2, 36}, null);
        CodeGenerator_x86.rulev[303] = new Rule(303, false, true, 99, "303: _57 -> (TSTGEU I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{36, 2}, null);
        CodeGenerator_x86.rulev[54] = new Rule(54, false, false, 30, "54: memb -> (MEM I8 addr)", null, ImList.list(ImList.list("mem", "byte", "$1")), null, 0L, false, false, new int[]{26}, new String[]{null, null});
        CodeGenerator_x86.rulev[53] = new Rule(53, false, false, 29, "53: memw -> (MEM I16 addr)", null, ImList.list(ImList.list("mem", "word", "$1")), null, 0L, false, false, new int[]{26}, new String[]{null, null});
        CodeGenerator_x86.rulev[52] = new Rule(52, false, false, 28, "52: meml -> (MEM I32 addr)", null, ImList.list(ImList.list("mem", "long", "$1")), null, 0L, false, false, new int[]{26}, new String[]{null, null});
        CodeGenerator_x86.rulev[109] = new Rule(109, false, true, 52, "109: _13 -> (MEM I32 _12)", null, null, null, 0L, false, false, new int[]{51}, null);
        CodeGenerator_x86.rulev[55] = new Rule(55, false, false, 31, "55: memf -> (MEM F32 addr)", null, ImList.list(ImList.list("mem", "float", "$1")), null, 0L, false, false, new int[]{26}, new String[]{null, null});
        CodeGenerator_x86.rulev[113] = new Rule(113, false, true, 55, "113: _16 -> (MEM F32 _12)", null, null, null, 0L, false, false, new int[]{51}, null);
        CodeGenerator_x86.rulev[51] = new Rule(51, false, false, 27, "51: memq -> (MEM I64 addr)", null, ImList.list(ImList.list("mem", "quad", "$1")), null, 0L, false, false, new int[]{26}, new String[]{null, null});
        CodeGenerator_x86.rulev[104] = new Rule(104, false, true, 48, "104: _9 -> (MEM I64 _8)", null, null, null, 0L, false, false, new int[]{47}, null);
        CodeGenerator_x86.rulev[56] = new Rule(56, false, false, 32, "56: memd -> (MEM F64 addr)", null, ImList.list(ImList.list("mem", "double", "$1")), null, 0L, false, false, new int[]{26}, new String[]{null, null});
        CodeGenerator_x86.rulev[116] = new Rule(116, false, true, 57, "116: _18 -> (MEM F64 _8)", null, null, null, 0L, false, false, new int[]{47}, null);
        CodeGenerator_x86.rulev[91] = new Rule(91, false, false, 8, "91: void -> (SET I8 memb rcb)", ImList.list(ImList.list("movb", "$2", "$1")), null, null, 0L, false, false, new int[]{30, 35}, new String[]{null, null, null});
        CodeGenerator_x86.rulev[95] = new Rule(95, false, false, 8, "95: void -> (SET I8 xregb regb)", ImList.list(ImList.list("movb", "$2", "$1")), null, null, 0L, false, false, new int[]{9, 5}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86.rulev[90] = new Rule(90, false, false, 8, "90: void -> (SET I16 memw rcw)", ImList.list(ImList.list("movw", "$2", "$1")), null, null, 0L, false, false, new int[]{29, 34}, new String[]{null, null, null});
        CodeGenerator_x86.rulev[94] = new Rule(94, false, false, 8, "94: void -> (SET I16 xregw regw)", ImList.list(ImList.list("movw", "$2", "$1")), null, null, 0L, false, false, new int[]{10, 4}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86.rulev[89] = new Rule(89, false, false, 8, "89: void -> (SET I32 meml rcl)", ImList.list(ImList.list("movl", "$2", "$1")), null, null, 0L, false, false, new int[]{28, 33}, new String[]{null, null, null});
        CodeGenerator_x86.rulev[93] = new Rule(93, false, false, 8, "93: void -> (SET I32 xregl regl)", ImList.list(ImList.list("movl", "$2", "$1")), null, null, 0L, false, false, new int[]{11, 2}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86.rulev[102] = new Rule(102, false, false, 8, "102: void -> (SET I32 _6 _7)", ImList.list(ImList.list("call", ImList.list("symbol", "_alloca"))), null, null, 0L, false, false, new int[]{45, 46}, new String[]{null, "*reg-eax-I32*"});
        CodeGenerator_x86.rulev[106] = new Rule(106, false, true, 50, "106: _11 -> (SET I32 _6 _8)", null, null, null, 0L, false, false, new int[]{45, 47}, null);
        CodeGenerator_x86.rulev[110] = new Rule(110, false, true, 53, "110: _14 -> (SET I32 _13 mrcl)", null, null, null, 0L, false, false, new int[]{52, 36}, null);
        CodeGenerator_x86.rulev[111] = new Rule(111, false, true, 54, "111: _15 -> (SET I32 _6 _12)", null, null, null, 0L, false, false, new int[]{45, 51}, null);
        CodeGenerator_x86.rulev[231] = new Rule(231, false, false, 8, "231: void -> (SET I32 meml _23)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "%ax"), ImList.list(ImList.list("orw", ImList.list("imm", "3072"), "%ax"), ImList.list("movw", "%ax", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpl", "$2", "$1"), ImList.list("fldcw", ImList.list("reserve-cw0"))))), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, true, false, new int[]{28, 65}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[233] = new Rule(233, false, false, 8, "233: void -> (SET I32 memw _24)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "%ax"), ImList.list(ImList.list("orw", ImList.list("imm", "3072"), "%ax"), ImList.list("movw", "%ax", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistps", "$2", "$1"), ImList.list("fldcw", ImList.list("reserve-cw0"))))), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, true, false, new int[]{29, 66}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[241] = new Rule(241, false, false, 8, "241: void -> (SET I32 meml _26)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "%ax"), ImList.list(ImList.list("orw", ImList.list("imm", "3072"), "%ax"), ImList.list("movw", "%ax", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpl", "$2", "$1"), ImList.list("fldcw", ImList.list("reserve-cw0"))))), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, true, false, new int[]{28, 68}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[243] = new Rule(243, false, false, 8, "243: void -> (SET I32 memw _27)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "%ax"), ImList.list(ImList.list("orw", ImList.list("imm", "3072"), "%ax"), ImList.list("movw", "%ax", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistps", "$2", "$1"), ImList.list("fldcw", ImList.list("reserve-cw0"))))), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, true, false, new int[]{29, 69}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[96] = new Rule(96, false, false, 8, "96: void -> (SET F32 xregf regf)", ImList.list(ImList.list("fmov", "$2", "$1")), null, null, 0L, false, false, new int[]{13, 6}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[99] = new Rule(99, false, false, 8, "99: void -> (SET F32 memf regf)", ImList.list(ImList.list("fstp", "$2", "$1")), null, null, 0L, false, false, new int[]{31, 6}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[114] = new Rule(114, false, true, 56, "114: _17 -> (SET F32 _16 memf)", null, null, null, 0L, false, false, new int[]{55, 31}, null);
        CodeGenerator_x86.rulev[119] = new Rule(119, false, true, 59, "119: _20 -> (SET F32 _16 regf)", null, null, null, 0L, false, false, new int[]{55, 6}, null);
        CodeGenerator_x86.rulev[88] = new Rule(88, false, false, 8, "88: void -> (SET I64 memq regq)", ImList.list(ImList.list("movl", ImList.list("qlow", "$2"), "$1"), ImList.list("movl", ImList.list("qhigh", "$2"), ImList.list("after", "$1", "4"))), null, null, 0L, false, false, new int[]{27, 1}, new String[]{null, null, "*reg-I64*"});
        CodeGenerator_x86.rulev[92] = new Rule(92, false, false, 8, "92: void -> (SET I64 xregq regq)", ImList.list(ImList.list("movl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("movl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1"))), null, null, 0L, false, false, new int[]{12, 1}, new String[]{null, null, "*reg-I64*"});
        CodeGenerator_x86.rulev[105] = new Rule(105, false, true, 49, "105: _10 -> (SET I64 _9 mrcq)", null, null, null, 0L, false, false, new int[]{48, 43}, null);
        CodeGenerator_x86.rulev[229] = new Rule(229, false, false, 8, "229: void -> (SET I64 memq _22)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "%ax"), ImList.list(ImList.list("orw", ImList.list("imm", "3072"), "%ax"), ImList.list("movw", "%ax", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpll", "$2", "$1"), ImList.list("fldcw", ImList.list("reserve-cw0"))))), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, true, false, new int[]{27, 64}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[239] = new Rule(239, false, false, 8, "239: void -> (SET I64 memq _25)", new ImList(ImList.list("fnstcw", ImList.list("reserve-cw0")), new ImList(ImList.list("movw", ImList.list("reserve-cw0"), "%ax"), ImList.list(ImList.list("orw", ImList.list("imm", "3072"), "%ax"), ImList.list("movw", "%ax", ImList.list("reserve-cw1")), ImList.list("fldcw", ImList.list("reserve-cw1")), ImList.list("fistpll", "$2", "$1"), ImList.list("fldcw", ImList.list("reserve-cw0"))))), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, true, false, new int[]{27, 67}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[97] = new Rule(97, false, false, 8, "97: void -> (SET F64 xregd regd)", ImList.list(ImList.list("fmov", "$2", "$1")), null, null, 0L, false, false, new int[]{14, 7}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[98] = new Rule(98, false, false, 8, "98: void -> (SET F64 memd regd)", ImList.list(ImList.list("fstp", "$2", "$1")), null, null, 0L, false, false, new int[]{32, 7}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86.rulev[117] = new Rule(117, false, true, 58, "117: _19 -> (SET F64 _18 memd)", null, null, null, 0L, false, false, new int[]{57, 32}, null);
        CodeGenerator_x86.rulev[121] = new Rule(121, false, true, 60, "121: _21 -> (SET F64 _18 regd)", null, null, null, 0L, false, false, new int[]{57, 7}, null);
        CodeGenerator_x86.rulev[244] = new Rule(244, false, false, 8, "244: void -> (JUMP _ lab)", ImList.list(ImList.list("jmp", "$1")), null, null, 0L, false, false, new int[]{18}, new String[]{null, null});
        CodeGenerator_x86.rulev[246] = new Rule(246, false, false, 8, "246: void -> (JUMPC _ _28 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jne", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{70, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[248] = new Rule(248, false, false, 8, "248: void -> (JUMPC _ _29 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jne", "$3"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{71, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[250] = new Rule(250, false, false, 8, "250: void -> (JUMPC _ _30 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jl", "$3"), ImList.list("jg", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{72, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[252] = new Rule(252, false, false, 8, "252: void -> (JUMPC _ _31 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jl", "$3"), ImList.list("jg", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{73, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[254] = new Rule(254, false, false, 8, "254: void -> (JUMPC _ _32 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jg", "$3"), ImList.list("jl", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{74, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[256] = new Rule(256, false, false, 8, "256: void -> (JUMPC _ _33 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jg", "$3"), ImList.list("jl", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{75, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[258] = new Rule(258, false, false, 8, "258: void -> (JUMPC _ _34 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jb", "$3"), ImList.list("ja", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{76, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[260] = new Rule(260, false, false, 8, "260: void -> (JUMPC _ _35 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jb", "$3"), ImList.list("ja", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{77, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[262] = new Rule(262, false, false, 8, "262: void -> (JUMPC _ _36 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("ja", "$3"), ImList.list("jb", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{78, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[264] = new Rule(264, false, false, 8, "264: void -> (JUMPC _ _37 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("ja", "$3"), ImList.list("jb", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{79, 18, 18}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86.rulev[266] = new Rule(266, false, false, 8, "266: void -> (JUMPC _ _38 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{80, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[268] = new Rule(268, false, false, 8, "268: void -> (JUMPC _ _39 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{81, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[270] = new Rule(270, false, false, 8, "270: void -> (JUMPC _ _40 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jl", "$3")), null, null, 0L, false, false, new int[]{82, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[272] = new Rule(272, false, false, 8, "272: void -> (JUMPC _ _41 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jle", "$3")), null, null, 0L, false, false, new int[]{83, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[274] = new Rule(274, false, false, 8, "274: void -> (JUMPC _ _42 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jg", "$3")), null, null, 0L, false, false, new int[]{84, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[276] = new Rule(276, false, false, 8, "276: void -> (JUMPC _ _43 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jge", "$3")), null, null, 0L, false, false, new int[]{85, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
    }

    private static void rrinit300() {
        CodeGenerator_x86.rulev[278] = new Rule(278, false, false, 8, "278: void -> (JUMPC _ _44 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{86, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[280] = new Rule(280, false, false, 8, "280: void -> (JUMPC _ _45 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{87, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[282] = new Rule(282, false, false, 8, "282: void -> (JUMPC _ _46 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{88, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[284] = new Rule(284, false, false, 8, "284: void -> (JUMPC _ _47 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{89, 18, 18}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86.rulev[286] = new Rule(286, false, false, 8, "286: void -> (JUMPC _ _48 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{90, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[288] = new Rule(288, false, false, 8, "288: void -> (JUMPC _ _49 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{91, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[290] = new Rule(290, false, false, 8, "290: void -> (JUMPC _ _50 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jg", "$3")), null, null, 0L, false, false, new int[]{92, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[292] = new Rule(292, false, false, 8, "292: void -> (JUMPC _ _51 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jge", "$3")), null, null, 0L, false, false, new int[]{93, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[294] = new Rule(294, false, false, 8, "294: void -> (JUMPC _ _52 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jl", "$3")), null, null, 0L, false, false, new int[]{94, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[296] = new Rule(296, false, false, 8, "296: void -> (JUMPC _ _53 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jle", "$3")), null, null, 0L, false, false, new int[]{95, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[298] = new Rule(298, false, false, 8, "298: void -> (JUMPC _ _54 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{96, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[300] = new Rule(300, false, false, 8, "300: void -> (JUMPC _ _55 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{97, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[302] = new Rule(302, false, false, 8, "302: void -> (JUMPC _ _56 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{98, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[304] = new Rule(304, false, false, 8, "304: void -> (JUMPC _ _57 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{99, 18, 18}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86.rulev[306] = new Rule(306, false, false, 8, "306: void -> (JUMPC _ _58 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{100, 18, 18}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86.rulev[308] = new Rule(308, false, false, 8, "308: void -> (JUMPC _ _59 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{101, 18, 18}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86.rulev[310] = new Rule(310, false, false, 8, "310: void -> (JUMPC _ _60 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{102, 18, 18}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86.rulev[312] = new Rule(312, false, false, 8, "312: void -> (JUMPC _ _61 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{103, 18, 18}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86.rulev[314] = new Rule(314, false, false, 8, "314: void -> (JUMPC _ _62 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("and", ImList.list("imm", "69"), "%ah"), ImList.list("cmp", ImList.list("imm", "64"), "%ah"), ImList.list("je", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{104, 18, 18}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86.rulev[316] = new Rule(316, false, false, 8, "316: void -> (JUMPC _ _63 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("and", ImList.list("imm", "69"), "%ah"), ImList.list("cmp", ImList.list("imm", "64"), "%ah"), ImList.list("jne", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{105, 18, 18}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86.rulev[318] = new Rule(318, false, false, 8, "318: void -> (JUMPC _ _64 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("and", ImList.list("imm", "69"), "%ah"), ImList.list("cmp", ImList.list("imm", "64"), "%ah"), ImList.list("je", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{106, 18, 18}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86.rulev[320] = new Rule(320, false, false, 8, "320: void -> (JUMPC _ _65 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("and", ImList.list("imm", "69"), "%ah"), ImList.list("cmp", ImList.list("imm", "64"), "%ah"), ImList.list("jne", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{107, 18, 18}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86.rulev[322] = new Rule(322, false, false, 8, "322: void -> (JUMPC _ _66 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("andb", ImList.list("imm", "69"), "%ah"), ImList.list("cmpb", ImList.list("imm", "1"), "%ah"), ImList.list("je", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{108, 18, 18}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86.rulev[324] = new Rule(324, false, false, 8, "324: void -> (JUMPC _ _67 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("andb", ImList.list("imm", "69"), "%ah"), ImList.list("cmpb", ImList.list("imm", "1"), "%ah"), ImList.list("jne", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{109, 18, 18}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86.rulev[326] = new Rule(326, false, false, 8, "326: void -> (JUMPC _ _68 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("andb", ImList.list("imm", "69"), "%ah"), ImList.list("cmpb", ImList.list("imm", "1"), "%ah"), ImList.list("je", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{110, 18, 18}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86.rulev[328] = new Rule(328, false, false, 8, "328: void -> (JUMPC _ _69 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("andb", ImList.list("imm", "69"), "%ah"), ImList.list("cmpb", ImList.list("imm", "1"), "%ah"), ImList.list("jne", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{111, 18, 18}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86.rulev[330] = new Rule(330, false, false, 8, "330: void -> (JUMPC _ _70 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("andb", ImList.list("imm", "69"), "%ah"), ImList.list("je", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{112, 18, 18}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86.rulev[332] = new Rule(332, false, false, 8, "332: void -> (JUMPC _ _71 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("andb", ImList.list("imm", "69"), "%ah"), ImList.list("jne", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{113, 18, 18}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86.rulev[334] = new Rule(334, false, false, 8, "334: void -> (JUMPC _ _72 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("andb", ImList.list("imm", "69"), "%ah"), ImList.list("je", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{114, 18, 18}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86.rulev[336] = new Rule(336, false, false, 8, "336: void -> (JUMPC _ _73 lab lab)", ImList.list(ImList.list("fcom", "$2", "$1"), ImList.list("fnstsw", "%ax"), ImList.list("andb", ImList.list("imm", "69"), "%ah"), ImList.list("jne", "$3")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{115, 18, 18}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86.rulev[337] = new Rule(337, false, false, 8, "337: void -> (CALL _ callarg)", ImList.list(ImList.list("call", "$1")), null, null, 0L, false, false, new int[]{44}, new String[]{null, null});
        CodeGenerator_x86.rulev[107] = new Rule(107, false, false, 8, "107: void -> (PARALLEL _ _10 _11)", ImList.list(ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1"))), null, null, 0L, false, false, new int[]{49, 50}, new String[]{null, null});
        CodeGenerator_x86.rulev[112] = new Rule(112, false, false, 8, "112: void -> (PARALLEL _ _14 _15)", ImList.list(ImList.list("pushl", "$1")), null, null, 0L, false, false, new int[]{53, 54}, new String[]{null, null});
        CodeGenerator_x86.rulev[115] = new Rule(115, false, false, 8, "115: void -> (PARALLEL _ _17 _15)", ImList.list(ImList.list("pushl", "$1")), null, null, 0L, false, false, new int[]{56, 54}, new String[]{null, null});
        CodeGenerator_x86.rulev[118] = new Rule(118, false, false, 8, "118: void -> (PARALLEL _ _19 _11)", ImList.list(ImList.list("pushl", ImList.list("after", "$1", "4")), ImList.list("pushl", "$1")), null, null, 0L, false, false, new int[]{58, 50}, new String[]{null, null});
        CodeGenerator_x86.rulev[120] = new Rule(120, false, false, 8, "120: void -> (PARALLEL _ _20 _15)", ImList.list(ImList.list("sub", ImList.list("imm", "4"), "%esp"), ImList.list("fstp", "$1", ImList.list("mem", "float", ImList.list("addr", ImList.list("base", ImList.list(), "%esp"), ImList.list())))), null, null, 0L, false, false, new int[]{59, 54}, new String[]{null, "*reg-tmp-F32*"});
        CodeGenerator_x86.rulev[122] = new Rule(122, false, false, 8, "122: void -> (PARALLEL _ _21 _11)", ImList.list(ImList.list("sub", ImList.list("imm", "8"), "%esp"), ImList.list("fstp", "$1", ImList.list("mem", "double", ImList.list("addr", ImList.list("base", ImList.list(), "%esp"), ImList.list())))), null, null, 0L, false, false, new int[]{60, 50}, new String[]{null, "*reg-tmp-F64*"});
    }

    String defaultRegsetForType(int type) {
        switch (type) {
            case 1026: {
                return "*reg-I64*";
            }
            case 514: {
                return "*reg-I32*";
            }
            case 258: {
                return "*reg-I16*";
            }
            case 130: {
                return "*reg-I8*";
            }
        }
        return null;
    }

    void initLabeling(LirFactory lir) {
        this.stateVec = new State[lir.idBound()];
    }

    String showLabel(LirNode t) {
        return this.stateVec[t.id].toString();
    }

    void labelTree(LirNode t) {
        if (this.stateVec[t.id] == null) {
            State st;
            int n = this.nActualOperands(t);
            State[] kid = new State[n];
            for (int i = 0; i < n; ++i) {
                LirNode s = t.kid(i);
                this.labelTree(s);
                kid[i] = this.stateVec[s.id];
            }
            this.stateVec[t.id] = st = new State();
            st.label(t, kid);
        }
    }

    Rule getRule(LirNode t, int goal) {
        return rulev[this.stateVec[t.id].rule[goal]];
    }

    int getCost1(LirNode t, int goal) {
        return this.stateVec[t.id].cost1[goal];
    }

    int getCost2(LirNode t, int goal) {
        return this.stateVec[t.id].cost2[goal];
    }

    int startNT() {
        return 8;
    }

    Object expandBuildMacro(ImList form) {
        String name = (String)form.elem();
        if (name == "reserve-tmpq") {
            return this.jmac2();
        }
        if (name == "reserve-tmpl") {
            return this.jmac3();
        }
        if (name == "reserve-cw0") {
            return this.jmac4();
        }
        if (name == "reserve-cw1") {
            return this.jmac5();
        }
        return null;
    }

    Object quiltLir(LirNode node) {
        switch (node.opCode) {
            case 7: {
                return this.jmac1(node);
            }
        }
        return this.quiltLirDefault(node);
    }

    String emitList(ImList form, boolean topLevel) {
        String name = (String)form.elem();
        if (name == "after") {
            return this.jmac6(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "+") {
            return this.jmac7(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "-") {
            return this.jmac8(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "-32") {
            return this.jmac9(this.emitObject(form.elem(1)));
        }
        if (name == "imm") {
            return this.jmac10(this.emitObject(form.elem(1)));
        }
        if (name == "ind") {
            return this.jmac11(this.emitObject(form.elem(1)));
        }
        if (name == "mem") {
            return this.jmac12(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "addr") {
            return this.jmac13(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "base") {
            return this.jmac14(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "index") {
            return this.jmac15(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "regwlow") {
            return this.jmac16(this.emitObject(form.elem(1)));
        }
        if (name == "regblow") {
            return this.jmac17(this.emitObject(form.elem(1)));
        }
        if (name == "qlow") {
            return this.jmac18(this.emitObject(form.elem(1)));
        }
        if (name == "qhigh") {
            return this.jmac19(this.emitObject(form.elem(1)));
        }
        if (name == "prologue") {
            return this.jmac20(form.elem(1));
        }
        if (name == "epilogue") {
            return this.jmac21(form.elem(1), this.emitObject(form.elem(2)));
        }
        if (name == "minus") {
            return this.jmac22(this.emitObject(form.elem(1)));
        }
        if (name == "line") {
            return this.jmac23(this.emitObject(form.elem(1)));
        }
        if (name == "symbol") {
            return this.jmac24(this.emitObject(form.elem(1)));
        }
        if (name == "genasm") {
            return this.jmac25(this.emitObject(form.elem(1)), form.elem(2));
        }
        return this.emitListDefault(form, topLevel);
    }

    String emitLir(LirNode node) {
        switch (node.opCode) {
            default: 
        }
        return this.emitLirDefault(node);
    }

    CodeGenerator.FunctionAttr newFunctionAttr(Function func) {
        return new X86Attr(func);
    }

    void setAllocaCalled() {
        X86Attr attr = (X86Attr)this.getFunctionAttr(this.func);
        attr.allocaCalled = true;
    }

    private boolean isConv(LirNode node) {
        switch (node.opCode) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    int makeVaStart(LirNode arg) {
        LirNode node = null;
        BiLink p = this.func.firstInstrList().first();
        while (!p.atEnd()) {
            node = (LirNode)p.elem();
            if (node.opCode == 54) break;
            p = p.next();
        }
        int n = node.nKids();
        int offset = 8;
        if (this.isConv(arg)) {
            arg = arg.kid(0);
        }
        for (int i = 1; i < n; ++i) {
            LirNode x = node.kid(i);
            offset += Type.bytes(x.type) + 3 & 0xFFFFFFFC;
            if (!this.equalArg(arg, x)) continue;
            return offset;
        }
        return 8;
    }

    boolean equalArg(LirNode x, LirNode y) {
        if (x.opCode == 47) {
            x = x.kid(0);
        }
        if (y.opCode == 47) {
            y = y.kid(0);
        }
        return ((LirSymRef)x).symbol == ((LirSymRef)y).symbol;
    }

    LirNode stripConv(LirNode tree) {
        switch (tree.opCode) {
            case 17: 
            case 18: {
                return tree.kid(0);
            }
        }
        return tree;
    }

    LirNode rewriteFrame(LirNode node) {
        Symbol ebp = this.func.getSymbol("%ebp");
        int off = ((SymAuto)((LirSymRef)node).symbol).offset();
        return this.lir.node(10, node.type, this.lir.symRef(ebp), this.lir.iconst(I32, off));
    }

    public Transformer[] earlyRewritingSequence() {
        return new Transformer[]{this.localEarlyRewritingTrig};
    }

    public Transformer[] lateRewritingSequence() {
        return new Transformer[]{AggregatePropagation.trig, this.localLateRewritingTrig, this.ProcessFramesTrig};
    }

    LirNode rewritePrologue(LirNode node, BiList post) {
        int location = 8;
        LirNode base = this.regnode(I32, "%ebp");
        if (this.func.origEpilogue.nKids() > 1 && Type.tag(this.func.origEpilogue.kid((int)1).type) == 1) {
            location += 4;
        }
        int n = node.nKids();
        for (int i = 1; i < n; ++i) {
            LirNode arg = node.kid(i);
            if (arg.opCode == 47) {
                if (arg.kid((int)0).opCode != 5) {
                    throw new CantHappenException("Malformed aggregate parameter");
                }
                SymAuto var = (SymAuto)((LirSymRef)arg.kid((int)0)).symbol;
                var.setOffset(location);
            } else {
                post.add(this.lir.node(48, arg.type, arg, this.stackMem(arg.type, location, base)));
            }
            location = location + Type.bytes(arg.type) + 3 & 0xFFFFFFFC;
        }
        return this.lir.node(54, 0, node.kid(0));
    }

    private LirNode regnode(int type, String name) {
        LirNode master = this.lir.symRef(this.module.globalSymtab.get(name));
        switch (Type.tag(type)) {
            case 2: {
                return master;
            }
            case 4: {
                if (type == F64) {
                    return master;
                }
                if (type != F32) break;
                return this.lir.node(7, F32, master, this.lir.untaggedIconst(I32, 0L));
            }
        }
        return null;
    }

    private LirNode stackMem(int type, int location, LirNode base) {
        return this.lir.node(47, type, this.lir.node(10, I32, base, this.lir.iconst(I32, location + this.adjustEndian(type))));
    }

    private int adjustEndian(int type) {
        return 0;
    }

    private LirNode makePush(LirNode operand) {
        LirNode stackPtr = this.regnode(I32, "%esp");
        if (Type.tag(operand.type) == 4) {
            int size = Type.bytes(operand.type);
            return this.lir.node(56, 0, this.lir.node(48, operand.type, this.lir.node(47, operand.type, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, size))), operand), this.lir.node(48, I32, stackPtr, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, size))));
        }
        if (Type.bits(operand.type) <= 32) {
            return this.lir.node(56, 0, this.lir.node(48, I32, this.lir.node(47, I32, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, 4L))), operand), this.lir.node(48, I32, stackPtr, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, 4L))));
        }
        return this.lir.node(56, 0, this.lir.node(48, I64, this.lir.node(47, I64, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, 8L))), operand), this.lir.node(48, I32, stackPtr, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, 8L))));
    }

    LirNode returnReg(int type) {
        switch (Type.tag(type)) {
            case 2: {
                switch (Type.bytes(type)) {
                    case 1: {
                        return this.regnode(type, "%al");
                    }
                    case 2: {
                        return this.regnode(type, "%ax");
                    }
                    case 4: {
                        return this.regnode(type, "%eax");
                    }
                    case 8: {
                        return this.regnode(type, "%edxeax");
                    }
                }
                return null;
            }
            case 4: {
                return this.regnode(type, "%t0");
            }
        }
        return null;
    }

    LirNode rewriteEpilogue(LirNode node, BiList pre) {
        if (node.nKids() < 2) {
            return node;
        }
        LirNode ret = node.kid(1);
        switch (Type.tag(ret.type)) {
            case 2: 
            case 4: {
                LirNode reg = this.returnReg(ret.type);
                pre.add(this.lir.node(48, ret.type, reg, ret));
                return this.lir.node(55, 0, node.kid(0), reg);
            }
            case 1: {
                pre.add(this.lir.node(48, ret.type, this.lir.operator(47, ret.type, this.stackMem(I32, 8, this.regnode(I32, "%ebp")), ImList.list("&align", "4")), ret));
                return this.lir.node(55, 0, new LirNode[0]);
            }
        }
        throw new CantHappenException();
    }

    LirNode rewriteCall(LirNode node, BiList pre, BiList post) {
        LirNode args = node.kid(1);
        LirNode ret = null;
        if (node.kid(2).nKids() > 0) {
            ret = node.kid(2).kid(0);
        }
        int loc = 0;
        int n = args.nKids();
        boolean paramCounter = false;
        LirNode spreg = this.regnode(I32, "%esp");
        int i = n;
        while (--i >= 0) {
            LirNode arg = args.kid(i);
            switch (Type.tag(arg.type)) {
                case 2: {
                    if (Type.bits(arg.type) < 32) {
                        arg = this.lir.node(18, I32, arg);
                    }
                    pre.add(this.makePush(arg));
                    loc += Type.bytes(arg.type);
                    break;
                }
                case 4: {
                    pre.add(this.makePush(arg));
                    loc += Type.bytes(arg.type);
                    break;
                }
                case 1: {
                    pre.add(this.lir.node(48, I32, spreg, this.lir.node(11, I32, spreg, this.lir.iconst(I32, Type.bytes(arg.type)))));
                    pre.add(this.lir.node(48, arg.type, this.lir.operator(47, arg.type, spreg, ImList.list("&align", "4")), arg));
                    loc += Type.bytes(arg.type) + 3 & 0xFFFFFFFC;
                }
            }
        }
        LirNode retReg = ret;
        if (ret != null) {
            switch (Type.tag(ret.type)) {
                case 2: 
                case 4: {
                    retReg = this.returnReg(ret.type);
                    break;
                }
                case 1: {
                    if (ret.opCode != 47) {
                        throw new CantHappenException();
                    }
                    pre.add(this.makePush(ret.kid(0)));
                    loc += 4;
                }
            }
        }
        LirNode[] emptyVector = new LirNode[]{};
        try {
            LirNode retNode = this.lir.node(61, 0, emptyVector);
            if (retReg != null) {
                retNode = this.lir.node(61, 0, retReg);
            }
            node = this.lir.node(56, 0, this.noRescan(this.lir.node(53, 0, node.kid(0), this.lir.node(61, 0, emptyVector), retNode)), this.lir.decodeLir(new ImList("CLOBBER", this.regCallClobbers), this.func, this.module));
        }
        catch (SyntaxError e) {
            throw new CantHappenException();
        }
        if (ret != null) {
            switch (Type.tag(ret.type)) {
                case 2: 
                case 4: {
                    if (this.isSimple(ret)) {
                        post.add(this.lir.node(48, ret.type, ret, retReg));
                        break;
                    }
                    LirNode tmp = this.func.newTemp(ret.type);
                    post.add(this.lir.node(48, ret.type, tmp, retReg));
                    post.add(this.lir.node(48, ret.type, ret, tmp));
                    break;
                }
            }
        }
        if (loc != 0) {
            post.add(this.lir.node(48, I32, spreg, this.lir.node(10, I32, spreg, this.lir.iconst(I32, loc))));
        }
        return node;
    }

    void peepHoleOpt(BiList list) {
        this.postRewriteFloatOps(list);
        if (this.root.traceOK("TMD", 1)) {
            this.debOut.println();
            this.debOut.println("After rewriting floatOps for function " + this.func.symbol.name + ":");
            BiLink p = list.first();
            while (!p.atEnd()) {
                this.debOut.println("  " + p.elem());
                p = p.next();
            }
            this.debOut.println();
        }
    }

    void postRewriteFloatOps(BiList list) {
        int counter = 1;
        int[] defAt = new int[9];
        int sp = 0;
        BiLink p = list.first();
        while (!p.atEnd()) {
            ImList inst = (ImList)p.elem();
            String op = (String)inst.elem();
            int dest = this.tregNum(inst.lastElem());
            int src = -1;
            int src2 = -1;
            if (op == "fldz" || op == "fld1") {
                inst = ImList.list(op);
                ++sp;
            } else if (op == "fldl" || op == "fildl" || op == "fildll" || op == "flds" || op == "filds") {
                src = this.fregNum(inst.elem2nd());
                inst = src >= 0 ? ImList.list(op, "%st(" + (src + sp) + ")") : ImList.list(op, inst.elem2nd());
                ++sp;
            } else if (op == "fchs") {
                inst = ImList.list(op);
            } else if (op == "fadd" || op == "fmul") {
                if (this.tregNum(inst.elem2nd()) >= 0 && this.tregNum(inst.elem3rd()) >= 0) {
                    inst = ImList.list((op + "p").intern(), "%st", "%st(1)");
                    --sp;
                } else {
                    src = this.fregNum(inst.elem2nd());
                    inst = src >= 0 ? ImList.list(op, "%st(" + (src + sp) + ")", "%st") : ImList.list((op + this.floatSizeSuffix(inst.elem2nd())).intern(), inst.elem2nd());
                }
            } else if (op == "fsub" || op == "fdiv") {
                src2 = this.tregNum(inst.elem2nd());
                if (src2 >= 0 && (src = this.tregNum(inst.elem3rd())) >= 0) {
                    inst = defAt[src2] > defAt[src] ? ImList.list((op + "rp").intern(), "%st", "%st(1)") : (defAt[src2] < defAt[src] ? ImList.list((op + "p").intern(), "%st", "%st(1)") : ImList.list((op + "?").intern()));
                    --sp;
                } else {
                    src = this.fregNum(inst.elem2nd());
                    inst = src >= 0 ? ImList.list(op, "%st(" + (src + sp) + ")", "%st") : ImList.list((op + this.floatSizeSuffix(inst.elem2nd())).intern(), inst.elem2nd());
                }
            } else if (op == "fcom") {
                src2 = this.tregNum(inst.elem2nd());
                if (src2 >= 0 && (src = this.tregNum(inst.elem3rd())) >= 0) {
                    if (defAt[src2] > defAt[src]) {
                        p.addBefore(ImList.list("fxch"));
                    }
                    inst = ImList.list("fcompp");
                    sp -= 2;
                } else {
                    src = this.fregNum(inst.elem2nd());
                    if (src >= 0) {
                        inst = ImList.list("fcomp", "%st(" + (src + sp) + ")");
                        --sp;
                    } else {
                        inst = ImList.list(("fcomp" + this.floatSizeSuffix(inst.elem2nd())).intern(), inst.elem2nd());
                        --sp;
                    }
                }
            } else if (op == "fstp") {
                src = this.fregNum(inst.elem3rd());
                inst = src >= 0 ? ImList.list(op, "%st(" + (src + sp) + ")") : ImList.list((op + this.floatSizeSuffix(inst.elem3rd())).intern(), inst.elem3rd());
                --sp;
            } else if (op == "fstps" || op == "fistpl" || op == "fistpll" || op == "fistps") {
                inst = ImList.list(op, inst.elem3rd());
                --sp;
            }
            if (dest >= 0) {
                defAt[dest] = counter++;
            }
            if (op == "fmov") {
                p.unlink();
            } else {
                p.setElem(inst);
            }
            p = p.next();
        }
    }

    int tregNum(Object operand) {
        if (operand instanceof String && ((String)operand).startsWith("%t")) {
            return Integer.parseInt(((String)operand).substring(2));
        }
        return -1;
    }

    int fregNum(Object operand) {
        if (operand instanceof String && ((String)operand).startsWith("%f")) {
            return Integer.parseInt(((String)operand).substring(2));
        }
        return -1;
    }

    String floatSizeSuffix(Object arg) {
        ImList mem = (ImList)arg;
        if (mem.elem() == "mem") {
            String size = (String)mem.elem2nd();
            if (size == "float") {
                return "s";
            }
            if (size == "double") {
                return "l";
            }
        }
        throw new CantHappenException();
    }

    Object jmac1(LirNode x) {
        Symbol reg = ((LirSymRef)x.kid((int)0)).symbol;
        int dtype = x.type;
        int offset = (int)((LirIconst)x.kid((int)1)).value;
        if (dtype == I16) {
            if (offset == 0) {
                return "%" + reg.name.substring(2);
            }
        } else if (dtype == I8) {
            int namel = reg.name.length();
            if (offset == 0) {
                return "%" + reg.name.substring(namel - 2, namel - 1) + "l";
            }
            if (offset == 1) {
                return "%" + reg.name.substring(namel - 2, namel - 1) + "h";
            }
        } else if (dtype == F32 && offset == 0) {
            return reg.name;
        }
        throw new CantHappenException();
    }

    Object jmac2() {
        SymAuto sym = this.reserveFrame(".TMPQ", I64);
        return sym.offset() + "(%ebp)";
    }

    Object jmac3() {
        SymAuto sym = this.reserveFrame(".TMPL", I32);
        return sym.offset() + "(%ebp)";
    }

    Object jmac4() {
        SymAuto sym = this.reserveFrame(".CONVCW0", I16);
        return sym.offset() + "(%ebp)";
    }

    Object jmac5() {
        SymAuto sym = this.reserveFrame(".CONVCW1", I16);
        return sym.offset() + "(%ebp)";
    }

    String jmac6(String x, String y) {
        return this.emitAfter(x, y);
    }

    String emitAfter(String x, String y) {
        if (x.charAt(x.length() - 1) != ')') {
            return x + "+" + y;
        }
        if (x.charAt(0) == '-' || x.charAt(0) == '(') {
            return y + x;
        }
        return y + "+" + x;
    }

    String jmac7(String x, String y) {
        if (y.charAt(0) == '-') {
            return x + y;
        }
        return x + "+" + y;
    }

    String jmac8(String x, String y) {
        if (y.charAt(0) == '-') {
            return x + "+" + y.substring(1);
        }
        return x + "-" + y;
    }

    String jmac9(String x) {
        return "" + (Integer.parseInt(x) - 32);
    }

    String jmac10(String x) {
        return "$" + x;
    }

    String jmac11(String x) {
        return "*" + x;
    }

    String jmac12(String type, String x) {
        return x;
    }

    String jmac13(String base, String index) {
        if (index == "") {
            return base;
        }
        if (base == "" || base.charAt(base.length() - 1) != ')') {
            return base + "(," + index + ")";
        }
        return base.substring(0, base.length() - 1) + "," + index + ")";
    }

    String jmac14(String con, String reg) {
        if (reg == "") {
            return con;
        }
        return con + "(" + reg + ")";
    }

    String jmac15(String reg, String scale) {
        if (scale == "1") {
            return reg;
        }
        return reg + "," + scale;
    }

    String jmac16(String x) {
        return "%" + x.substring(2);
    }

    String jmac17(String x) {
        return "%" + x.substring(x.length() - 2, x.length() - 1) + "l";
    }

    String jmac18(String x) {
        if (x.charAt(0) == '$') {
            return "$" + (Long.parseLong(x.substring(1)) & 0xFFFFFFFFL);
        }
        if (x.charAt(0) == '%') {
            return "%" + x.substring(x.length() - 3);
        }
        return x;
    }

    String jmac19(String x) {
        if (x.charAt(0) == '$') {
            return "$" + (Long.parseLong(x.substring(1)) >> 32 & 0xFFFFFFFFL);
        }
        if (x.charAt(0) == '%') {
            return x.substring(0, x.length() - 3);
        }
        return this.emitAfter(x, "4");
    }

    String jmac20(Object f) {
        Function func = (Function)f;
        SaveRegisters saveList = (SaveRegisters)func.require(SaveRegisters.analyzer);
        int size = this.frameSize(func);
        size = size + 3 & 0xFFFFFFFC;
        String seq = "\tpushl\t%ebp\n\tmovl\t%esp,%ebp";
        if (size != 0) {
            seq = this.convention == "cygwin" && size > 4000 ? seq + "\n\tmovl\t$" + size + ",%eax" + "\n\tcall\t__alloca" : seq + "\n\tsubl\t$" + size + ",%esp";
        }
        NumberSet.Iterator it = saveList.calleeSave.iterator();
        while (it.hasNext()) {
            int reg = it.next();
            seq = seq + "\n\tpushl\t" + this.machineParams.registerToString(reg);
        }
        return seq;
    }

    String jmac21(Object f, String rettype) {
        Function func = (Function)f;
        SaveRegisters saveList = (SaveRegisters)func.require(SaveRegisters.analyzer);
        int size = this.frameSize(func);
        X86Attr attr = (X86Attr)this.getFunctionAttr(func);
        String pops = "";
        int n = 0;
        NumberSet.Iterator it = saveList.calleeSave.iterator();
        while (it.hasNext()) {
            int reg = it.next();
            pops = "\tpopl\t" + this.machineParams.registerToString(reg) + "\n" + pops;
            n += 4;
        }
        String seq = "";
        if (attr.allocaCalled && n != 0) {
            seq = "\tlea\t-" + (size + n) + "(%ebp),%esp\n";
        }
        return seq + pops + "\tleave\n\tret";
    }

    String jmac22(String con) {
        return -Integer.parseInt(con) + "";
    }

    String jmac23(String x) {
        return "# line " + x;
    }

    String jmac24(String x) {
        return this.makeAsmSymbol(x);
    }

    String jmac25(String format, Object args) {
        return this.emitAsmCode(format, (ImList)args);
    }

    void emitBeginningOfSegment(PrintWriter out, String segment) {
        if (this.convention == "cygwin") {
            if (segment.equals(".text") || segment.equals(".rodata")) {
                out.println("\t.text");
            } else if (segment.equals(".data")) {
                out.println("\t.data");
            } else {
                out.println("\t.section " + segment);
            }
        } else {
            out.println("\t.section " + segment);
        }
    }

    String makeAsmSymbol(String symbol) {
        if (this.convention == "cygwin" && symbol.charAt(0) != '.') {
            return "_" + symbol;
        }
        return symbol;
    }

    public int alignForType(int type) {
        switch (Type.bytes(type)) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    String segmentForConst() {
        return ".rodata";
    }

    void emitData(PrintWriter out, int type, LirNode node) {
        if (type == I64) {
            long v = ((LirIconst)node).signedValue();
            out.println("\t.long\t" + (v & 0xFFFFFFFFL) + "," + (v >> 32 & 0xFFFFFFFFL));
        } else if (type == I32) {
            out.println("\t.long\t" + this.lexpConv.convert(node));
        } else if (type == I16) {
            out.println("\t.short\t" + ((LirIconst)node).signedValue());
        } else if (type == I8) {
            out.println("\t.byte\t" + ((LirIconst)node).signedValue());
        } else if (type == F64) {
            double value = ((LirFconst)node).value;
            long bits = Double.doubleToLongBits(value);
            out.println("\t.long\t0x" + Long.toString(bits & 0xFFFFFFFFL, 16) + ",0x" + Long.toString(bits >> 32 & 0xFFFFFFFFL, 16) + " /* " + value + " */");
        } else if (type == F32) {
            double value = ((LirFconst)node).value;
            long bits = Float.floatToIntBits((float)value);
            out.println("\t.long\t0x" + Long.toString(bits & 0xFFFFFFFFL, 16) + " /* " + value + " */");
        } else {
            throw new CantHappenException("unknown type: " + type);
        }
    }

    void emitCommon(PrintWriter out, SymStatic symbol, int bytes) {
        if (symbol.linkage == "LDEF") {
            out.println("\t.lcomm\t" + this.makeAsmSymbol(symbol.name) + "," + bytes);
        } else if (this.convention == "cygwin") {
            out.println("\t.comm\t" + this.makeAsmSymbol(symbol.name) + "," + bytes);
        } else {
            out.println("\t.comm\t" + this.makeAsmSymbol(symbol.name) + "," + bytes + "," + symbol.boundary);
        }
    }

    static {
        CodeGenerator_x86.rrinit0();
        CodeGenerator_x86.rrinit100();
        CodeGenerator_x86.rrinit200();
        CodeGenerator_x86.rrinit300();
    }

    static class X86Attr
    extends CodeGenerator.FunctionAttr {
        int stackRequired = 0;
        int tmpOffset = 0;
        boolean allocaCalled;

        X86Attr(Function func) {
            super(func);
        }
    }

    class State {
        static final int NNONTERM = 116;
        static final int NRULES = 338;
        static final int START_NT = 8;
        static final int NT__ = 0;
        static final int NT_regq = 1;
        static final int NT_regl = 2;
        static final int NT_reglb = 3;
        static final int NT_regw = 4;
        static final int NT_regb = 5;
        static final int NT_regf = 6;
        static final int NT_regd = 7;
        static final int NT_void = 8;
        static final int NT_xregb = 9;
        static final int NT_xregw = 10;
        static final int NT_xregl = 11;
        static final int NT_xregq = 12;
        static final int NT_xregf = 13;
        static final int NT_xregd = 14;
        static final int NT_con = 15;
        static final int NT_sta = 16;
        static final int NT_asmcon = 17;
        static final int NT_lab = 18;
        static final int NT_base = 19;
        static final int NT_index = 20;
        static final int NT__1 = 21;
        static final int NT__2 = 22;
        static final int NT__3 = 23;
        static final int NT__4 = 24;
        static final int NT__5 = 25;
        static final int NT_addr = 26;
        static final int NT_memq = 27;
        static final int NT_meml = 28;
        static final int NT_memw = 29;
        static final int NT_memb = 30;
        static final int NT_memf = 31;
        static final int NT_memd = 32;
        static final int NT_rcl = 33;
        static final int NT_rcw = 34;
        static final int NT_rcb = 35;
        static final int NT_mrcl = 36;
        static final int NT_mregl = 37;
        static final int NT_mrcw = 38;
        static final int NT_mregw = 39;
        static final int NT_mrcb = 40;
        static final int NT_mregb = 41;
        static final int NT_mregq = 42;
        static final int NT_mrcq = 43;
        static final int NT_callarg = 44;
        static final int NT__6 = 45;
        static final int NT__7 = 46;
        static final int NT__8 = 47;
        static final int NT__9 = 48;
        static final int NT__10 = 49;
        static final int NT__11 = 50;
        static final int NT__12 = 51;
        static final int NT__13 = 52;
        static final int NT__14 = 53;
        static final int NT__15 = 54;
        static final int NT__16 = 55;
        static final int NT__17 = 56;
        static final int NT__18 = 57;
        static final int NT__19 = 58;
        static final int NT__20 = 59;
        static final int NT__21 = 60;
        static final int NT_shfct = 61;
        static final int NT_regmemd = 62;
        static final int NT_regmemf = 63;
        static final int NT__22 = 64;
        static final int NT__23 = 65;
        static final int NT__24 = 66;
        static final int NT__25 = 67;
        static final int NT__26 = 68;
        static final int NT__27 = 69;
        static final int NT__28 = 70;
        static final int NT__29 = 71;
        static final int NT__30 = 72;
        static final int NT__31 = 73;
        static final int NT__32 = 74;
        static final int NT__33 = 75;
        static final int NT__34 = 76;
        static final int NT__35 = 77;
        static final int NT__36 = 78;
        static final int NT__37 = 79;
        static final int NT__38 = 80;
        static final int NT__39 = 81;
        static final int NT__40 = 82;
        static final int NT__41 = 83;
        static final int NT__42 = 84;
        static final int NT__43 = 85;
        static final int NT__44 = 86;
        static final int NT__45 = 87;
        static final int NT__46 = 88;
        static final int NT__47 = 89;
        static final int NT__48 = 90;
        static final int NT__49 = 91;
        static final int NT__50 = 92;
        static final int NT__51 = 93;
        static final int NT__52 = 94;
        static final int NT__53 = 95;
        static final int NT__54 = 96;
        static final int NT__55 = 97;
        static final int NT__56 = 98;
        static final int NT__57 = 99;
        static final int NT__58 = 100;
        static final int NT__59 = 101;
        static final int NT__60 = 102;
        static final int NT__61 = 103;
        static final int NT__62 = 104;
        static final int NT__63 = 105;
        static final int NT__64 = 106;
        static final int NT__65 = 107;
        static final int NT__66 = 108;
        static final int NT__67 = 109;
        static final int NT__68 = 110;
        static final int NT__69 = 111;
        static final int NT__70 = 112;
        static final int NT__71 = 113;
        static final int NT__72 = 114;
        static final int NT__73 = 115;
        final int[] rule = new int[116];
        final int[] cost1 = new int[116];
        final int[] cost2 = new int[116];

        State() {
        }

        String nontermName(int nt) {
            switch (nt) {
                case 0: {
                    return "_";
                }
                case 1: {
                    return "regq";
                }
                case 2: {
                    return "regl";
                }
                case 3: {
                    return "reglb";
                }
                case 4: {
                    return "regw";
                }
                case 5: {
                    return "regb";
                }
                case 6: {
                    return "regf";
                }
                case 7: {
                    return "regd";
                }
                case 8: {
                    return "void";
                }
                case 9: {
                    return "xregb";
                }
                case 10: {
                    return "xregw";
                }
                case 11: {
                    return "xregl";
                }
                case 12: {
                    return "xregq";
                }
                case 13: {
                    return "xregf";
                }
                case 14: {
                    return "xregd";
                }
                case 15: {
                    return "con";
                }
                case 16: {
                    return "sta";
                }
                case 17: {
                    return "asmcon";
                }
                case 18: {
                    return "lab";
                }
                case 19: {
                    return "base";
                }
                case 20: {
                    return "index";
                }
                case 21: {
                    return "_1";
                }
                case 22: {
                    return "_2";
                }
                case 23: {
                    return "_3";
                }
                case 24: {
                    return "_4";
                }
                case 25: {
                    return "_5";
                }
                case 26: {
                    return "addr";
                }
                case 27: {
                    return "memq";
                }
                case 28: {
                    return "meml";
                }
                case 29: {
                    return "memw";
                }
                case 30: {
                    return "memb";
                }
                case 31: {
                    return "memf";
                }
                case 32: {
                    return "memd";
                }
                case 33: {
                    return "rcl";
                }
                case 34: {
                    return "rcw";
                }
                case 35: {
                    return "rcb";
                }
                case 36: {
                    return "mrcl";
                }
                case 37: {
                    return "mregl";
                }
                case 38: {
                    return "mrcw";
                }
                case 39: {
                    return "mregw";
                }
                case 40: {
                    return "mrcb";
                }
                case 41: {
                    return "mregb";
                }
                case 42: {
                    return "mregq";
                }
                case 43: {
                    return "mrcq";
                }
                case 44: {
                    return "callarg";
                }
                case 45: {
                    return "_6";
                }
                case 46: {
                    return "_7";
                }
                case 47: {
                    return "_8";
                }
                case 48: {
                    return "_9";
                }
                case 49: {
                    return "_10";
                }
                case 50: {
                    return "_11";
                }
                case 51: {
                    return "_12";
                }
                case 52: {
                    return "_13";
                }
                case 53: {
                    return "_14";
                }
                case 54: {
                    return "_15";
                }
                case 55: {
                    return "_16";
                }
                case 56: {
                    return "_17";
                }
                case 57: {
                    return "_18";
                }
                case 58: {
                    return "_19";
                }
                case 59: {
                    return "_20";
                }
                case 60: {
                    return "_21";
                }
                case 61: {
                    return "shfct";
                }
                case 62: {
                    return "regmemd";
                }
                case 63: {
                    return "regmemf";
                }
                case 64: {
                    return "_22";
                }
                case 65: {
                    return "_23";
                }
                case 66: {
                    return "_24";
                }
                case 67: {
                    return "_25";
                }
                case 68: {
                    return "_26";
                }
                case 69: {
                    return "_27";
                }
                case 70: {
                    return "_28";
                }
                case 71: {
                    return "_29";
                }
                case 72: {
                    return "_30";
                }
                case 73: {
                    return "_31";
                }
                case 74: {
                    return "_32";
                }
                case 75: {
                    return "_33";
                }
                case 76: {
                    return "_34";
                }
                case 77: {
                    return "_35";
                }
                case 78: {
                    return "_36";
                }
                case 79: {
                    return "_37";
                }
                case 80: {
                    return "_38";
                }
                case 81: {
                    return "_39";
                }
                case 82: {
                    return "_40";
                }
                case 83: {
                    return "_41";
                }
                case 84: {
                    return "_42";
                }
                case 85: {
                    return "_43";
                }
                case 86: {
                    return "_44";
                }
                case 87: {
                    return "_45";
                }
                case 88: {
                    return "_46";
                }
                case 89: {
                    return "_47";
                }
                case 90: {
                    return "_48";
                }
                case 91: {
                    return "_49";
                }
                case 92: {
                    return "_50";
                }
                case 93: {
                    return "_51";
                }
                case 94: {
                    return "_52";
                }
                case 95: {
                    return "_53";
                }
                case 96: {
                    return "_54";
                }
                case 97: {
                    return "_55";
                }
                case 98: {
                    return "_56";
                }
                case 99: {
                    return "_57";
                }
                case 100: {
                    return "_58";
                }
                case 101: {
                    return "_59";
                }
                case 102: {
                    return "_60";
                }
                case 103: {
                    return "_61";
                }
                case 104: {
                    return "_62";
                }
                case 105: {
                    return "_63";
                }
                case 106: {
                    return "_64";
                }
                case 107: {
                    return "_65";
                }
                case 108: {
                    return "_66";
                }
                case 109: {
                    return "_67";
                }
                case 110: {
                    return "_68";
                }
                case 111: {
                    return "_69";
                }
                case 112: {
                    return "_70";
                }
                case 113: {
                    return "_71";
                }
                case 114: {
                    return "_72";
                }
                case 115: {
                    return "_73";
                }
            }
            return null;
        }

        void record(int nt, int cost1, int cost2, int rule) {
            if (this.rule[nt] == 0 || (CodeGenerator_x86.this.optSpeed ? cost1 < this.cost1[nt] || cost1 == this.cost1[nt] && cost2 < this.cost2[nt] : cost2 < this.cost2[nt] || cost2 == this.cost2[nt] && cost1 < this.cost1[nt])) {
                this.rule[nt] = rule;
                this.cost1[nt] = cost1;
                this.cost2[nt] = cost2;
                switch (nt) {
                    case 1: {
                        this.record(42, 0 + cost1, 0 + cost2, 76);
                        this.record(61, 0 + cost1, 0 + cost2, 143);
                        break;
                    }
                    case 2: {
                        this.record(19, 0 + cost1, 0 + cost2, 31);
                        this.record(20, 0 + cost1, 0 + cost2, 35);
                        this.record(33, 0 + cost1, 0 + cost2, 57);
                        this.record(37, 0 + cost1, 0 + cost2, 66);
                        this.record(44, 0 + cost1, 0 + cost2, 80);
                        this.record(61, 0 + cost1, 0 + cost2, 144);
                        this.record(3, 0 + cost1, 0 + cost2, 189);
                        break;
                    }
                    case 4: {
                        this.record(34, 0 + cost1, 0 + cost2, 59);
                        this.record(39, 0 + cost1, 0 + cost2, 70);
                        this.record(61, 0 + cost1, 0 + cost2, 145);
                        break;
                    }
                    case 5: {
                        this.record(35, 0 + cost1, 0 + cost2, 61);
                        this.record(41, 0 + cost1, 0 + cost2, 74);
                        this.record(61, 0 + cost1, 0 + cost2, 146);
                        this.record(3, 2 + cost1, 2 + cost2, 190);
                        break;
                    }
                    case 6: {
                        this.record(63, 0 + cost1, 0 + cost2, 177);
                        break;
                    }
                    case 7: {
                        this.record(62, 0 + cost1, 0 + cost2, 175);
                        break;
                    }
                    case 9: {
                        this.record(5, 0 + cost1, 0 + cost2, 13);
                        break;
                    }
                    case 10: {
                        this.record(4, 0 + cost1, 0 + cost2, 14);
                        break;
                    }
                    case 11: {
                        this.record(2, 0 + cost1, 0 + cost2, 15);
                        break;
                    }
                    case 12: {
                        this.record(1, 0 + cost1, 0 + cost2, 16);
                        break;
                    }
                    case 13: {
                        this.record(6, 0 + cost1, 0 + cost2, 17);
                        break;
                    }
                    case 14: {
                        this.record(7, 0 + cost1, 0 + cost2, 18);
                        break;
                    }
                    case 15: {
                        this.record(17, 0 + cost1, 0 + cost2, 25);
                        this.record(34, 0 + cost1, 0 + cost2, 60);
                        this.record(35, 0 + cost1, 0 + cost2, 62);
                        this.record(43, 0 + cost1, 0 + cost2, 78);
                        break;
                    }
                    case 16: {
                        this.record(17, 0 + cost1, 0 + cost2, 26);
                        this.record(44, 0 + cost1, 0 + cost2, 79);
                        break;
                    }
                    case 17: {
                        this.record(19, 0 + cost1, 0 + cost2, 30);
                        this.record(33, 0 + cost1, 0 + cost2, 58);
                        break;
                    }
                    case 19: {
                        this.record(26, 0 + cost1, 0 + cost2, 47);
                        break;
                    }
                    case 20: {
                        this.record(26, 0 + cost1, 0 + cost2, 48);
                        break;
                    }
                    case 26: {
                        this.record(2, 1 + cost1, 3 + cost2, 81);
                        break;
                    }
                    case 27: {
                        this.record(42, 0 + cost1, 0 + cost2, 75);
                        this.record(61, 1 + cost1, 1 + cost2, 142);
                        break;
                    }
                    case 28: {
                        this.record(36, 0 + cost1, 0 + cost2, 63);
                        this.record(37, 0 + cost1, 0 + cost2, 65);
                        break;
                    }
                    case 29: {
                        this.record(38, 0 + cost1, 0 + cost2, 67);
                        this.record(39, 0 + cost1, 0 + cost2, 69);
                        break;
                    }
                    case 30: {
                        this.record(40, 0 + cost1, 0 + cost2, 71);
                        this.record(41, 0 + cost1, 0 + cost2, 73);
                        break;
                    }
                    case 31: {
                        this.record(6, 1 + cost1, 1 + cost2, 87);
                        this.record(63, 0 + cost1, 0 + cost2, 178);
                        break;
                    }
                    case 32: {
                        this.record(7, 1 + cost1, 1 + cost2, 86);
                        this.record(62, 0 + cost1, 0 + cost2, 176);
                        break;
                    }
                    case 33: {
                        this.record(36, 0 + cost1, 0 + cost2, 64);
                        break;
                    }
                    case 34: {
                        this.record(38, 0 + cost1, 0 + cost2, 68);
                        break;
                    }
                    case 35: {
                        this.record(40, 0 + cost1, 0 + cost2, 72);
                        break;
                    }
                    case 36: {
                        this.record(2, 1 + cost1, 1 + cost2, 83);
                        break;
                    }
                    case 38: {
                        this.record(4, 1 + cost1, 1 + cost2, 84);
                        break;
                    }
                    case 40: {
                        this.record(5, 1 + cost1, 1 + cost2, 85);
                        break;
                    }
                    case 42: {
                        this.record(43, 0 + cost1, 0 + cost2, 77);
                        break;
                    }
                    case 43: {
                        this.record(1, 2 + cost1, 2 + cost2, 82);
                    }
                }
            }
        }

        void label(LirNode t, State[] kids) {
            switch (t.opCode) {
                case 2: {
                    this.record(15, 0, 0, 19);
                    if (t.type != 514) break;
                    if (((LirIconst)t).value == 2L) {
                        this.record(21, 0, 0, 36);
                    }
                    if (((LirIconst)t).value == 4L) {
                        this.record(22, 0, 0, 38);
                    }
                    if (((LirIconst)t).value == 8L) {
                        this.record(23, 0, 0, 40);
                    }
                    if (((LirIconst)t).value == 1L) {
                        this.record(24, 0, 0, 42);
                    }
                    if (((LirIconst)t).value != 3L) break;
                    this.record(25, 0, 0, 45);
                    break;
                }
                case 3: {
                    if (t.type == 516) {
                        if (((LirFconst)t).value == 0.0) {
                            this.record(6, 1, 1, 23);
                        }
                        if (((LirFconst)t).value == 1.0) {
                            this.record(6, 1, 1, 24);
                        }
                    }
                    if (t.type != 1028) break;
                    if (((LirFconst)t).value == 0.0) {
                        this.record(7, 1, 1, 21);
                    }
                    if (((LirFconst)t).value != 1.0) break;
                    this.record(7, 1, 1, 22);
                    break;
                }
                case 4: {
                    if (t.type != 514) break;
                    this.record(16, 0, 0, 20);
                    break;
                }
                case 6: {
                    if (t.type == 130) {
                        this.record(9, 0, 0, 1);
                    }
                    if (t.type == 258) {
                        this.record(10, 0, 0, 3);
                    }
                    if (t.type == 514) {
                        this.record(11, 0, 0, 5);
                        if (((LirSymRef)t).symbol.name == "%esp") {
                            this.record(45, 0, 0, 100);
                        }
                    }
                    if (t.type == 516) {
                        this.record(13, 0, 0, 9);
                    }
                    if (t.type == 1026) {
                        this.record(12, 0, 0, 7);
                    }
                    if (t.type != 1028) break;
                    this.record(14, 0, 0, 11);
                    break;
                }
                case 7: {
                    if (t.type == 130) {
                        this.record(9, 0, 0, 2);
                    }
                    if (t.type == 258) {
                        this.record(10, 0, 0, 4);
                    }
                    if (t.type == 514) {
                        this.record(11, 0, 0, 6);
                    }
                    if (t.type == 516) {
                        this.record(13, 0, 0, 10);
                    }
                    if (t.type == 1026) {
                        this.record(12, 0, 0, 8);
                    }
                    if (t.type != 1028) break;
                    this.record(14, 0, 0, 12);
                    break;
                }
                case 8: {
                    if (t.type != 514) break;
                    this.record(18, 0, 0, 29);
                    break;
                }
                case 9: {
                    if (t.type == 514 && kids[0].rule[2] != 0) {
                        this.record(2, 2 + kids[0].cost1[2], 2 + kids[0].cost2[2], 161);
                    }
                    if (t.type == 516 && kids[0].rule[6] != 0) {
                        this.record(6, 1 + kids[0].cost1[6], 1 + kids[0].cost2[6], 188);
                    }
                    if (t.type == 1026 && kids[0].rule[1] != 0) {
                        this.record(1, 2 + kids[0].cost1[1], 2 + kids[0].cost2[1], 128);
                    }
                    if (t.type != 1028 || kids[0].rule[7] == 0) break;
                    this.record(7, 1 + kids[0].cost1[7], 1 + kids[0].cost2[7], 183);
                    break;
                }
                case 10: {
                    if (t.type == 514) {
                        if (kids[0].rule[17] != 0 && kids[1].rule[15] != 0) {
                            this.record(17, 0 + kids[0].cost1[17] + kids[1].cost1[15], 0 + kids[0].cost2[17] + kids[1].cost2[15], 27);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[17] != 0) {
                            this.record(19, 0 + kids[0].cost1[2] + kids[1].cost1[17], 0 + kids[0].cost2[2] + kids[1].cost2[17], 32);
                        }
                        if (kids[0].rule[17] != 0 && kids[1].rule[2] != 0) {
                            this.record(19, 0 + kids[0].cost1[17] + kids[1].cost1[2], 0 + kids[0].cost2[17] + kids[1].cost2[2], 33);
                        }
                        if (kids[0].rule[19] != 0 && kids[1].rule[20] != 0) {
                            this.record(26, 0 + kids[0].cost1[19] + kids[1].cost1[20], 0 + kids[0].cost2[19] + kids[1].cost2[20], 49);
                        }
                        if (kids[0].rule[20] != 0 && kids[1].rule[19] != 0) {
                            this.record(26, 0 + kids[0].cost1[20] + kids[1].cost1[19], 0 + kids[0].cost2[20] + kids[1].cost2[19], 50);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                            this.record(2, 2 + kids[0].cost1[2] + kids[1].cost1[36], 2 + kids[0].cost2[2] + kids[1].cost2[36], 152);
                        }
                        if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                            this.record(2, 2 + kids[0].cost1[36] + kids[1].cost1[2], 2 + kids[0].cost2[36] + kids[1].cost2[2], 157);
                        }
                    }
                    if (t.type == 516 && kids[0].rule[6] != 0 && kids[1].rule[63] != 0) {
                        this.record(6, 2 + kids[0].cost1[6] + kids[1].cost1[63], 2 + kids[0].cost2[6] + kids[1].cost2[63], 184);
                    }
                    if (t.type == 1026 && kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[43], 2 + kids[0].cost2[1] + kids[1].cost2[43], 123);
                    }
                    if (t.type != 1028 || kids[0].rule[7] == 0 || kids[1].rule[62] == 0) break;
                    this.record(7, 2 + kids[0].cost1[7] + kids[1].cost1[62], 2 + kids[0].cost2[7] + kids[1].cost2[62], 179);
                    break;
                }
                case 11: {
                    if (t.type == 514) {
                        if (kids[0].rule[17] != 0 && kids[1].rule[15] != 0) {
                            this.record(17, 0 + kids[0].cost1[17] + kids[1].cost1[15], 0 + kids[0].cost2[17] + kids[1].cost2[15], 28);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[15] != 0) {
                            this.record(19, 0 + kids[0].cost1[2] + kids[1].cost1[15], 0 + kids[0].cost2[2] + kids[1].cost2[15], 34);
                        }
                        if (kids[0].rule[45] != 0 && kids[1].rule[2] != 0) {
                            this.record(46, 0 + kids[0].cost1[45] + kids[1].cost1[2], 0 + kids[0].cost2[45] + kids[1].cost2[2], 101);
                        }
                        if (kids[0].rule[45] != 0 && kids[1].rule[23] != 0) {
                            this.record(47, 0 + kids[0].cost1[45] + kids[1].cost1[23], 0 + kids[0].cost2[45] + kids[1].cost2[23], 103);
                        }
                        if (kids[0].rule[45] != 0 && kids[1].rule[22] != 0) {
                            this.record(51, 0 + kids[0].cost1[45] + kids[1].cost1[22], 0 + kids[0].cost2[45] + kids[1].cost2[22], 108);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                            this.record(2, 2 + kids[0].cost1[2] + kids[1].cost1[36], 2 + kids[0].cost2[2] + kids[1].cost2[36], 153);
                        }
                    }
                    if (t.type == 516 && kids[0].rule[6] != 0 && kids[1].rule[63] != 0) {
                        this.record(6, 2 + kids[0].cost1[6] + kids[1].cost1[63], 2 + kids[0].cost2[6] + kids[1].cost2[63], 185);
                    }
                    if (t.type == 1026 && kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[43], 2 + kids[0].cost2[1] + kids[1].cost2[43], 124);
                    }
                    if (t.type != 1028 || kids[0].rule[7] == 0 || kids[1].rule[62] == 0) break;
                    this.record(7, 2 + kids[0].cost1[7] + kids[1].cost1[62], 2 + kids[0].cost2[7] + kids[1].cost2[62], 180);
                    break;
                }
                case 12: {
                    if (t.type == 514) {
                        if (kids[0].rule[2] != 0 && kids[1].rule[21] != 0) {
                            this.record(20, 0 + kids[0].cost1[2] + kids[1].cost1[21], 0 + kids[0].cost2[2] + kids[1].cost2[21], 37);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[22] != 0) {
                            this.record(20, 0 + kids[0].cost1[2] + kids[1].cost1[22], 0 + kids[0].cost2[2] + kids[1].cost2[22], 39);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[23] != 0) {
                            this.record(20, 0 + kids[0].cost1[2] + kids[1].cost1[23], 0 + kids[0].cost2[2] + kids[1].cost2[23], 41);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                            this.record(2, 14 + kids[0].cost1[2] + kids[1].cost1[36], 14 + kids[0].cost2[2] + kids[1].cost2[36], 169);
                        }
                        if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                            this.record(2, 14 + kids[0].cost1[36] + kids[1].cost1[2], 14 + kids[0].cost2[36] + kids[1].cost2[2], 170);
                        }
                    }
                    if (t.type == 516 && kids[0].rule[6] != 0 && kids[1].rule[63] != 0) {
                        this.record(6, 2 + kids[0].cost1[6] + kids[1].cost1[63], 2 + kids[0].cost2[6] + kids[1].cost2[63], 186);
                    }
                    if (t.type == 1026 && kids[0].rule[1] != 0 && kids[1].rule[1] != 0) {
                        this.record(1, 7 + kids[0].cost1[1] + kids[1].cost1[1], 7 + kids[0].cost2[1] + kids[1].cost2[1], 147);
                    }
                    if (t.type != 1028 || kids[0].rule[7] == 0 || kids[1].rule[62] == 0) break;
                    this.record(7, 2 + kids[0].cost1[7] + kids[1].cost1[62], 2 + kids[0].cost2[7] + kids[1].cost2[62], 181);
                    break;
                }
                case 13: {
                    if (t.type == 514 && kids[0].rule[2] != 0 && kids[1].rule[2] != 0) {
                        this.record(2, 14 + kids[0].cost1[2] + kids[1].cost1[2], 14 + kids[0].cost2[2] + kids[1].cost2[2], 171);
                    }
                    if (t.type == 516 && kids[0].rule[6] != 0 && kids[1].rule[63] != 0) {
                        this.record(6, 2 + kids[0].cost1[6] + kids[1].cost1[63], 2 + kids[0].cost2[6] + kids[1].cost2[63], 187);
                    }
                    if (t.type == 1026 && kids[0].rule[43] != 0 && kids[1].rule[43] != 0) {
                        this.record(1, 6 + kids[0].cost1[43] + kids[1].cost1[43], 6 + kids[0].cost2[43] + kids[1].cost2[43], 148);
                    }
                    if (t.type != 1028 || kids[0].rule[7] == 0 || kids[1].rule[62] == 0) break;
                    this.record(7, 2 + kids[0].cost1[7] + kids[1].cost1[62], 2 + kids[0].cost2[7] + kids[1].cost2[62], 182);
                    break;
                }
                case 14: {
                    if (t.type == 514 && kids[0].rule[2] != 0 && kids[1].rule[2] != 0) {
                        this.record(2, 14 + kids[0].cost1[2] + kids[1].cost1[2], 14 + kids[0].cost2[2] + kids[1].cost2[2], 172);
                    }
                    if (t.type != 1026 || kids[0].rule[43] == 0 || kids[1].rule[43] == 0) break;
                    this.record(1, 6 + kids[0].cost1[43] + kids[1].cost1[43], 6 + kids[0].cost2[43] + kids[1].cost2[43], 149);
                    break;
                }
                case 15: {
                    if (t.type == 514 && kids[0].rule[2] != 0 && kids[1].rule[2] != 0) {
                        this.record(2, 14 + kids[0].cost1[2] + kids[1].cost1[2], 14 + kids[0].cost2[2] + kids[1].cost2[2], 173);
                    }
                    if (t.type != 1026 || kids[0].rule[43] == 0 || kids[1].rule[43] == 0) break;
                    this.record(1, 6 + kids[0].cost1[43] + kids[1].cost1[43], 6 + kids[0].cost2[43] + kids[1].cost2[43], 150);
                    break;
                }
                case 16: {
                    if (t.type == 514 && kids[0].rule[2] != 0 && kids[1].rule[2] != 0) {
                        this.record(2, 14 + kids[0].cost1[2] + kids[1].cost1[2], 14 + kids[0].cost2[2] + kids[1].cost2[2], 174);
                    }
                    if (t.type != 1026 || kids[0].rule[43] == 0 || kids[1].rule[43] == 0) break;
                    this.record(1, 6 + kids[0].cost1[43] + kids[1].cost1[43], 6 + kids[0].cost2[43] + kids[1].cost2[43], 151);
                    break;
                }
                case 17: {
                    if (t.type == 258 && kids[0].rule[41] != 0) {
                        this.record(4, 2 + kids[0].cost1[41], 2 + kids[0].cost2[41], 196);
                    }
                    if (t.type == 514) {
                        if (kids[0].rule[39] != 0) {
                            this.record(2, 2 + kids[0].cost1[39], 2 + kids[0].cost2[39], 194);
                        }
                        if (kids[0].rule[41] != 0) {
                            this.record(2, 2 + kids[0].cost1[41], 2 + kids[0].cost2[41], 195);
                        }
                    }
                    if (t.type != 1026) break;
                    if (kids[0].rule[2] != 0) {
                        this.record(1, 1 + kids[0].cost1[2], 1 + kids[0].cost2[2], 191);
                    }
                    if (kids[0].rule[4] != 0) {
                        this.record(1, 2 + kids[0].cost1[4], 2 + kids[0].cost2[4], 192);
                    }
                    if (kids[0].rule[5] == 0) break;
                    this.record(1, 2 + kids[0].cost1[5], 2 + kids[0].cost2[5], 193);
                    break;
                }
                case 18: {
                    if (t.type == 258 && kids[0].rule[41] != 0) {
                        this.record(4, 2 + kids[0].cost1[41], 2 + kids[0].cost2[41], 203);
                    }
                    if (t.type == 514) {
                        if (kids[0].rule[39] != 0) {
                            this.record(2, 2 + kids[0].cost1[39], 2 + kids[0].cost2[39], 201);
                        }
                        if (kids[0].rule[41] != 0) {
                            this.record(2, 2 + kids[0].cost1[41], 2 + kids[0].cost2[41], 202);
                        }
                    }
                    if (t.type != 1026) break;
                    if (kids[0].rule[37] != 0) {
                        this.record(1, 2 + kids[0].cost1[37], 2 + kids[0].cost2[37], 197);
                    }
                    if (kids[0].rule[39] != 0) {
                        this.record(1, 2 + kids[0].cost1[39], 2 + kids[0].cost2[39], 198);
                    }
                    if (kids[0].rule[41] != 0) {
                        this.record(1, 2 + kids[0].cost1[41], 2 + kids[0].cost2[41], 199);
                    }
                    if (kids[0].rule[41] == 0) break;
                    this.record(1, 2 + kids[0].cost1[41], 2 + kids[0].cost2[41], 200);
                    break;
                }
                case 19: {
                    if (t.type == 130) {
                        if (kids[0].rule[1] != 0) {
                            this.record(5, 2 + kids[0].cost1[1], 2 + kids[0].cost2[1], 206);
                        }
                        if (kids[0].rule[2] != 0) {
                            this.record(5, 2 + kids[0].cost1[2], 2 + kids[0].cost2[2], 208);
                        }
                        if (kids[0].rule[4] != 0) {
                            this.record(5, 2 + kids[0].cost1[4], 2 + kids[0].cost2[4], 209);
                        }
                    }
                    if (t.type == 258) {
                        if (kids[0].rule[1] != 0) {
                            this.record(4, 2 + kids[0].cost1[1], 2 + kids[0].cost2[1], 205);
                        }
                        if (kids[0].rule[2] != 0) {
                            this.record(4, 2 + kids[0].cost1[2], 2 + kids[0].cost2[2], 207);
                        }
                    }
                    if (t.type != 514 || kids[0].rule[1] == 0) break;
                    this.record(2, 2 + kids[0].cost1[1], 2 + kids[0].cost2[1], 204);
                    break;
                }
                case 20: {
                    if (t.type != 1028 || kids[0].rule[6] == 0) break;
                    this.record(7, 0 + kids[0].cost1[6], 0 + kids[0].cost2[6], 222);
                    break;
                }
                case 21: {
                    if (t.type != 516 || kids[0].rule[7] == 0) break;
                    this.record(6, 0 + kids[0].cost1[7], 0 + kids[0].cost2[7], 223);
                    break;
                }
                case 23: {
                    if (t.type == 130) {
                        if (kids[0].rule[7] != 0) {
                            this.record(5, 2 + kids[0].cost1[7], 2 + kids[0].cost2[7], 227);
                        }
                        if (kids[0].rule[6] != 0) {
                            this.record(5, 2 + kids[0].cost1[6], 2 + kids[0].cost2[6], 237);
                        }
                    }
                    if (t.type == 258) {
                        if (kids[0].rule[7] != 0) {
                            this.record(4, 2 + kids[0].cost1[7], 2 + kids[0].cost2[7], 226);
                        }
                        if (kids[0].rule[7] != 0) {
                            this.record(66, 0 + kids[0].cost1[7], 0 + kids[0].cost2[7], 232);
                        }
                        if (kids[0].rule[6] != 0) {
                            this.record(4, 2 + kids[0].cost1[6], 2 + kids[0].cost2[6], 236);
                        }
                        if (kids[0].rule[6] != 0) {
                            this.record(69, 0 + kids[0].cost1[6], 0 + kids[0].cost2[6], 242);
                        }
                    }
                    if (t.type == 514) {
                        if (kids[0].rule[7] != 0) {
                            this.record(2, 2 + kids[0].cost1[7], 2 + kids[0].cost2[7], 225);
                        }
                        if (kids[0].rule[7] != 0) {
                            this.record(65, 0 + kids[0].cost1[7], 0 + kids[0].cost2[7], 230);
                        }
                        if (kids[0].rule[6] != 0) {
                            this.record(2, 2 + kids[0].cost1[6], 2 + kids[0].cost2[6], 235);
                        }
                        if (kids[0].rule[6] != 0) {
                            this.record(68, 0 + kids[0].cost1[6], 0 + kids[0].cost2[6], 240);
                        }
                    }
                    if (t.type != 1026) break;
                    if (kids[0].rule[7] != 0) {
                        this.record(1, 2 + kids[0].cost1[7], 2 + kids[0].cost2[7], 224);
                    }
                    if (kids[0].rule[7] != 0) {
                        this.record(64, 0 + kids[0].cost1[7], 0 + kids[0].cost2[7], 228);
                    }
                    if (kids[0].rule[6] != 0) {
                        this.record(1, 2 + kids[0].cost1[6], 2 + kids[0].cost2[6], 234);
                    }
                    if (kids[0].rule[6] == 0) break;
                    this.record(67, 0 + kids[0].cost1[6], 0 + kids[0].cost2[6], 238);
                    break;
                }
                case 25: {
                    if (t.type == 516) {
                        if (kids[0].rule[27] != 0) {
                            this.record(6, 1 + kids[0].cost1[27], 1 + kids[0].cost2[27], 216);
                        }
                        if (kids[0].rule[1] != 0) {
                            this.record(6, 1 + kids[0].cost1[1], 1 + kids[0].cost2[1], 217);
                        }
                        if (kids[0].rule[28] != 0) {
                            this.record(6, 1 + kids[0].cost1[28], 1 + kids[0].cost2[28], 218);
                        }
                        if (kids[0].rule[3] != 0) {
                            this.record(6, 1 + kids[0].cost1[3], 1 + kids[0].cost2[3], 219);
                        }
                        if (kids[0].rule[29] != 0) {
                            this.record(6, 1 + kids[0].cost1[29], 1 + kids[0].cost2[29], 220);
                        }
                        if (kids[0].rule[4] != 0) {
                            this.record(6, 1 + kids[0].cost1[4], 1 + kids[0].cost2[4], 221);
                        }
                    }
                    if (t.type != 1028) break;
                    if (kids[0].rule[27] != 0) {
                        this.record(7, 1 + kids[0].cost1[27], 1 + kids[0].cost2[27], 210);
                    }
                    if (kids[0].rule[1] != 0) {
                        this.record(7, 1 + kids[0].cost1[1], 1 + kids[0].cost2[1], 211);
                    }
                    if (kids[0].rule[28] != 0) {
                        this.record(7, 1 + kids[0].cost1[28], 1 + kids[0].cost2[28], 212);
                    }
                    if (kids[0].rule[3] != 0) {
                        this.record(7, 1 + kids[0].cost1[3], 1 + kids[0].cost2[3], 213);
                    }
                    if (kids[0].rule[29] != 0) {
                        this.record(7, 1 + kids[0].cost1[29], 1 + kids[0].cost2[29], 214);
                    }
                    if (kids[0].rule[4] == 0) break;
                    this.record(7, 1 + kids[0].cost1[4], 1 + kids[0].cost2[4], 215);
                    break;
                }
                case 27: {
                    if (t.type == 514) {
                        if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                            this.record(2, 2 + kids[0].cost1[2] + kids[1].cost1[36], 2 + kids[0].cost2[2] + kids[1].cost2[36], 154);
                        }
                        if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                            this.record(2, 2 + kids[0].cost1[36] + kids[1].cost1[2], 2 + kids[0].cost2[36] + kids[1].cost2[2], 158);
                        }
                    }
                    if (t.type != 1026 || kids[0].rule[1] == 0 || kids[1].rule[43] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[43], 2 + kids[0].cost2[1] + kids[1].cost2[43], 125);
                    break;
                }
                case 28: {
                    if (t.type == 514) {
                        if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                            this.record(2, 2 + kids[0].cost1[2] + kids[1].cost1[36], 2 + kids[0].cost2[2] + kids[1].cost2[36], 155);
                        }
                        if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                            this.record(2, 2 + kids[0].cost1[36] + kids[1].cost1[2], 2 + kids[0].cost2[36] + kids[1].cost2[2], 159);
                        }
                    }
                    if (t.type != 1026 || kids[0].rule[1] == 0 || kids[1].rule[43] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[43], 2 + kids[0].cost2[1] + kids[1].cost2[43], 126);
                    break;
                }
                case 29: {
                    if (t.type == 514) {
                        if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                            this.record(2, 2 + kids[0].cost1[2] + kids[1].cost1[36], 2 + kids[0].cost2[2] + kids[1].cost2[36], 156);
                        }
                        if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                            this.record(2, 2 + kids[0].cost1[36] + kids[1].cost1[2], 2 + kids[0].cost2[36] + kids[1].cost2[2], 160);
                        }
                    }
                    if (t.type != 1026 || kids[0].rule[1] == 0 || kids[1].rule[43] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[43], 2 + kids[0].cost2[1] + kids[1].cost2[43], 127);
                    break;
                }
                case 30: {
                    if (t.type == 514 && kids[0].rule[2] != 0) {
                        this.record(2, 2 + kids[0].cost1[2], 2 + kids[0].cost2[2], 162);
                    }
                    if (t.type != 1026 || kids[0].rule[1] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1], 2 + kids[0].cost2[1], 129);
                    break;
                }
                case 31: {
                    if (t.type == 514) {
                        if (kids[0].rule[2] != 0 && kids[1].rule[24] != 0) {
                            this.record(20, 0 + kids[0].cost1[2] + kids[1].cost1[24], 0 + kids[0].cost2[2] + kids[1].cost2[24], 43);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[21] != 0) {
                            this.record(20, 0 + kids[0].cost1[2] + kids[1].cost1[21], 0 + kids[0].cost2[2] + kids[1].cost2[21], 44);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[25] != 0) {
                            this.record(20, 0 + kids[0].cost1[2] + kids[1].cost1[25], 0 + kids[0].cost2[2] + kids[1].cost2[25], 46);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[15] != 0) {
                            this.record(2, 2 + kids[0].cost1[2] + kids[1].cost1[15], 2 + kids[0].cost2[2] + kids[1].cost2[15], 163);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[61] != 0) {
                            this.record(2, 1 + kids[0].cost1[2] + kids[1].cost1[61], 1 + kids[0].cost2[2] + kids[1].cost2[61], 166);
                        }
                    }
                    if (t.type != 1026) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() < 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 130);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() == 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 131);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() > 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 132);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[61] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[61], 2 + kids[0].cost2[1] + kids[1].cost2[61], 133);
                    break;
                }
                case 33: {
                    if (t.type == 514) {
                        if (kids[0].rule[2] != 0 && kids[1].rule[15] != 0) {
                            this.record(2, 2 + kids[0].cost1[2] + kids[1].cost1[15], 2 + kids[0].cost2[2] + kids[1].cost2[15], 164);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[61] != 0) {
                            this.record(2, 1 + kids[0].cost1[2] + kids[1].cost1[61], 1 + kids[0].cost2[2] + kids[1].cost2[61], 167);
                        }
                    }
                    if (t.type != 1026) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() < 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 134);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() == 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 135);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() > 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 136);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[61] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[61], 2 + kids[0].cost2[1] + kids[1].cost2[61], 137);
                    break;
                }
                case 34: {
                    if (t.type == 514) {
                        if (kids[0].rule[2] != 0 && kids[1].rule[15] != 0) {
                            this.record(2, 2 + kids[0].cost1[2] + kids[1].cost1[15], 2 + kids[0].cost2[2] + kids[1].cost2[15], 165);
                        }
                        if (kids[0].rule[2] != 0 && kids[1].rule[61] != 0) {
                            this.record(2, 1 + kids[0].cost1[2] + kids[1].cost1[61], 1 + kids[0].cost2[2] + kids[1].cost2[61], 168);
                        }
                    }
                    if (t.type != 1026) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() < 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 138);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() == 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 139);
                    }
                    if (kids[0].rule[1] != 0 && kids[1].rule[15] != 0 && ((LirIconst)t.kid(1)).signedValue() > 32L) {
                        this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[15], 2 + kids[0].cost2[1] + kids[1].cost2[15], 140);
                    }
                    if (kids[0].rule[1] == 0 || kids[1].rule[61] == 0) break;
                    this.record(1, 2 + kids[0].cost1[1] + kids[1].cost1[61], 2 + kids[0].cost2[1] + kids[1].cost2[61], 141);
                    break;
                }
                case 35: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(70, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 245);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(80, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 265);
                    }
                    if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                        this.record(90, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 285);
                    }
                    if (kids[0].rule[5] != 0 && kids[1].rule[40] != 0) {
                        this.record(100, 0 + kids[0].cost1[5] + kids[1].cost1[40], 0 + kids[0].cost2[5] + kids[1].cost2[40], 305);
                    }
                    if (kids[0].rule[40] != 0 && kids[1].rule[5] != 0) {
                        this.record(102, 0 + kids[0].cost1[40] + kids[1].cost1[5], 0 + kids[0].cost2[40] + kids[1].cost2[5], 309);
                    }
                    if (kids[0].rule[7] != 0 && kids[1].rule[62] != 0) {
                        this.record(104, 0 + kids[0].cost1[7] + kids[1].cost1[62], 0 + kids[0].cost2[7] + kids[1].cost2[62], 313);
                    }
                    if (kids[0].rule[6] == 0 || kids[1].rule[63] == 0) break;
                    this.record(106, 0 + kids[0].cost1[6] + kids[1].cost1[63], 0 + kids[0].cost2[6] + kids[1].cost2[63], 317);
                    break;
                }
                case 36: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(71, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 247);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(81, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 267);
                    }
                    if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                        this.record(91, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 287);
                    }
                    if (kids[0].rule[5] != 0 && kids[1].rule[40] != 0) {
                        this.record(101, 0 + kids[0].cost1[5] + kids[1].cost1[40], 0 + kids[0].cost2[5] + kids[1].cost2[40], 307);
                    }
                    if (kids[0].rule[40] != 0 && kids[1].rule[5] != 0) {
                        this.record(103, 0 + kids[0].cost1[40] + kids[1].cost1[5], 0 + kids[0].cost2[40] + kids[1].cost2[5], 311);
                    }
                    if (kids[0].rule[7] != 0 && kids[1].rule[62] != 0) {
                        this.record(105, 0 + kids[0].cost1[7] + kids[1].cost1[62], 0 + kids[0].cost2[7] + kids[1].cost2[62], 315);
                    }
                    if (kids[0].rule[6] == 0 || kids[1].rule[63] == 0) break;
                    this.record(107, 0 + kids[0].cost1[6] + kids[1].cost1[63], 0 + kids[0].cost2[6] + kids[1].cost2[63], 319);
                    break;
                }
                case 37: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(72, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 249);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(82, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 269);
                    }
                    if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                        this.record(92, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 289);
                    }
                    if (kids[0].rule[7] != 0 && kids[1].rule[62] != 0) {
                        this.record(108, 0 + kids[0].cost1[7] + kids[1].cost1[62], 0 + kids[0].cost2[7] + kids[1].cost2[62], 321);
                    }
                    if (kids[0].rule[6] == 0 || kids[1].rule[63] == 0) break;
                    this.record(110, 0 + kids[0].cost1[6] + kids[1].cost1[63], 0 + kids[0].cost2[6] + kids[1].cost2[63], 325);
                    break;
                }
                case 38: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(73, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 251);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(83, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 271);
                    }
                    if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                        this.record(93, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 291);
                    }
                    if (kids[0].rule[7] != 0 && kids[1].rule[62] != 0) {
                        this.record(113, 0 + kids[0].cost1[7] + kids[1].cost1[62], 0 + kids[0].cost2[7] + kids[1].cost2[62], 331);
                    }
                    if (kids[0].rule[6] == 0 || kids[1].rule[63] == 0) break;
                    this.record(115, 0 + kids[0].cost1[6] + kids[1].cost1[63], 0 + kids[0].cost2[6] + kids[1].cost2[63], 335);
                    break;
                }
                case 39: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(74, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 253);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(84, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 273);
                    }
                    if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                        this.record(94, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 293);
                    }
                    if (kids[0].rule[7] != 0 && kids[1].rule[62] != 0) {
                        this.record(112, 0 + kids[0].cost1[7] + kids[1].cost1[62], 0 + kids[0].cost2[7] + kids[1].cost2[62], 329);
                    }
                    if (kids[0].rule[6] == 0 || kids[1].rule[63] == 0) break;
                    this.record(114, 0 + kids[0].cost1[6] + kids[1].cost1[63], 0 + kids[0].cost2[6] + kids[1].cost2[63], 333);
                    break;
                }
                case 40: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(75, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 255);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(85, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 275);
                    }
                    if (kids[0].rule[36] != 0 && kids[1].rule[2] != 0) {
                        this.record(95, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 295);
                    }
                    if (kids[0].rule[7] != 0 && kids[1].rule[62] != 0) {
                        this.record(109, 0 + kids[0].cost1[7] + kids[1].cost1[62], 0 + kids[0].cost2[7] + kids[1].cost2[62], 323);
                    }
                    if (kids[0].rule[6] == 0 || kids[1].rule[63] == 0) break;
                    this.record(111, 0 + kids[0].cost1[6] + kids[1].cost1[63], 0 + kids[0].cost2[6] + kids[1].cost2[63], 327);
                    break;
                }
                case 41: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(76, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 257);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(86, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 277);
                    }
                    if (kids[0].rule[36] == 0 || kids[1].rule[2] == 0) break;
                    this.record(96, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 297);
                    break;
                }
                case 42: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(77, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 259);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(87, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 279);
                    }
                    if (kids[0].rule[36] == 0 || kids[1].rule[2] == 0) break;
                    this.record(97, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 299);
                    break;
                }
                case 43: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(78, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 261);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(88, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 281);
                    }
                    if (kids[0].rule[36] == 0 || kids[1].rule[2] == 0) break;
                    this.record(98, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 301);
                    break;
                }
                case 44: {
                    if (t.type != 514) break;
                    if (kids[0].rule[1] != 0 && kids[1].rule[43] != 0) {
                        this.record(79, 0 + kids[0].cost1[1] + kids[1].cost1[43], 0 + kids[0].cost2[1] + kids[1].cost2[43], 263);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[36] != 0) {
                        this.record(89, 0 + kids[0].cost1[2] + kids[1].cost1[36], 0 + kids[0].cost2[2] + kids[1].cost2[36], 283);
                    }
                    if (kids[0].rule[36] == 0 || kids[1].rule[2] == 0) break;
                    this.record(99, 0 + kids[0].cost1[36] + kids[1].cost1[2], 0 + kids[0].cost2[36] + kids[1].cost2[2], 303);
                    break;
                }
                case 47: {
                    if (t.type == 130 && kids[0].rule[26] != 0) {
                        this.record(30, 0 + kids[0].cost1[26], 0 + kids[0].cost2[26], 54);
                    }
                    if (t.type == 258 && kids[0].rule[26] != 0) {
                        this.record(29, 0 + kids[0].cost1[26], 0 + kids[0].cost2[26], 53);
                    }
                    if (t.type == 514) {
                        if (kids[0].rule[26] != 0) {
                            this.record(28, 0 + kids[0].cost1[26], 0 + kids[0].cost2[26], 52);
                        }
                        if (kids[0].rule[51] != 0) {
                            this.record(52, 0 + kids[0].cost1[51], 0 + kids[0].cost2[51], 109);
                        }
                    }
                    if (t.type == 516) {
                        if (kids[0].rule[26] != 0) {
                            this.record(31, 0 + kids[0].cost1[26], 0 + kids[0].cost2[26], 55);
                        }
                        if (kids[0].rule[51] != 0) {
                            this.record(55, 0 + kids[0].cost1[51], 0 + kids[0].cost2[51], 113);
                        }
                    }
                    if (t.type == 1026) {
                        if (kids[0].rule[26] != 0) {
                            this.record(27, 0 + kids[0].cost1[26], 0 + kids[0].cost2[26], 51);
                        }
                        if (kids[0].rule[47] != 0) {
                            this.record(48, 0 + kids[0].cost1[47], 0 + kids[0].cost2[47], 104);
                        }
                    }
                    if (t.type != 1028) break;
                    if (kids[0].rule[26] != 0) {
                        this.record(32, 0 + kids[0].cost1[26], 0 + kids[0].cost2[26], 56);
                    }
                    if (kids[0].rule[47] == 0) break;
                    this.record(57, 0 + kids[0].cost1[47], 0 + kids[0].cost2[47], 116);
                    break;
                }
                case 48: {
                    if (t.type == 130) {
                        if (kids[0].rule[30] != 0 && kids[1].rule[35] != 0) {
                            this.record(8, 1 + kids[0].cost1[30] + kids[1].cost1[35], 1 + kids[0].cost2[30] + kids[1].cost2[35], 91);
                        }
                        if (kids[0].rule[9] != 0 && kids[1].rule[5] != 0) {
                            this.record(8, 1 + kids[0].cost1[9] + kids[1].cost1[5], 1 + kids[0].cost2[9] + kids[1].cost2[5], 95);
                        }
                    }
                    if (t.type == 258) {
                        if (kids[0].rule[29] != 0 && kids[1].rule[34] != 0) {
                            this.record(8, 1 + kids[0].cost1[29] + kids[1].cost1[34], 1 + kids[0].cost2[29] + kids[1].cost2[34], 90);
                        }
                        if (kids[0].rule[10] != 0 && kids[1].rule[4] != 0) {
                            this.record(8, 1 + kids[0].cost1[10] + kids[1].cost1[4], 1 + kids[0].cost2[10] + kids[1].cost2[4], 94);
                        }
                    }
                    if (t.type == 514) {
                        if (kids[0].rule[28] != 0 && kids[1].rule[33] != 0) {
                            this.record(8, 1 + kids[0].cost1[28] + kids[1].cost1[33], 1 + kids[0].cost2[28] + kids[1].cost2[33], 89);
                        }
                        if (kids[0].rule[11] != 0 && kids[1].rule[2] != 0) {
                            this.record(8, 1 + kids[0].cost1[11] + kids[1].cost1[2], 1 + kids[0].cost2[11] + kids[1].cost2[2], 93);
                        }
                        if (kids[0].rule[45] != 0 && kids[1].rule[46] != 0 && CodeGenerator_x86.this.convention == "cygwin") {
                            this.record(8, 0 + kids[0].cost1[45] + kids[1].cost1[46], 0 + kids[0].cost2[45] + kids[1].cost2[46], 102);
                        }
                        if (kids[0].rule[45] != 0 && kids[1].rule[47] != 0) {
                            this.record(50, 0 + kids[0].cost1[45] + kids[1].cost1[47], 0 + kids[0].cost2[45] + kids[1].cost2[47], 106);
                        }
                        if (kids[0].rule[52] != 0 && kids[1].rule[36] != 0) {
                            this.record(53, 0 + kids[0].cost1[52] + kids[1].cost1[36], 0 + kids[0].cost2[52] + kids[1].cost2[36], 110);
                        }
                        if (kids[0].rule[45] != 0 && kids[1].rule[51] != 0) {
                            this.record(54, 0 + kids[0].cost1[45] + kids[1].cost1[51], 0 + kids[0].cost2[45] + kids[1].cost2[51], 111);
                        }
                        if (kids[0].rule[28] != 0 && kids[1].rule[65] != 0) {
                            this.record(8, 2 + kids[0].cost1[28] + kids[1].cost1[65], 2 + kids[0].cost2[28] + kids[1].cost2[65], 231);
                        }
                        if (kids[0].rule[29] != 0 && kids[1].rule[66] != 0) {
                            this.record(8, 2 + kids[0].cost1[29] + kids[1].cost1[66], 2 + kids[0].cost2[29] + kids[1].cost2[66], 233);
                        }
                        if (kids[0].rule[28] != 0 && kids[1].rule[68] != 0) {
                            this.record(8, 2 + kids[0].cost1[28] + kids[1].cost1[68], 2 + kids[0].cost2[28] + kids[1].cost2[68], 241);
                        }
                        if (kids[0].rule[29] != 0 && kids[1].rule[69] != 0) {
                            this.record(8, 2 + kids[0].cost1[29] + kids[1].cost1[69], 2 + kids[0].cost2[29] + kids[1].cost2[69], 243);
                        }
                    }
                    if (t.type == 516) {
                        if (kids[0].rule[13] != 0 && kids[1].rule[6] != 0) {
                            this.record(8, 1 + kids[0].cost1[13] + kids[1].cost1[6], 1 + kids[0].cost2[13] + kids[1].cost2[6], 96);
                        }
                        if (kids[0].rule[31] != 0 && kids[1].rule[6] != 0) {
                            this.record(8, 1 + kids[0].cost1[31] + kids[1].cost1[6], 1 + kids[0].cost2[31] + kids[1].cost2[6], 99);
                        }
                        if (kids[0].rule[55] != 0 && kids[1].rule[31] != 0) {
                            this.record(56, 0 + kids[0].cost1[55] + kids[1].cost1[31], 0 + kids[0].cost2[55] + kids[1].cost2[31], 114);
                        }
                        if (kids[0].rule[55] != 0 && kids[1].rule[6] != 0) {
                            this.record(59, 0 + kids[0].cost1[55] + kids[1].cost1[6], 0 + kids[0].cost2[55] + kids[1].cost2[6], 119);
                        }
                    }
                    if (t.type == 1026) {
                        if (kids[0].rule[27] != 0 && kids[1].rule[1] != 0) {
                            this.record(8, 2 + kids[0].cost1[27] + kids[1].cost1[1], 2 + kids[0].cost2[27] + kids[1].cost2[1], 88);
                        }
                        if (kids[0].rule[12] != 0 && kids[1].rule[1] != 0) {
                            this.record(8, 2 + kids[0].cost1[12] + kids[1].cost1[1], 2 + kids[0].cost2[12] + kids[1].cost2[1], 92);
                        }
                        if (kids[0].rule[48] != 0 && kids[1].rule[43] != 0) {
                            this.record(49, 0 + kids[0].cost1[48] + kids[1].cost1[43], 0 + kids[0].cost2[48] + kids[1].cost2[43], 105);
                        }
                        if (kids[0].rule[27] != 0 && kids[1].rule[64] != 0) {
                            this.record(8, 2 + kids[0].cost1[27] + kids[1].cost1[64], 2 + kids[0].cost2[27] + kids[1].cost2[64], 229);
                        }
                        if (kids[0].rule[27] != 0 && kids[1].rule[67] != 0) {
                            this.record(8, 2 + kids[0].cost1[27] + kids[1].cost1[67], 2 + kids[0].cost2[27] + kids[1].cost2[67], 239);
                        }
                    }
                    if (t.type != 1028) break;
                    if (kids[0].rule[14] != 0 && kids[1].rule[7] != 0) {
                        this.record(8, 1 + kids[0].cost1[14] + kids[1].cost1[7], 1 + kids[0].cost2[14] + kids[1].cost2[7], 97);
                    }
                    if (kids[0].rule[32] != 0 && kids[1].rule[7] != 0) {
                        this.record(8, 1 + kids[0].cost1[32] + kids[1].cost1[7], 1 + kids[0].cost2[32] + kids[1].cost2[7], 98);
                    }
                    if (kids[0].rule[57] != 0 && kids[1].rule[32] != 0) {
                        this.record(58, 0 + kids[0].cost1[57] + kids[1].cost1[32], 0 + kids[0].cost2[57] + kids[1].cost2[32], 117);
                    }
                    if (kids[0].rule[57] == 0 || kids[1].rule[7] == 0) break;
                    this.record(60, 0 + kids[0].cost1[57] + kids[1].cost1[7], 0 + kids[0].cost2[57] + kids[1].cost2[7], 121);
                    break;
                }
                case 49: {
                    if (kids[0].rule[18] == 0) break;
                    this.record(8, 3 + kids[0].cost1[18], 3 + kids[0].cost2[18], 244);
                    break;
                }
                case 50: {
                    if (kids[0].rule[70] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[70] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[70] + kids[1].cost2[18] + kids[2].cost2[18], 246);
                    }
                    if (kids[0].rule[71] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[71] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[71] + kids[1].cost2[18] + kids[2].cost2[18], 248);
                    }
                    if (kids[0].rule[72] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[72] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[72] + kids[1].cost2[18] + kids[2].cost2[18], 250);
                    }
                    if (kids[0].rule[73] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[73] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[73] + kids[1].cost2[18] + kids[2].cost2[18], 252);
                    }
                    if (kids[0].rule[74] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[74] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[74] + kids[1].cost2[18] + kids[2].cost2[18], 254);
                    }
                    if (kids[0].rule[75] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[75] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[75] + kids[1].cost2[18] + kids[2].cost2[18], 256);
                    }
                    if (kids[0].rule[76] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[76] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[76] + kids[1].cost2[18] + kids[2].cost2[18], 258);
                    }
                    if (kids[0].rule[77] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[77] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[77] + kids[1].cost2[18] + kids[2].cost2[18], 260);
                    }
                    if (kids[0].rule[78] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[78] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[78] + kids[1].cost2[18] + kids[2].cost2[18], 262);
                    }
                    if (kids[0].rule[79] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 8 + kids[0].cost1[79] + kids[1].cost1[18] + kids[2].cost1[18], 8 + kids[0].cost2[79] + kids[1].cost2[18] + kids[2].cost2[18], 264);
                    }
                    if (kids[0].rule[80] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[80] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[80] + kids[1].cost2[18] + kids[2].cost2[18], 266);
                    }
                    if (kids[0].rule[81] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[81] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[81] + kids[1].cost2[18] + kids[2].cost2[18], 268);
                    }
                    if (kids[0].rule[82] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[82] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[82] + kids[1].cost2[18] + kids[2].cost2[18], 270);
                    }
                    if (kids[0].rule[83] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[83] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[83] + kids[1].cost2[18] + kids[2].cost2[18], 272);
                    }
                    if (kids[0].rule[84] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[84] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[84] + kids[1].cost2[18] + kids[2].cost2[18], 274);
                    }
                    if (kids[0].rule[85] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[85] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[85] + kids[1].cost2[18] + kids[2].cost2[18], 276);
                    }
                    if (kids[0].rule[86] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[86] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[86] + kids[1].cost2[18] + kids[2].cost2[18], 278);
                    }
                    if (kids[0].rule[87] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[87] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[87] + kids[1].cost2[18] + kids[2].cost2[18], 280);
                    }
                    if (kids[0].rule[88] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[88] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[88] + kids[1].cost2[18] + kids[2].cost2[18], 282);
                    }
                    if (kids[0].rule[89] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[89] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[89] + kids[1].cost2[18] + kids[2].cost2[18], 284);
                    }
                    if (kids[0].rule[90] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[90] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[90] + kids[1].cost2[18] + kids[2].cost2[18], 286);
                    }
                    if (kids[0].rule[91] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[91] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[91] + kids[1].cost2[18] + kids[2].cost2[18], 288);
                    }
                    if (kids[0].rule[92] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[92] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[92] + kids[1].cost2[18] + kids[2].cost2[18], 290);
                    }
                    if (kids[0].rule[93] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[93] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[93] + kids[1].cost2[18] + kids[2].cost2[18], 292);
                    }
                    if (kids[0].rule[94] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[94] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[94] + kids[1].cost2[18] + kids[2].cost2[18], 294);
                    }
                    if (kids[0].rule[95] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[95] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[95] + kids[1].cost2[18] + kids[2].cost2[18], 296);
                    }
                    if (kids[0].rule[96] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[96] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[96] + kids[1].cost2[18] + kids[2].cost2[18], 298);
                    }
                    if (kids[0].rule[97] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[97] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[97] + kids[1].cost2[18] + kids[2].cost2[18], 300);
                    }
                    if (kids[0].rule[98] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[98] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[98] + kids[1].cost2[18] + kids[2].cost2[18], 302);
                    }
                    if (kids[0].rule[99] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[99] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[99] + kids[1].cost2[18] + kids[2].cost2[18], 304);
                    }
                    if (kids[0].rule[100] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[100] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[100] + kids[1].cost2[18] + kids[2].cost2[18], 306);
                    }
                    if (kids[0].rule[101] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[101] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[101] + kids[1].cost2[18] + kids[2].cost2[18], 308);
                    }
                    if (kids[0].rule[102] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[102] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[102] + kids[1].cost2[18] + kids[2].cost2[18], 310);
                    }
                    if (kids[0].rule[103] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[103] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[103] + kids[1].cost2[18] + kids[2].cost2[18], 312);
                    }
                    if (kids[0].rule[104] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[104] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[104] + kids[1].cost2[18] + kids[2].cost2[18], 314);
                    }
                    if (kids[0].rule[105] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[105] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[105] + kids[1].cost2[18] + kids[2].cost2[18], 316);
                    }
                    if (kids[0].rule[106] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[106] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[106] + kids[1].cost2[18] + kids[2].cost2[18], 318);
                    }
                    if (kids[0].rule[107] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[107] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[107] + kids[1].cost2[18] + kids[2].cost2[18], 320);
                    }
                    if (kids[0].rule[108] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[108] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[108] + kids[1].cost2[18] + kids[2].cost2[18], 322);
                    }
                    if (kids[0].rule[109] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[109] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[109] + kids[1].cost2[18] + kids[2].cost2[18], 324);
                    }
                    if (kids[0].rule[110] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[110] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[110] + kids[1].cost2[18] + kids[2].cost2[18], 326);
                    }
                    if (kids[0].rule[111] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[111] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[111] + kids[1].cost2[18] + kids[2].cost2[18], 328);
                    }
                    if (kids[0].rule[112] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[112] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[112] + kids[1].cost2[18] + kids[2].cost2[18], 330);
                    }
                    if (kids[0].rule[113] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[113] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[113] + kids[1].cost2[18] + kids[2].cost2[18], 332);
                    }
                    if (kids[0].rule[114] != 0 && kids[1].rule[18] != 0 && kids[2].rule[18] != 0) {
                        this.record(8, 4 + kids[0].cost1[114] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[114] + kids[1].cost2[18] + kids[2].cost2[18], 334);
                    }
                    if (kids[0].rule[115] == 0 || kids[1].rule[18] == 0 || kids[2].rule[18] == 0) break;
                    this.record(8, 4 + kids[0].cost1[115] + kids[1].cost1[18] + kids[2].cost1[18], 4 + kids[0].cost2[115] + kids[1].cost2[18] + kids[2].cost2[18], 336);
                    break;
                }
                case 53: {
                    if (kids[0].rule[44] == 0) break;
                    this.record(8, 4 + kids[0].cost1[44], 4 + kids[0].cost2[44], 337);
                    break;
                }
                case 56: {
                    if (kids.length == 2 && kids[0].rule[49] != 0 && kids[1].rule[50] != 0) {
                        this.record(8, 2 + kids[0].cost1[49] + kids[1].cost1[50], 2 + kids[0].cost2[49] + kids[1].cost2[50], 107);
                    }
                    if (kids.length == 2 && kids[0].rule[53] != 0 && kids[1].rule[54] != 0) {
                        this.record(8, 1 + kids[0].cost1[53] + kids[1].cost1[54], 1 + kids[0].cost2[53] + kids[1].cost2[54], 112);
                    }
                    if (kids.length == 2 && kids[0].rule[56] != 0 && kids[1].rule[54] != 0) {
                        this.record(8, 1 + kids[0].cost1[56] + kids[1].cost1[54], 1 + kids[0].cost2[56] + kids[1].cost2[54], 115);
                    }
                    if (kids.length == 2 && kids[0].rule[58] != 0 && kids[1].rule[50] != 0) {
                        this.record(8, 1 + kids[0].cost1[58] + kids[1].cost1[50], 1 + kids[0].cost2[58] + kids[1].cost2[50], 118);
                    }
                    if (kids.length == 2 && kids[0].rule[59] != 0 && kids[1].rule[54] != 0) {
                        this.record(8, 1 + kids[0].cost1[59] + kids[1].cost1[54], 1 + kids[0].cost2[59] + kids[1].cost2[54], 120);
                    }
                    if (kids.length != 2 || kids[0].rule[60] == 0 || kids[1].rule[50] == 0) break;
                    this.record(8, 1 + kids[0].cost1[60] + kids[1].cost1[50], 1 + kids[0].cost2[60] + kids[1].cost2[50], 122);
                }
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("State(");
            boolean comma = false;
            for (int i = 0; i < 116; ++i) {
                if (this.rule[i] == 0) continue;
                if (comma) {
                    buf.append(",");
                }
                buf.append(this.nontermName(i) + ":" + this.rule[i] + "[" + this.cost1[i] + "." + this.cost2[i] + "]");
                comma = true;
            }
            buf.append(")");
            return buf.toString();
        }
    }

    class RewrState {
        static final int NNONTERM = 8;
        static final int NRULES = 34;
        static final int START_NT = 1;
        static final int NT__ = 0;
        static final int NT__rewr = 1;
        static final int NT__1 = 2;
        static final int NT__2 = 3;
        static final int NT__3 = 4;
        static final int NT_sbyteopr = 5;
        static final int NT_ubyteopr = 6;
        static final int NT__4 = 7;
        final int[] rule = new int[8];
        boolean rewritten;

        RewrState() {
        }

        String nontermName(int nt) {
            switch (nt) {
                case 0: {
                    return "_";
                }
                case 1: {
                    return "_rewr";
                }
                case 2: {
                    return "_1";
                }
                case 3: {
                    return "_2";
                }
                case 4: {
                    return "_3";
                }
                case 5: {
                    return "sbyteopr";
                }
                case 6: {
                    return "ubyteopr";
                }
                case 7: {
                    return "_4";
                }
            }
            return null;
        }

        void record(int nt, int rule) {
            if (this.rule[nt] == 0) {
                this.rule[nt] = rule;
            }
        }

        LirNode labelAndRewrite(LirNode t, RewrState[] kids, String phase, BiList pre, BiList post) {
            switch (t.opCode) {
                case 2: {
                    if (t.type != 514) break;
                    if (-128L <= ((LirIconst)t).signedValue() && ((LirIconst)t).signedValue() <= 127L) {
                        this.record(5, 21);
                    }
                    if (((LirIconst)t).unsignedValue() > 255L) break;
                    this.record(6, 23);
                    break;
                }
                case 3: {
                    if (((LirFconst)t).value == 0.0) {
                        return null;
                    }
                    if (((LirFconst)t).value == 1.0) {
                        return null;
                    }
                    if (t.type == 516 && phase == "late") {
                        this.rewritten = true;
                        return CodeGenerator_x86.this.lir.node(47, 516, CodeGenerator_x86.this.lir.node(4, 514, CodeGenerator_x86.this.module.constToData(t)));
                    }
                    if (t.type != 1028 || phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.lir.node(47, 1028, CodeGenerator_x86.this.lir.node(4, 514, CodeGenerator_x86.this.module.constToData(t)));
                }
                case 4: {
                    if (t.type != 514) break;
                    if (((LirSymRef)t).symbol.name == "__builtin_va_start") {
                        this.record(2, 7);
                    }
                    if (((LirSymRef)t).symbol.name != "alloca") break;
                    this.record(4, 10);
                    break;
                }
                case 6: {
                    if (t.type != 514 || ((LirSymRef)t).symbol.name != ".strretp" || phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.lir.node(47, 514, CodeGenerator_x86.this.lir.node(10, 514, CodeGenerator_x86.this.lir.node(6, 514, CodeGenerator_x86.this.func.getSymbol("%ebp")), CodeGenerator_x86.this.lir.iconst(514, 8L)));
                }
                case 17: {
                    this.record(7, 24);
                    if (t.type != 514 || t.kid((int)0).type != CodeGenerator.I8) break;
                    this.record(5, 20);
                    break;
                }
                case 18: {
                    if (t.type != 514 || t.kid((int)0).type != CodeGenerator.I8) break;
                    this.record(6, 22);
                    break;
                }
                case 24: {
                    if (phase != "early") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.rewriteCONVFU(t, pre);
                }
                case 26: {
                    if (phase != "early") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.rewriteCONVUF(t, pre);
                }
                case 31: {
                    if (t.type == 514 && kids[1].rule[7] != 0 && phase == "late") {
                        this.rewritten = true;
                        return CodeGenerator_x86.this.lir.node(31, 514, t.kid(0), t.kid(1).kid(0));
                    }
                    if (t.type != 1026 || kids[1].rule[7] == 0 || phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.lir.node(31, 1026, t.kid(0), t.kid(1).kid(0));
                }
                case 33: {
                    if (t.type == 514 && kids[1].rule[7] != 0 && phase == "late") {
                        this.rewritten = true;
                        return CodeGenerator_x86.this.lir.node(33, 514, t.kid(0), t.kid(1).kid(0));
                    }
                    if (t.type != 1026 || kids[1].rule[7] == 0 || phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.lir.node(33, 1026, t.kid(0), t.kid(1).kid(0));
                }
                case 34: {
                    if (t.type == 514 && kids[1].rule[7] != 0 && phase == "late") {
                        this.rewritten = true;
                        return CodeGenerator_x86.this.lir.node(34, 514, t.kid(0), t.kid(1).kid(0));
                    }
                    if (t.type != 1026 || kids[1].rule[7] == 0 || phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.lir.node(34, 1026, t.kid(0), t.kid(1).kid(0));
                }
                case 35: {
                    if (t.type != 514) break;
                    if (kids[0].rule[5] != 0 && kids[1].rule[5] != 0 && phase == "late") {
                        this.rewritten = true;
                        return CodeGenerator_x86.this.lir.node(35, 514, CodeGenerator_x86.this.stripConv(t.kid(0)), CodeGenerator_x86.this.stripConv(t.kid(1)));
                    }
                    if (kids[0].rule[6] == 0 || kids[1].rule[6] == 0 || phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.lir.node(35, 514, CodeGenerator_x86.this.stripConv(t.kid(0)), CodeGenerator_x86.this.stripConv(t.kid(1)));
                }
                case 36: {
                    if (t.type != 514) break;
                    if (kids[0].rule[5] != 0 && kids[1].rule[5] != 0 && phase == "late") {
                        this.rewritten = true;
                        return CodeGenerator_x86.this.lir.node(36, 514, CodeGenerator_x86.this.stripConv(t.kid(0)), CodeGenerator_x86.this.stripConv(t.kid(1)));
                    }
                    if (kids[0].rule[6] == 0 || kids[1].rule[6] == 0 || phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.lir.node(36, 514, CodeGenerator_x86.this.stripConv(t.kid(0)), CodeGenerator_x86.this.stripConv(t.kid(1)));
                }
                case 48: {
                    if (phase != "late" || Type.tag(t.type) != 1) break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.rewriteAggregateCopy(t, pre);
                }
                case 51: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.rewriteJumpn(t, pre);
                }
                case 53: {
                    if (phase == "late") {
                        this.rewritten = true;
                        return CodeGenerator_x86.this.rewriteCall(t, pre, post);
                    }
                    if (kids[0].rule[2] != 0 && kids[1].rule[3] != 0 && kids[2].rule[3] != 0 && phase == "early") {
                        this.rewritten = true;
                        return CodeGenerator_x86.this.lir.node(48, 514, t.kid(2).kid(0), CodeGenerator_x86.this.lir.node(10, 514, CodeGenerator_x86.this.lir.node(6, 514, CodeGenerator_x86.this.func.getSymbol("%ebp")), CodeGenerator_x86.this.lir.iconst(514, CodeGenerator_x86.this.makeVaStart(t.kid(1).kid(0)))));
                    }
                    if (kids[0].rule[4] == 0 || kids[1].rule[3] == 0 || kids[2].rule[3] == 0 || phase != "early") break;
                    this.rewritten = true;
                    CodeGenerator_x86.this.setAllocaCalled();
                    pre.add(CodeGenerator_x86.this.lir.node(48, 514, CodeGenerator_x86.this.lir.node(6, 514, CodeGenerator_x86.this.func.getSymbol("%esp")), CodeGenerator_x86.this.lir.node(11, 514, CodeGenerator_x86.this.lir.node(6, 514, CodeGenerator_x86.this.func.getSymbol("%esp")), CodeGenerator_x86.this.lir.node(27, 514, CodeGenerator_x86.this.lir.node(10, 514, t.kid(1).kid(0), CodeGenerator_x86.this.lir.iconst(514, 3L)), CodeGenerator_x86.this.lir.iconst(514, -4L)))));
                    return CodeGenerator_x86.this.lir.node(48, 514, t.kid(2).kid(0), CodeGenerator_x86.this.lir.node(6, 514, CodeGenerator_x86.this.func.getSymbol("%esp")));
                }
                case 54: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.noRescan(CodeGenerator_x86.this.rewritePrologue(t, post));
                }
                case 55: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.noRescan(CodeGenerator_x86.this.rewriteEpilogue(t, pre));
                }
                case 61: {
                    if (kids.length != 1) break;
                    this.record(3, 8);
                    break;
                }
                case 67: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_x86.this.noRescan(CodeGenerator_x86.this.rewriteAsm(t, pre, post));
                }
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("State(");
            boolean comma = false;
            for (int i = 0; i < 8; ++i) {
                if (this.rule[i] == 0) continue;
                if (comma) {
                    buf.append(",");
                }
                buf.append(this.nontermName(i));
                comma = true;
            }
            buf.append(")");
            return buf.toString();
        }
    }
}

