/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.lir;

import coins.backend.Op;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirVisitor;
import coins.backend.util.ImList;

public class LirIconst
extends LirNode {
    public final long value;

    public LirIconst(int id, int t, long v, ImList opt) {
        super(id, 2, t, opt);
        this.value = v;
    }

    public LirNode makeCopy(LirFactory fac) {
        return fac.iconst(this.type, this.value, this.opt);
    }

    public LirNode replaceOptions(LirFactory fac, ImList newOpt) {
        return fac.iconst(this.type, this.value, newOpt);
    }

    public long signedValue() {
        int bits = Type.bits(this.type);
        if (bits >= 64) {
            return this.value;
        }
        long signbit = 1L << bits - 1;
        long mask = (1L << bits) - 1L;
        return -((this.value & signbit) << 1) | this.value & mask;
    }

    public long unsignedValue() {
        if (Type.bits(this.type) >= 64) {
            return this.value;
        }
        return this.value & (1L << Type.bits(this.type)) - 1L;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32 ^ (long)this.type);
    }

    public Object toSexp() {
        if (this.opt.locate("&untagged") != null) {
            return Long.toString(this.value).intern();
        }
        return ImList.list(Op.toName(this.opCode), Type.toString(this.type), this.value + "").append(this.opt.makeCopy());
    }

    public String toString() {
        if (this.opt.locate("&untagged") != null) {
            return Long.toString(this.value);
        }
        return "(" + Op.toName(this.opCode) + " " + Type.toString(this.type) + " " + this.value + "" + ")";
    }

    public boolean equals(Object x) {
        return x instanceof LirIconst && super.equals(x) && this.value == ((LirIconst)x).value;
    }

    public void accept(LirVisitor v) {
        v.visit(this);
    }

    public String toStringExp() {
        return Long.toString(this.signedValue());
    }
}

