/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sym;

import coins.backend.Storage;
import coins.backend.SyntaxError;
import coins.backend.Type;
import coins.backend.sym.SymAuto;
import coins.backend.sym.SymStatic;
import coins.backend.sym.SymTab;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;

public abstract class Symbol {
    public final SymTab table;
    public final String name;
    public final int id;
    public final int storage;
    public final int type;
    public final int boundary;
    ImList opt;

    Symbol(SymTab table, String name, int id, int storage, int type, int boundary, ImList opt) {
        this.table = table;
        this.name = name;
        this.id = id;
        this.storage = storage;
        this.type = type;
        this.boundary = boundary;
        this.opt = opt == null ? ImList.Empty : opt;
    }

    static Symbol parseSymbol(SymTab table, int id, ImList list) throws SyntaxError {
        int offset2;
        int boundary2;
        String name = ((QuotedString)list.elem()).body;
        int tag = Storage.decode((String)list.elem2nd());
        int type = Type.decode((String)list.elem3rd());
        switch (tag) {
            case 0: {
                int boundary2 = Integer.parseInt((String)list.elem4th());
                return new SymStatic(table, name, id, tag, type, boundary2, ((QuotedString)list.elem5th()).body, (String)list.elem6th(), list.scanOpt());
            }
            case 1: {
                int boundary2 = Integer.parseInt((String)list.elem4th());
                int offset2 = Integer.parseInt((String)list.elem5th());
                return new SymAuto(table, name, id, tag, type, boundary2, offset2, list.scanOpt());
            }
        }
        if (list.length() < 5 || ((String)list.elem5th()).charAt(0) == '&') {
            boundary2 = 0;
            offset2 = Integer.parseInt((String)list.elem4th());
        } else {
            boundary2 = Integer.parseInt((String)list.elem4th());
            offset2 = Integer.parseInt((String)list.elem5th());
        }
        return new SymAuto(table, name, id, tag, type, boundary2, offset2, list.scanOpt());
    }

    String preSpace(String x) {
        return x.length() == 0 ? x : " " + x;
    }

    public void setOpt(ImList prepend) {
        this.opt = prepend.append(this.opt);
    }

    public ImList opt() {
        return this.opt;
    }

    public String toString() {
        return "\"" + this.name + "\"";
    }

    public abstract Object toSexp();

    public abstract String contents();

    public String printName() {
        return this.name;
    }
}

