/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.tools;

import coins.backend.SyntaxError;
import coins.backend.Type;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.BitMapSet;
import coins.backend.util.ImList;
import coins.backend.util.NumberSet;
import coins.backend.util.QuotedString;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

class RegisterDescription2Java {
    SymTab symtbl = new SymTab();
    PrintWriter debOut = new PrintWriter(System.err);
    PrintWriter javaOut;
    String targetName;
    BiList registerSets = new BiList();
    static final int MAXSET = 1000;
    RegSymbol[] regVec;
    RegisterSet[] regsetVec = new RegisterSet[1000];
    int nSets;
    int nRegs = 1;
    int addrType;
    int boolType;

    RegSymbol installRegister(RegSymbol sym) {
        if (sym.regId == 0) {
            sym.regId = this.nRegs++;
        }
        return sym;
    }

    RegSymbol installSubRegister(RegSymbol parent, int type, int position) {
        RegSymbol sym = this.symtbl.addSymbol(parent, type, position);
        if (sym.regId == 0) {
            sym.regId = this.nRegs++;
        }
        return sym;
    }

    void canonRegRelations() {
        BiLink p = this.symtbl.list.first();
        while (!p.atEnd()) {
            RegSymbol r = (RegSymbol)p.elem();
            r.canonRelation();
            p = p.next();
        }
    }

    void setRegVector() {
        this.regVec = new RegSymbol[this.nRegs];
        this.regVec[0] = null;
        BiLink p = this.symtbl.list.first();
        while (!p.atEnd()) {
            RegSymbol r = (RegSymbol)p.elem();
            if (r.regId != 0) {
                this.regVec[r.regId] = r;
            }
            p = p.next();
        }
    }

    RegisterSet findRegisterSet(BitMapSet set) {
        BiLink p = this.registerSets.first();
        while (!p.atEnd()) {
            RegisterSet regset = (RegisterSet)p.elem();
            if (regset.regset.equals(set)) {
                return regset;
            }
            p = p.next();
        }
        return null;
    }

    RegisterSet installRegisterSet(BitMapSet set, String name, int type) {
        RegisterSet regset = this.findRegisterSet(set);
        if (regset != null) {
            if (regset.name != null && name != null) {
                throw new Error("There are two same sets: " + regset.name + ", " + name);
            }
            if (name != null) {
                regset.name = name;
            }
        } else {
            regset = new RegisterSet(set, name, type);
            this.registerSets.add(regset);
        }
        return regset;
    }

    RegisterSet andSet(RegisterSet x, RegisterSet y) {
        BitMapSet andset = (BitMapSet)x.regset.clone();
        andset.meet(y.regset);
        RegisterSet regset = this.findRegisterSet(andset);
        if (regset == null) {
            regset = this.installRegisterSet(andset, null, x.type);
            if (this.nSets >= 1000) {
                throw new Error("Too many sets (Max 1000)");
            }
            regset.setId(this.nSets);
            this.regsetVec[this.nSets++] = regset;
        }
        return regset;
    }

    boolean interferes(RegSymbol x, RegSymbol y) {
        if (x.parent != y.parent) {
            return false;
        }
        int xwidth = Type.bits(x.type);
        int ywidth = Type.bits(y.type);
        return x.from <= y.from && y.from < x.from + xwidth || y.from <= x.from && x.from < y.from + ywidth;
    }

    boolean covers(RegSymbol x, RegSymbol y) {
        if (x.parent != y.parent) {
            return false;
        }
        if (x.type == 0) {
            return true;
        }
        if (y.type == 0) {
            return false;
        }
        int xwidth = Type.bits(x.type);
        int ywidth = Type.bits(y.type);
        return x.from <= y.from && y.from + ywidth <= x.from + xwidth;
    }

    boolean interferes(RegisterSet x, RegisterSet y) {
        RegSymbol r;
        BiList[] regs = new BiList[this.symtbl.nsyms];
        NumberSet.Iterator it = x.regset.iterator();
        while (it.hasNext()) {
            r = this.regVec[it.next()];
            if (regs[r.parent.id] == null) {
                regs[r.parent.id] = new BiList();
            }
            regs[r.parent.id].add(r);
        }
        it = y.regset.iterator();
        while (it.hasNext()) {
            r = this.regVec[it.next()];
            if (regs[r.parent.id] == null) continue;
            BiLink p = regs[r.parent.id].first();
            while (!p.atEnd()) {
                RegSymbol s = (RegSymbol)p.elem();
                if (this.interferes(r, s)) {
                    return true;
                }
                p = p.next();
            }
        }
        return false;
    }

    int relativeWeight(RegisterSet x, RegisterSet y) {
        BiList[] regs = new BiList[this.symtbl.nsyms];
        NumberSet.Iterator it = x.regset.iterator();
        while (it.hasNext()) {
            RegSymbol r = this.regVec[it.next()];
            if (regs[r.parent.id] == null) {
                regs[r.parent.id] = new BiList();
            }
            regs[r.parent.id].add(r);
        }
        int max = 0;
        NumberSet.Iterator it2 = y.regset.iterator();
        while (it2.hasNext()) {
            RegSymbol r = this.regVec[it2.next()];
            if (regs[r.parent.id] == null) continue;
            int n = 0;
            BiLink p = regs[r.parent.id].first();
            while (!p.atEnd()) {
                RegSymbol s = (RegSymbol)p.elem();
                if (this.interferes(r, s)) {
                    ++n;
                }
                p = p.next();
            }
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    void parseRegisterSet(String setname, ImList sexp) throws SyntaxError {
        BitMapSet set = new BitMapSet();
        int type = -1;
        ImList p = sexp;
        while (!p.atEnd()) {
            Object elem = p.elem();
            if (!(elem instanceof ImList)) {
                throw new Error("Bad register set form: " + setname);
            }
            ImList node = (ImList)elem;
            if (node.elem() == "SUBREG") {
                ImList sub = (ImList)node.elem3rd();
                int subtype = Type.decode((String)node.elem2nd());
                if (type < 0) {
                    type = subtype;
                }
                int position = Integer.parseInt((String)node.elem4th());
                if (sub.elem() != "REG") {
                    throw new Error("REG expected but " + sub.elem());
                }
                int regtype = Type.decode((String)sub.elem2nd());
                String name = ((QuotedString)sub.elem3rd()).body;
                RegSymbol sym = this.symtbl.get(name);
                if (sym == null) {
                    throw new Error("Undeclared REG: " + name);
                }
                RegSymbol reg = this.installSubRegister(sym, subtype, position);
                set.add(reg.regId);
            } else if (node.elem() == "REG") {
                String name;
                RegSymbol sym;
                int regtype = Type.decode((String)node.elem2nd());
                if (type < 0) {
                    type = regtype;
                }
                if ((sym = this.symtbl.get(name = ((QuotedString)node.elem3rd()).body)) == null) {
                    throw new Error("Undeclared REG: " + name);
                }
                RegSymbol reg = this.installRegister(sym);
                set.add(reg.regId);
            } else {
                throw new SyntaxError("REG expected but " + node.elem());
            }
            p = p.next();
        }
        this.installRegisterSet(set, setname, type);
    }

    void genTables(String targetName, PrintWriter out) {
        int j;
        int i;
        int i2;
        int j2;
        int i3;
        RegisterSet nullSet;
        this.canonRegRelations();
        this.setRegVector();
        this.regsetVec[0] = nullSet = this.installRegisterSet(new BitMapSet(), null, -1);
        nullSet.setId(0);
        this.nSets = 1;
        for (int i4 = 1; i4 < this.nRegs; ++i4) {
            BiList l = new BiList();
            l.add(this.regVec[i4]);
            BitMapSet s = new BitMapSet();
            s.add(this.regVec[i4].regId);
            this.regsetVec[this.nSets] = this.installRegisterSet(s, null, this.regVec[i4].type);
            this.regsetVec[this.nSets].setId(this.nSets);
            ++this.nSets;
        }
        BiLink p = this.registerSets.first();
        while (!p.atEnd()) {
            RegisterSet regset = (RegisterSet)p.elem();
            if (regset.id < 0) {
                regset.setId(this.nSets);
                this.regsetVec[this.nSets++] = regset;
            }
            p = p.next();
        }
        int[] andTbl = new int[16];
        int k = 0;
        for (i3 = 0; i3 < this.nSets; ++i3) {
            for (j2 = 0; j2 < i3; ++j2) {
                RegisterSet regset = this.andSet(this.regsetVec[i3], this.regsetVec[j2]);
                if (k >= andTbl.length) {
                    int[] tmp = new int[andTbl.length * 2];
                    for (int ii = 0; ii < andTbl.length; ++ii) {
                        tmp[ii] = andTbl[ii];
                    }
                    andTbl = tmp;
                }
                andTbl[k] = regset.id;
                ++k;
            }
        }
        int[][] weightTbl = new int[this.nSets][this.nSets];
        for (i3 = 0; i3 < this.nSets; ++i3) {
            for (j2 = 0; j2 < this.nSets; ++j2) {
                weightTbl[i3][j2] = this.relativeWeight(this.regsetVec[i3], this.regsetVec[j2]);
            }
        }
        out.println("  public int nRegisters() { return " + this.nRegs + "; }");
        out.println("  public int nRegsets() { return " + this.nSets + "; }");
        out.println();
        if (this.addrType == 0) {
            System.err.println("Warning: *type-address* undefined.");
        }
        out.println("  public int typeAddress() { return " + this.addrType + "; }");
        if (this.boolType == 0) {
            System.err.println("Warning: *type-bool* undefined.");
        }
        out.println("  public int typeBool() { return " + this.boolType + "; }");
        out.println("  public String[] getSymName() {");
        out.println("    return new String[]{");
        BiLink p2 = this.symtbl.list.first();
        while (!p2.atEnd()) {
            RegSymbol sym = (RegSymbol)p2.elem();
            out.println("      \"" + sym.name + "\",");
            p2 = p2.next();
        }
        out.println("    };");
        out.println("  };");
        out.println("  public int[] getSymType() {");
        out.println("    return new int[] {");
        p2 = this.symtbl.list.first();
        while (!p2.atEnd()) {
            RegSymbol sym = (RegSymbol)p2.elem();
            out.println("      " + sym.type + ",");
            p2 = p2.next();
        }
        out.println("    };");
        out.println("  };");
        out.println("  public int[] getSymRegNumber() {");
        out.println("    return new int[] {");
        p2 = this.symtbl.list.first();
        while (!p2.atEnd()) {
            RegSymbol sym = (RegSymbol)p2.elem();
            out.println("      " + sym.regId + ",");
            p2 = p2.next();
        }
        out.println("    };");
        out.println("  };");
        out.println();
        out.println("  public short[][] getOverlapReg() {");
        out.println("    return new short[][] { {},");
        for (i2 = 1; i2 < this.nRegs; ++i2) {
            out.print("  /* " + i2 + ": */ {");
            for (int j3 = 1; j3 < this.nRegs; ++j3) {
                if (i2 == j3 || !this.interferes(this.regVec[i2], this.regVec[j3])) continue;
                out.print(j3 + ",");
            }
            out.println("},");
        }
        out.println("    };");
        out.println("  };");
        out.println();
        out.println("  public short[][] getSuperReg() {");
        out.println("    return new short[][] { {},");
        for (i2 = 1; i2 < this.nRegs; ++i2) {
            out.print("  /* " + i2 + ": */ {");
            for (int j4 = 1; j4 < this.nRegs; ++j4) {
                if (i2 == j4 || !this.covers(this.regVec[j4], this.regVec[i2])) continue;
                out.print(j4 + ",");
            }
            out.println("},");
        }
        out.println("    };");
        out.println("  };");
        out.println();
        out.println("  public short[][] getSubReg() {");
        out.println("    return new short[][] { {},");
        for (i2 = 1; i2 < this.nRegs; ++i2) {
            out.print("  /* " + i2 + ": */ {");
            for (int j5 = 1; j5 < this.nRegs; ++j5) {
                if (i2 == j5 || !this.covers(this.regVec[i2], this.regVec[j5])) continue;
                out.print(j5 + ",");
            }
            out.println("},");
        }
        out.println("    };");
        out.println("  };");
        out.println();
        out.println("  public String[] getRegsetName() {");
        out.println("    return new String[] {");
        for (i2 = 0; i2 < this.nSets; ++i2) {
            if (this.regsetVec[i2].name == null) continue;
            out.println("      \"" + this.regsetVec[i2].name + "\",");
        }
        out.println("    };");
        out.println("  };");
        out.println("  public int[] getRegsetNumber() {");
        out.println("    return new int[] {");
        for (i2 = 0; i2 < this.nSets; ++i2) {
            if (this.regsetVec[i2].name == null) continue;
            out.println("      " + i2 + ",");
        }
        out.println("    };");
        out.println("  };");
        out.println("  public short[][] getRegsetMap() {");
        out.println("    return new short[][] {");
        for (i2 = this.nRegs; i2 < this.nSets; ++i2) {
            out.print("      {");
            NumberSet.Iterator it = this.regsetVec[i2].regset.iterator();
            while (it.hasNext()) {
                out.print(it.next() + ",");
            }
            out.println("},");
        }
        out.println("    };");
        out.println("  };");
        out.println();
        out.println("  public short[] getRegsetNAvail() {");
        out.println("    return new short[] {");
        int col = 0;
        for (i = 0; i < this.nSets; ++i) {
            if (col == 0) {
                out.print("      ");
            }
            out.print(this.regsetVec[i].regset.size() + ", ");
            if (++col != 10) continue;
            out.println();
            col = 0;
        }
        out.println("    };");
        out.println("  };");
        out.println();
        out.println("  public int[] getCompAndTbl() {");
        out.println("    return new int[] {");
        int k2 = 0;
        int pre = 0;
        boolean col2 = false;
        for (int i5 = 0; i5 < this.nSets; ++i5) {
            for (j = 0; j < i5; ++j) {
                if (andTbl[k2] != 0) {
                    if (pre == 0) {
                        out.print("      " + -k2 + ",");
                    }
                    out.print(andTbl[k2] + ",");
                } else if (pre != 0) {
                    out.println();
                }
                pre = andTbl[k2];
                ++k2;
            }
        }
        out.println("    };");
        out.println("  };");
        out.println();
        out.println("  public int[] getCompWeightTbl() {");
        out.println("    return new int[] {");
        k2 = 0;
        for (i = 0; i < this.nSets; ++i) {
            int pre2 = 0;
            int count = 0;
            for (j = 0; j < this.nSets; ++j) {
                if (weightTbl[i][j] != pre2) {
                    if (pre2 != 0) {
                        out.println(count * 64 + pre2 + ",");
                    }
                    count = 0;
                    if (weightTbl[i][j] != 0) {
                        out.print("    " + (i * this.nSets + j) + ",");
                    }
                }
                ++count;
                pre2 = weightTbl[i][j];
            }
            if (pre2 == 0) continue;
            out.println(count * 64 + pre2 + ",");
        }
        out.println("    };");
        out.println("  };");
        out.println();
        out.println("  public int[] getRegsetTypeTbl() {");
        out.println("    return new int[] {");
        for (i2 = 0; i2 < this.nSets; ++i2) {
            out.println("    " + this.regsetVec[i2].type + ",");
        }
        out.println("    };");
        out.println("  }");
        out.println("}");
    }

    RegisterDescription2Java(String targetName, String file, String packageName) throws IOException {
        this.targetName = targetName;
        this.javaOut = new PrintWriter(new FileOutputStream(file));
        this.javaOut.println("package " + packageName + ";");
        this.javaOut.println();
        this.javaOut.println("import coins.backend.Storage;");
        this.javaOut.println("import coins.backend.sym.SymTab;");
        this.javaOut.println("import coins.backend.util.ImList;");
        this.javaOut.println();
        this.javaOut.println("public class MachineParams_" + targetName + " extends coins.backend.MachineParams {");
        this.javaOut.println();
    }

    void doDef(ImList form) throws SyntaxError {
        ImList definee;
        if (form.elem() != "def") {
            throw new Error("def expected but " + form.elem());
        }
        Object value = form.elem3rd();
        if (form.elem2nd() instanceof ImList && (definee = (ImList)form.elem2nd()).elem() == "REG") {
            String name = ((QuotedString)definee.elem3rd()).body;
            RegSymbol left = this.symtbl.get(name);
            if (left == null) {
                throw new Error("Undeclared:" + definee);
            }
            if (Type.decode((String)definee.elem2nd()) != left.type) {
                throw new Error("Bad register type: " + definee);
            }
            ImList definer = (ImList)value;
            if (definer.elem() != "SUBREG") {
                throw new Error("SUBREG expected");
            }
            if (Type.decode((String)definer.elem2nd()) != left.type) {
                throw new Error("Bad SUBREG type: " + definee);
            }
            ImList parentReg = (ImList)definer.elem3rd();
            if (parentReg.elem() != "REG") {
                throw new Error("REG expected");
            }
            RegSymbol parent = this.symtbl.get(((QuotedString)parentReg.elem3rd()).body);
            if (parent == null) {
                throw new Error("Undeclared: " + parentReg);
            }
            if (Type.decode((String)parentReg.elem2nd()) != parent.type) {
                throw new Error("Bad register type: " + definee);
            }
            int position = Integer.parseInt((String)definer.elem4th());
            left.setSubregOf(parent, position);
            return;
        }
        String defname = (String)form.elem2nd();
        if (defname == "*real-reg-symtab*") {
            ImList p = (ImList)value;
            if (p.elem() != "SYMTAB") {
                throw new Error("SYMTAB expected but " + p.elem());
            }
            p = p.next();
            while (!p.atEnd()) {
                this.symtbl.addSymbol((ImList)p.elem());
                p = p.next();
            }
        } else if (defname == "*cmplib-xref-symtab*") {
            ImList p = (ImList)value;
            if (p.elem() != "SYMTAB") {
                throw new Error("SYMTAB expected but " + p.elem());
            }
            this.javaOut.println("  public void addRequired(SymTab symtbl) {");
            p = p.next();
            while (!p.atEnd()) {
                ImList e = (ImList)p.elem();
                this.javaOut.println("    symtbl.addSymbol(\"" + ((QuotedString)e.elem()).body + "\", " + "Storage." + e.elem2nd() + ", " + Type.decode((String)e.elem3rd()) + ", " + e.elem4th() + ", " + "\"" + ((QuotedString)e.elem5th()).body + "\", " + "\"" + e.elem6th() + "\", " + "ImList.Empty);");
                p = p.next();
            }
            this.javaOut.println("  }");
            this.javaOut.println();
        } else if (defname.startsWith("*reg") && defname.endsWith("*")) {
            this.parseRegisterSet(defname, (ImList)value);
        } else if (defname.equals("*type-address*")) {
            this.addrType = Type.decode((String)value);
        } else if (defname.equals("*type-bool*")) {
            this.boolType = Type.decode((String)value);
        }
    }

    void close() {
        this.genTables(this.targetName, this.javaOut);
        this.javaOut.flush();
        this.debOut.flush();
    }

    static class RegisterSet {
        BitMapSet regset;
        String name;
        int type;
        int id;

        RegisterSet(BitMapSet set, String name, int type) {
            this.name = name;
            this.regset = set;
            this.type = type;
            this.id = -1;
        }

        void setId(int id) {
            this.id = id;
        }
    }

    static class SymTab {
        Map table = new HashMap();
        BiList list = new BiList();
        int nsyms = 0;

        SymTab() {
        }

        RegSymbol addSymbol(ImList desc) throws SyntaxError {
            String name = ((QuotedString)desc.elem()).body;
            RegSymbol sym = (RegSymbol)this.table.get(name);
            if (sym == null) {
                int type = Type.decode((String)desc.elem3rd());
                sym = new RegSymbol(name, type, desc, this.nsyms++);
                this.table.put(name, sym);
                this.list.add(sym);
            }
            return sym;
        }

        RegSymbol addSymbol(RegSymbol parent, int type, int position) {
            String name = parent.name + "/" + Type.toString(type) + "/" + position;
            RegSymbol sym = (RegSymbol)this.table.get(name);
            if (sym == null) {
                ImList desc = ImList.list(name, "REG", Type.toString(type), Integer.toString(Type.bytes(type)), "0");
                sym = new RegSymbol(name, type, desc, this.nsyms++);
                sym.setSubregOf(parent, position);
                this.table.put(name, sym);
                this.list.add(sym);
            }
            return sym;
        }

        RegSymbol get(String name) {
            return (RegSymbol)this.table.get(name);
        }
    }

    static class RegSymbol {
        final String name;
        final ImList record;
        final int type;
        final int id;
        RegSymbol parent;
        int from = 0;
        int regId = 0;
        boolean visited;

        RegSymbol(String name, int type, ImList record, int id) {
            this.record = record;
            this.name = name;
            this.type = type;
            this.id = id;
            this.parent = this;
        }

        void setSubregOf(RegSymbol parent, int position) {
            this.parent = parent;
            this.from = Type.bits(this.type) * position;
        }

        void canonRelation() {
            if (this.visited) {
                throw new Error("SUBREG relation loop.");
            }
            if (this.parent != this) {
                this.visited = true;
                this.parent.canonRelation();
                this.visited = false;
                this.from += this.parent.from;
                this.parent = this.parent.parent;
            }
        }

        public String toString() {
            return "(REG " + Type.toString(this.type) + " \"" + this.name + "\")";
        }
    }
}

