/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import java.util.HashSet;
import java.util.Set;

public class ParseString {
    private final String fText;
    private final Set fDelimiters;
    private final Set fSpaces;
    private final Set fIdSpChars;
    private final Set fIdHeadingChars;
    private final Set fIdBodyChars;
    private final int fLength;
    private int fNextPosition;
    private int fTokenKind;
    private String fCurrentToken;
    public static final int UNDEFINED = 0;
    public static final int IDENTIFIER = 1;
    public static final int DELIMITER = 2;
    public static final int DIGITS = 3;
    public static final int STRING = 4;
    static final String[] alphabetCharacters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    static final String[] digitCharacters = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public ParseString(String pText, Set pDelimiters, Set pSpaces, Set pIdSpChars) {
        int i;
        this.fText = pText;
        this.fDelimiters = pDelimiters;
        this.fSpaces = pSpaces;
        this.fLength = pText.length();
        this.fNextPosition = 0;
        this.fTokenKind = 0;
        this.fIdSpChars = pIdSpChars;
        this.fIdHeadingChars = new HashSet(pIdSpChars);
        for (i = 0; i < alphabetCharacters.length; ++i) {
            this.fIdHeadingChars.add(alphabetCharacters[i]);
        }
        this.fIdBodyChars = new HashSet(this.fIdHeadingChars);
        for (i = 0; i < digitCharacters.length; ++i) {
            this.fIdBodyChars.add(digitCharacters[i]);
        }
    }

    public boolean hasNext() {
        return this.fNextPosition < this.fLength;
    }

    public String getNextToken() {
        String lResult;
        char lTokenHeaderChar = this.getNextNonSpaceChar();
        if (lTokenHeaderChar >= '0' && lTokenHeaderChar <= '9') {
            lResult = this.digitString();
            this.fTokenKind = 3;
        } else if (lTokenHeaderChar == '\"') {
            lResult = this.characterString();
            this.fTokenKind = 4;
        } else {
            String lHead = String.valueOf(lTokenHeaderChar);
            if (this.fIdHeadingChars.contains(lHead)) {
                lResult = this.identifierString();
                this.fTokenKind = 1;
            } else {
                if (this.fDelimiters.contains(lHead)) {
                    lResult = lHead;
                    this.fTokenKind = 2;
                } else {
                    lResult = "";
                    this.fTokenKind = 0;
                }
                ++this.fNextPosition;
            }
        }
        this.fCurrentToken = lResult;
        return lResult.intern();
    }

    public String seeCurrentToken() {
        return this.fCurrentToken;
    }

    public int getTokenKind() {
        return this.fTokenKind;
    }

    public static Set fromStringToSet(String pString) {
        HashSet<String> lSet = new HashSet<String>();
        for (int lIndex = 0; lIndex < pString.length(); ++lIndex) {
            String lSubstring = pString.substring(lIndex, lIndex + 1);
            lSet.add(lSubstring);
        }
        return lSet;
    }

    private char getNextNonSpaceChar() {
        char lChar = ' ';
        while (this.fNextPosition < this.fLength && this.fSpaces.contains(String.valueOf(lChar = this.fText.charAt(this.fNextPosition)))) {
            ++this.fNextPosition;
        }
        return lChar;
    }

    String digitString() {
        char lNextChar;
        StringBuffer lBuffer = new StringBuffer();
        while (this.fNextPosition < this.fLength && (lNextChar = this.fText.charAt(this.fNextPosition)) >= '0' && lNextChar <= '9') {
            lBuffer.append(lNextChar);
            ++this.fNextPosition;
        }
        return lBuffer.toString();
    }

    String characterString() {
        StringBuffer lBuffer = new StringBuffer();
        ++this.fNextPosition;
        while (this.fNextPosition < this.fLength) {
            char lNextChar = this.fText.charAt(this.fNextPosition);
            if (lNextChar == '\"') {
                ++this.fNextPosition;
                break;
            }
            lBuffer.append(lNextChar);
            ++this.fNextPosition;
        }
        return lBuffer.toString();
    }

    String identifierString() {
        String lNextChar;
        StringBuffer lBuffer = new StringBuffer();
        while (this.fNextPosition < this.fLength && this.fIdBodyChars.contains(lNextChar = String.valueOf(this.fText.charAt(this.fNextPosition)))) {
            lBuffer.append(lNextChar);
            ++this.fNextPosition;
        }
        return lBuffer.toString();
    }
}

