/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.FatalError;
import coins.HirRoot;
import coins.SymRoot;
import coins.ast.ASTList;
import coins.ast.ASTree;
import coins.ast.Declarator;
import coins.ast.DeclaratorList;
import coins.ast.Enum;
import coins.ast.Expr;
import coins.ast.Function;
import coins.ast.Pair;
import coins.ast.Pragma;
import coins.ast.Stmnt;
import coins.ast.Struct;
import coins.ast.TokenId;
import coins.ast.TypeId;
import coins.ast.Union;
import coins.ast.Visitor;
import coins.ast.expr.AddressExpr;
import coins.ast.expr.ArithBinaryExpr;
import coins.ast.expr.ArithUnaryExpr;
import coins.ast.expr.ArrayExpr;
import coins.ast.expr.ArrayInitializer;
import coins.ast.expr.AsmExpr;
import coins.ast.expr.AssignExpr;
import coins.ast.expr.CallExpr;
import coins.ast.expr.CastExpr;
import coins.ast.expr.CommaExpr;
import coins.ast.expr.ConditionalExpr;
import coins.ast.expr.ConstantExpr;
import coins.ast.expr.DereferenceExpr;
import coins.ast.expr.MemberExpr;
import coins.ast.expr.PointerBinaryExpr;
import coins.ast.expr.PostfixExpr;
import coins.ast.expr.PrefixExpr;
import coins.ast.expr.SizeofExpr;
import coins.ast.expr.StringLiteral;
import coins.ast.expr.VariableExpr;
import coins.ast.expr.WcharLiteral;
import coins.ast.stmnt.BreakStmnt;
import coins.ast.stmnt.CaseLabel;
import coins.ast.stmnt.CompoundStmnt;
import coins.ast.stmnt.ContinueStmnt;
import coins.ast.stmnt.DefaultLabel;
import coins.ast.stmnt.DoStmnt;
import coins.ast.stmnt.ExpressionStmnt;
import coins.ast.stmnt.ForStmnt;
import coins.ast.stmnt.GotoStmnt;
import coins.ast.stmnt.IfStmnt;
import coins.ast.stmnt.NamedLabel;
import coins.ast.stmnt.NullStmnt;
import coins.ast.stmnt.ReturnStmnt;
import coins.ast.stmnt.SwitchStmnt;
import coins.ast.stmnt.WhileStmnt;
import coins.casttohir.ConditionalReporter;
import coins.casttohir.ToC;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirInit;
import coins.casttohir.ToHirSym;
import coins.cfront.GccLex;
import coins.cfront.Lex;
import coins.cfront.Parser;
import coins.ir.IrList;
import coins.ir.IrListImpl;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.HirSeq;
import coins.ir.hir.LabelNode;
import coins.ir.hir.Program;
import coins.ir.hir.SetDataStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.sym.Const;
import coins.sym.Elem;
import coins.sym.EnumType;
import coins.sym.IntConst;
import coins.sym.Label;
import coins.sym.Param;
import coins.sym.PointerType;
import coins.sym.StringConst;
import coins.sym.StructType;
import coins.sym.Subp;
import coins.sym.SubpType;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymTable;
import coins.sym.SymTableImpl;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VectorType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ListIterator;

public final class ToHirC
implements Visitor,
TypeId,
TokenId {
    private SubpDefinition nowSubpDef;
    private BlockStmt nowBlock;
    private BlockStmt nowLocal;
    private int nowDepth;
    private HIR nowHir;
    private Lex lex;
    private Type ctrlExpType = null;
    private Label continueLabel = null;
    private Label breakLabel = null;
    private IrList caseList = null;
    private Label defaultLabel = null;
    private final ToHir toHir;
    private final HirRoot hirRoot;
    private final SymRoot symRoot;
    private final HIR hir;
    private final Sym sym;
    private final ToHirInit toInit;
    private final ToHirSym toSym;
    private final ConditionalReporter reporter;
    static final byte[] astPrototype = new byte[]{70, 36, 105};
    static int lListNum = 0;

    public ToHirC(ToHir tohir) {
        this.toHir = tohir;
        this.hirRoot = this.toHir.hirRoot;
        this.symRoot = this.toHir.symRoot;
        this.hir = this.hirRoot.hir;
        this.sym = this.hirRoot.sym;
        this.message(1, "ToHirC\n");
        this.toInit = new ToHirInit(this.toHir, this);
        this.toSym = new ToHirSym(this.toHir);
        this.reporter = new ConditionalReporter(this.toHir);
    }

    protected void message(int level, String mes) {
        this.toHir.debug.print(level, "C1", mes);
    }

    public void astToHirC(InputStream stream) throws IOException, FatalError {
        this.nowHir = null;
        this.nowSubpDef = null;
        this.nowBlock = null;
        this.nowLocal = null;
        this.nowDepth = 0;
        this.lex = new GccLex(this.toHir.ioRoot, stream);
        Parser parser = new Parser(this.toHir.ioRoot, this.lex, this);
        SymTableImpl astroot = new SymTableImpl(this.symRoot);
        this.message(1, "\nastToHirC\n");
        while (this.lex.lookAhead() != -1) {
            this.message(4, "lookAhead in astToHirC " + this.lex.lookAhead() + " " + this.lex.getString());
            this.symRoot.symTableCurrent = astroot;
            this.symRoot.subpCurrent = null;
            this.symRoot.symTableCurrent = this.symRoot.symTableRoot;
            this.symRoot.subpCurrent = null;
            for (ASTList list = parser.read(); list != null; list = list.tail()) {
                this.message(1, "C parser\n" + list.head());
                this.visit(list.head());
            }
        }
        this.createZeroInitializerForGlobal();
    }

    public HIR visit(ASTree ast) {
        if (ast == null) {
            return null;
        }
        if (ast instanceof Stmnt) {
            String oldfile = this.toHir.nowFile;
            int oldline = this.toHir.nowLine;
            String nowfile = ((Stmnt)((Object)ast)).fileName();
            int nowline = ((Stmnt)((Object)ast)).lineNumber();
            this.toHir.nowFile = nowfile != null ? nowfile : oldfile;
            this.toHir.nowLine = nowline != 0 ? nowline : oldline;
            this.message(8, "{" + ast.getClass().getName() + "}\t" + nowfile + "(" + nowline + ")");
            ast.accept(this);
            if (this.nowHir instanceof Stmt) {
                ((Stmt)this.nowHir).setFileName(this.toHir.nowFile);
                ((Stmt)this.nowHir).setLineNumber(this.toHir.nowLine);
            }
            this.toHir.nowFile = oldfile;
            this.toHir.nowLine = oldline;
        } else {
            this.message(8, "<" + ast.getClass().getName() + ">");
            ast.accept(this);
        }
        HIR h = this.nowHir;
        this.nowHir = null;
        return h;
    }

    public void atASTList(ASTList ast) {
        this.toHir.fatal("atASTList");
    }

    public void atPragma(Pragma ast) {
        String lPragmaBody;
        String lPragmaKind;
        String text = ast.getText();
        int length = text.length();
        if (length == 0) {
            return;
        }
        this.message(4, "atPragma " + text);
        int i = 0;
        if (Character.isJavaIdentifierStart(text.charAt(0))) {
            for (i = 1; i < length && Character.isJavaIdentifierPart(text.charAt(i)); ++i) {
            }
        }
        if (i == 0) {
            if (text.charAt(0) == '\"') {
                StringBuffer lBuffer = new StringBuffer();
                ++i;
                while (i < length) {
                    char lNextChar = text.charAt(i);
                    if (lNextChar == '\"') {
                        ++i;
                        break;
                    }
                    lBuffer.append(lNextChar);
                    ++i;
                }
                lPragmaKind = lBuffer.toString();
                lPragmaBody = text.substring(i).trim();
            } else {
                lPragmaKind = "";
                lPragmaBody = text;
            }
        } else if (i == text.length()) {
            lPragmaKind = text;
            lPragmaBody = "";
        } else {
            lPragmaKind = text.substring(0, i);
            lPragmaBody = text.substring(i).trim();
        }
        this.message(4, " kind " + lPragmaKind + " body " + lPragmaBody);
        IrListImpl lIrList = new IrListImpl(this.hirRoot);
        lIrList.add(lPragmaBody.intern());
        this.nowHir = this.hir.infStmt(lPragmaKind.intern(), lIrList);
        if (this.hirRoot.symRoot.symTableCurrent == null || this.hirRoot.symRoot.symTableCurrent.getOwner() == null) {
            ((Stmt)this.nowHir).setFileName(this.toHir.nowFile);
            ((Stmt)this.nowHir).setLineNumber(this.toHir.nowLine);
            ((Program)this.hirRoot.programRoot).addInitiationStmt(this.nowHir);
        }
        this.message(4, " pragma result " + ((Object)this.nowHir).toString());
    }

    public void atAsmExpr(AsmExpr ast) {
        this.message(4, "atAsmExpr " + ast);
        String lInstructions = null;
        HirList lActualParams = this.hir.hirList();
        int lIndex = 0;
        for (ASTList al = ast.getArguments(); al != null; al = al.tail()) {
            ASTree lTree = al.head();
            Exp lExp = (Exp)this.visit(lTree);
            ++lIndex;
            if (this.toHir.fDbgLevel > 1) {
                this.message(4, "arg" + lIndex + " " + lExp.toStringWithChildren());
            }
            if (lIndex == 1 && lExp instanceof ConstNode) {
                lInstructions = ((ConstNode)lExp).getSymNodeSym().getName();
                continue;
            }
            Exp lExp2 = this.pPromotion(lExp);
            lActualParams.add(lExp2);
            lExp2.setParent(lActualParams);
        }
        if (lInstructions == null) {
            this.toHir.warning("Instructions of asm( ) is null string");
            lInstructions = "";
        }
        this.nowHir = this.hir.asmStmt(lInstructions, lActualParams);
        if (this.toHir.fDbgLevel > 1) {
            this.message(4, " asmExpr result " + ((Object)this.nowHir).toString());
        }
    }

    public void atCompoundStmnt(CompoundStmnt ast) {
        if (++this.nowDepth > 1) {
            this.symRoot.symTableCurrent.pushSymTable(this.toHir.createBlockSym());
        }
        BlockStmt nb = this.nowBlock;
        BlockStmt nl = this.nowLocal;
        this.nowBlock = this.hir.blockStmt(null);
        this.nowBlock.setSymTable(this.symRoot.symTableCurrent);
        this.nowLocal = null;
        for (ASTList list = ast; list != null; list = list.tail()) {
            HIR h = this.visit(list.head());
            this.nowBlock.addLastStmt((Stmt)h);
        }
        this.createZeroInitializerForStatic();
        this.nowHir = this.nowBlock;
        this.nowBlock = nb;
        this.nowLocal = nl;
        if (this.nowDepth-- > 1) {
            this.symRoot.symTableCurrent.popSymTable();
        }
    }

    public void atStruct(Struct ast) {
        this.atStructDeclarator(ast);
    }

    public StructType atStructDeclarator(Struct ast) {
        String tagname = ast.name();
        Type sttmp = this.toSym.convertType(("<" + tagname + '>').getBytes());
        if (sttmp == null || sttmp.getTypeKind() != 24) {
            return null;
        }
        StructType st = (StructType)sttmp;
        if (this.toHir.fDbgLevel > 1) {
            this.message(4, "atStructDeclarator STRUCT NAME=" + tagname + " TYPE=" + st);
        }
        if (st.getElemList().size() > 0) {
            this.toHir.error("redeclared struct '" + st.getName() + "'");
            return null;
        }
        this.symRoot.symTableCurrent.pushSymTable(st);
        for (DeclaratorList dl = (DeclaratorList)ast.getLeft(); dl != null; dl = dl.next()) {
            Declarator d = dl.get();
            String name = d.getName().intern();
            if (this.symRoot.symTableCurrent.searchLocal(name, 10) != null) {
                this.toHir.error("duplicate member '" + name + "'");
                continue;
            }
            Type type = this.toSym.convertType(d.getType());
            Elem elem = this.sym.defineElem(name, type);
            if (this.toHir.fDbgLevel > 1) {
                this.message(6, "ELEM NAME=" + name + " TYPE=" + type + " SIZE=" + type.getSizeValue());
            }
            if (d.isItBitField()) {
                int bits = d.getBitFieldSize();
                if (this.toHir.fDbgLevel > 1) {
                    this.message(6, "BITFIELD=" + bits);
                }
                if (this.toHir.isIntegral(type)) {
                    if ((long)bits <= 8L * type.getSizeValue()) {
                        elem.setBitFieldSize(bits);
                    } else {
                        this.toHir.error("width of bit-field '" + name + "' exceeds its type");
                    }
                } else {
                    this.toHir.error("bit-field '" + name + "' has invalid type");
                }
            }
            if (type.getSizeValue() <= 0L) {
                this.toHir.error("member '" + name + "' is incomplete type or size 0");
            }
            elem.setDefinedFile(d.fileName());
            elem.setDefinedLine(d.lineNumber());
            st.addElem(elem);
        }
        this.symRoot.symTableCurrent.popSymTable();
        SymTable table = this.symRoot.symTableCurrent;
        this.symRoot.symTableCurrent = this.toHir.getSubpTable();
        st.finishStructType(true);
        this.symRoot.symTableCurrent = table;
        this.toSym.makeQualifiedTypes(st, tagname);
        return st;
    }

    public void atUnion(Union ast) {
        this.atUnionDeclarator(ast);
    }

    public UnionType atUnionDeclarator(Union ast) {
        UnionType ut;
        String tagname = ast.name();
        Type uttmp = this.toSym.convertType(("(" + tagname + ')').getBytes());
        if (uttmp == null || uttmp.getTypeKind() != 25) {
            return null;
        }
        if (this.toHir.fDbgLevel > 1) {
            this.message(4, "atUnionDeclarator UNION NAME=" + tagname + " TYPE=" + uttmp);
        }
        if ((ut = (UnionType)uttmp).getOrigin() != null) {
            this.toHir.error("redeclared union '" + ut.getName() + "'");
            return null;
        }
        this.symRoot.symTableCurrent.pushSymTable(ut);
        for (DeclaratorList dl = (DeclaratorList)ast.getLeft(); dl != null; dl = dl.next()) {
            Declarator d = dl.get();
            String name = d.getName().intern();
            if (this.symRoot.symTableCurrent.searchLocal(name, 10) != null) {
                this.toHir.error("duplicate member '" + name + "'");
                continue;
            }
            Type type = this.toSym.convertType(d.getType());
            if (this.toHir.fDbgLevel > 1) {
                this.message(6, "ELEM NAME=" + name + " TYPE=" + type + " SIZE=" + type.getSizeExp());
            }
            Elem elem = this.sym.defineElem(name, type);
            ut.addElem(elem);
            if (type.getSizeValue() <= 0L) {
                this.toHir.error("member '" + name + "' is incomplete type or size 0");
            }
            elem.setDefinedFile(d.fileName());
            elem.setDefinedLine(d.lineNumber());
        }
        this.symRoot.symTableCurrent.popSymTable();
        SymTable table = this.symRoot.symTableCurrent;
        this.symRoot.symTableCurrent = this.toHir.getSubpTable();
        ut.finishUnionType(true);
        this.symRoot.symTableCurrent = table;
        this.toSym.makeQualifiedTypes(ut, tagname);
        return ut;
    }

    public void atEnum(Enum ast) {
        Type ettmp = this.toSym.convertType(("[" + ast.name() + "]").getBytes());
        if (ettmp == null || ettmp.getTypeKind() != 21) {
            return;
        }
        EnumType et = (EnumType)ettmp;
        if (et.getOrigin() != null) {
            this.toHir.error("redeclared enum '" + et.getName() + "'");
            return;
        }
        long value = 0L;
        for (Enum.Item item = ast.getItems(); item != null; item = item.getNext()) {
            ConstantExpr ce = item.getValue();
            if (ce != null) {
                if (ce.getTypeChar() == 'i') {
                    value = ce.longValue();
                } else {
                    this.toHir.error("definition of enumeration constant requires 'const int'");
                }
            }
            String name = item.getName().intern();
            if (this.toHir.fDbgLevel > 1) {
                this.message(6, "ENUM NAME=" + name + " VALUE=" + value);
            }
            et.addElem(this.sym.namedConst(name, (int)value++, this.symRoot.typeInt));
        }
        SymTable table = this.symRoot.symTableCurrent;
        this.symRoot.symTableCurrent = this.toHir.getSubpTable();
        et.finishEnumType(true);
        this.symRoot.symTableCurrent = table;
    }

    public void atDeclarator(Declarator ast) {
        Type type = this.toSym.convertType(ast.getType());
        String name = ast.getName().intern();
        Expr init = ast.getInitializer();
        int storage = ast.getStorage();
        if (ast.isTypedef()) {
            this.toSym.declareType(type, name);
            if (init != null) {
                this.toHir.error("typedef '" + name + "' is initialized like a variable");
            }
        } else if (type.getTypeKind() == 27) {
            Subp f = this.nowDepth == 0 ? this.toSym.declareGlobalFunction(storage, (SubpType)type, name, false) : this.toSym.declareLocalFunction(storage, (SubpType)type, name);
            f.setDefinedFile(ast.fileName());
            f.setDefinedLine(ast.lineNumber());
            if (init != null) {
                this.toHir.error("function '" + name + "' is initialized like a variable");
            }
        } else {
            Var v;
            if (type.getTypeKind() == 15) {
                this.toHir.error("variable '" + name + "' declared void");
            }
            Var var = v = this.nowDepth == 0 ? this.toSym.declareGlobalVariable(storage, type, name, init) : this.toSym.declareLocalVariable(storage, type, name, init);
            if (v != null) {
                v.setDefinedFile(ast.fileName());
                v.setDefinedLine(ast.lineNumber());
                if (init != null) {
                    this.createInitializer(v, init);
                }
            }
        }
    }

    private void createInitializer(Var v, Expr ast) {
        if (v == null || v.getVisibility() == 1) {
            return;
        }
        if (v.getInitialValue() != null) {
            this.toHir.error("variable '" + v.getName() + "' is initialized two or more times");
            return;
        }
        Exp init = this.toInit.createSetData(v, ast);
        v.setInitialValue(init);
        if (this.toHir.machineParam.initByDataCode()) {
            if (this.symRoot.symTableCurrent == this.symRoot.symTableRoot) {
                SetDataStmt data = this.hir.setDataStmt(this.hir.varNode(v), init);
                data.setFileName(this.toHir.nowFile);
                data.setLineNumber(this.toHir.nowLine);
                ((Program)this.hirRoot.programRoot).addInitiationStmt(data);
            } else if (v.getStorageClass() == 6) {
                SetDataStmt data = this.hir.setDataStmt(this.hir.varNode(v), init);
                data.setFileName(this.toHir.nowFile);
                data.setLineNumber(this.toHir.nowLine);
                this.nowSubpDef.addInitiationStmt(data);
            } else {
                this.toInit.createAssignStmts(this.getLocalVarInitBlock(), v, ast);
            }
        } else if (this.symRoot.symTableCurrent == this.symRoot.symTableRoot) {
            ((Program)this.hirRoot.programRoot).addInitiationStmt(null);
            this.toInit.createAssignStmts((BlockStmt)((Program)this.hirRoot.programRoot).getInitiationPart(), v, ast);
        } else if (v.getStorageClass() == 6) {
            this.nowSubpDef.addInitiationStmt(null);
            this.toInit.createAssignStmts(this.nowSubpDef.getInitiationPart(), v, ast);
        } else {
            this.toInit.createAssignStmts(this.getLocalVarInitBlock(), v, ast);
        }
    }

    private BlockStmt getLocalVarInitBlock() {
        if (this.nowLocal == null) {
            this.symRoot.symTableCurrent.pushSymTable(this.toHir.createBlockSym());
            this.nowLocal = this.hir.blockStmt(null);
            this.nowLocal.setSymTable(this.symRoot.symTableCurrent);
            this.nowLocal.setFlag(4, true);
            this.nowBlock.addFirstStmt(this.nowLocal);
            this.symRoot.symTableCurrent.popSymTable();
        }
        return this.nowLocal;
    }

    public void atDeclaratorList(DeclaratorList ast) {
        this.toHir.fatal("DeclaratorList");
    }

    public void atArrayInitializer(ArrayInitializer ast) {
        this.toHir.fatal("atArrayInitializer");
    }

    public void atFunction(Function ast) {
        String subpname = ast.getName().intern();
        Type type = this.toSym.convertType(ast.getType());
        if (type.getTypeKind() != 27) {
            this.toHir.error("variable is defined like a function");
            return;
        }
        SubpType subptype = (SubpType)type;
        this.symRoot.subpCurrent = this.toSym.declareGlobalFunction(ast.getStorage(), subptype, subpname, true);
        if (this.symRoot.subpCurrent != null) {
            if (this.symRoot.subpCurrent.getHirBody() == null) {
                this.symRoot.symTableCurrent = this.symRoot.symTableRoot;
                this.symRoot.symTableCurrent.pushSymTable(this.symRoot.subpCurrent);
                this.nowSubpDef = this.hir.subpDefinition(this.symRoot.subpCurrent, this.symRoot.symTableCurrent);
                ((Program)this.hirRoot.programRoot).addSubpDefinition(this.nowSubpDef);
                BlockStmt paramblock = this.declareParameters(ast.getArguments(), subptype.getParamTypeList());
                this.nowDepth = 0;
                BlockStmt bodyblock = (BlockStmt)this.visit(ast.getRight());
                if (paramblock != null) {
                    bodyblock.addFirstStmt(paramblock);
                }
                bodyblock.setSubpBodyFlag(true);
                this.nowSubpDef.setHirBody(bodyblock);
                this.symRoot.subpCurrent.setDefinedFile(ast.fileName());
                this.symRoot.subpCurrent.setDefinedLine(ast.lineNumber());
            } else {
                this.toHir.error("function '" + subpname + "' is defined two or more times");
            }
        }
        if (this.toHir.fDbgLevel > 1) {
            this.message(3, "\n End of atFunction " + subpname + " reset SymTable");
        }
        this.symRoot.subpCurrent = null;
        this.symRoot.symTableCurrent = this.symRoot.symTableRoot;
        this.nowSubpDef = null;
    }

    private BlockStmt declareParameters(DeclaratorList decllist, IrList typelist) {
        BlockStmt paramblock = null;
        int index = 1;
        while (decllist != null) {
            Declarator decl = decllist.get();
            String paramname = decl.getName().intern();
            Type paramtype = this.toSym.convertType(decl.getType());
            Param param = null;
            if (this.toHir.searchLocalOrdinaryId(paramname) == null) {
                if (paramtype.getTypeKind() == 15) {
                    this.toHir.error("parameter '" + paramname + "' is declared as void");
                }
                if (paramtype.getTypeKind() == 23) {
                    paramtype = this.sym.pointerType(((VectorType)paramtype).getElemType());
                }
                if (this.toHir.fDbgLevel > 1) {
                    this.message(6, "PARAMETER NAME=" + paramname + " TYPE=" + paramtype);
                }
                if (paramtype.getTypeKind() == 22 && decl.getArrayParamSize() > 0L) {
                    paramtype = this.sym.pointerType(paramtype.getPointedType(), decl.getArrayParamSize());
                }
                if (typelist.size() == 0) {
                    if (this.toHir.isIntegral(paramtype) && paramtype.getTypeRank() < this.symRoot.typeInt.getTypeRank()) {
                        param = this.symRoot.symTableCurrent.generateParam(this.symRoot.typeInt, this.symRoot.subpCurrent);
                    } else if (paramtype.getTypeKind() == 16) {
                        param = this.symRoot.symTableCurrent.generateParam(this.symRoot.typeDouble, this.symRoot.subpCurrent);
                    }
                }
                if (param != null) {
                    Var var = this.sym.defineVar(paramname, paramtype, this.symRoot.subpCurrent);
                    var.setVisibility(4);
                    var.setStorageClass(7);
                    if (paramblock == null) {
                        paramblock = this.hir.blockStmt(null);
                    }
                    paramblock.addLastStmt(this.toHir.newExpStmt(this.hir.exp(22, this.hir.varNode(var), this.hir.varNode(param))));
                } else {
                    param = this.sym.defineParam(paramname, paramtype);
                }
                param.setArrayParamSize(decl.getArrayParamSize());
                param.setVisibility(4);
                param.setStorageClass(7);
                param.setParamIndex(index);
                param.setDefinedFile(decl.fileName());
                param.setDefinedLine(decl.lineNumber());
                this.symRoot.subpCurrent.addParam(param);
            } else {
                this.toHir.error("parameter '" + paramname + "' is redeclared");
            }
            decllist = decllist.next();
            ++index;
        }
        return paramblock;
    }

    public void atPair(Pair ast) {
        this.toHir.fatal("atPair");
    }

    public void atAddressExpr(AddressExpr ast) {
        Exp e = (Exp)this.visit(ast.getLeft());
        this.nowHir = this.toHir.addrExp(e);
    }

    public void atArithBinaryExpr(ArithBinaryExpr ast) {
        Exp e1 = this.pPromotion((Exp)this.visit(ast.getLeft()));
        Exp e2 = this.pPromotion((Exp)this.visit(ast.getRight()));
        int op = 0;
        switch (ast.operatorId()) {
            case 43: {
                op = 38;
                break;
            }
            case 45: {
                op = 39;
                break;
            }
            case 42: {
                op = 41;
                break;
            }
            case 47: {
                op = 42;
                break;
            }
            case 37: {
                op = 43;
                break;
            }
            case 38: {
                op = 46;
                break;
            }
            case 124: {
                op = 47;
                break;
            }
            case 94: {
                op = 48;
                break;
            }
            case 363: {
                op = 51;
                break;
            }
            case 360: {
                op = 52;
                break;
            }
            case 62: {
                op = 53;
                break;
            }
            case 362: {
                op = 54;
                break;
            }
            case 60: {
                op = 55;
                break;
            }
            case 361: {
                op = 56;
                break;
            }
            case 366: {
                op = 58;
                break;
            }
            case 367: {
                op = 60;
                break;
            }
            case 369: {
                op = 77;
                break;
            }
            case 368: {
                op = 78;
                break;
            }
            case 44: {
                op = 80;
                break;
            }
            default: {
                this.toHir.fatal("atArithBinaryExpr " + e1 + " " + ast.operatorName() + " " + e2);
            }
        }
        this.nowHir = this.hir.exp(op, e1, e2);
    }

    public void atArithUnaryExpr(ArithUnaryExpr ast) {
        Exp e1 = this.pPromotion((Exp)this.visit(ast.getLeft()));
        switch (ast.operatorId()) {
            case 33: {
                this.nowHir = this.hir.exp(81, e1);
                break;
            }
            case 126: {
                this.nowHir = this.hir.exp(62, e1);
                break;
            }
            case 43: {
                this.nowHir = e1;
                break;
            }
            case 45: {
                this.nowHir = this.hir.exp(63, e1);
                break;
            }
            default: {
                this.toHir.fatal("ArithUnary");
            }
        }
    }

    public void atArrayExpr(ArrayExpr ast) {
        Exp e1 = (Exp)this.visit(ast.getLeft());
        Exp e2 = (Exp)this.visit(ast.getRight());
        boolean use = this.toHir.useSubsForPtr;
        switch (e2.getType().getTypeKind()) {
            case 22: 
            case 23: {
                Exp e = e1;
                e1 = e2;
                e2 = e;
                use = false;
            }
        }
        switch (e1.getType().getTypeKind()) {
            case 22: {
                if (use) {
                    long size = 1L;
                    long t = 0L;
                    if (this.toHir.useArrayParameterSize && 0L < (t = ((PointerType)e1.getType()).getElemCount())) {
                        size = t;
                    }
                    this.nowHir = this.toHir.subsExp(this.hir.undecayExp(e1, size), e2);
                } else {
                    this.nowHir = this.hir.contentsExp(this.hir.exp(38, e1, e2));
                    this.toHir.setFlagPointerOperation(e1);
                    this.toHir.setFlagPointerOperation(e2);
                }
                return;
            }
            case 23: {
                this.nowHir = this.toHir.subsExp(e1, e2);
                return;
            }
        }
        this.toHir.error("[] requires array or pointer: " + ToC.tos(e1) + " [ " + ToC.tos(e2) + " ]");
        if (this.toHir.fDbgLevel > 1) {
            this.message(6, "atArrayExpr  ARRAY=" + e1.getType() + " INDEX=" + e2.getType());
        }
        this.nowHir = e2;
    }

    public void atAssignExpr(AssignExpr ast) {
        int op;
        Exp e1 = (Exp)this.visit(ast.getLeft());
        Exp e2 = this.pPromotion((Exp)this.visit(ast.getRight()));
        this.toHir.setFlagPointerOperation(e1);
        this.toHir.setFlagPointerOperation(e2);
        switch (ast.operatorId()) {
            case 61: {
                op = 22;
                break;
            }
            case 353: {
                op = 86;
                break;
            }
            case 354: {
                op = 87;
                break;
            }
            case 352: {
                op = 88;
                break;
            }
            case 355: {
                op = 89;
                break;
            }
            case 350: {
                op = 90;
                break;
            }
            case 356: {
                op = 91;
                break;
            }
            case 359: {
                op = 92;
                break;
            }
            case 351: {
                op = 93;
                break;
            }
            case 358: {
                op = 94;
                break;
            }
            case 357: {
                op = 95;
                break;
            }
            default: {
                op = 0;
                this.toHir.fatal("AssignExpr");
            }
        }
        this.toHir.setFlagValueIsAssigned(e1);
        this.nowHir = this.hir.exp(op, e1, e2);
        if (e1.getType().getTypeKind() == 22) {
            this.nowHir.getFlag(2);
        }
    }

    public void atCallExpr(CallExpr ast) {
        Exp funcExp;
        Expr funcExpr = ast.getFunction();
        if (funcExpr instanceof VariableExpr) {
            String name = funcExpr.toString().intern();
            if (this.toHir.searchOrdinaryId(name) == null) {
                SubpType type = (SubpType)this.toSym.convertType(astPrototype);
                Subp subp = this.toSym.declareLocalFunction(2, type, name);
                funcExp = this.hir.subpNode(subp);
            } else {
                funcExp = (Exp)this.visit((ASTree)((Object)funcExpr));
            }
        } else {
            funcExp = (Exp)this.visit((ASTree)((Object)funcExpr));
        }
        funcExp = this.pPromotion(funcExp);
        IrList arglist = this.hir.irList();
        for (ASTList al = ast.getArguments(); al != null; al = al.tail()) {
            Exp e = this.pPromotion((Exp)this.visit(al.head()));
            this.toHir.setFlagPointerOperation(e);
            arglist.add(e);
            e.setParent(arglist);
        }
        this.nowHir = funcExp != null ? this.hir.functionExp(funcExp, arglist) : null;
    }

    public void atCastExpr(CastExpr ast) {
        this.nowHir = this.hir.convExp(this.toSym.convertType(ast.getType()), this.pPromotion((Exp)this.visit(ast.getLeft())));
    }

    public void atSizeofExpr(SizeofExpr ast) {
        Type lType;
        if (ast.getType() == null && ast.getExpr() != null) {
            Exp lExp = (Exp)this.visit((ASTree)((Object)ast.getExpr()));
            lType = lExp.getType();
        } else {
            lType = ast.getType() != null && ast.getExpr() == null ? this.toSym.convertType(ast.getType()) : this.symRoot.typeInt;
        }
        this.nowHir = this.hir.intConstNode(lType.getSizeValue());
    }

    public void atCommaExpr(CommaExpr ast) {
        Exp e1 = (Exp)this.visit(ast.getLeft());
        Exp e2 = this.pPromotion((Exp)this.visit(ast.getRight()));
        this.toHir.setFlagPointerOperation(e2);
        this.nowHir = this.hir.exp(80, e1, e2);
    }

    public void atConditionalExpr(ConditionalExpr ast) {
        Exp e1 = this.pPromotion((Exp)this.visit((ASTree)((Object)ast.getCondition())));
        Exp e2 = this.pPromotion((Exp)this.visit((ASTree)((Object)ast.getThen())));
        Exp e3 = this.pPromotion((Exp)this.visit((ASTree)((Object)ast.getElse())));
        this.toHir.setFlagPointerOperation(e2);
        this.toHir.setFlagPointerOperation(e3);
        this.nowHir = this.hir.exp(79, e1, e2, e3);
    }

    public void atConstantExpr(ConstantExpr ast) {
        byte[] asttype = ast.getType();
        Type t = this.toSym.convertType(asttype);
        Const c = null;
        switch (t.getTypeKind()) {
            case 3: 
            case 4: 
            case 7: {
                c = this.sym.intConst(ast.longValue(), this.symRoot.typeInt);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                c = this.sym.intConst(ast.longValue(), this.symRoot.typeU_Int);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                c = this.sym.intConst(ast.longValue(), t);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                c = this.sym.floatConst(ast.doubleValue(), t);
                break;
            }
            default: {
                this.toHir.fatal("ConstantExpr type=" + t);
            }
        }
        if (this.toHir.fDbgLevel > 1) {
            this.message(6, "CONST=" + c);
        }
        this.nowHir = this.hir.constNode(c);
    }

    public void atDereferenceExpr(DereferenceExpr ast) {
        Exp e = this.pPromotion((Exp)this.visit(ast.getLeft()));
        HIR hIR = this.nowHir = e != null ? this.hir.contentsExp(e) : this.hir.nullNode();
        if (this.nowHir.getType() == null) {
            this.nowHir.setType(this.symRoot.typeVoid);
        }
    }

    private Elem searchElement(Type type, String name) {
        IrList elemlist = type.getElemList();
        if (elemlist == null) {
            this.toHir.fatal("searchElement");
        }
        if (elemlist.size() == 0) {
            this.toHir.error("dereferencing to incomplete type '" + type.getName() + "'");
            return null;
        }
        for (int i = 0; i < elemlist.size(); ++i) {
            Elem elem = (Elem)elemlist.get(i);
            if (!elem.getName().equals(name)) continue;
            return elem;
        }
        this.toHir.error("'" + name + "' is not a struct/union member");
        return null;
    }

    public void atMemberExpr(MemberExpr ast) {
        Exp e1 = this.pPromotion((Exp)this.visit(ast.getLeft()));
        Type t1 = e1.getType();
        String name = ast.name();
        switch (ast.operatorId()) {
            case 371: {
                if (t1.getTypeKind() == 22) {
                    if ((t1 = ((PointerType)t1).getPointedType()).getTypeKind() == 24 || t1.getTypeKind() == 25) {
                        Elem elem = this.searchElement(t1, name);
                        if (elem != null) {
                            this.nowHir = this.hir.pointedExp(e1, this.hir.elemNode(elem));
                            return;
                        }
                        this.toHir.error("right side of -> requires element name: " + ToC.tos(e1) + " . " + name);
                    } else {
                        this.toHir.error("left side of -> requires pointer to struct/union: " + ToC.tos(e1) + " -> " + name);
                    }
                } else {
                    this.toHir.error("left side of -> requires pointer: " + ToC.tos(e1) + " -> " + name);
                }
                this.nowHir = this.hir.nullNode();
                return;
            }
            case 46: {
                if (t1.getTypeKind() == 24 || t1.getTypeKind() == 25) {
                    Elem elem = this.searchElement(t1, name);
                    if (elem != null) {
                        this.nowHir = this.hir.qualifiedExp(e1, this.hir.elemNode(elem));
                        return;
                    }
                    this.toHir.error("right side of . requires element name: " + ToC.tos(e1) + " . " + name);
                } else {
                    this.toHir.error("left side of . requires struct/union: " + ToC.tos(e1) + " . " + name);
                }
                this.nowHir = this.hir.nullNode();
                return;
            }
        }
        this.toHir.fatal("MemberExpr");
    }

    public void atPointerBinaryExpr(PointerBinaryExpr ast) {
        Exp e1 = this.pPromotion((Exp)this.visit(ast.getLeft()));
        Exp e2 = this.pPromotion((Exp)this.visit(ast.getRight()));
        int op = 0;
        switch (ast.operatorId()) {
            case 43: {
                op = 38;
                if (e2.getType().getTypeKind() != 22) break;
                Exp e = e1;
                e1 = e2;
                e2 = e;
                break;
            }
            case 45: {
                op = 39;
                break;
            }
            default: {
                this.toHir.fatal("atPointerBinaryExpr: " + e1.getType() + ast.operatorName() + e2.getType());
            }
        }
        if (this.toHir.isIntegral(e2.getType())) {
            this.nowHir = this.hir.exp(op, e1, e2);
            this.toHir.setFlagPointerOperation(e1);
            this.nowHir.setFlag(2, true);
        } else {
            this.nowHir = this.hir.exp(76, e1, e2);
        }
    }

    public void atPostfixExpr(PostfixExpr ast) {
        Exp e1 = (Exp)this.visit(ast.getLeft());
        this.toHir.setFlagPointerOperation(e1);
        int op = 0;
        switch (ast.operatorId()) {
            case 364: {
                op = 84;
                break;
            }
            case 365: {
                op = 85;
                break;
            }
            default: {
                this.toHir.fatal("PostfixExpr");
            }
        }
        this.nowHir = this.hir.exp(op, e1);
    }

    public void atPrefixExpr(PrefixExpr ast) {
        Exp e1 = (Exp)this.visit(ast.getLeft());
        this.toHir.setFlagPointerOperation(e1);
        int op = 0;
        switch (ast.operatorId()) {
            case 364: {
                op = 82;
                break;
            }
            case 365: {
                op = 83;
                break;
            }
            default: {
                this.toHir.fatal("PrefixExpr");
            }
        }
        this.nowHir = this.hir.exp(op, e1);
    }

    public void atStringLiteral(StringLiteral ast) {
        String str = ast.get();
        this.reporter.isWideChar(ast instanceof WcharLiteral);
        StringConst sc = this.sym.stringConst(str.intern());
        this.nowHir = this.hir.constNode(sc);
    }

    public void atVariableExpr(VariableExpr ast) {
        String name = ast.toString().intern();
        Sym s = this.toHir.searchOrdinaryId(name);
        if (s == null) {
            this.toHir.error("undeclared identifier '" + name + "'");
            s = this.sym.defineVar(name, this.symRoot.typeInt, this.symRoot.symTableCurrent.getOwner());
            ((Var)s).setVisibility(4);
            ((Var)s).setStorageClass(7);
        }
        switch (s.getSymKind()) {
            case 8: 
            case 9: {
                this.reporter.isSupportedType((Var)s);
                this.nowHir = this.hir.varNode((Var)s);
                break;
            }
            case 12: {
                this.reporter.isVaArg((Subp)s);
                this.nowHir = this.hir.subpNode((Subp)s);
                break;
            }
            default: {
                this.toHir.fatal("atVariableExpr " + s.getSymKind());
            }
        }
    }

    public void atBreakStmnt(BreakStmnt ast) {
        if (this.breakLabel == null) {
            this.toHir.error("'break' without control structure");
            return;
        }
        this.nowHir = this.hir.jumpStmt(this.breakLabel);
    }

    public void atCaseLabel(CaseLabel ast) {
        if (this.caseList == null) {
            this.toHir.error("'case' without 'switch'");
            return;
        }
        long unusedbits = 64L - 8L * this.ctrlExpType.getSizeValue();
        long value = this.ctrlExpType.isUnsigned() ? ast.getConstant() << (int)unusedbits >>> (int)unusedbits : ast.getConstant() << (int)unusedbits >> (int)unusedbits;
        IntConst c = this.sym.intConst(value, this.ctrlExpType);
        Label l = this.toHir.createLabel();
        ListIterator i = this.caseList.iterator();
        while (i.hasNext()) {
            if (c != ((ConstNode)((HirSeq)i.next()).getChild1()).getConstSym()) continue;
            this.toHir.error("duplicated case constant");
            break;
        }
        ConstNode cn = this.hir.constNode(c);
        LabelNode ln = this.hir.labelNode(l);
        cn.setType(this.ctrlExpType);
        this.caseList.add(this.hir.hirSeq(cn, ln));
        this.nowHir = this.hir.labeledStmt(l, null);
    }

    public void atContinueStmnt(ContinueStmnt ast) {
        if (this.continueLabel == null) {
            this.toHir.error("'continue' without loop structure");
            return;
        }
        this.nowHir = this.hir.jumpStmt(this.continueLabel);
    }

    public void atDefaultLabel(DefaultLabel ast) {
        if (this.defaultLabel == null) {
            this.toHir.error("'default' without 'switch'");
            return;
        }
        this.nowHir = this.hir.labeledStmt(this.defaultLabel, null);
    }

    public void atDoStmnt(DoStmnt ast) {
        Label cl = this.continueLabel;
        Label bl = this.breakLabel;
        this.continueLabel = this.toHir.createLabel();
        this.breakLabel = this.toHir.createLabel();
        HIR h1 = this.visit((ASTree)((Object)ast.getBody()));
        HIR h2 = this.visit((ASTree)((Object)ast.getExpr()));
        this.nowHir = this.hir.repeatStmt(null, (Stmt)h1, this.continueLabel, this.pPromotion((Exp)h2), this.breakLabel);
        this.continueLabel = cl;
        this.breakLabel = bl;
    }

    public void atExpressionStmnt(ExpressionStmnt ast) {
        HIR lHir;
        ASTree lLeft = ast.getLeft();
        if (this.toHir.fDbgLevel > 1) {
            this.toHir.message(4, "\n atExpressionStmnt " + ast + " left " + lLeft + " right " + ast.getRight());
        }
        this.nowHir = lLeft != null ? ((lHir = this.visit(ast.getLeft())) instanceof Exp ? this.hir.expStmt(this.pPromotion((Exp)this.visit(ast.getLeft()))) : lHir) : this.hir.expStmt((Exp)this.visit(ast.getRight()));
        if (this.toHir.fDbgLevel > 1) {
            this.toHir.message(6, " result " + this.nowHir.toStringWithChildren());
        }
    }

    public void atForStmnt(ForStmnt ast) {
        Label cl = this.continueLabel;
        Label bl = this.breakLabel;
        this.continueLabel = this.toHir.createLabel();
        this.breakLabel = this.toHir.createLabel();
        HIR h1 = this.visit((ASTree)((Object)ast.getInitializer()));
        HIR h2 = this.visit((ASTree)((Object)ast.getCondition()));
        HIR h3 = this.visit((ASTree)((Object)ast.getIteration()));
        HIR h4 = this.visit((ASTree)((Object)ast.getBody()));
        this.nowHir = this.hir.forStmt(h1 != null ? this.hir.expStmt((Exp)h1) : null, null, h2 != null ? this.pPromotion((Exp)h2) : this.toHir.new1Node(), (Stmt)h4, this.continueLabel, h3 != null ? this.hir.expStmt((Exp)h3) : null, this.breakLabel);
        this.continueLabel = cl;
        this.breakLabel = bl;
    }

    public void atGotoStmnt(GotoStmnt ast) {
        this.nowHir = this.hir.jumpStmt(this.toHir.createLabel(ast.getLabel()));
    }

    public void atIfStmnt(IfStmnt ast) {
        HIR h1 = this.visit((ASTree)((Object)ast.getExpr()));
        HIR h2 = this.visit((ASTree)((Object)ast.getThen()));
        HIR h3 = this.visit((ASTree)((Object)ast.getElse()));
        this.nowHir = this.hir.ifStmt(this.pPromotion((Exp)h1), (Stmt)h2, (Stmt)h3);
    }

    public void atNamedLabel(NamedLabel ast) {
        String name = ast.getName().intern();
        Label label = this.toHir.createLabel(name);
        if (label.getHirPosition() != null) {
            this.toHir.error("duplicated label declaration '" + name + "'");
        }
        this.nowHir = this.hir.labeledStmt(label, null);
    }

    public void atNullStmnt(NullStmnt ast) {
    }

    public void atReturnStmnt(ReturnStmnt ast) {
        Exp e = (Exp)this.visit(ast.getLeft());
        this.nowHir = this.hir.returnStmt(this.pPromotion(e));
    }

    public void atSwitchStmnt(SwitchStmnt ast) {
        Type cet = this.ctrlExpType;
        IrList cl = this.caseList;
        Label dl = this.defaultLabel;
        Label bl = this.breakLabel;
        this.caseList = this.hir.irList();
        this.defaultLabel = this.toHir.createLabel();
        this.breakLabel = this.toHir.createLabel();
        HIR h1 = this.visit((ASTree)((Object)ast.getExpr()));
        this.ctrlExpType = this.toHir.iPromotedType(h1.getType());
        HIR h2 = this.visit((ASTree)((Object)ast.getBody()));
        this.nowHir = this.hir.switchStmt(this.pPromotion((Exp)h1), this.caseList, this.defaultLabel, (Stmt)h2, this.breakLabel);
        this.ctrlExpType = cet;
        this.caseList = cl;
        this.defaultLabel = dl;
        this.breakLabel = bl;
    }

    public void atWhileStmnt(WhileStmnt ast) {
        Label cl = this.continueLabel;
        Label bl = this.breakLabel;
        this.continueLabel = this.toHir.createLabel();
        this.breakLabel = this.toHir.createLabel();
        HIR h1 = this.visit((ASTree)((Object)ast.getExpr()));
        HIR h2 = this.visit((ASTree)((Object)ast.getBody()));
        this.nowHir = this.hir.whileStmt(null, this.pPromotion((Exp)h1), (Stmt)h2, this.continueLabel, this.breakLabel);
        this.continueLabel = cl;
        this.breakLabel = bl;
    }

    private void createZeroInitializerForGlobal() {
        SymIterator i = this.symRoot.symTableRoot.getSymIterator();
        while (i.hasNext()) {
            Sym s = i.next();
            switch (s.getSymKind()) {
                case 8: {
                    Var v = (Var)s;
                    if (v.getVisibility() == -1) {
                        v.setVisibility(2);
                    }
                    if (this.toHir.machineParam.initGlobalExplicitly() && v.getVisibility() != 1 && v.getInitialValue() == null) {
                        this.createInitializer(v, null);
                    }
                    Type t = v.getSymType();
                    if (v.getVisibility() == 1 || t.getSizeValue() > 0L) break;
                    this.toHir.warning(s, "'" + v.getName() + "' is incomplete type or size 0");
                    break;
                }
                case 12: {
                    Subp subp = (Subp)s;
                    if (subp.getVisibility() != 5 || subp.getHirBody() != null) break;
                    this.toHir.warning(s, "undefined static function '" + subp.getName() + "'");
                }
            }
        }
    }

    private void createZeroInitializerForStatic() {
        SymIterator i = this.symRoot.symTableCurrent.getSymIterator();
        while (i.hasNext()) {
            Sym s = i.next();
            switch (s.getSymKind()) {
                case 8: {
                    Var v = (Var)s;
                    if (v.getVisibility() == 1 || v.getStorageClass() != 6 || v.getInitialValue() != null) break;
                    this.createInitializer(v, null);
                }
            }
        }
    }

    public Exp pPromotion(Exp e) {
        if (e != null && e.getType() != null) {
            switch (e.getType().getTypeKind()) {
                case 23: {
                    return this.toHir.decayExp(e);
                }
                case 27: {
                    return this.toHir.addrExp(e);
                }
            }
        }
        return e;
    }
}

