/*
 * Decompiled with CFR 0.152.
 */
package coins.cfront;

import coins.MachineParam;
import coins.ast.TokenId;
import coins.ast.TypeId;
import coins.ast.expr.ConstantExpr;
import coins.ast.expr.FloatConstantExpr;
import coins.ast.expr.IntConstantExpr;
import coins.cfront.EncodedType;
import coins.cfront.Lex;
import coins.cfront.ParseError;
import coins.sym.Type;
import java.math.BigInteger;

class Evaluator
implements TokenId,
TypeId {
    final int[] toSize = new int[128];
    private final int[] toRank = new int[128];
    private final BigInteger[] toBigIntMask = new BigInteger[128];
    private static byte[] signedIntType = new byte[]{83, 105};
    private static byte[] unsignedIntType = new byte[]{85, 105};

    public Evaluator(MachineParam mp) {
        this.toSize[99] = mp.evaluateSize(7);
        this.toSize[115] = mp.evaluateSize(3);
        this.toSize[105] = mp.evaluateSize(4);
        this.toSize[108] = mp.evaluateSize(5);
        this.toSize[106] = mp.evaluateSize(6);
        this.toSize[102] = mp.evaluateSize(16);
        this.toSize[100] = mp.evaluateSize(17);
        this.toSize[114] = mp.evaluateSize(18);
        this.toSize[80] = mp.evaluateSize(22);
        this.toRank[99] = Type.KIND_RANKS[7];
        this.toRank[115] = Type.KIND_RANKS[3];
        this.toRank[105] = Type.KIND_RANKS[4];
        this.toRank[108] = Type.KIND_RANKS[5];
        this.toRank[106] = Type.KIND_RANKS[6];
        this.toRank[102] = Type.KIND_RANKS[16];
        this.toRank[100] = Type.KIND_RANKS[17];
        this.toRank[114] = Type.KIND_RANKS[18];
        this.toBigIntMask[99] = BigInteger.valueOf(-1L << 8 * mp.evaluateSize(7) ^ 0xFFFFFFFFFFFFFFFFL);
        this.toBigIntMask[115] = BigInteger.valueOf(-1L << 8 * mp.evaluateSize(3) ^ 0xFFFFFFFFFFFFFFFFL);
        this.toBigIntMask[105] = BigInteger.valueOf(-1L << 8 * mp.evaluateSize(4) ^ 0xFFFFFFFFFFFFFFFFL);
        this.toBigIntMask[108] = BigInteger.valueOf(-1L << 8 * mp.evaluateSize(5) ^ 0xFFFFFFFFFFFFFFFFL);
        this.toBigIntMask[106] = BigInteger.valueOf(-1L << 8 * mp.evaluateSize(6) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public ConstantExpr make(long value) {
        return this.make(value, 'S', 'i');
    }

    public ConstantExpr make(long value, byte[] type) {
        return this.make(value, (char)type[0], (char)type[1]);
    }

    public ConstantExpr make(long value, EncodedType type) {
        return this.make(value, type.isSigned() ? (char)'S' : 'U', (char)type.getTypeChar());
    }

    public ConstantExpr make(long value, char sign, char type) {
        int bits;
        if (type == '[') {
            type = (char)105;
        }
        if ((bits = 8 * this.toSize[type]) == 0) {
            System.err.println("TYPEID ERROR: " + type);
            bits = 8 * this.toSize[105];
        }
        int restbits = 64 - bits;
        value = sign == 'S' ? value << restbits >> restbits : value << restbits >>> restbits;
        return new IntConstantExpr(value, sign, type);
    }

    public ConstantExpr make(double value) {
        return this.make(value, 'd');
    }

    public ConstantExpr make(double value, byte[] type) {
        return this.make(value, (char)type[0]);
    }

    public ConstantExpr make(double value, EncodedType type) {
        return this.make(value, (char)type.getTypeChar());
    }

    public ConstantExpr make(double value, char type) {
        switch (type) {
            case 'f': {
                value = (float)value;
            }
            case 'd': {
                break;
            }
            case 'r': {
                break;
            }
            default: {
                System.err.println("TYPEID ERROR: " + type);
            }
        }
        return new FloatConstantExpr(value, type);
    }

    public ConstantExpr cast(Lex lex, ConstantExpr expr, EncodedType etype) throws ParseError {
        if (etype.isValue()) {
            return etype.isDouble() ? this.make(expr.doubleValue(), etype) : this.make(expr.longValue(), etype);
        }
        throw new ParseError(lex, "bad cast operation: (" + etype + ")");
    }

    public ConstantExpr applyUnaryOp(Lex lex, int op, ConstantExpr expr) throws ParseError {
        if (expr instanceof IntConstantExpr) {
            switch (op) {
                case 43: {
                    return this.make(expr.longValue(), this.getIpType(expr.getType()));
                }
                case 45: {
                    return this.make(-expr.longValue(), this.getIpType(expr.getType()));
                }
                case 33: {
                    return this.make(expr.longValue() == 0L ? 1L : 0L, signedIntType);
                }
                case 126: {
                    return this.make(expr.longValue() ^ 0xFFFFFFFFFFFFFFFFL, this.getIpType(expr.getType()));
                }
            }
        } else {
            switch (op) {
                case 43: {
                    return expr;
                }
                case 45: {
                    return this.make(-expr.doubleValue(), expr.getTypeChar());
                }
                case 33: {
                    return this.make(expr.doubleValue() == 0.0 ? 1L : 0L, signedIntType);
                }
                case 126: {
                    throw new ParseError(lex, "bad unary operation");
                }
            }
        }
        throw new RuntimeException("unknonw unary operator: " + op);
    }

    public ConstantExpr applyBinaryOp(Lex lex, ConstantExpr expr1, int op, ConstantExpr expr2) throws ParseError {
        byte[] uactype = this.getUacType(expr1.getType(), expr2.getType());
        if (uactype.length == 1) {
            double d1 = expr1.doubleValue();
            double d2 = expr2.doubleValue();
            switch (op) {
                case 43: {
                    return this.make(d1 + d2, uactype);
                }
                case 45: {
                    return this.make(d1 - d2, uactype);
                }
                case 42: {
                    return this.make(d1 * d2, uactype);
                }
                case 47: {
                    if (d2 == 0.0) {
                        throw new ParseError(lex, "division by zero");
                    }
                    return this.make(d1 / d2, uactype);
                }
                case 37: 
                case 38: 
                case 94: 
                case 124: 
                case 366: 
                case 367: {
                    throw new ParseError(lex, "bad binary operation of float");
                }
                case 369: {
                    return this.make(d1 != 0.0 && d2 != 0.0 ? 1L : 0L, signedIntType);
                }
                case 368: {
                    return this.make(d1 != 0.0 || d2 != 0.0 ? 1L : 0L, signedIntType);
                }
                case 361: {
                    return this.make(d1 <= d2 ? 1L : 0L, signedIntType);
                }
                case 362: {
                    return this.make(d1 >= d2 ? 1L : 0L, signedIntType);
                }
                case 60: {
                    return this.make(d1 < d2 ? 1L : 0L, signedIntType);
                }
                case 62: {
                    return this.make(d1 > d2 ? 1L : 0L, signedIntType);
                }
                case 363: {
                    return this.make(d1 == d2 ? 1L : 0L, signedIntType);
                }
                case 360: {
                    return this.make(d1 != d2 ? 1L : 0L, signedIntType);
                }
            }
        } else {
            long l1 = expr1.longValue();
            long l2 = expr2.longValue();
            switch (op) {
                case 366: {
                    return this.make(l1 << (int)l2, this.getIpType(expr1.getType()));
                }
                case 367: {
                    return this.make(expr1.getSignChar() == 'S' ? l1 >> (int)l2 : l1 >>> (int)l2, this.getIpType(expr1.getType()));
                }
                case 38: {
                    return this.make(l1 & l2, uactype);
                }
                case 94: {
                    return this.make(l1 ^ l2, uactype);
                }
                case 124: {
                    return this.make(l1 | l2, uactype);
                }
                case 369: {
                    return this.make(l1 != 0L && l2 != 0L ? 1L : 0L, signedIntType);
                }
                case 368: {
                    return this.make(l1 != 0L || l2 != 0L ? 1L : 0L, signedIntType);
                }
            }
            ConstantExpr c1 = this.make(l1, uactype);
            BigInteger b1 = BigInteger.valueOf(c1.longValue());
            if (c1.getSignChar() != 'S') {
                b1 = b1.and(this.toBigIntMask[c1.getTypeChar()]);
            }
            ConstantExpr c2 = this.make(l2, uactype);
            BigInteger b2 = BigInteger.valueOf(c2.longValue());
            if (c2.getSignChar() != 'S') {
                b2 = b2.and(this.toBigIntMask[c2.getTypeChar()]);
            }
            switch (op) {
                case 43: {
                    return this.make(b1.add(b2).longValue(), uactype);
                }
                case 45: {
                    return this.make(b1.subtract(b2).longValue(), uactype);
                }
                case 42: {
                    return this.make(b1.multiply(b2).longValue(), uactype);
                }
                case 47: {
                    if (b2.equals(BigInteger.ZERO)) {
                        throw new ParseError(lex, "division by zero");
                    }
                    return this.make(b1.divide(b2).longValue(), uactype);
                }
                case 37: {
                    return this.make(b1.remainder(b2).longValue(), uactype);
                }
                case 361: {
                    return this.make(b1.compareTo(b2) <= 0 ? 1L : 0L, signedIntType);
                }
                case 362: {
                    return this.make(b1.compareTo(b2) >= 0 ? 1L : 0L, signedIntType);
                }
                case 60: {
                    return this.make(b1.compareTo(b2) < 0 ? 1L : 0L, signedIntType);
                }
                case 62: {
                    return this.make(b1.compareTo(b2) > 0 ? 1L : 0L, signedIntType);
                }
                case 363: {
                    return this.make(b1.compareTo(b2) == 0 ? 1L : 0L, signedIntType);
                }
                case 360: {
                    return this.make(b1.compareTo(b2) != 0 ? 1L : 0L, signedIntType);
                }
            }
        }
        throw new RuntimeException("unknonw binary operator: " + op);
    }

    private byte[] getUacType(byte[] t1, byte[] t2) {
        int r1 = this.toRank[t1[0]];
        int r2 = this.toRank[t2[0]];
        if (r1 != 0 || r2 != 0) {
            return r1 > r2 ? t1 : t2;
        }
        r1 = this.toRank[t1[1]];
        r2 = this.toRank[t2[1]];
        int a1 = this.toSize[t1[1]];
        int a2 = this.toSize[t2[1]];
        if (r1 >= this.toRank[105] || r2 >= this.toRank[105]) {
            if (a1 != a2) {
                return a1 > a2 ? t1 : t2;
            }
            return new byte[]{t1[0] == 83 && t2[0] == 83 ? (byte)83 : 85, r1 > r2 ? t1[1] : t2[1]};
        }
        if (a1 >= this.toSize[105] && t1[0] == 85 || a2 >= this.toSize[105] && t2[0] == 85) {
            return unsignedIntType;
        }
        return signedIntType;
    }

    private byte[] getIpType(byte[] t1) {
        if (this.toRank[t1[0]] != 0) {
            return null;
        }
        if (this.toRank[t1[1]] >= this.toRank[105]) {
            return t1;
        }
        if (this.toSize[t1[1]] >= this.toSize[105] && t1[0] == 85) {
            return unsignedIntType;
        }
        return signedIntType;
    }
}

