/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.FatalError;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class TemporaryFileManager {
    private static final String DEFAULT_PREFIX = "COINS";
    private static final String DEFAULT_POSTFIX = null;
    private Collection fTemporaryFiles = new ArrayList();
    private int fCounter = 0;
    private String myName = "TemporaryFileManager";

    public synchronized void cleanupTemporaryFiles() {
        for (File lFile : this.fTemporaryFiles) {
            if (!lFile.isFile()) continue;
            lFile.delete();
        }
    }

    public File createTemporaryFile() throws IOException {
        return this.createTemporaryFile(DEFAULT_POSTFIX);
    }

    public synchronized File createTemporaryFile(String suffix) throws IOException {
        try {
            return this.createTemporaryFile(DEFAULT_PREFIX, suffix);
        }
        catch (IllegalArgumentException lIllegalArgumentException) {
            FatalError lFatalError = new FatalError(this.myName + ": panic(IllegalArgumentException): " + lIllegalArgumentException.getMessage());
            System.err.println(lFatalError.getMessage());
            throw lFatalError;
        }
    }

    public synchronized File createTemporaryFile(String prefix, String suffix) throws IllegalArgumentException, IOException {
        File lFile = File.createTempFile(prefix, suffix);
        this.fTemporaryFiles.add(lFile);
        return lFile;
    }

    public synchronized Collection getTemporaryFiles() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.fTemporaryFiles);
        return ret;
    }
}

