/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.driver.Warning;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;

public class Trace {
    private static final char CATEGORY_DELIMITER = '/';
    private static final char LEVEL_DELIMITER = '.';
    private static final String fMessageHeader = "TRACE";
    private static final String defaultCategoryName = "default";
    private final PrintStream fTraceOut;
    private final Map fTraceTable;
    private int fGenericTraceLevel;
    private boolean fGenericTraceLevelIsSet;
    private int fDefaultTraceLevel;
    private boolean fDefaultTraceLevelIsSet;

    private void parseTraceSpec(String pTraceSpec, Map pTable, Warning pWarning) {
        int lLevelDelimiterIndex = pTraceSpec.indexOf(46);
        if (lLevelDelimiterIndex == -1) {
            if (Character.isDigit(pTraceSpec.charAt(0))) {
                try {
                    this.fGenericTraceLevel = Integer.parseInt(pTraceSpec);
                    this.fGenericTraceLevelIsSet = true;
                }
                catch (NumberFormatException lNumberFormatException) {
                    pWarning.warning("Driver", "Trace level must be a number: " + pTraceSpec);
                }
            } else {
                pTable.put(pTraceSpec, new Integer(Integer.MAX_VALUE));
            }
        } else {
            String lCategory = pTraceSpec.substring(0, lLevelDelimiterIndex);
            String lLevelString = pTraceSpec.substring(lLevelDelimiterIndex + 1);
            try {
                Integer lLevel = Integer.valueOf(lLevelString);
                if (lCategory.equals(defaultCategoryName)) {
                    this.fDefaultTraceLevelIsSet = true;
                    this.fDefaultTraceLevel = lLevel;
                } else {
                    pTable.put(lCategory, lLevel);
                }
            }
            catch (NumberFormatException lNumberFormatException) {
                pWarning.warning("Driver", "Trace level must be a number: " + lLevelString);
            }
        }
    }

    private Map parseArgument(String pArgument, Warning pWarning) {
        Hashtable lTable = new Hashtable();
        String lArgument = pArgument.trim();
        int lIndex = 0;
        int lLen = lArgument.length();
        while (lIndex < lLen) {
            String lNextArg;
            int lCategoryDelimiterIndex = lArgument.indexOf(47, lIndex);
            if (lCategoryDelimiterIndex == -1) {
                lNextArg = lArgument.substring(lIndex);
                lIndex = lLen;
            } else {
                lNextArg = lArgument.substring(lIndex, lCategoryDelimiterIndex);
                lIndex = lCategoryDelimiterIndex + 1;
            }
            this.parseTraceSpec(lNextArg, lTable, pWarning);
        }
        return lTable;
    }

    public Trace(Warning warning) {
        this(System.out, warning);
    }

    public Trace(PrintStream out, Warning warning) {
        this(out, "", warning);
    }

    public Trace(PrintStream out, String traceArgument, Warning warning) {
        this.fTraceOut = out;
        this.fGenericTraceLevelIsSet = false;
        this.fDefaultTraceLevelIsSet = false;
        this.fTraceTable = this.parseArgument(traceArgument, warning);
    }

    public synchronized boolean shouldTrace() {
        return this.fGenericTraceLevelIsSet || this.fDefaultTraceLevelIsSet;
    }

    public synchronized boolean shouldTrace(int level) {
        return this.fGenericTraceLevelIsSet && this.fGenericTraceLevel >= level || this.fDefaultTraceLevelIsSet && this.fDefaultTraceLevel >= level;
    }

    public synchronized boolean shouldTrace(String category) {
        return this.fTraceTable.containsKey(category);
    }

    public synchronized boolean shouldTrace(String category, int level) {
        if (this.shouldTrace(category)) {
            return (Integer)this.fTraceTable.get(category) >= level;
        }
        return this.fDefaultTraceLevelIsSet && this.fDefaultTraceLevel >= level;
    }

    private void putMessage(String message) {
        this.fTraceOut.println("[TRACE] " + message);
    }

    private void putMessage(String category, String message) {
        this.fTraceOut.println("[TRACE:" + category + "] " + message);
    }

    private void putMessage(int level, String message) {
        this.fTraceOut.println("[TRACE:" + level + "] " + message);
    }

    private void putMessage(String category, int level, String message) {
        this.fTraceOut.println("[TRACE:" + category + "." + level + "] " + message);
    }

    public synchronized void trace(String message) {
        if (this.shouldTrace()) {
            this.putMessage(message);
        }
    }

    public synchronized void trace(int level, String message) {
        if (this.shouldTrace(level)) {
            this.putMessage(level, message);
        }
    }

    public synchronized void trace(String category, String message) {
        if (this.shouldTrace(category)) {
            this.putMessage(category, message);
        }
    }

    public synchronized void trace(String category, int level, String message) {
        if (this.shouldTrace(category, level)) {
            this.putMessage(category, level, message);
        }
    }

    public synchronized int getGenericTraceLevel() {
        if (this.fGenericTraceLevelIsSet) {
            return this.fGenericTraceLevel;
        }
        return 0;
    }

    public synchronized int getDefaultTraceLevel() {
        if (this.fDefaultTraceLevelIsSet) {
            return this.fDefaultTraceLevel;
        }
        return 0;
    }

    public synchronized int getTraceLevel(String category) {
        if (this.fTraceTable.containsKey(category)) {
            return (Integer)this.fTraceTable.get(category);
        }
        return 0;
    }

    public synchronized int setGenericTraceLevel(int newLevel) {
        int oldLevel = this.fGenericTraceLevel;
        this.fGenericTraceLevel = newLevel;
        this.fGenericTraceLevelIsSet = true;
        return oldLevel;
    }

    public synchronized int setDefaultTraceLevel(int newLevel) {
        int oldLevel = this.fDefaultTraceLevel;
        this.fDefaultTraceLevel = newLevel;
        this.fDefaultTraceLevelIsSet = true;
        return oldLevel;
    }

    public synchronized int setTraceLevel(String category, int newLevel) {
        if (category.equals(defaultCategoryName)) {
            int oldLevel = this.fDefaultTraceLevel;
            this.fDefaultTraceLevel = newLevel;
            this.fDefaultTraceLevelIsSet = true;
            return oldLevel;
        }
        Integer old = (Integer)this.fTraceTable.get(category);
        int oldLevel = old == null ? 0 : old;
        this.fTraceTable.put(category, new Integer(newLevel));
        return oldLevel;
    }
}

