/*
 * Decompiled with CFR 0.152.
 */
package coins.drivergen.process;

import coins.PassException;
import coins.backend.Module;
import coins.backend.Root;
import coins.driver.CoinsOptions;
import coins.drivergen.InputIr;
import coins.drivergen.Options;
import coins.drivergen.ProcessException;
import coins.drivergen.process.Navigator;
import coins.drivergen.process.Process;
import java.io.IOException;
import java.io.PrintWriter;

public class GenerateCode
extends Process {
    public static final Navi navi = new Navi();
    private String myName = navi.name();

    GenerateCode(InputIr ir, Options opt) {
        super(ir, opt);
    }

    public void go() throws ProcessException, PassException, IOException {
        if (!this.canStart()) {
            throw new PassException(this.myName, "can't start this process");
        }
        if (InputIr.unit == null) {
            CoinsOptions coinsOptions = this.opt.coinsOptions;
            Root root = new Root(this.opt.spec, new PrintWriter(System.out, true));
            String targetName = coinsOptions.getArg("target-arch");
            String targetConvention = coinsOptions.getArg("target-convention");
            this.opt.trace.trace(this.myName, 5000, "target name = " + targetName);
            if (InputIr.sexp == null) {
                throw new PassException(this.myName, "no ImList");
            }
            InputIr.unit = Module.loadSLir(InputIr.sexp, targetName, targetConvention, root);
            if (InputIr.unit == null) {
                throw new PassException(this.myName, "no Module");
            }
        }
        InputIr.unit.basicOptimization();
        InputIr.unit.generateCode(Options.out);
        InputIr.condition = 4;
    }

    public boolean canStart() {
        if (InputIr.sexp == null) {
            return false;
        }
        return InputIr.condition == 3;
    }

    private static class Navi
    implements Navigator {
        private Navi() {
        }

        public String name() {
            return "GenerateCode";
        }

        public String subject() {
            return "generate code from Lir.";
        }

        public int precondition() {
            return 3;
        }

        public int postcondition() {
            return 4;
        }

        public boolean isExternalCommand() {
            return false;
        }

        public void go(InputIr ir, Options op) {
            try {
                new GenerateCode(ir, op).go();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }
}

