/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.ConcatNode;
import coins.ffront.FStmt;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.Node;
import coins.ffront.StmtFuncType;
import coins.ffront.SubscrOrFunCallNode;
import coins.ir.hir.Exp;
import coins.ir.hir.SubscriptedExp;
import coins.sym.PointerType;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.VectorType;

public class AssignOrFuncStmt
extends FStmt {
    private Node left;
    private Node right;
    private Type returnType;

    public AssignOrFuncStmt(Node pLeft, Node pRight, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.left = pLeft;
        this.right = pRight;
        if (this.left == null || this.right == null) {
            this.fHir.printMsgFatal("parser error in assignment statement: " + this.left + "," + this.right);
        }
        this.returnType = null;
    }

    public Node getLeft() {
        return this.left;
    }

    public Node getRight() {
        return this.right;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.fHir.debugPrint(level, spaces + "AssignOrFunc" + "\n");
        this.left.print(level, spaces + "  ");
        this.right.print(level, spaces + "  ");
    }

    public String toString() {
        return super.toString() + "assign statement : <" + this.left + "> = <" + this.right + ">";
    }

    public void process() {
        if (this.isStmtFunc()) {
            return;
        }
        if (this.right instanceof ConcatNode) {
            this.stmt = ((ConcatNode)this.right).assignWithConcatString(this.left);
            super.process();
            return;
        }
        Exp lExp1 = this.left.makeExp();
        Exp lExp2 = this.right.makeExp();
        if (lExp1 instanceof FortranCharacterExp) {
            this.characterAssignment((FortranCharacterExp)lExp1, this.fTypeUtil.castFortranCharacterExp(lExp2));
            super.process();
            return;
        }
        this.stmt = this.fHirUtil.makeAssignStmt(lExp1, lExp2);
        super.process();
    }

    void characterAssignment(FortranCharacterExp e1, FortranCharacterExp e2) {
        this.stmt = this.fHirUtil.makeCharacterAssignStmt(this.hir.exp(64, e1.getBody()), this.hir.exp(64, e2.getBody()), e1.getLength(), e2.getLength());
    }

    Exp complexCheck(Exp e) {
        if (e instanceof SubscriptedExp && e.getType() instanceof StructType) {
            e = this.fHirUtil.makeComplexExp(e);
        }
        return e;
    }

    boolean isStmtFunc() {
        if (this.left instanceof SubscrOrFunCallNode) {
            String ident = ((SubscrOrFunCallNode)this.left).getIdent();
            Sym leftSym = this.fDeclMgr.search(ident);
            if (leftSym == null) {
                this.returnType = this.fDeclMgr.getImplicitType(ident);
                leftSym = this.fDeclMgr.defineSubp(ident, this.returnType, 4, null);
            } else {
                this.returnType = leftSym.getSymType();
                if (this.returnType instanceof VectorType || this.returnType instanceof PointerType) {
                    return false;
                }
                leftSym.remove();
                leftSym = this.fDeclMgr.defineSubp(ident, this.returnType, 4, null);
            }
            leftSym.setSymType(new StmtFuncType(this, this.returnType, this.fHir));
            return true;
        }
        return false;
    }
}

