/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.ffront.DeclManager;
import coins.ffront.ExecStmtManager;
import coins.ffront.F77Hir;
import coins.ffront.F77Sym;
import coins.ffront.HirUtility;
import coins.ffront.IntrinsicUtility;
import coins.ffront.TypeUtility;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.sym.Sym;

public class FirToHir {
    private SymRoot symRoot;
    private HirRoot hirRoot;
    private IoRoot ioRoot;
    String fFileName;
    F77Sym f7Sym;
    F77Hir f7Hir;
    HirUtility fHirUtil;
    TypeUtility fTypeMgr;
    DeclManager fDeclMgr;
    ExecStmtManager fESMgr;
    IntrinsicUtility fIntrUtil;

    HirRoot getHirRoot() {
        return this.hirRoot;
    }

    SymRoot getSymRoot() {
        return this.symRoot;
    }

    HIR getHir() {
        return this.hirRoot.hir;
    }

    Sym getSym() {
        return this.symRoot.sym;
    }

    HirUtility getHirUtility() {
        return this.fHirUtil;
    }

    TypeUtility getTypeUtility() {
        return this.fTypeMgr;
    }

    DeclManager getDeclManager() {
        return this.fDeclMgr;
    }

    ExecStmtManager getExecStmtManager() {
        return this.fESMgr;
    }

    IntrinsicUtility getIntrinsicUtility() {
        return this.fIntrUtil;
    }

    public FirToHir(SymRoot sRoot, HirRoot hRoot, IoRoot iRoot) {
        this.symRoot = sRoot;
        this.hirRoot = hRoot;
        this.ioRoot = iRoot;
        this.fFileName = iRoot.getSourceFile().getName();
        this.fHirUtil = new HirUtility(this, this.hirRoot.hir);
        this.fHirUtil.fTypeUtil = this.fTypeMgr = new TypeUtility(this);
        this.fTypeMgr.fHirUtil = this.fHirUtil;
        this.fIntrUtil = new IntrinsicUtility(this);
        this.hirRoot.programRoot = this.getHir().program(null, this.symRoot.symTableRoot, null, null);
    }

    public void makeHirFromFir(F77Sym pf7Sym, F77Hir pf7Hir) {
        this.f7Sym = pf7Sym;
        this.f7Hir = pf7Hir;
        this.fDeclMgr = new DeclManager(this, this.f7Sym);
        this.fESMgr = new ExecStmtManager(this);
        this.dp("** start process decl");
        this.fDeclMgr.processDecl();
        if (this.f7Sym.programHeader != null) {
            this.dp("** start process execution body");
            BlockStmt blockStmt = this.fESMgr.processExecStmt(this.f7Hir.getProgramBody());
            blockStmt.addFirstStmt(this.fDeclMgr.fInitialPart);
            blockStmt.setSymTable(this.fDeclMgr.fSubpDef.getSymTable());
            this.fDeclMgr.fSubpDef.finishHir();
            this.fDeclMgr.fSubpDef.setHirBody(blockStmt);
        }
    }

    public void debugPrint(int level, String pMsg) {
        this.ioRoot.dbgToHir.print(level, pMsg);
    }

    public void dp(String msg) {
        this.ioRoot.dbgToHir.print(2, ";; " + msg + "\n");
    }

    public void p(String pMsg) {
        this.ioRoot.dbgToHir.print(0, pMsg);
        this.ioRoot.dbgToHir.print(0, "\n");
    }

    public void printMsgWarn(String pMsg) {
        String msg = pMsg;
        if (this.fESMgr.currentStmt != null) {
            msg = msg + " at " + this.fESMgr.currentStmt.toString();
            msg = msg + "(line: " + this.fESMgr.currentStmt.fLine + ")";
        }
        this.ioRoot.msgWarning.put(": " + pMsg);
    }

    public void printMsgFatal(String pMsg) {
        String msg = pMsg;
        if (this.fESMgr.currentStmt != null) {
            msg = msg + " at " + this.fESMgr.currentStmt.toString();
            msg = msg + "(line: " + this.fESMgr.currentStmt.fLine + ")";
        }
        this.ioRoot.msgFatal.put(": " + pMsg);
    }

    public void printMsgRecovered(String pMsg) {
        String msg = pMsg;
        if (this.fESMgr.currentStmt != null) {
            msg = msg + " at " + this.fESMgr.currentStmt.toString();
            msg = msg + "(line: " + this.fESMgr.currentStmt.fLine + ")";
        }
        this.ioRoot.msgFatal.put(": " + pMsg);
        this.ioRoot.msgRecovered.put(": " + msg);
    }

    public void printMsgError(String pMsg) {
        String msg = pMsg;
        if (this.fESMgr.currentStmt != null) {
            msg = msg + " at " + this.fESMgr.currentStmt.toString();
            msg = msg + "(line: " + this.fESMgr.currentStmt.fLine + ")";
        }
        this.ioRoot.msgFatal.put(": " + pMsg);
        this.ioRoot.msgError.put(": " + msg);
    }
}

