/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.HirRoot;
import coins.ffront.ComplexConstNode;
import coins.ffront.DeclManager;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.HasConstValue;
import coins.ffront.HirUtility;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.Quad;
import coins.ffront.Token;
import coins.ffront.TypeUtility;
import coins.ffront.UnaryNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpListExp;
import coins.ir.hir.ExpListExpImpl;
import coins.ir.hir.NullNode;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ProcessData {
    FirToHir fHir;
    HirRoot hirRoot;
    TypeUtility fTypeUtil;
    DeclManager fDeclMgr;
    HirUtility fHirUtil;

    ProcessData(FirToHir fth) {
        this.fHir = fth;
        this.hirRoot = this.fHir.getHirRoot();
        this.fDeclMgr = this.fHir.getDeclManager();
        this.fTypeUtil = this.fHir.getTypeUtility();
        this.fHirUtil = this.fHir.getHirUtility();
    }

    void process() {
        Iterator declit = this.fDeclMgr.f7Sym.dataList.iterator();
        while (declit.hasNext()) {
            for (Pair p : (FirList)declit.next()) {
                Iterator varit = ((FirList)p.getLeft()).iterator();
                Iterator valit = ((FirList)p.getRight()).iterator();
                FirList vals = this.makeDataVals(valit);
                valit = vals.iterator();
                while (varit.hasNext()) {
                    Node var = (Node)varit.next();
                    if (var instanceof Token) {
                        this.init_token((Token)var, valit);
                        continue;
                    }
                    Pair pvar = (Pair)var;
                    if (pvar.getLeft() instanceof Token) {
                        this.init_subscr((Token)pvar.getLeft(), (FirList)pvar.getRight(), valit);
                        continue;
                    }
                    this.init_dolist((FirList)pvar.getLeft(), (Quad)pvar.getRight(), valit);
                }
            }
        }
    }

    private void init_token(Token var, Iterator valit) {
        Exp val_exp;
        this.dp("** ProcessData/Token: " + var);
        String ident = var.getLexem();
        Var v = this.fDeclMgr.searchOrAddVar(ident);
        Type type = v.getSymType();
        if (type instanceof VectorType && !this.fTypeUtil.isFortranCharacterType(type)) {
            val_exp = this.makeArrayInitializeList((VectorType)type, valit, null);
            val_exp.setType(v.getSymType());
        } else {
            val_exp = ((Node)valit.next()).makeExp();
        }
        this.dp("ProcessData/Token/val_exp: " + val_exp);
        this.fHir.getDeclManager().setInitialValue(v, val_exp, ident);
    }

    private void init_subscr(Token t, FirList dims, Iterator valit) {
        this.dp("** ProcessData/subscr: " + t);
        LinkedList elist = new LinkedList();
        ArrayElement ae = new ArrayElement(t, dims, null);
        Exp exp = ((Node)valit.next()).makeExp();
        if (exp instanceof FortranCharacterExp) {
            exp = ((FortranCharacterExp)exp).getBody();
            exp = exp.getExp1();
        }
        ae.setExp(exp);
        HashMap<List, Exp> map = new HashMap<List, Exp>();
        map.put(ae.getDims(), ae.getExp());
        String ident = t.getLexem();
        Var v = this.fDeclMgr.searchOrAddVar(ident);
        if (v.getSymType() instanceof VectorType) {
            Exp val_exp = this.makeArrayInitializeList((VectorType)v.getSymType(), null, map);
            val_exp = this.setArrayInitializeValue(v, val_exp, ident);
            val_exp.setType(v.getSymType());
        } else {
            this.fHir.printMsgFatal("this is not array in do list :" + ident);
        }
    }

    private void init_dolist(FirList do_range, Quad do_spec, Iterator valit) {
        this.dp("** ProcessData/dolist: " + do_range);
        List elist = this.makeElemListFromDoList(do_range, do_spec, new HashMap());
        Iterator it = elist.iterator();
        HashMap symbol_and_val_map = new HashMap();
        while (it.hasNext()) {
            Map<List, Exp> m;
            Exp exp = ((Node)valit.next()).makeExp();
            if (exp instanceof FortranCharacterExp) {
                exp = ((FortranCharacterExp)exp).getBody();
                exp = exp.getExp1();
            }
            ArrayElement ae = (ArrayElement)it.next();
            ae.setExp(exp);
            if (symbol_and_val_map.containsKey(ae.getLexem())) {
                m = (Map)symbol_and_val_map.get(ae.getLexem());
                m.put(ae.getDims(), ae.getExp());
                continue;
            }
            m = new HashMap<List, Exp>();
            ((HashMap)m).put(ae.getDims(), ae.getExp());
            symbol_and_val_map.put(ae.getLexem(), m);
        }
        for (String ident : symbol_and_val_map.keySet()) {
            Var v = this.fDeclMgr.searchOrAddVar(ident);
            if (v.getSymType() instanceof VectorType) {
                Map m = (Map)symbol_and_val_map.get(ident);
                Exp val_exp = this.makeArrayInitializeList((VectorType)v.getSymType(), null, m);
                val_exp = this.setArrayInitializeValue(v, val_exp, ident);
                val_exp.setType(v.getSymType());
                continue;
            }
            this.fHir.printMsgFatal("this is not array in do list :" + ident);
        }
    }

    Exp setArrayInitializeValue(Var v, Exp val_exp, String ident) {
        ExpListExp el2;
        ExpListExp el1;
        if (v.getInitialValue() != null && (val_exp = this.mergeArrayInitializeList(el1 = (ExpListExp)val_exp, el2 = (ExpListExp)v.getInitialValue())) == null) {
            this.dp("el1: " + this.exp2str(el1));
            this.dp("el2: " + this.exp2str(el2));
            this.fHir.printMsgFatal("Attempt to specify second initial value for element of " + ident);
            return null;
        }
        this.fHir.getDeclManager().setInitialValue(v, val_exp, ident);
        return val_exp;
    }

    FirList makeDataVals(Iterator valit) {
        FirList vals = new FirList(this.fHir);
        while (valit.hasNext()) {
            Node val = (Node)valit.next();
            if (val instanceof Token || val instanceof UnaryNode || val instanceof ComplexConstNode) {
                vals.add(val);
                continue;
            }
            if (val instanceof Pair) {
                HasConstValue v = (HasConstValue)((Object)((Pair)val).getLeft());
                int n = v.getConstValue().intValue();
                while (n-- > 0) {
                    vals.add(((Pair)val).getRight());
                }
                continue;
            }
            this.fHir.printMsgFatal("unknown data type!!!!! : " + val.getClass());
        }
        return vals;
    }

    List makeElemListFromDoList(FirList do_range, Quad do_spec, HashMap env) {
        String do_val = ((Token)do_spec.getLeft()).getLexem();
        int beg = ((HasConstValue)((Object)do_spec.getRight())).getConstValue().intValue();
        int end = ((HasConstValue)((Object)do_spec.getExtra())).getConstValue().intValue();
        int step = do_spec.getLast() == null ? 1 : ((HasConstValue)((Object)do_spec.getLast())).getConstValue().intValue();
        LinkedList<ArrayElement> list = new LinkedList<ArrayElement>();
        for (int i = beg; i <= end; i += step) {
            env.put(do_val, new Integer(i));
            for (Pair p : do_range) {
                if (p.getLeft() instanceof Token) {
                    list.add(new ArrayElement((Token)p.getLeft(), (FirList)p.getRight(), env));
                    continue;
                }
                list.addAll(this.makeElemListFromDoList((FirList)p.getLeft(), (Quad)p.getRight(), (HashMap)env.clone()));
            }
        }
        return list;
    }

    Exp makeArrayInitializeList(VectorType vt, Iterator valit, Map m) {
        int dimsize = vt.getDimension();
        int[] dims = new int[7];
        int[] dimlow = new int[7];
        if (this.fTypeUtil.isFortranCharacterType(this.fTypeUtil.getVectorBaseType(vt))) {
            --dimsize;
        }
        for (int i = 0; i < dimsize; ++i) {
            dims[dimsize - i - 1] = (int)vt.getElemCount();
            dimlow[dimsize - i - 1] = (int)vt.getLowerBound();
            if (!(vt.getElemType() instanceof VectorType)) continue;
            vt = (VectorType)vt.getElemType();
        }
        if (m != null) {
            return this.makeArrayInitializeList_r(dimsize, dims, dimlow, new LinkedList(), m);
        }
        return this.makeArrayInitializeList_r(dimsize, dims, valit);
    }

    Exp makeArrayInitializeList_r(int dim, int[] dimidx, int[] dimlow, LinkedList dims, Map m) {
        if (dim == 0) {
            this.dp("list :" + dims);
            this.dp("map  :" + m.keySet());
            if (m.containsKey(dims)) {
                return (Exp)m.get(dims);
            }
            return this.fHirUtil.makeNullNode();
        }
        LinkedList<Exp> list = new LinkedList<Exp>();
        for (int i = 0; i < dimidx[dim - 1]; ++i) {
            LinkedList l = (LinkedList)dims.clone();
            l.add(new Integer(i + dimlow[dim - 1]));
            list.add(this.makeArrayInitializeList_r(dim - 1, dimidx, dimlow, l, m));
        }
        return new ExpListExpImpl(this.hirRoot, list);
    }

    Exp makeArrayInitializeList_r(int dim, int[] dims, Iterator it) {
        if (dim == 0) {
            Node n = (Node)it.next();
            this.dp("processData#makeArrayInitializeList_r(dim:0): " + n);
            Exp exp = n.makeExp();
            if (exp instanceof FortranCharacterExp) {
                exp = ((FortranCharacterExp)exp).getBody();
                exp = exp.getExp1();
            }
            return exp;
        }
        LinkedList<Exp> list = new LinkedList<Exp>();
        for (int i = 0; i < dims[dim - 1]; ++i) {
            list.add(this.makeArrayInitializeList_r(dim - 1, dims, it));
        }
        return new ExpListExpImpl(this.hirRoot, list);
    }

    ExpListExp mergeArrayInitializeList(ExpListExp el1, ExpListExp el2) {
        LinkedList<Exp> list = new LinkedList<Exp>();
        if (el1.length() != el2.length()) {
            this.dp("mergeArrayInitializeList length mismatch: " + el1.length() + ", " + el2.length());
            return null;
        }
        for (int i = 0; i < el1.length(); ++i) {
            Exp e1 = el1.getExp(i);
            Exp e2 = el2.getExp(i);
            if (e1 instanceof NullNode) {
                e1 = null;
            }
            if (e2 instanceof NullNode) {
                e2 = null;
            }
            if (e1 instanceof ExpListExp) {
                ExpListExp ele = this.mergeArrayInitializeList((ExpListExp)e1, (ExpListExp)e2);
                if (ele == null) {
                    return null;
                }
                list.add(ele);
                continue;
            }
            if (e1 == null && e2 != null) {
                list.add(e2);
                continue;
            }
            if (e1 != null && e2 == null) {
                list.add(e1);
                continue;
            }
            if (e1 == null && e2 == null) {
                list.add(this.fHirUtil.makeNullNode());
                continue;
            }
            return null;
        }
        return new ExpListExpImpl(this.hirRoot, list);
    }

    String exp2str(ExpListExp el) {
        ListIterator it = el.iterator();
        String ret = "(" + el.size() + ")>> ";
        while (it.hasNext()) {
            Exp e = (Exp)it.next();
            ret = ret + e.toString() + ", ";
        }
        return ret;
    }

    void dp(String str) {
        this.fHir.dp(str);
    }

    void settlementArrayInitializeList(ExpListExp elist, Type vt) {
        int len = elist.length();
        for (int i = 0; i < len; ++i) {
            Exp e = elist.getExp(i);
            if (e == null) {
                elist.setExp(i, this.fHirUtil.makeNullNode());
                continue;
            }
            if (!(e instanceof ExpListExp)) continue;
            this.settlementArrayInitializeList((ExpListExp)elist.getExp(i), ((VectorType)vt).getElemType());
        }
        elist.setType(vt);
    }

    class ArrayElement {
        String ident_;
        int[] idx_ = new int[7];
        int dim_;
        Exp val_ = null;

        public ArrayElement(Token ident, FirList dims, Map env) {
            this.ident_ = ident.getLexem();
            Iterator it = dims.iterator();
            this.dim_ = 0;
            while (it.hasNext()) {
                Token idx = (Token)it.next();
                int i = idx.getKind() == 261 ? ((Number)env.get(idx.getLexem())).intValue() : idx.getConstValue().intValue();
                this.idx_[this.dim_++] = i;
            }
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.ident_);
            buff.append("(");
            for (int i = 0; i < this.dim_; ++i) {
                buff.append(Integer.toString(this.idx_[i]));
                buff.append(i + 1 < this.dim_ ? "," : ")");
            }
            if (this.val_ != null) {
                buff.append(" as " + this.val_);
            }
            return buff.toString();
        }

        public void setExp(Exp e) {
            this.val_ = e;
        }

        public Exp getExp() {
            return this.val_;
        }

        public List getDims() {
            LinkedList<Integer> list = new LinkedList<Integer>();
            for (int i = 0; i < this.dim_; ++i) {
                list.add(new Integer(this.idx_[this.dim_ - i - 1]));
            }
            return list;
        }

        public String getLexem() {
            return this.ident_;
        }
    }
}

