/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.ComplexExp;
import coins.ffront.FNumber;
import coins.ffront.FStmt;
import coins.ffront.FirToHir;
import coins.ffront.HasConstValue;
import coins.ffront.Node;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;

public class UnaryNode
implements Node,
HasConstValue {
    FirToHir fHir;
    int op;
    Node exp;

    public UnaryNode(int op, Node pExp, FirToHir pfHir) {
        this.op = op;
        this.exp = pExp;
        this.fHir = pfHir;
    }

    public int getOp() {
        return this.op;
    }

    public Node getExp() {
        return this.exp;
    }

    public void print(int level, String spaces) {
        this.fHir.debugPrint(level, spaces + "unary:" + this.opString() + "\n");
        this.exp.print(level, spaces + "  ");
    }

    public String toString() {
        return "UnaryExp " + this.opString();
    }

    public String opString() {
        switch (this.op) {
            case 16: {
                return "()";
            }
            case 63: {
                return "-";
            }
            case 62: {
                return ".NOT.";
            }
        }
        return "error";
    }

    public Exp makeExp() {
        Exp lExp = this.exp.makeExp();
        HIR hir = this.fHir.getHir();
        if (this.op == 16) {
            return lExp;
        }
        if (this.op == 62) {
            return hir.exp(48, lExp, this.fHir.getHirUtility().makeIntConstNode(1));
        }
        if (lExp instanceof ComplexExp) {
            Exp rexp = ((ComplexExp)lExp).getRealPart();
            Exp iexp = ((ComplexExp)lExp).getImagPart();
            return this.fHir.getHirUtility().makeComplexExpByType(hir.exp(this.op, rexp), hir.exp(this.op, iexp), rexp.getType());
        }
        return hir.exp(this.op, this.exp.makeExp());
    }

    public Exp makeArgAddr(FStmt pCallStmt) {
        return this.fHir.getHirUtility().makeArgAddr(pCallStmt, this.makeExp());
    }

    public FNumber getConstValue() {
        FNumber n = null;
        if (this.exp instanceof HasConstValue && (n = ((HasConstValue)((Object)this.exp)).getConstValue()) != null) {
            switch (this.op) {
                case 16: {
                    return n;
                }
                case 63: {
                    return n.neg();
                }
            }
        }
        return null;
    }
}

