/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.flow.ExpVector;
import coins.flow.ExpVectorImpl;
import coins.flow.FlowAnalSymVector;
import coins.flow.FlowAnalSymVectorIterator;
import coins.flow.FlowAnalSymVectorIteratorImpl;
import coins.flow.SubpFlow;
import coins.flow.SubpFlowImpl;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import coins.sym.Sym;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FlowAnalSymVectorImpl
extends ExpVectorImpl
implements FlowAnalSymVector {
    public FlowAnalSymVectorImpl(SubpFlow pSubpFlow) {
        super(pSubpFlow);
        this.fBitLength = pSubpFlow.getSymExpCount() + 2;
        this.fLongWordLength = this.fBitLength / 64 + 1;
        this.fVectorWord = new long[this.fLongWordLength];
    }

    public SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    public Set flowAnalSyms() {
        HashSet<FlowAnalSym> lFlowAnalSyms = new HashSet<FlowAnalSym>();
        FlowAnalSymVectorIterator lFASVectIt = this.flowAnalSymVectorIterator();
        while (lFASVectIt.hasNext()) {
            FlowAnalSym lFlowAnalSym = lFASVectIt.nextFlowAnalSym();
            if (lFlowAnalSym == null) continue;
            lFlowAnalSyms.add(lFlowAnalSym);
        }
        return lFlowAnalSyms;
    }

    public boolean contains(FlowAnalSym pFlowAnalSym) {
        return this.flowAnalSyms().contains(pFlowAnalSym);
    }

    public boolean remove(FlowAnalSym pFlowAnalSym) {
        int lIndex = pFlowAnalSym.getIndex();
        if (this.isSet(lIndex)) {
            this.resetBit(lIndex);
            return true;
        }
        return false;
    }

    public static FlowAnalSymVector flowAnalSymVectorFromSet(Set pFlowAnalSyms, SubpFlow pSubpFlow) {
        FlowAnalSymVector lFlowAnalSymVect = pSubpFlow.flowAnalSymVector();
        for (FlowAnalSym lNext : pFlowAnalSyms) {
            lFlowAnalSymVect.setBit(lNext.getIndex());
        }
        return lFlowAnalSymVect;
    }

    public FlowAnalSymVectorIterator flowAnalSymVectorIterator() {
        return new FlowAnalSymVectorIteratorImpl(this);
    }

    public boolean addAll(Set pFlowAnalSyms) {
        FlowAnalSymVector lVect = FlowAnalSymVectorImpl.flowAnalSymVectorFromSet(pFlowAnalSyms, this.fSubpFlow);
        FlowAnalSymVector lVectResult = this.fSubpFlow.flowAnalSymVector();
        this.vectorOr(lVect, lVectResult);
        boolean lReturnVal = lVectResult.vectorEqual(this);
        lVectResult.vectorCopy(this);
        return lReturnVal;
    }

    public String toStringDescriptive() {
        StringBuffer lBuff = new StringBuffer();
        ArrayList<FlowAnalSym> lFlowAnalSymList = new ArrayList<FlowAnalSym>(this.fSubpFlow.getSymExpCount());
        FlowAnalSymVectorIterator lIt = this.flowAnalSymVectorIterator();
        while (lIt.hasNext()) {
            FlowAnalSym lFlowAnalSym = lIt.nextFlowAnalSym();
            if (lFlowAnalSym == null) continue;
            lFlowAnalSymList.add(lFlowAnalSym);
        }
        List lFlowAnalSymsSorted = this.fSubpFlow.sortExpIdCollection(lFlowAnalSymList);
        for (FlowAnalSym lFlowAnalSym : lFlowAnalSymsSorted) {
            Sym lSym;
            if (lFlowAnalSym == null) continue;
            lBuff.append(lFlowAnalSym.getName());
            if (lFlowAnalSym instanceof ExpId && (lSym = ((ExpId)lFlowAnalSym).getLinkedSym()) != null) {
                lBuff.append("(" + lSym.getName() + ")");
            }
            lBuff.append(" ");
        }
        return lBuff.toString();
    }

    public String toStringShort() {
        StringBuffer lBuff = new StringBuffer();
        ArrayList<FlowAnalSym> lFlowAnalSymList = new ArrayList<FlowAnalSym>(this.fSubpFlow.getSymExpCount());
        FlowAnalSymVectorIterator lIt = this.flowAnalSymVectorIterator();
        while (lIt.hasNext()) {
            FlowAnalSym lFlowAnalSym = lIt.nextFlowAnalSym();
            if (lFlowAnalSym == null) continue;
            lFlowAnalSymList.add(lFlowAnalSym);
        }
        List lFlowAnalSymsSorted = this.fSubpFlow.sortExpIdCollection(lFlowAnalSymList);
        for (FlowAnalSym lFlowAnalSym : lFlowAnalSymsSorted) {
            if (lFlowAnalSym == null) continue;
            lBuff.append(lFlowAnalSym.toStringShort() + " ");
        }
        return lBuff.toString();
    }

    public ExpVector flowAnalSymToExpVector() {
        ExpVector lExpVector = this.fSubpFlow.expVector();
        FlowAnalSymVectorIterator lIterator = this.flowAnalSymVectorIterator();
        while (lIterator.hasNext()) {
            FlowAnalSym lSym = lIterator.nextFlowAnalSym();
            if (!(lSym instanceof ExpId)) continue;
            lExpVector.setBit(((ExpId)lSym).getIndex());
        }
        if (((SubpFlowImpl)this.fSubpFlow).fDbgLevel > 0) {
            ((SubpFlowImpl)this.fSubpFlow).flow.dbg(4, " flowAnalSymToExpVector", lExpVector.toStringDescriptive());
        }
        return lExpVector;
    }
}

