/*
 * Decompiled with CFR 0.152.
 */
package coins.hir2lir;

import coins.HirRoot;
import coins.IoRoot;
import coins.MachineParam;
import coins.MachineParamSparc;
import coins.Registry;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.CompileThread;
import coins.driver.Trace;
import coins.ir.IrList;
import coins.ir.hir.AsmStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpListExp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.IfStmt;
import coins.ir.hir.InfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.PointedExp;
import coins.ir.hir.Program;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.SymNode;
import coins.ir.hir.VarNode;
import coins.sym.BaseType;
import coins.sym.Const;
import coins.sym.Elem;
import coins.sym.EnumType;
import coins.sym.Label;
import coins.sym.Param;
import coins.sym.PointerType;
import coins.sym.StringConst;
import coins.sym.StructType;
import coins.sym.Subp;
import coins.sym.SubpType;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymNestIterator;
import coins.sym.SymTable;
import coins.sym.SymTableIterator;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VectorType;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ConvToNewLIR {
    private File fSourceFile;
    private PrintStream fOut;
    private HirRoot fHirRoot;
    private int tempCtr = 1;
    private int labelCtr = 1;
    private String returnVarName = null;
    private Type retType;
    private ImList autoSym = null;
    private ImList symtab = null;
    private Map symNumbers = new HashMap();
    private Map pureExterns = new HashMap();
    private Set appearedLabels = new HashSet();
    private MachineParam machineParam;
    private String ptrType;
    private static final String ASM_PARAM = "#param";
    private static final String ASM_CLOBBER = "#clobber";
    private static final String INTCONST = "INTCONST";
    private static final String FLOATCONST = "FLOATCONST";
    private static final String STATIC = "STATIC";
    private static final String FRAME = "FRAME";
    private static final String REG = "REG";
    private static final String SUBREG = "SUBREG";
    private static final String LABEL = "LABEL";
    private static final String NEG = "NEG";
    private static final String ADD = "ADD";
    private static final String SUB = "SUB";
    private static final String MUL = "MUL";
    private static final String DIVS = "DIVS";
    private static final String DIVU = "DIVU";
    private static final String MODS = "MODS";
    private static final String MODU = "MODU";
    private static final String CONVSX = "CONVSX";
    private static final String CONVZX = "CONVZX";
    private static final String CONVIT = "CONVIT";
    private static final String CONVFX = "CONVFX";
    private static final String CONVFT = "CONVFT";
    private static final String CONVFI = "CONVFI";
    private static final String CONVFS = "CONVFS";
    private static final String CONVFU = "CONVFU";
    private static final String CONVSF = "CONVSF";
    private static final String CONVUF = "CONVUF";
    private static final String BAND = "BAND";
    private static final String BOR = "BOR";
    private static final String BXOR = "BXOR";
    private static final String BNOT = "BNOT";
    private static final String LSHS = "LSHS";
    private static final String LSHU = "LSHU";
    private static final String RSHS = "RSHS";
    private static final String RSHU = "RSHU";
    private static final String TSTEQ = "TSTEQ";
    private static final String TSTNE = "TSTNE";
    private static final String TSTLTS = "TSTLTS";
    private static final String TSTLES = "TSTLES";
    private static final String TSTGTS = "TSTGTS";
    private static final String TSTGES = "TSTGES";
    private static final String TSTLTU = "TSTLTU";
    private static final String TSTLEU = "TSTLEU";
    private static final String TSTGTU = "TSTGTU";
    private static final String TSTGEU = "TSTGEU";
    private static final String MEM = "MEM";
    private static final String SET = "SET";
    private static final String JUMP = "JUMP";
    private static final String JUMPC = "JUMPC";
    private static final String JUMPN = "JUMPN";
    private static final String DEFLABEL = "DEFLABEL";
    private static final String CALL = "CALL";
    private static final String PROLOGUE = "PROLOGUE";
    private static final String EPILOGUE = "EPILOGUE";
    private static final String PARALLEL = "PARALLEL";
    private static final String USE = "USE";
    private static final String CLOBBER = "CLOBBER";
    private static final String PHI = "PHI";
    private static final String IF = "IF";
    private static final String LIST = "LIST";
    private static final String SPACE = "SPACE";
    private static final String ZEROS = "ZEROS";
    private static final String LINE = "LINE";
    private static final String INFO = "INFO";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String MODULE = "MODULE";
    private static final String SYMTAB = "SYMTAB";
    private static final String DATA = "DATA";
    private static final String FUNCTION = "FUNCTION";
    private static final String LDEF = "LDEF";
    private static final String XDEF = "XDEF";
    private static final String XREF = "XREF";
    private static final String ASM = "ASM";
    private static final String HIR_PROF = "simulate";
    private static final String LIR_PROF = "SIMULATE";
    private static final String PROF_ON = "profileOn";
    private static final String PROF_OFF = "profileOff";
    private static final String VOLATILE_M = "&V";
    private static final String ALIGN_M = "&align";
    private static final String ARG_M = "&argtype";
    private static final String CLOB_M = "&clobber";
    private static final String BODY_M = "&body";
    private static final String OPTSYM_M = "&syminfo";
    private static final String SYMINFO = "SYMINFO";
    private static final String ID_M = "&id";
    private static final QuotedString CSEG = new QuotedString(".text");
    private static final QuotedString DSEG = new QuotedString(".data");
    private static final QuotedString BSEG = new QuotedString(".bss");
    private static final QuotedString ROSEG = new QuotedString(".rodata");
    private static QuotedString LITERAL_SEG = CSEG;
    private static final String prefLirLabel = "_llab";
    private static final String ZERO = "0";
    private static final QuotedString _EPILOGUE = new QuotedString("_epilogue");
    private static final String PADDING = "ZEROS";
    private static final QuotedString BUILTIN_ALIGN = new QuotedString("__builtin_align");
    private ImList Lseq;
    private ImList Lbody;
    private ImList DZSSeq;
    private boolean returnUsed;
    private int curline = -1;
    private boolean autoString = false;
    private long vectorAssignLen = -1L;
    private long dstVectorLen = -1L;
    private int builtin_align = 0;
    private long regionLoc = 0L;
    private boolean generateLineDefault = false;
    private boolean generateLine = false;
    private boolean generateProfileInfo = false;
    private boolean simulateOption = false;
    private StringConverter strconv;
    private boolean emitRoseg = false;
    private boolean fixIdBug = false;
    private boolean debugUniqFun = false;
    private int debugLevel = 0;
    private boolean supportLabeledNull = true;
    private int memNum = 0;
    private boolean omitUnusedSymbol = true;
    private NumSeq numSeq;
    StructOffset stroff;
    private final ConvContext lvalue_noIfExp = new ConvContext(true, false);
    private final ConvContext lvalue_emitIfExp = new ConvContext(true, true);
    private final ConvContext nonLvalue_noIfExp = new ConvContext(false, false);
    private final ConvContext nonLvalue_emitIfExp;
    private final ConvContext topLevelCc = this.nonLvalue_emitIfExp = new ConvContext(false, true);
    AsmParam no_param = new AsmParam();
    private static QuotedString complexMem = new QuotedString(" _ ");
    public static final int DEFAULT_INDENT_STEP = 2;
    public static final Object[] keywordList = new Object[]{"MODULE", "SYMTAB", "DATA", "FUNCTION", "SET", "JUMP", "JUMPC", "JUMPN", "DEFLABEL", "CALL", "ASM", "PROLOGUE", "EPILOGUE", "PARALLEL", "CLOBBER", "INFO"};
    public static final Object[] tableList = new Object[]{"SYMTAB"};
    public static final Object[] specList = new Object[]{"DEFLABEL", "INFO"};

    private void debug(String s) {
        if (this.debugLevel > 0) {
            System.out.println(s);
        }
    }

    private void bug(String s) {
        System.out.println("bug?:" + s);
    }

    private void badHIR(String s) {
        System.out.println("bad HIR?: " + s);
    }

    private int getAlignment(Sym sym) {
        int align = sym.getSymType().getAlignment();
        if (align <= 0) {
            this.bug("align <= 0: " + sym);
            align = 4;
        }
        return align;
    }

    public ConvToNewLIR(File pSourceFile, OutputStream pOut, HirRoot pHirRoot) {
        this.fSourceFile = pSourceFile;
        this.fOut = new PrintStream(pOut);
        this.fHirRoot = pHirRoot;
        this.strconv = new PlainStringConverter();
        this.debugLevel = this.fHirRoot.ioRoot.dbgToLir.getLevel();
        Thread th = Thread.currentThread();
        if (th instanceof CompileThread) {
            IoRoot io = ((CompileThread)th).getIoRoot();
            this.machineParam = io.machineParam;
            this.ptrType = this.hkind2ltype(22);
            CompileSpecification spec = io.getCompileSpecification();
            CoinsOptions coinsOptions = spec.getCoinsOptions();
            if (coinsOptions.isSet("debuginfo") || coinsOptions.isSet(HIR_PROF)) {
                this.generateLine = this.generateLineDefault = true;
                if (coinsOptions.isSet(HIR_PROF)) {
                    this.simulateOption = true;
                }
            } else {
                this.debug("coins:debuginfo is not set");
            }
            SymTable rootSymTab = io.symRoot.symTableRoot;
            rootSymTab.setUniqueNameToAllSym();
            if (coinsOptions.getArg("target-arch").equals("mb")) {
                this.emitRoseg = true;
                LITERAL_SEG = ROSEG;
            }
        } else {
            this.machineParam = new MachineParamSparc(this.fHirRoot.ioRoot);
        }
    }

    private ImList reverse(ImList l) {
        return l.destructiveReverse();
    }

    private QuotedString quote(String s) {
        return new QuotedString(s);
    }

    private QuotedString uniqName(Sym pSym) {
        int varnum;
        if (pSym == null) {
            return this.quote("bug: uniqName(null)");
        }
        if (this.isRewrite(pSym) && (varnum = this.getSymNum(pSym)) != 0) {
            return this.quote(pSym.getName() + "." + varnum);
        }
        return this.quote(pSym.getName());
    }

    private String uniqStrName(int pNum, String pName) {
        return pName + "." + pNum;
    }

    private Object car(Object l) {
        return ((ImList)l).elem();
    }

    private Object cdr(Object l) {
        return ((ImList)l).next();
    }

    private ImList prefix(Object x, ImList y) {
        return new ImList(x, y);
    }

    private ImList prefix(Object x, Object y, ImList z) {
        return new ImList(x, new ImList(y, z));
    }

    private ImList prefix(Object x, Object y, Object z, ImList w) {
        return new ImList(x, new ImList(y, new ImList(z, w)));
    }

    private ImList prefix(Object x, Object y, Object z, Object w, ImList u) {
        return new ImList(x, new ImList(y, new ImList(z, new ImList(w, u))));
    }

    private ImList prefix(Object x, Object y, Object z, Object w, Object u, ImList v) {
        return new ImList(x, new ImList(y, new ImList(z, new ImList(w, new ImList(u, v)))));
    }

    private ImList list(Object x) {
        return new ImList(x, ImList.Empty);
    }

    private ImList list(Object x, Object y) {
        return new ImList(x, new ImList(y, ImList.Empty));
    }

    private ImList list(Object x, Object y, Object z) {
        return new ImList(x, new ImList(y, new ImList(z, ImList.Empty)));
    }

    private ImList list(Object x, Object y, Object z, Object w) {
        return new ImList(x, new ImList(y, new ImList(z, new ImList(w, ImList.Empty))));
    }

    private ImList list(Object x, Object y, Object z, Object w, Object u) {
        return new ImList(x, new ImList(y, new ImList(z, new ImList(w, new ImList(u, ImList.Empty)))));
    }

    private ImList list(Object x, Object y, Object z, Object w, Object u, Object v) {
        return new ImList(x, new ImList(y, new ImList(z, new ImList(w, new ImList(u, new ImList(v, ImList.Empty))))));
    }

    private void addLexp(ImList s) {
        if (s != null) {
            this.Lseq = new ImList(s, this.Lseq);
        }
    }

    private void addProfInfo(ImList s) {
        if (this.simulateOption && s != null) {
            this.Lseq = new ImList(s, this.Lseq);
        }
    }

    private void addLexpAfterInfo(ImList s) {
        this.addLexp(s);
        ImList t = this.list(s, this.list(LINE, String.valueOf(this.curline)));
        this.addProfInfo(new ImList(INFO, t));
    }

    private void addLexpBeforeInfo(ImList s) {
        ImList t = this.list(s, this.list(LINE, String.valueOf(this.curline)));
        this.addProfInfo(new ImList(INFO, t));
        this.addLexp(s);
    }

    private void addLbody(ImList s) {
        if (s != null) {
            this.Lbody = new ImList(s, this.Lbody);
        }
    }

    private boolean isConstZero(HIR exp) {
        if (!(exp instanceof ConstNode)) {
            return false;
        }
        Const c = ((ConstNode)exp).getConstSym();
        return exp.getType().isFloating() && c.doubleValue() == 0.0 || !exp.getType().isFloating() && c.longValue() == 0L;
    }

    private boolean isScalerType(Type ty) {
        return ty instanceof BaseType || ty instanceof PointerType || ty instanceof EnumType;
    }

    private boolean isStrunion(Type ty) {
        return ty instanceof StructType || ty instanceof UnionType;
    }

    private boolean isLiteral(HIR pHir) {
        Const sym;
        return pHir.getOperator() == 5 && (sym = ((ConstNode)pHir).getConstSym()).getSymKind() == 6;
    }

    public ImList doConvert(HIR pProg) {
        IoRoot io;
        CompileSpecification spec;
        Trace trace;
        Sym sym;
        Object tmp;
        ImList root = ImList.Empty;
        this.symtab = ImList.Empty;
        this.Lbody = ImList.Empty;
        SymTableIterator stab_it = ((Program)pProg).getSymTable().getSymTableIterator();
        boolean isTop = true;
        if (this.debugUniqFun) {
            System.out.println("\n*** numbering all symbols");
        }
        while (stab_it.hasNext()) {
            SymTable stab = stab_it.next();
            if (this.debugUniqFun) {
                System.out.println("        ---- " + stab);
            }
            SymIterator symit2 = stab.getSymIterator();
            while (symit2.hasNext()) {
                Sym sym2 = symit2.next();
                if (this.isLirSym(sym2)) {
                    this.bug("already installed: " + sym2);
                }
                if (sym2.getSymKind() == 10) {
                    this.install(sym2);
                    this.needNotInit(sym2);
                    this.keepName(sym2);
                    this.setUsed(sym2);
                    if (this.debugUniqFun) {
                        System.out.println("    + " + sym2 + " -> " + this.uniqName(sym2));
                    }
                }
                if (sym2.getSymKind() == 12 || sym2.getSymKind() == 8) {
                    this.install(sym2);
                    if (sym2.getSymKind() == 12) {
                        this.needNotInit(sym2);
                    }
                    int v = 4;
                    if (sym2 instanceof Subp) {
                        v = ((Subp)sym2).getVisibility();
                    } else if (sym2 instanceof Var) {
                        v = ((Var)sym2).getVisibility();
                    } else {
                        this.badHIR("neither Subp nor Var: " + sym2);
                    }
                    switch (v) {
                        case 2: 
                        case 5: {
                            this.keepName(sym2);
                            break;
                        }
                        case 1: {
                            this.keepName(sym2);
                            if (this.pureExterns.get(sym2.getName()) != null) break;
                            this.pureExterns.put(sym2.getName(), "");
                            this.needNotInit(sym2);
                            this.resetUsed(sym2);
                            break;
                        }
                        case 4: {
                            if (isTop) {
                                this.keepName(sym2);
                                break;
                            }
                            this.uniqSym(sym2);
                            break;
                        }
                        default: {
                            this.uniqSym(sym2);
                        }
                    }
                    this.numbering(sym2);
                    if (!this.debugUniqFun) continue;
                    System.out.println("    + " + sym2 + " -> " + this.uniqName(sym2));
                    continue;
                }
                if (sym2.getSymKind() != 9) continue;
                this.install(sym2);
                this.uniqSym(sym2);
                this.needNotInit(sym2);
                this.numbering(sym2);
                if (!this.debugUniqFun) continue;
                System.out.println("    + " + sym2 + " -> " + this.uniqName(sym2));
            }
            isTop = false;
        }
        ListIterator subpit = ((Program)pProg).getSubpDefinitionList().iterator();
        while (subpit.hasNext()) {
            SubpDefinition subp = (SubpDefinition)subpit.next();
            tmp = this.convertSubpDef(subp);
            if (this.generateLine) {
                if (subp.getChild1() == null) {
                    this.badHIR("SubpDefinition.getChild1() returns null. " + subp.toStringDetail());
                } else {
                    sym = ((SymNode)subp.getChild1()).getSymNodeSym();
                    if (sym.getDefinedFile() != null) {
                        this.addLbody(this.list(INFO, LINE, String.valueOf(sym.getDefinedLine())));
                    }
                }
            }
            this.addLbody((ImList)tmp);
            BlockStmt initPart = subp.getInitiationPart();
            if (initPart == null || !(initPart instanceof BlockStmt)) continue;
            Stmt st = initPart.getFirstStmt();
            this.convertNode(st, this.topLevelCc);
        }
        HIR initPart = (HIR)((Program)pProg).getInitiationPart();
        if (initPart != null && initPart instanceof BlockStmt && (tmp = ((BlockStmt)initPart).getFirstStmt()) != null) {
            this.addLbody(this.convertNode((HIR)tmp, this.topLevelCc));
        }
        Collection view = this.symNumbers.values();
        Iterator it = view.iterator();
        while (it.hasNext()) {
            sym = ((SymStat)it.next()).getSym();
            if (this.isGenInit(sym)) continue;
            this.lineInfo(sym);
            String size = String.valueOf(sym.getSymType().getSizeValue());
            ImList tmp2 = this.list(DATA, this.uniqName(sym), this.list(SPACE, size));
            this.addLbody(tmp2);
            this.needNotInit(sym);
        }
        if (this.debugUniqFun) {
            System.out.println("\n*** global symbol table");
            ((Program)pProg).getSymTable().printSymTableDetail();
        }
        SymIterator symit = ((Program)pProg).getSymTable().getSymIterator();
        block22: while (symit.hasNext()) {
            QuotedString segment;
            Sym sym3 = symit.next();
            if (this.omitUnusedSymbol && !this.isUsed(sym3)) {
                this.debug("          " + sym3 + " is not used.");
                continue;
            }
            switch (sym3.getSymKind()) {
                case 8: {
                    if (!(sym3 instanceof Var) || ((Var)sym3).getStorageClass() != 6) {
                        this.bug("non-static global is not supported in LIR: " + sym3);
                    }
                    if (this.emitRoseg && ((Var)sym3).getSymType().isConst()) {
                        segment = ROSEG;
                        break;
                    }
                    segment = DSEG;
                    break;
                }
                case 12: {
                    segment = CSEG;
                    break;
                }
                default: {
                    continue block22;
                }
            }
            String linkage = null;
            boolean publicVar = false;
            if (sym3 instanceof Var) {
                switch (((Var)sym3).getVisibility()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        linkage = ((Var)sym3).getVisibility() == 2 ? XDEF : LDEF;
                        if (((Var)sym3).getInitialValue() == null) {
                            segment = BSEG;
                            break;
                        }
                        if (this.emitRoseg && ((Var)sym3).getSymType().isConst()) {
                            segment = ROSEG;
                            break;
                        }
                        segment = DSEG;
                        break;
                    }
                    case 1: {
                        linkage = XREF;
                        if (this.pureExterns.get(sym3.getName()) != null) break;
                        this.pureExterns.put(sym3.getName(), "");
                    }
                }
            } else if (sym3 instanceof Subp) {
                switch (((Subp)sym3).getVisibility()) {
                    case 2: {
                        linkage = XDEF;
                        break;
                    }
                    case 1: {
                        linkage = XREF;
                        if (this.pureExterns.get(sym3.getName()) == null) {
                            this.pureExterns.put(sym3.getName(), "");
                        }
                        this.needNotInit(sym3);
                        break;
                    }
                    case 4: 
                    case 5: {
                        linkage = LDEF;
                    }
                }
            }
            if (linkage == null) {
                this.badHIR("invalid storage class or linkage of global symbol (treat as LDEF): " + sym3);
                linkage = LDEF;
            }
            ImList tmp3 = this.staticEnt(sym3, segment, linkage);
            this.symtab = new ImList(tmp3, this.symtab);
            this.setLirSym(sym3);
        }
        if (this.symtab != ImList.Empty) {
            this.symtab = new ImList(SYMTAB, this.symtab);
        }
        ImList subs = this.reverse(this.Lbody);
        if (this.symtab != ImList.Empty) {
            subs = this.prefix(this.symtab, subs);
        }
        root = this.prefix(MODULE, this.quote(this.fSourceFile.getName()), subs);
        Thread th = Thread.currentThread();
        if (th instanceof CompileThread && (trace = (spec = (io = ((CompileThread)th).getIoRoot()).getCompileSpecification()).getTrace()).shouldTrace("LIR", 1)) {
            System.out.println("\n\nAfter HIR to LIR:");
            ImPrinter printer = new ImPrinter(new PrintWriter(System.out));
            printer.print(root);
        }
        return root;
    }

    private Sym subpSymbol(SubpDefinition pSubp) {
        for (HIR p = pSubp; p != null; p = (HIR)p.getParent()) {
            if (p.getOperator() != 2) continue;
            return p.getSubpSym();
        }
        return null;
    }

    private ImList convertSubpDef(SubpDefinition pSubp) {
        Subp funSym = (Subp)this.subpSymbol(pSubp);
        this.retType = ((SubpType)funSym.getSymType()).getReturnType();
        this.generateProfileInfo = false;
        if (this.debugUniqFun) {
            System.out.println("");
            System.out.println("*** local symbol table of subp " + funSym);
            pSubp.getSymTable().printSymTableDetail();
            System.out.println("");
        }
        SymNestIterator symit = pSubp.getSymTable().getSymNestIterator();
        while (symit.hasNext()) {
            ImList tmpsym;
            Sym sym = symit.next();
            if (this.isLirSym(sym) || (tmpsym = this.symEnt("", sym)) == null) continue;
            this.symtab = this.prefix(tmpsym, this.symtab);
        }
        SymTableIterator stab_it = pSubp.getSymTable().getSymTableIterator();
        this.autoSym = ImList.Empty;
        while (stab_it.hasNext()) {
            SymTable stab = stab_it.next();
            Sym owner = stab.getOwner();
            if (this.debugUniqFun) {
                System.out.println("");
                System.out.println("*** local symbol table of " + owner);
                stab.printSymTableDetail();
                System.out.println("");
            }
            if (owner instanceof Subp && owner != funSym) break;
            SymIterator symit2 = stab.getSymIterator();
            block5: while (symit2.hasNext()) {
                Sym sym = symit2.next();
                switch (sym.getSymKind()) {
                    case 8: 
                    case 9: {
                        if (((Var)sym).getStorageClass() != 7 && ((Var)sym).getStorageClass() != 8) continue block5;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                ImList tmp = this.autoEnt(sym);
                this.autoSym = this.prefix(tmp, this.autoSym);
                this.needNotInit(sym);
            }
        }
        this.returnVarName = null;
        if (this.retType.getTypeKind() != 15) {
            this.returnVarName = this.uniqStrName(this.tempCtr++, "returnvalue");
            ImList tmp = this.frameEnt(this.returnVarName, this.htype2ltype(this.retType), String.valueOf(this.retType.getAlignment()), ZERO);
            this.autoSym = this.prefix(tmp, this.autoSym);
        }
        this.Lseq = ImList.Empty;
        ImList prologue = ImList.Empty;
        HIR pHir = pSubp.getHirBody();
        if ((pHir = (HIR)pHir.getChild2()).getOperator() == 35 && (pHir = (HIR)pHir.getChild1()) != null && pHir.getOperator() == 4 && ((InfStmt)pHir).getInfKind() == HIR_PROF && this.simulateOption) {
            this.addLexp(this.convertInfo(pHir));
        }
        if (funSym.getParamList() == null) {
            this.badHIR("getParamList() returns null");
        } else {
            Param param;
            ListIterator params = funSym.getParamList().iterator();
            while (params.hasNext() && (param = (Param)params.next()) != null) {
                Type parType = param.getSymType();
                ImList tmp = param instanceof SymNode && this.isReg(((SymNode)((Object)param)).getSymNodeSym()) ? this.list(REG, this.htype2ltype(param.getSymType()), this.uniqName(param)) : this.memExp(this.htype2ltype(parType), this.frameExp((Object)this.hkind2ltype(22), this.uniqName(param)), false, this.getAggregateAlign(parType), this.uniqName(param));
                prologue = this.prefix(tmp, prologue);
            }
        }
        this.addProfInfo(this.list(INFO, "BEGIN", PROLOGUE));
        prologue = this.prefix(PROLOGUE, this.list(ZERO, ZERO), prologue.destructiveReverse());
        this.addLexp(prologue);
        this.addProfInfo(this.list(INFO, "END", PROLOGUE));
        this.returnUsed = false;
        this.convertNode(pSubp.getHirBody(), this.topLevelCc);
        ImList epilogue = ImList.Empty;
        this.addLexp(this.list(DEFLABEL, _EPILOGUE));
        if (this.retType.getTypeKind() != 15 && this.returnUsed) {
            epilogue = this.list(this.memExp(this.htype2ltype(this.retType), this.frameExp((Object)this.hkind2ltype(22), this.returnVarName), false, this.getAggregateAlign(this.retType), this.quote(this.returnVarName)));
        }
        epilogue = this.prefix(EPILOGUE, this.list(ZERO, ZERO), epilogue);
        this.addLexp(epilogue);
        if (this.autoSym != ImList.Empty) {
            this.autoSym = this.reverse(this.autoSym);
            this.autoSym = this.prefix(SYMTAB, this.autoSym);
        }
        ImList body = this.reverse(this.Lseq);
        if (this.autoSym != ImList.Empty) {
            body = this.prefix(this.autoSym, body);
        }
        this.needNotInit(funSym);
        return this.prefix(FUNCTION, this.uniqName(funSym), body);
    }

    private ImList convertNode(HIR pHir, ConvContext cc) {
        ImList tmp = this.convertNode1(pHir, cc.nonLvalue());
        return tmp;
    }

    private ImList convertLvalue(HIR pHir, ConvContext cc) {
        return this.convertNode1(pHir, cc.lvalue());
    }

    private ImList convertAddress(HIR pHir, ConvContext cc) {
        ImList tmp = this.convertNode1(pHir, cc.lvalue());
        this.debug("lval: " + tmp);
        switch (pHir.getOperator()) {
            case 33: {
                if (this.car(tmp) != MEM) break;
                tmp = (ImList)this.car(this.cdr(this.cdr(tmp)));
                this.debug(" -> " + tmp);
            }
        }
        return tmp;
    }

    private ImList convertInfo(HIR pHir) {
        InfStmt inf = (InfStmt)pHir;
        String key = inf.getInfKind();
        if (key == HIR_PROF && !this.simulateOption) {
            return null;
        }
        ListIterator it = null;
        try {
            IrList infs = inf.getInfList(key);
            it = infs.iterator();
        }
        catch (Exception e) {
            // empty catch block
        }
        ImList l = null;
        if (key == HIR_PROF) {
            if (it == null) {
                this.bug("bad prof");
                return null;
            }
            String val = (String)it.next();
            l = this.list(INFO, LIR_PROF, val);
            if (val == PROF_ON) {
                this.generateProfileInfo = true;
                this.generateLine = true;
            } else if (val == PROF_OFF) {
                this.generateProfileInfo = false;
                this.generateLine = this.generateLineDefault;
            } else {
                l = this.list(INFO, LIR_PROF, val);
            }
            return l;
        }
        l = this.list(key, INFO);
        while (it.hasNext()) {
            Object tmp = it.next();
            if (tmp instanceof Sym) {
                Sym sym = (Sym)tmp;
                if (sym.getSymKind() == 14) {
                    l = new ImList(sym.getName(), l);
                    continue;
                }
                l = new ImList(this.uniqName(sym), l);
                continue;
            }
            if (!(tmp instanceof String)) continue;
            l = new ImList(tmp, l);
        }
        l = l.destructiveReverse();
        return l;
    }

    private ImList convertNode1(HIR pHir, ConvContext cc) {
        ImList result = ImList.Empty;
        while (pHir != null) {
            Type type = pHir.getType();
            String ltype = this.htype2ltype(type);
            boolean isVolatile = type.isVolatile();
            block0 : switch (pHir.getOperator()) {
                case 4: {
                    InfStmt inf = (InfStmt)pHir;
                    String key = inf.getInfKind().intern();
                    for (int i1 = 0; i1 < Registry.INF_KIND.length; ++i1) {
                        if (key != Registry.INF_KIND[i1]) continue;
                        this.addLexp(this.convertInfo(pHir));
                        break block0;
                    }
                    break;
                }
                case 7: 
                case 8: {
                    Sym sym = ((SymNode)pHir).getSymNodeSym();
                    this.setUsed(sym);
                    if (cc.isLvalue()) {
                        if (this.isReg(sym)) {
                            result = this.list(REG, this.htype2ltype(sym.getSymType()), this.uniqName(sym));
                            return result;
                        }
                        String store = ((Var)sym).getStorageClass() == 6 ? STATIC : FRAME;
                        result = this.list(store, this.hkind2ltype(22), this.uniqName(sym));
                    } else {
                        ImList tmp = this.convertLvalue(pHir, cc);
                        if (this.isReg(sym)) {
                            return tmp;
                        }
                        if (this.vectorAssignLen > 0L) {
                            ltype = this.size2ltype(this.vectorAssignLen);
                            this.vectorAssignLen = -1L;
                        }
                        result = this.memExp(ltype, tmp, isVolatile, this.getAggregateAlign(type), this.optId(tmp));
                    }
                    return result;
                }
                case 9: {
                    Sym sym = ((SymNode)pHir).getSymNodeSym();
                    this.setUsed(sym);
                    result = this.staticExp(this.uniqName(sym));
                    return result;
                }
                case 5: {
                    Const sym = ((ConstNode)pHir).getConstSym();
                    if (sym.getSymKind() == 6) {
                        if (cc.isLvalue() || this.autoString) {
                            int varnum = this.getSymNum(sym);
                            if (varnum == 0) {
                                this.installSpecial(sym);
                                ImList tmp = this.staticEntString(sym);
                                this.symtab = new ImList(tmp, this.symtab);
                                this.debug("add: " + tmp + " = " + ((StringConst)sym).getStringBody());
                                if (this.dstVectorLen > 0L) {
                                    this.addLbody(this.strConst(this.stringName(sym), ((StringConst)sym).getStringBody()));
                                    this.dstVectorLen = -1L;
                                    this.vectorAssignLen = -1L;
                                } else {
                                    this.addLbody(this.strConst(this.stringName(sym), ((StringConst)sym).getStringBody()));
                                }
                                this.needNotInit(sym);
                            }
                            result = this.staticExp(this.stringName(sym));
                            if (!cc.isLvalue()) {
                                result = this.memExp(this.htype2ltype(pHir.getType()), result);
                            }
                        } else {
                            String s = ((ConstNode)pHir).getConstSym().getName();
                            long len = 0L;
                            if (sym.getSymType() instanceof VectorType) {
                                len = ((VectorType)sym.getSymType()).getElemCount();
                                if (len <= 0L) {
                                    this.badHIR("literal length <= 0\n");
                                }
                            } else {
                                len = s.length() - 2;
                            }
                            result = this.charSeq(s.substring(1, s.length() - 1), len);
                        }
                    } else {
                        result = type.isFloating() ? this.floatConst((Object)ltype, ((ConstNode)pHir).getConstSym().doubleValue()) : this.intConst((Object)ltype, ((ConstNode)pHir).getConstSym().longValue());
                    }
                    return result;
                }
                case 38: {
                    return this.convertBinop(pHir, ADD, cc);
                }
                case 39: {
                    return this.convertBinop(pHir, SUB, cc);
                }
                case 41: {
                    return this.convertBinop(pHir, MUL, cc);
                }
                case 42: {
                    return this.convertBinop(pHir, type.isUnsigned() ? DIVU : DIVS, cc);
                }
                case 43: {
                    return this.convertBinop(pHir, type.isUnsigned() ? MODU : MODS, cc);
                }
                case 63: {
                    return this.convertUnaop(pHir, NEG, cc);
                }
                case 62: {
                    ImList bnot = this.convertUnaop(pHir, BNOT, cc);
                    Type ty = pHir.getType();
                    if (ty.getTypeKind() != 1) {
                        return bnot;
                    }
                    ImList lnot = this.list(BAND, this.htype2ltype(ty), bnot, this.intConst((Object)this.htype2ltype(ty), 1L));
                    return lnot;
                }
                case 46: {
                    return this.convertBinop(pHir, BAND, cc);
                }
                case 47: {
                    return this.convertBinop(pHir, BOR, cc);
                }
                case 48: {
                    return this.convertBinop(pHir, BXOR, cc);
                }
                case 59: {
                    return this.convertBinop(pHir, RSHS, cc);
                }
                case 58: {
                    return this.convertBinop(pHir, LSHU, cc);
                }
                case 60: {
                    return this.convertBinop(pHir, RSHU, cc);
                }
                case 51: {
                    return this.convertCmp(pHir, TSTEQ, cc);
                }
                case 52: {
                    return this.convertCmp(pHir, TSTNE, cc);
                }
                case 53: {
                    return this.convertCmp(pHir, ((HIR)pHir.getChild1()).getType().isUnsigned() ? TSTGTU : TSTGTS, cc);
                }
                case 54: {
                    return this.convertCmp(pHir, ((HIR)pHir.getChild1()).getType().isUnsigned() ? TSTGEU : TSTGES, cc);
                }
                case 55: {
                    return this.convertCmp(pHir, ((HIR)pHir.getChild1()).getType().isUnsigned() ? TSTLTU : TSTLTS, cc);
                }
                case 56: {
                    return this.convertCmp(pHir, ((HIR)pHir.getChild1()).getType().isUnsigned() ? TSTLEU : TSTLES, cc);
                }
                case 65: {
                    long d;
                    Type srcType = ((HIR)pHir.getChild1()).getType();
                    result = srcType.isFloating() ? (type.isFloating() ? (srcType.getSizeValue() > type.getSizeValue() ? this.convertUnaop(pHir, CONVFT, cc) : this.convertUnaop(pHir, CONVFX, cc)) : (type.isUnsigned() ? this.convertUnaop(pHir, CONVFU, cc) : this.convertUnaop(pHir, CONVFS, cc))) : (type.isFloating() ? (srcType.isUnsigned() ? this.convertUnaop(pHir, CONVUF, cc) : this.convertUnaop(pHir, CONVSF, cc)) : ((d = type.getSizeValue() - srcType.getSizeValue()) > 0L ? (srcType.isUnsigned() ? this.convertUnaop(pHir, CONVZX, cc) : this.convertUnaop(pHir, CONVSX, cc)) : (d < 0L ? this.convertUnaop(pHir, CONVIT, cc) : this.convertNode((HIR)pHir.getChild1(), cc))));
                    return result;
                }
                case 68: {
                    if (this.builtin_align != 0) {
                        this.badHIR("nested __builtin_align() is not supported. (ignored)");
                    }
                    this.builtin_align = 0;
                    if (cc.isLvalue()) {
                        result = this.convertNode((HIR)pHir.getChild1(), cc);
                    } else {
                        ImList tmp = this.convertNode((HIR)pHir.getChild1(), cc);
                        if (this.builtin_align != 0) {
                            result = this.memExp(ltype, tmp, isVolatile, this.builtin_align, this.optId(tmp));
                            this.builtin_align = 0;
                        } else {
                            result = this.memExp(ltype, tmp, isVolatile, this.getAggregateAlign(type), this.optId(tmp));
                        }
                    }
                    return result;
                }
                case 17: {
                    ImList l = this.convertLvalue((HIR)pHir.getChild1(), cc);
                    ImList r = this.convertNode((HIR)pHir.getChild2(), cc);
                    ImList baseExp = null;
                    Type v = null;
                    long scale = 1L;
                    if (pHir.getChild1() instanceof Exp) {
                        v = ((Exp)pHir.getChild1()).getType();
                        if (v instanceof VectorType) {
                            VectorType vt = (VectorType)v;
                            Exp lowerBound = vt.getLowerBoundExp();
                            if (lowerBound != null) {
                                baseExp = lowerBound instanceof ConstNode && ((ConstNode)lowerBound).getIntValue() == 0 ? null : this.convertNode(lowerBound, cc);
                            } else {
                                this.badHIR("getLowerBoundExp() returns null, treat as 0. " + vt);
                                baseExp = null;
                            }
                            this.debug("lower exp " + baseExp);
                        } else {
                            this.badHIR("operand of op_sub node must be vector. " + v);
                        }
                    } else if (pHir.getChild1() instanceof VarNode) {
                        v = ((VarNode)pHir.getChild1()).getSymNodeSym().getSymType();
                    } else if (pHir.getChild1() instanceof ConstNode) {
                        v = ((ConstNode)pHir.getChild1()).getConstSym().getSymType();
                    } else {
                        System.out.println("front bug ? " + pHir.getChild1());
                    }
                    if (baseExp != null) {
                        r = this.list(SUB, this.hkind2ltype(22), r, baseExp);
                    }
                    if (v instanceof VectorType) {
                        scale = ((VectorType)v).getElemType().getSizeValue();
                    } else {
                        this.badHIR("front bug ?");
                    }
                    if (scale != 1L) {
                        if (scale == 0L) {
                            this.badHIR("getSizeValue() returns 0 in op_subs's operand. (cannot calculate correct address) " + v);
                        } else if (scale > 0L) {
                            r = this.list(MUL, this.hkind2ltype(22), r, this.intConst((Object)this.hkind2ltype(22), scale));
                        } else {
                            ImList scaleExp = this.convertNode(((VectorType)v).getElemType().getSizeExp(), cc);
                            this.debug("scale < 0, sizeExp: " + scaleExp);
                            r = this.list(MUL, this.hkind2ltype(22), r, scaleExp);
                        }
                    }
                    result = this.address(l, r);
                    if (this.vectorAssignLen > 0L) {
                        ltype = this.size2ltype(this.vectorAssignLen);
                        this.vectorAssignLen = -1L;
                        this.dstVectorLen = -1L;
                    }
                    result = cc.isLvalue() ? result : this.memExp(ltype, result, isVolatile, this.getAggregateAlign(type), complexMem);
                    return result;
                }
                case 64: 
                case 66: {
                    return this.convertLvalue((HIR)pHir.getChild1(), cc);
                }
                case 67: {
                    if (!cc.isLvalue()) {
                        return null;
                    }
                    return this.convertNode((HIR)pHir.getChild1(), cc);
                }
                case 19: {
                    return this.convertLoadMember(this.convertAddress(((QualifiedExp)pHir).getQualifierExp(), cc), ((QualifiedExp)pHir).getQualifiedElem(), type, cc);
                }
                case 20: {
                    return this.convertLoadMember(this.convertNode(((PointedExp)pHir).getPointerExp(), cc), ((PointedExp)pHir).getPointedElem(), type, cc);
                }
                case 33: {
                    boolean needFuncval = true;
                    String functionVarName = null;
                    if (type.getTypeKind() != 15) {
                        if (pHir.getParent().getOperator() == 22) {
                            this.debug("parent is assign, delete tmp-copy");
                            needFuncval = false;
                        } else {
                            functionVarName = this.uniqStrName(this.tempCtr++, "functionvalue");
                            this.debug("parent is not assign, generate " + functionVarName);
                            this.autoSym = this.prefix(this.frameEnt(functionVarName, ltype, String.valueOf(type.getAlignment()), ZERO), this.autoSym);
                        }
                    }
                    FunctionExp exp = (FunctionExp)pHir;
                    ListIterator params = exp.getParamList().iterator();
                    ImList callee = this.convertNode(exp.getFunctionSpec(), cc);
                    if (this.car(callee) == STATIC && BUILTIN_ALIGN.equals(this.car(this.cdr(this.cdr(callee))))) {
                        return this.convert_builtin_align(params, cc);
                    }
                    ImList paramList = ImList.Empty;
                    while (params.hasNext()) {
                        paramList = new ImList(this.convertNode((HIR)params.next(), cc), paramList);
                    }
                    paramList = this.reverse(paramList);
                    ImList out = null;
                    if (type.getTypeKind() != 15) {
                        result = needFuncval ? this.memExp(ltype, this.frameExp((Object)this.hkind2ltype(22), functionVarName), false, -1, this.quote(functionVarName)) : this.convertNode((HIR)pHir.getParent().getChild1(), cc);
                        out = this.list(result);
                    } else {
                        out = result = ImList.Empty;
                    }
                    ImList opt = ImList.Empty;
                    if (this.simulateOption || this.generateLine) {
                        Object target = this.car(callee);
                        if (target == STATIC) {
                            Object id = this.car(this.cdr(this.cdr(callee)));
                            if (id instanceof QuotedString) {
                                opt = this.list(ID_M, this.list(id, String.valueOf(this.memNum++)));
                            } else {
                                this.bug("bad STATIC: " + callee);
                                opt = this.list(ID_M, String.valueOf(this.memNum++));
                            }
                        } else {
                            opt = this.list(ID_M, String.valueOf(this.memNum++));
                        }
                    }
                    this.addProfInfo(this.list(INFO, "BEGIN", CALL));
                    this.addLexp(this.prefix(CALL, callee, paramList, out, opt));
                    this.addProfInfo(this.list(INFO, "END", CALL));
                    return needFuncval ? result : null;
                }
                case 22: {
                    ImList tmp;
                    ImList r;
                    this.lineInfo(pHir);
                    this.autoString = true;
                    VectorType v = null;
                    if (pHir.getType() instanceof VectorType) {
                        v = (VectorType)pHir.getType();
                        this.vectorAssignLen = v.getElemCount();
                        VectorType dstType = (VectorType)((HIR)pHir.getChild1()).getType();
                        this.dstVectorLen = dstType.getElemCount();
                        if (this.vectorAssignLen <= 0L || this.dstVectorLen <= 0L) {
                            System.out.println("op_assign: length <= 0 (not supported)\n");
                        }
                    }
                    if ((r = this.convertNode((HIR)pHir.getChild2(), cc)) == null) break;
                    HIR lhs = (HIR)pHir.getChild1();
                    switch (lhs.getOperator()) {
                        case 19: {
                            tmp = this.convertStoreMember(this.convertAddress(((QualifiedExp)lhs).getQualifierExp(), cc), ((QualifiedExp)lhs).getQualifiedElem(), type, r, cc);
                            break;
                        }
                        case 20: {
                            tmp = this.convertStoreMember(this.convertNode(((PointedExp)lhs).getPointerExp(), cc), ((PointedExp)lhs).getPointedElem(), type, r, cc);
                            break;
                        }
                        default: {
                            ImList l = this.convertNode((HIR)pHir.getChild1(), cc);
                            tmp = this.list(SET, this.htype2ltype(pHir.getType()), l, r);
                        }
                    }
                    this.addLexp(tmp);
                    break;
                }
                case 35: {
                    this.lineInfo(pHir);
                    this.lineInfo(((BlockStmt)pHir).getFirstStmt());
                    this.regionLoc = 0L;
                    this.addLexp(this.convertNode(((BlockStmt)pHir).getFirstStmt(), cc));
                    this.regionLoc = 0L;
                    break;
                }
                case 34: {
                    this.lineInfo(pHir);
                    if (this.returnVarName != null) {
                        ImList tmp;
                        if (ltype.equals(UNKNOWN)) {
                            ltype = this.hkind2ltype(4);
                        }
                        if (!type.equals(this.retType)) {
                            this.badHIR("type mismatch in " + pHir + " (" + type + " != " + this.retType + ", -> treat as " + this.retType + ")");
                            ltype = this.htype2ltype(this.retType);
                        }
                        if ((tmp = this.convertNode(((ReturnStmt)pHir).getReturnValue(), cc)) != null) {
                            this.addLexp(this.list(SET, ltype, this.memExp(ltype, this.frameExp((Object)this.hkind2ltype(22), this.returnVarName), false, this.getAggregateAlign(type), this.quote(this.returnVarName)), tmp));
                            this.returnUsed = true;
                        }
                    }
                    this.addLexpBeforeInfo(this.list(JUMP, this.list(LABEL, this.hkind2ltype(22), _EPILOGUE)));
                    break;
                }
                case 23: {
                    this.lineInfo(pHir);
                    IfStmt stm = (IfStmt)pHir;
                    Label endlabel = stm.getEndLabel();
                    Label thenlabel = stm.getThenPart() == null ? endlabel : stm.getThenPart().getLabel();
                    Label elselabel = stm.getElsePart() == null ? endlabel : stm.getElsePart().getLabel();
                    this.jumpc2(stm.getIfCondition(), thenlabel, elselabel, cc.noIfExp());
                    if (stm.getThenPart() != null) {
                        this.addLexp(this.convertNode(stm.getThenPart(), cc));
                        this.addLexpBeforeInfo(this.jump(endlabel));
                    }
                    if (stm.getElsePart() != null) {
                        this.addLexp(this.convertNode(stm.getElsePart(), cc));
                    }
                    if (!this.supportLabeledNull) {
                        this.addLexpAfterInfo(this.convertDeflabel(endlabel));
                        break;
                    }
                    this.addLexp(this.convertNode((Stmt)stm.getChild(4), cc));
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    this.lineInfo(pHir);
                    LoopStmt stm = (LoopStmt)pHir;
                    Label looplabel = stm.getLoopBackLabel();
                    Label endlabel = stm.getLoopEndLabel();
                    Object tmp = null;
                    if (stm.getLoopInitPart() != null) {
                        this.addLexp(this.convertNode(stm.getLoopInitPart(), cc));
                    }
                    this.addLexpAfterInfo(this.convertDeflabel(looplabel));
                    if (stm.getLoopStartCondition() != null) {
                        this.jumpc2(stm.getLoopStartCondition(), stm.getLoopBodyLabel(), endlabel, cc.noIfExp());
                    }
                    this.addLexp(this.convertNode(stm.getLoopBodyPart(), cc));
                    if (stm.getLoopEndCondition() != null) {
                        int lab;
                        ++this.labelCtr;
                        Label newLabel = this.fHirRoot.sym.defineLabel(prefLirLabel + lab);
                        this.jumpc2(stm.getLoopEndCondition(), newLabel, endlabel, cc.noIfExp());
                        this.addLexp(this.convertDefLirLabel(lab));
                    }
                    if (stm.getLoopStepPart() != null) {
                        this.addLexp(this.convertNode(stm.getLoopStepPart(), cc));
                    }
                    this.addLexpBeforeInfo(this.jump(looplabel));
                    this.addLexp(this.convertNode(stm.getLoopEndPart(), cc));
                    break;
                }
                case 21: {
                    LabeledStmt stm = (LabeledStmt)pHir;
                    ListIterator it = stm.getLabelDefList().iterator();
                    while (it.hasNext()) {
                        if (!this.supportLabeledNull) {
                            this.addLexpAfterInfo(this.convertDeflabel(((LabelDef)it.next()).getLabel()));
                            continue;
                        }
                        Label lLabel = ((LabelDef)it.next()).getLabel();
                        if (this.appearedLabels.contains(lLabel)) continue;
                        this.addLexpAfterInfo(this.convertDeflabel(lLabel));
                    }
                    this.addLexp(this.convertNode(stm.getStmt(), cc));
                    break;
                }
                case 36: {
                    this.lineInfo(pHir);
                    Exp exp = ((ExpStmt)pHir).getExp();
                    if (exp == null) break;
                    ImList tmp = this.convertNode(exp, cc);
                    break;
                }
                case 28: {
                    this.lineInfo(pHir);
                    this.addLexpBeforeInfo(this.jump(((JumpStmt)pHir).getLabel()));
                    break;
                }
                case 32: {
                    this.lineInfo(pHir);
                    SwitchStmt stm = (SwitchStmt)pHir;
                    ImList selExp = this.convertNode(stm.getSelectionExp(), cc);
                    ltype = this.htype2ltype(stm.getSelectionExp().getType());
                    int n = stm.getCaseCount();
                    ArrayList<ImList> caseLab = new ArrayList<ImList>();
                    for (int i = 0; i < n; ++i) {
                        caseLab.add(this.list(this.intConst((Object)ltype, stm.getCaseConst(i).getName()), this.labelOperand(stm.getCaseLabel(i))));
                    }
                    Label defaultlabel = stm.getDefaultLabel();
                    ImList tmp = ImList.Empty;
                    for (int i = n - 1; i >= 0; --i) {
                        tmp = this.prefix(caseLab.get(i), tmp);
                    }
                    tmp = this.list(tmp, this.labelOperand(defaultlabel));
                    tmp = this.prefix(JUMPN, selExp, tmp);
                    this.addLexpBeforeInfo(tmp);
                    this.addLexp(this.convertNode(stm.getBodyStmt(), cc));
                    if (!this.appearedLabels.contains(defaultlabel)) {
                        this.addLexpAfterInfo(this.convertDeflabel(defaultlabel));
                    }
                    if (!this.supportLabeledNull) {
                        this.addLexpAfterInfo(this.convertDeflabel(stm.getEndLabel()));
                        break;
                    }
                    this.addLexp(this.convertNode((LabeledStmt)stm.getChild(4), cc));
                    break;
                }
                case 71: {
                    ImList data;
                    this.DZSSeq = ImList.Empty;
                    this.lineInfo(pHir);
                    this.autoString = false;
                    this.stroff = new StructOffset();
                    if (pHir.getChild1().getOperator() == 19) {
                        long bcePadding = 0L;
                        Exp qual = ((QualifiedExp)pHir.getChild1()).getQualifierExp();
                        Sym qsym = ((SymNode)qual).getSymNodeSym();
                        Sym bceSym = ((SymNode)((HIR)pHir.getChild1()).getChild2()).getSymNodeSym();
                        this.setUsed(qsym);
                        this.needNotInit(qsym);
                        this.setUsed(bceSym);
                        this.needNotInit(bceSym);
                        long off = ((QualifiedExp)pHir.getChild1()).getQualifiedElem().evaluateDisp();
                        System.out.println("qualExp " + qual.toStringDetail());
                        System.out.println("qsym " + qsym.toStringDetail());
                        if (this.regionLoc < off) {
                            bcePadding = off - this.regionLoc;
                            this.regionLoc = off;
                        } else if (this.regionLoc != off) {
                            this.badHIR("region offset mismatch: cur " + this.regionLoc + " next " + off);
                        }
                        ImList bcElem = null;
                        HIR r = (HIR)pHir.getChild2();
                        if (r instanceof ExpListExp) {
                            this.numSeq = new NumSeq();
                            this.convertNode1(r, cc.nonLvalue());
                            bcElem = this.reverse(this.DZSSeq);
                        } else if (r instanceof ConstNode) {
                            bcElem = this.list(this.list(this.htype2ltype(r.getType()), this.convertNode1(r, cc.nonLvalue())));
                        } else {
                            this.badHIR("region init (expect ExpListExp)");
                        }
                        if (bcElem == null) break;
                        this.addLbody(this.prefix(DATA, this.uniqName(bceSym), bcElem));
                        break;
                    }
                    Sym sym = ((SymNode)pHir.getChild1()).getSymNodeSym();
                    this.setUsed(sym);
                    this.needNotInit(sym);
                    Type vtype = null;
                    if (pHir.getChild1() instanceof VarNode) {
                        vtype = ((VarNode)pHir.getChild1()).getVar().getSymType();
                    }
                    this.debug("setdata: *** type " + vtype);
                    HIR r = (HIR)pHir.getChild2();
                    if (this.isScalerType(vtype)) {
                        Object tmp = r instanceof ConstNode ? (vtype.isFloating() ? Double.toString(((ConstNode)r).getConstSym().doubleValue()) : Long.toString(((ConstNode)r).getConstSym().longValue())) : this.convertNode1(r, cc.nonLvalue());
                        if (tmp == null) {
                            this.badHIR("non constant exp. in initializer: " + r);
                        }
                        data = this.list(this.list(this.htype2ltype(vtype), tmp));
                        this.debug("setdata: *** data " + data);
                    } else if (vtype instanceof VectorType) {
                        VectorType tmp = (VectorType)vtype;
                        vtype = this.getVectorElemType(vtype);
                        this.debug("*** r: " + r);
                        if (r instanceof ExpListExp) {
                            this.numSeq = new NumSeq();
                            this.convertNode1((ExpListExp)r, cc.nonLvalue());
                            data = this.reverse(this.DZSSeq);
                            this.debug("setdata: *** data " + data);
                        } else {
                            long len = tmp.getElemCount();
                            long slen = ((VectorType)((ConstNode)r).getConstSym().getSymType()).getElemCount();
                            if (len <= 0L || slen <= 0L) {
                                this.badHIR("vector length <= 0\n");
                            }
                            data = len - slen > 0L ? this.list(this.convertNode1(r, cc.nonLvalue()), this.zeros(len - slen)) : this.list(this.convertNode1(r, cc.nonLvalue()));
                        }
                        this.debug("setdata: *** data " + data);
                    } else if (this.isStrunion(vtype)) {
                        if (r instanceof ExpListExp) {
                            this.numSeq = new NumSeq();
                            this.convertNode1((ExpListExp)r, cc.nonLvalue());
                            data = this.reverse(this.DZSSeq);
                        } else {
                            data = this.list("bug? strunion init (expect ExpListExp)");
                        }
                    } else {
                        data = this.list("bug? setdata");
                        this.convertNode1(r, cc.nonLvalue());
                    }
                    this.lineInfo(((SymNode)pHir.getChild1()).getSymNodeSym());
                    this.addLbody(this.prefix(DATA, this.uniqName(((SymNode)pHir.getChild1()).getSymNodeSym()), data));
                    break;
                }
                case 96: {
                    IrList elem;
                    this.debug("explist:" + pHir);
                    ExpListExp l = (ExpListExp)pHir;
                    Type ty = l.getType();
                    this.debug("type:" + ty);
                    this.stroff.align(ty.getAlignment());
                    if (ty instanceof VectorType) {
                        Type old = this.numSeq.replType(this.getVectorElemType(ty));
                        long len = l.length();
                        long vlen = ((VectorType)ty).getElemCount();
                        if (vlen <= 0L) {
                            this.badHIR("length of op_explist <= 0\n");
                        }
                        long total = this.stroff.total + this.numSeq.getElemSize() * vlen;
                        vlen = len < vlen ? len : vlen;
                        ListIterator iter = l.iterator();
                        int i = 0;
                        while ((long)i < vlen) {
                            HIR tmp = (HIR)iter.next();
                            Const c = null;
                            if (tmp.getOperator() == 5 && (c = ((ConstNode)tmp).getConstSym()).getSymKind() == 6) {
                                int j;
                                String s = c.getName();
                                for (j = 1; j < s.length() - 1; ++j) {
                                    this.numSeq.add(this.intConst((Object)"I8", s.charAt(j)));
                                }
                                --j;
                                len = ((VectorType)((VectorType)ty).getElemType()).getElemCount();
                                if (len <= 0L) {
                                    this.badHIR("length of op_explist <= 0\n");
                                }
                                if ((long)j < len) {
                                    this.numSeq.addZeros(len - (long)j);
                                }
                            } else {
                                this.numSeq.add(this.convertNode1(tmp, cc.nonLvalue()));
                            }
                            ++i;
                        }
                        this.stroff.set(total);
                        this.numSeq.toDZSseq();
                        this.numSeq.replType(old);
                        break;
                    }
                    if (this.isStrunion(ty)) {
                        elem = ty.getElemList();
                        Type old = this.numSeq.replType(null);
                        long top = this.stroff.total;
                        this.debug("-- struct head align " + ty.getAlignment() + "@" + top);
                        int len = ty instanceof UnionType ? 1 : elem.size();
                        for (int i = 0; i < len; ++i) {
                            long ofs = ((Elem)elem.get(i)).evaluateDisp() + top;
                            this.debug("  disp = " + ((Elem)elem.get(i)).evaluateDisp());
                            this.debug("[" + elem.get(i) + "] top: " + top + " off: " + ofs);
                            this.stroff.flushBitField(ofs);
                            ImList tmp = this.convertNode1(l.getExp(i), cc.nonLvalue());
                            long total = ofs + ((Sym)elem.get(i)).getSymType().getSizeValue();
                            this.stroff.padding(ofs);
                            if (((Elem)elem.get(i)).isBitField()) {
                                if (l.getExp(i).isEvaluable()) {
                                    long val = l.getExp(i).evaluateAsLong();
                                    Elem bitf = (Elem)elem.get(i);
                                    int bsz = bitf.getBitSize();
                                    int bitoff = bitf.getBitOffset();
                                    if (this.machineParam.isBigEndian()) {
                                        bitoff = this.machineParam.evaluateSize(4) * 8 - bitoff - bsz;
                                    }
                                    this.debug("  packing ofs = " + ofs + ", bit field pos = " + bitoff + " wid = " + bsz + " <- " + val);
                                    val &= (1L << bsz) - 1L;
                                    this.stroff.pack(val <<= bitoff, bsz, (1L << bsz) - 1L << bitoff);
                                    continue;
                                }
                                this.badHIR("non constant exp. in bit-field initializer");
                                continue;
                            }
                            if (tmp == null) continue;
                            if (this.isLiteral(l.getExp(i))) {
                                long sz = ((Sym)elem.get(i)).getSymType().getSizeValue();
                                Const sym = ((ConstNode)l.getExp(i)).getConstSym();
                                int gen = ((StringConst)sym).getStringBody().length();
                                if ((long)gen < sz) {
                                    this.DZSSeq = new ImList(tmp, this.DZSSeq);
                                    tmp = this.zeros(sz - (long)gen - 1L);
                                } else if ((long)gen > sz) {
                                    this.bug("literal init.");
                                }
                                this.DZSSeq = new ImList(tmp, this.DZSSeq);
                            } else {
                                this.DZSSeq = new ImList(this.list(this.htype2ltype(((Sym)elem.get(i)).getSymType()), tmp), this.DZSSeq);
                            }
                            this.stroff.set(total);
                        }
                        long su_size = ty.getSizeValue();
                        this.stroff.flushBitField(su_size + top);
                        this.stroff.padding(su_size + top);
                        this.numSeq.toDZSseq();
                        this.numSeq.replType(old);
                        break;
                    }
                    elem = ty.getElemList();
                    int len = l.length();
                    System.out.println("*** void len " + len);
                    this.numSeq = new NumSeq();
                    for (int i = 0; i < len; ++i) {
                        this.numSeq.replType(l.getExp(i).getType());
                        System.out.println("*** elem " + this.convertNode(l.getExp(i), cc));
                    }
                    break;
                }
                case 97: {
                    HIR exp = (HIR)pHir.getChild1();
                    int n = ((ConstNode)pHir.getChild2()).getConstSym().intValue();
                    long size = (long)n * this.numSeq.getElemSize();
                    if (this.isConstZero(exp)) {
                        this.numSeq.toDZSseq();
                        this.DZSSeq = new ImList(this.zeros(size), this.DZSSeq);
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.numSeq.add(this.convertNode1(exp, cc.nonLvalue()));
                        }
                        this.numSeq.toDZSseq();
                    }
                    this.stroff.add(size);
                    break;
                }
                case 37: {
                    ImList clobp;
                    HIR tmp = (HIR)pHir.getChild1();
                    ArrayList<ImList> args = new ArrayList<ImList>();
                    ListIterator params = ((AsmStmt)pHir).getActualParamList().iterator();
                    while (params.hasNext()) {
                        args.add(this.convertNode((HIR)params.next(), cc));
                    }
                    String body = "bug";
                    if (tmp instanceof ConstNode) {
                        body = ((StringConst)((ConstNode)tmp).getConstSym()).getStringBody();
                    }
                    this.debug("body = " + body);
                    AsmParamList asm_params = null;
                    if (body.startsWith(ASM_PARAM)) {
                        body = body.substring(ASM_PARAM.length());
                        int end = body.indexOf("\n");
                        asm_params = this.doAsmParam(body.substring(0, end), false);
                        body = body.substring(end + 1);
                    }
                    AsmParamList asm_clobbers = null;
                    if (body.startsWith(ASM_CLOBBER)) {
                        body = body.substring(ASM_CLOBBER.length());
                        int end = body.indexOf("\n");
                        asm_clobbers = this.doAsmParam(body.substring(0, end), true);
                        body = body.substring(end + 1);
                    }
                    ImList argp = clobp = ImList.Empty;
                    ImList inoutp = clobp;
                    ImList outp = clobp;
                    ImList inp = clobp;
                    ImList asm = ImList.Empty;
                    if (asm_clobbers != null) {
                        for (int i = 0; i < asm_clobbers.size(); ++i) {
                            clobp = new ImList(asm_clobbers.get(i).getType(), clobp);
                        }
                        asm = this.list(CLOB_M, clobp);
                    }
                    if (asm_params != null) {
                        int i;
                        AsmParam p = null;
                        AsmParamList ins = new AsmParamList();
                        AsmParamList outs = new AsmParamList();
                        AsmParamList inouts = new AsmParamList();
                        for (int i2 = 0; i2 < asm_params.size() && i2 < args.size(); ++i2) {
                            String io;
                            p = asm_params.get(i2);
                            ImList q = (ImList)args.get(i2);
                            String ty = p.getType();
                            if (ty == "a") {
                                if (this.car(q) == MEM) {
                                    q = (ImList)this.car(this.cdr(this.cdr(q)));
                                }
                            } else if (ty == "s" && this.car(q) == MEM) {
                                q = (ImList)this.car(this.cdr(this.cdr(q)));
                            }
                            if ((io = p.getIo()) == null) {
                                p.addTo(ins);
                                inp = new ImList(q, inp);
                                continue;
                            }
                            if (io == "w") {
                                p.addTo(outs);
                                outp = new ImList(q, outp);
                                continue;
                            }
                            if (io != "m") continue;
                            p.addTo(inouts);
                            inoutp = new ImList(q, inoutp);
                        }
                        int pos = 0;
                        int n = ins.size();
                        for (i = 0; i < n; ++i) {
                            p = ins.get(i);
                            p.setPos(pos++);
                            argp = new ImList(p.getType(), argp);
                        }
                        n = outs.size();
                        for (i = 0; i < n; ++i) {
                            p = outs.get(i);
                            p.setPos(pos++);
                            argp = new ImList(p.getType(), argp);
                        }
                        n = inouts.size();
                        for (i = 0; i < n; ++i) {
                            p = inouts.get(i);
                            p.setPos(pos++);
                            argp = new ImList(p.getType(), argp);
                        }
                        argp = argp.destructiveReverse();
                        asm = new ImList(ARG_M, new ImList(argp, asm));
                    }
                    body = this.doAsmBody(body, asm_params);
                    inp = inp.destructiveReverse();
                    outp = outp.destructiveReverse();
                    inoutp = inoutp.destructiveReverse();
                    asm = this.prefix(ASM, this.quote(body), inp, outp, inoutp, asm);
                    this.addProfInfo(this.list(INFO, "BEGIN", ASM));
                    this.addLexp(asm);
                    this.addProfInfo(this.list(INFO, "END", ASM));
                    break;
                }
            }
            pHir = pHir.getNextStmt();
        }
        return null;
    }

    AsmParamList doAsmParam(String s, boolean regOnly) {
        int i = 0;
        AsmParamList ret = new AsmParamList();
        AsmParam p = this.no_param;
        this.debug("param = " + s);
        while (true) {
            p = new AsmParam();
            while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            if (i >= s.length()) break;
            if (!regOnly) {
                if (s.charAt(i) == 'w' || s.charAt(i) == 'm') {
                    p.setIo(s.substring(i, i + 1));
                    ++i;
                }
                if (i >= s.length()) break;
            }
            switch (s.charAt(i)) {
                case '%': {
                    int sta = i;
                    while (i < s.length() && !Character.isWhitespace(s.charAt(i)) && s.charAt(i) != ',') {
                        ++i;
                    }
                    p.setType(s.substring(sta, i));
                    break;
                }
                case 'a': 
                case 's': {
                    if (!regOnly) {
                        p.setType(s.substring(i, i + 1));
                        ++i;
                        break;
                    }
                }
                default: {
                    System.err.println("bad format: " + s.substring(i));
                    return ret;
                }
            }
            this.debug("" + p);
            if (p.isValid()) {
                p.addTo(ret);
            }
            p = this.no_param;
            boolean garbage = false;
            while (i < s.length() && s.charAt(i) != ',') {
                if (!Character.isWhitespace(s.charAt(i))) {
                    garbage = true;
                }
                ++i;
            }
            if (i >= s.length()) {
                this.debug("found end");
                break;
            }
            if (s.charAt(i) != ',') {
                this.debug("garbage [" + s.substring(i) + "]");
                break;
            }
            ++i;
        }
        if (p.isValid()) {
            this.debug("" + p);
            p = p.addTo(ret);
        }
        this.debug("next param = [" + s.substring(i) + "]");
        return ret;
    }

    String doAsmBody(String s, AsmParamList params) {
        int i = 0;
        StringBuffer dst = new StringBuffer();
        while (i < s.length()) {
            while (i < s.length() && s.charAt(i) != '%') {
                dst.append(s.charAt(i++));
            }
            if (i >= s.length()) break;
            if (s.charAt(i) != '%') continue;
            if (i + 1 >= s.length()) {
                System.err.println("single % in asm.");
                break;
            }
            dst.append('%');
            if (s.charAt(++i) == '%') {
                ++i;
                continue;
            }
            if (s.charAt(i) == '0') {
                dst.append('0');
                ++i;
                continue;
            }
            if (!Character.isDigit(s.charAt(i))) continue;
            int t = i;
            while (i < s.length() && Character.isDigit(s.charAt(i))) {
                ++i;
            }
            int pos = Integer.parseInt(s.substring(t, i)) - 1;
            if (params != null) {
                this.debug("pos = " + pos + " -> " + params.get(pos).getPos());
                dst.append(params.get(pos).getPos() + 1);
                continue;
            }
            System.err.println("positional parameter used, but no #param line");
            dst.append(pos);
        }
        return dst.toString();
    }

    private void jumpc2(HIR pHir, Label labelTrue, Label labelFalse, ConvContext cc) {
        switch (pHir.getOperator()) {
            case 62: {
                this.jumpc2((HIR)pHir.getChild1(), labelFalse, labelTrue, cc);
                return;
            }
            case 46: {
                int lab = this.labelCtr++;
                Label newLabel = this.fHirRoot.sym.defineLabel(prefLirLabel + lab);
                this.jumpc2((HIR)pHir.getChild1(), newLabel, labelFalse, cc);
                ImList newLabDef = this.convertDefLirLabel(lab);
                this.addLexpBeforeInfo(newLabDef);
                this.jumpc2((HIR)pHir.getChild2(), labelTrue, labelFalse, cc);
                return;
            }
            case 47: {
                int lab = this.labelCtr++;
                Label newLabel = this.fHirRoot.sym.defineLabel(prefLirLabel + lab);
                this.jumpc2((HIR)pHir.getChild1(), labelTrue, newLabel, cc);
                ImList newLabDef = this.convertDefLirLabel(lab);
                this.addLexpBeforeInfo(newLabDef);
                this.jumpc2((HIR)pHir.getChild2(), labelTrue, labelFalse, cc);
                return;
            }
        }
        ImList cond = this.convertConditionNode(pHir, cc);
        this.addLexpBeforeInfo(this.jumpc((Object)cond, labelTrue, labelFalse));
    }

    private ImList convertConditionNode(HIR pHir, ConvContext cc) {
        int lOperator = pHir.getOperator();
        if (lOperator >= 51 && lOperator <= 56) {
            return this.convertNode(pHir, cc);
        }
        Exp lCondExp = pHir.conditionalExp((Exp)pHir);
        return this.convertNode(lCondExp, cc);
    }

    private ImList convertStoreMember(ImList base, Elem elem, Type type, ImList value, ConvContext cc) {
        ImList result;
        String ltype = this.htype2ltype(type);
        String inttype = this.hkind2ltype(4);
        String ptrtype = this.hkind2ltype(22);
        long offset = elem.evaluateDisp();
        if (elem.isBitField()) {
            ImList lval;
            int cellType = 4;
            int wordbits = this.machineParam.evaluateSize(4) * 8;
            int bitoffset = elem.getBitOffset();
            int bitwidth = elem.getBitSize();
            if (this.machineParam.isBigEndian()) {
                bitoffset = wordbits - bitoffset - bitwidth;
            }
            boolean isUnsigned = elem.getSymType().isUnsigned();
            long mask = (1L << bitwidth) - 1L;
            String tmpName = this.uniqStrName(this.tempCtr++, "ptr");
            this.autoSym = this.prefix(this.frameEnt(tmpName, ptrtype, String.valueOf(this.machineParam.getAlignment(22)), ZERO), this.autoSym);
            this.addLexp(this.list(SET, ptrtype, this.memExp(ptrtype, this.frameExp2(tmpName)), this.address(base, this.intConst((Object)ptrtype, offset))));
            ImList tree = lval = this.memExp(this.hkind2ltype(cellType), this.memExp(ptrtype, this.frameExp2(tmpName)));
            if (cellType != 4) {
                tree = this.list(CONVZX, inttype, lval);
            }
            result = this.list(SET, this.hkind2ltype(cellType), lval, this.list(CONVIT, this.hkind2ltype(cellType), this.list(BOR, inttype, this.list(BAND, inttype, tree, this.intConst((Object)inttype, mask << bitoffset ^ 0xFFFFFFFFFFFFFFFFL)), this.list(LSHU, inttype, this.list(BAND, inttype, value, this.intConst((Object)inttype, mask)), this.intConst((Object)inttype, bitoffset)))));
        } else {
            result = this.address(base, this.intConst((Object)ptrtype, offset));
            this.debug("disp: " + offset);
            if (this.vectorAssignLen > 0L) {
                ltype = this.size2ltype(this.vectorAssignLen);
            }
            result = this.list(SET, ltype, this.memExp(ltype, result, type.isVolatile(), this.getAggregateAlign(type), this.optId(result)), value);
        }
        return result;
    }

    private ImList convertLoadMember(ImList base, Elem elem, Type type, ConvContext cc) {
        ImList result;
        String ltype = this.htype2ltype(type);
        String inttype = this.hkind2ltype(4);
        String ptrtype = this.hkind2ltype(22);
        long offset = elem.evaluateDisp();
        if (elem.isBitField()) {
            if (cc.isLvalue()) {
                throw new Error("taking address of bit field");
            }
            int cellType = 4;
            int wordbits = this.machineParam.evaluateSize(4) * 8;
            int bitoffset = elem.getBitOffset();
            int bitwidth = elem.getBitSize();
            if (this.machineParam.isBigEndian()) {
                bitoffset = wordbits - bitoffset - bitwidth;
            }
            boolean isUnsigned = elem.getSymType().isUnsigned();
            long mask = (1L << bitwidth) - 1L;
            ImList tree = this.memExp(this.hkind2ltype(cellType), this.address(base, this.intConst((Object)ptrtype, offset)));
            if (cellType != 4) {
                tree = this.list(CONVZX, inttype, tree);
            }
            if (isUnsigned) {
                tree = this.list(RSHU, inttype, tree, this.intConst((Object)inttype, bitoffset));
                result = this.list(BAND, inttype, tree, this.intConst((Object)inttype, mask));
            } else {
                result = tree = this.list(RSHS, inttype, this.list(LSHU, inttype, tree, this.intConst((Object)inttype, wordbits - (bitwidth + bitoffset))), this.intConst((Object)inttype, wordbits - bitwidth));
            }
        } else {
            result = this.address(base, this.intConst((Object)ptrtype, offset));
            this.debug("disp: " + offset);
            if (this.vectorAssignLen > 0L) {
                ltype = this.size2ltype(this.vectorAssignLen);
            }
            result = cc.isLvalue() ? result : this.memExp(ltype, result, type.isVolatile(), this.getAggregateAlign(type), this.optId(result));
        }
        return result;
    }

    private Type getVectorElemType(Type pVec) {
        Type ty = ((VectorType)pVec).getElemType();
        if (ty instanceof VectorType) {
            return this.getVectorElemType((VectorType)ty);
        }
        return ty;
    }

    private ImList convertCmp(HIR pHir, String pOpname, ConvContext cc) {
        String ifexpType = this.hkind2ltype(4);
        ImList l = this.convertNode((HIR)pHir.getChild1(), cc.emitIfExp());
        ImList r = this.convertNode((HIR)pHir.getChild2(), cc.emitIfExp());
        ImList tmp = this.list(pOpname, this.htype2ltype(pHir.getType()), l, r);
        switch (pHir.getOperator()) {
            default: {
                this.bug("cmp(binop)");
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                if (!cc.isEmitIfExp()) break;
                tmp = this.list(IF, ifexpType, tmp, this.intConst((Object)ifexpType, 1L), this.intConst((Object)ifexpType, 0L));
            }
        }
        return tmp;
    }

    private ImList convertBinop(HIR pHir, String pOpname, ConvContext cc) {
        ImList l = this.convertNode((HIR)pHir.getChild1(), cc);
        ImList r = this.convertNode((HIR)pHir.getChild2(), cc);
        ImList tmp = this.list(pOpname, this.htype2ltype(pHir.getType()), l, r);
        switch (pHir.getOperator()) {
            default: {
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                this.bug("binop(cmp)");
            }
        }
        return tmp;
    }

    private ImList convert_builtin_align(ListIterator params, ConvContext cc) {
        HIR tmp;
        ImList ptr = ImList.Empty;
        this.builtin_align = 0;
        if (params.hasNext()) {
            ptr = this.convertNode((HIR)params.next(), cc);
        }
        if (params.hasNext() && (tmp = (HIR)params.next()) instanceof ConstNode) {
            this.builtin_align = ((ConstNode)tmp).getConstSym().intValue();
        }
        if (ptr == null) {
            this.badHIR("__builtin_align(bad pointer)");
        }
        if (this.builtin_align == 0) {
            this.badHIR("__builtin_align(bad align) -> treat as 4");
            this.builtin_align = 4;
        }
        return ptr;
    }

    private ImList convertUnaop(HIR pHir, String pOpname, ConvContext cc) {
        ImList tmp = this.convertNode((HIR)pHir.getChild1(), cc);
        return this.list(pOpname, this.htype2ltype(pHir.getType()), tmp);
    }

    private ImList convertDeflabel(Label pLabel) {
        this.appearedLabels.add(pLabel);
        return this.list(DEFLABEL, this.quote(pLabel.getName()));
    }

    private ImList convertDefLirLabel(int pLabel) {
        return this.list(DEFLABEL, this.quote(prefLirLabel + pLabel));
    }

    private ImList labelOperand(Label pLabel) {
        return this.list(LABEL, this.hkind2ltype(22), this.quote(pLabel.getName()));
    }

    private ImList lirLabel(int pLabel) {
        return this.list(LABEL, this.hkind2ltype(22), this.quote(prefLirLabel + pLabel));
    }

    private boolean isReg(Sym sym) {
        switch (sym.getSymType().getTypeKind()) {
            case 23: 
            case 24: 
            case 25: {
                return false;
            }
        }
        return ((Var)sym).getStorageClass() == 8;
    }

    private ImList intConst(Object type, Object num) {
        return this.list(INTCONST, type, num);
    }

    private ImList intConst(Object type, long num) {
        return this.list(INTCONST, type, String.valueOf(num));
    }

    private ImList floatConst(Object type, Object num) {
        return this.list(FLOATCONST, type, num);
    }

    private ImList floatConst(Object type, double num) {
        return this.list(FLOATCONST, type, String.valueOf(num));
    }

    private ImList frameExp2(String s) {
        return this.list(FRAME, this.hkind2ltype(22), this.quote(s));
    }

    private ImList frameExp2(QuotedString qs) {
        return this.list(FRAME, this.hkind2ltype(22), qs);
    }

    private ImList frameExp(Object type, String s) {
        return this.list(FRAME, type, this.quote(s));
    }

    private ImList frameExp(Object type, QuotedString qs) {
        return this.list(FRAME, type, qs);
    }

    private QuotedString optId(ImList l) {
        QuotedString tmp = null;
        Object target = this.car(l);
        if (target == FRAME || target == STATIC) {
            Object id = this.car(this.cdr(this.cdr(l)));
            if (id instanceof QuotedString) {
                tmp = (QuotedString)id;
            } else {
                this.bug("broken FRAME/STATIC: " + l);
            }
        } else {
            tmp = complexMem;
        }
        return tmp;
    }

    private ImList memExp(Object type, Object exp) {
        return this.list(MEM, type, exp);
    }

    private ImList memExp(Object type, Object exp, Object m) {
        return this.list(MEM, type, exp, m);
    }

    private ImList memExp(Object type, Object exp, boolean isVolatile, int align, Object id) {
        ImList tmp = ImList.Empty;
        if (align <= 1) {
            align = -1;
        }
        if (this.simulateOption || this.generateLine) {
            if (id == complexMem) {
                tmp = this.list(ID_M, String.valueOf(this.memNum++));
            } else if (id instanceof QuotedString) {
                tmp = this.list(ID_M, this.list(id, String.valueOf(this.memNum++)));
            } else {
                this.bug("id is not QS");
                tmp = this.list(ID_M, String.valueOf(this.memNum++));
            }
        }
        if (!isVolatile && align < 0) {
            return this.prefix(MEM, type, exp, tmp);
        }
        if (!isVolatile) {
            return this.prefix(MEM, type, exp, ALIGN_M, String.valueOf(align), tmp);
        }
        if (align < 0) {
            return this.prefix(MEM, type, exp, VOLATILE_M, tmp);
        }
        tmp = this.prefix(ALIGN_M, String.valueOf(align), tmp);
        return this.prefix(MEM, type, exp, VOLATILE_M, tmp);
    }

    private ImList staticExp(String s) {
        return this.list(STATIC, this.hkind2ltype(22), this.quote(s));
    }

    private ImList staticExp(QuotedString s) {
        return this.list(STATIC, this.hkind2ltype(22), s);
    }

    private ImList jump(Label label) {
        return this.list(JUMP, this.labelOperand(label));
    }

    private ImList jumpc(Object cond, Label label1, Label label2) {
        return this.list(JUMPC, cond, this.labelOperand(label1), this.labelOperand(label2));
    }

    private ImList jumpc(Object cond, int label1, Label label2) {
        return this.list(JUMPC, cond, this.lirLabel(label1), this.labelOperand(label2));
    }

    private ImList address(Object l, Object r) {
        return this.list(ADD, this.hkind2ltype(22), l, r);
    }

    private ImList optsym(Sym sym) {
        String filename = sym.getDefinedFile();
        if (filename == null) {
            filename = "";
        }
        return this.list(OPTSYM_M, this.quote(sym.getUniqueName()), this.quote(filename), new Integer(sym.getDefinedLine()), new Integer(sym.getDefinedColumn()));
    }

    private ImList autoEnt(Sym sym) {
        String type = UNKNOWN;
        String store = FRAME;
        if (sym.getSymKind() == 8 || sym.getSymKind() == 9) {
            if (sym.getSymType().getSizeValue() <= 0L) {
                this.bug("**** size <= 0" + sym.getSymType());
            }
            if ((type = this.htype2ltype(sym.getSymType())) == UNKNOWN) {
                this.badHIR("unknown size auto symbol -> treat as INT " + sym);
                type = this.hkind2ltype(4);
            }
            if (((Var)sym).getStorageClass() == 7) {
                store = FRAME;
            } else if (((Var)sym).getStorageClass() == 8) {
                store = REG;
            } else {
                this.bug("bad storage class:" + sym + " -> treat as FRAME");
            }
        }
        ImList opt = this.optsym(sym);
        opt = this.prefix(type, String.valueOf(this.getAlignment(sym)), ZERO, opt);
        return this.prefix(this.uniqName(sym), store, opt);
    }

    private ImList frameEnt(String s, Object type, Object align, Object offset) {
        return this.list(this.quote(s), FRAME, type, align, offset);
    }

    private ImList staticEntBase(Sym sym, QuotedString qs, QuotedString seg, Object linkage) {
        String type = UNKNOWN;
        if (sym.getSymKind() == 8) {
            type = this.htype2ltype(sym.getSymType());
        }
        ImList opt = this.optsym(sym);
        opt = this.prefix(type, String.valueOf(this.getAlignment(sym)), seg, linkage, opt);
        return this.prefix(qs, STATIC, opt);
    }

    private ImList staticEnt(Sym sym, QuotedString seg, Object linkage) {
        return this.staticEntBase(sym, this.uniqName(sym), seg, linkage);
    }

    private ImList staticEntString(Sym sym) {
        return this.staticEntBase(sym, this.quote(this.stringName(sym)), LITERAL_SEG, LDEF);
    }

    private ImList strConst(String name, String s) {
        return this.list(DATA, this.quote(name), this.charSeq(s));
    }

    private ImList strConst(String name, String s, long len) {
        ImList tmp = this.charSeq(s, len);
        return this.list(DATA, this.quote(name), tmp);
    }

    private ImList charSeq(String s) {
        return this.strconv.charSeq(s);
    }

    private ImList charSeq(String s, long len) {
        return this.strconv.charSeq(s, len);
    }

    private int setCurLine(HIR pHir) {
        int thisLine = -1;
        if (!this.generateLine) {
            return thisLine;
        }
        if (pHir instanceof Stmt) {
            Stmt tmp = (Stmt)pHir;
            if (tmp.getFileName() != null) {
                if (this.curline != tmp.getLineNumber()) {
                    thisLine = tmp.getLineNumber();
                }
                if (thisLine == 0) {
                    this.debug("no lineno for " + tmp);
                }
            } else if (pHir.getOperator() == 22) {
                HIR lhs = (HIR)pHir.getChild1();
                if (lhs == null) {
                    this.badHIR("op_assign.getChild1() returns null. " + pHir.toStringDetail());
                    return thisLine;
                }
                if (lhs.getOperator() == 7) {
                    Sym sym = ((SymNode)lhs).getSymNodeSym();
                    if (sym.getDefinedFile() != null && this.curline < sym.getDefinedLine()) {
                        thisLine = sym.getDefinedLine();
                    }
                    if (thisLine == 0) {
                        this.debug("no lineno for " + sym);
                    }
                }
            }
            if (thisLine != -1 && thisLine != 0) {
                this.curline = thisLine;
            }
        }
        return thisLine;
    }

    private void lineInfo(HIR pHir) {
        if (!this.generateLine) {
            return;
        }
        int thisLine = this.setCurLine(pHir);
        if (thisLine != -1 && thisLine != 0) {
            this.addLexp(this.list(INFO, LINE, String.valueOf(thisLine)));
        }
    }

    private void lineInfo(Sym sym) {
        if (!this.generateLine) {
            return;
        }
        if (sym.getDefinedFile() != null) {
            this.addLbody(this.list(INFO, LINE, String.valueOf(sym.getDefinedLine())));
            this.debug("sym defined: " + sym.getDefinedLine());
        }
    }

    private ImList zeros(long n) {
        return this.list("ZEROS", String.valueOf(n));
    }

    private ImList symEnt(String type, Sym sym) {
        ImList tmp = null;
        if (sym.getSymKind() == 10) {
            tmp = this.list(this.uniqName(sym), STATIC, UNKNOWN, "1", DSEG, XREF);
            this.needNotInit(sym);
            this.setLirSym(sym);
        }
        if (sym.getSymKind() == 8) {
            if (((Var)sym).getVisibility() == 1) {
                if (this.pureExterns.get(sym.getName()) == null) {
                    this.pureExterns.put(sym.getName(), "");
                    tmp = this.staticEnt(sym, DSEG, XREF);
                    this.setLirSym(sym);
                    this.needNotInit(sym);
                }
            } else if (((Var)sym).getStorageClass() == 6) {
                tmp = this.emitRoseg && ((Var)sym).getSymType().isConst() ? this.staticEnt(sym, ROSEG, LDEF) : this.staticEnt(sym, DSEG, LDEF);
                this.setLirSym(sym);
            }
        }
        if (sym.getSymKind() == 12) {
            String linkage = LDEF;
            switch (((Subp)sym).getVisibility()) {
                case 2: {
                    linkage = XDEF;
                    break;
                }
                case 1: {
                    linkage = XREF;
                    break;
                }
            }
            tmp = this.staticEnt(sym, CSEG, linkage);
            if (this.debugUniqFun) {
                System.out.println("func " + sym + " -> " + this.uniqName(sym));
            }
            this.needNotInit(sym);
            this.setLirSym(sym);
        }
        return tmp;
    }

    private boolean isAggregate(Type pType) {
        int pTypeKind = pType.getTypeKind();
        switch (pTypeKind) {
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    private int getAggregateAlign(Type pType) {
        return this.isAggregate(pType) ? pType.getAlignment() : 0;
    }

    private String htype2ltype(Type pType) {
        int pTypeKind = pType.getTypeKind();
        switch (pTypeKind) {
            case 23: 
            case 24: 
            case 25: {
                long len = pType.getSizeValue();
                if (len <= 0L) {
                    return UNKNOWN;
                }
                return "A" + String.valueOf(len * 8L);
            }
        }
        return this.hkind2ltype(pTypeKind);
    }

    private String size2ltype(long n) {
        return "A" + n * 8L;
    }

    private String n2Ixx(int n) {
        return "I" + n * 8;
    }

    private String hkind2ltype(int pTypeKind) {
        if (pTypeKind == 20) {
            pTypeKind = 22;
        }
        switch (pTypeKind) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: {
                switch (this.machineParam.evaluateSize(pTypeKind)) {
                    case 1: {
                        return "I8";
                    }
                    case 2: {
                        return "I16";
                    }
                    case 4: {
                        return "I32";
                    }
                    case 8: {
                        return "I64";
                    }
                    case 16: {
                        return "I128";
                    }
                }
            }
            case 15: {
                return UNKNOWN;
            }
            case 16: 
            case 17: 
            case 18: {
                switch (this.machineParam.evaluateSize(pTypeKind)) {
                    case 4: {
                        return "F32";
                    }
                    case 8: {
                        return "F64";
                    }
                    case 16: {
                        return "F128";
                    }
                }
            }
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return "AGGREGATE";
            }
        }
        return UNKNOWN;
    }

    private void printQuotedString(String s) {
        int n = s.length();
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (' ' <= c && c <= '~') {
                buf.append(c);
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            buf.append('\\');
            String v = "00" + Integer.toOctalString(c);
            int k = v.length();
            buf.append(v.substring(k - 3));
        }
        buf.append('\"');
    }

    private int getSymNum(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            return 0;
        }
        return tmp.num();
    }

    private String stringName(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            return "bug: " + pSym;
        }
        return "string." + tmp.num();
    }

    private void install(Sym pSym) {
        SymStat tmp = new SymStat(pSym);
        this.symNumbers.put(pSym, tmp);
    }

    private void installSpecial(Sym pSym) {
        SymStat tmp = new SymStat(pSym);
        this.symNumbers.put(pSym, tmp);
        tmp.numbering();
    }

    private boolean isRemoved(Sym pSym) {
        if (pSym.isRemoved()) {
            this.badHIR("removed symbol is used [" + pSym.toStringDetail() + "]");
            return true;
        }
        return false;
    }

    private int numbering(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        return tmp.numbering();
    }

    private boolean isLirSym(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            return false;
        }
        return tmp.isLirSym();
    }

    private void setLirSym(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            if (!this.isRemoved(pSym)) {
                this.bug("1(bad HIR ?) not installed: " + pSym.toStringDetail());
            }
            return;
        }
        tmp.setLirSym();
    }

    private boolean isUsed(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            return false;
        }
        return tmp.isUsed();
    }

    private void setUsed(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            if (!this.isRemoved(pSym)) {
                this.bug("3(bad HIR ?) not installed: " + pSym.toStringDetail());
            }
            return;
        }
        tmp.setUsed();
    }

    private void resetUsed(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            if (!this.isRemoved(pSym)) {
                this.bug("4(bad HIR ?) not installed: " + pSym.toStringDetail());
            }
            return;
        }
        tmp.resetUsed();
    }

    private boolean isGenInit(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            if (!this.isRemoved(pSym)) {
                this.bug("isGenInit(): not installed: " + pSym.toStringDetail());
            }
            return false;
        }
        return tmp.isGenInit();
    }

    private void needNotInit(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            if (!this.isRemoved(pSym)) {
                this.bug("needNotInit(): not installed: " + pSym.toStringDetail());
            }
            return;
        }
        tmp.needNotInit();
    }

    private boolean isRewrite(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            if (!this.isRemoved(pSym)) {
                this.bug("7(bad HIR ?) not installed: " + pSym.toStringDetail());
            }
            return false;
        }
        return tmp.isRewrite();
    }

    private int uniqSym(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            if (!this.isRemoved(pSym)) {
                this.bug("8(bad HIR ?) not installed: " + pSym.toStringDetail());
            }
            return -1;
        }
        tmp.setRewrite();
        return tmp.num();
    }

    private int keepName(Sym pSym) {
        SymStat tmp = (SymStat)this.symNumbers.get(pSym);
        if (tmp == null) {
            if (!this.isRemoved(pSym)) {
                this.bug("(bad HIR ?) not installed: " + pSym.toStringDetail());
            }
            return -1;
        }
        tmp.resetRewrite();
        return tmp.num();
    }

    public void print(ImList l) {
        ImPrinter printer = new ImPrinter(new PrintWriter(this.fOut));
        printer.print(l);
    }

    private class ImPrinter {
        private int indentStep = 2;
        private int nest = 0;
        private PrintWriter out;
        private Set keywords;
        private Set tables;
        private Set specs;
        private boolean needSpace = false;
        private final String longSpace = "                                                            ";

        public ImPrinter() {
            this(new PrintWriter(System.out));
        }

        public ImPrinter(PrintWriter out) {
            int i;
            this.out = out;
            this.keywords = new HashSet();
            this.tables = new HashSet();
            this.specs = new HashSet();
            for (i = 0; i < keywordList.length; ++i) {
                this.keywords.add(keywordList[i]);
            }
            for (i = 0; i < tableList.length; ++i) {
                this.tables.add(tableList[i]);
            }
            for (i = 0; i < specList.length; ++i) {
                this.specs.add(specList[i]);
            }
        }

        private void outString(String s) {
            this.out.print(s);
            this.needSpace = true;
        }

        private void outStringln(String s) {
            this.out.println(s);
            this.needSpace = true;
        }

        private void outSpace() {
            if (this.needSpace) {
                this.out.print(" ");
            }
            this.needSpace = false;
        }

        private void outSpace(int n) {
            if (this.needSpace) {
                while (n > 0) {
                    int n1 = n;
                    if (n1 > "                                                            ".length()) {
                        n1 = "                                                            ".length();
                    }
                    n -= n1;
                    this.out.print("                                                            ".substring(0, n1));
                }
            }
            this.needSpace = false;
        }

        private void outParens() {
            if (this.nest > 0) {
                this.outSpace();
                for (int i = 0; i < this.nest; ++i) {
                    this.outString("(");
                }
            }
            this.nest = 0;
        }

        private void pp1(Object l, int indent, boolean inTable) {
            if (l instanceof ImList) {
                while (l != ImList.Empty) {
                    boolean inTable2 = inTable;
                    if (ConvToNewLIR.this.car(l) instanceof ImList) {
                        if (inTable || this.keywords.contains(ConvToNewLIR.this.car(ConvToNewLIR.this.car(l)))) {
                            this.outStringln("");
                            if (this.specs.contains(ConvToNewLIR.this.car(ConvToNewLIR.this.car(l)))) {
                                this.outSpace((indent - 1) * this.indentStep + this.indentStep - 1);
                            } else {
                                this.outSpace(indent * this.indentStep);
                            }
                            if (this.tables.contains(ConvToNewLIR.this.car(ConvToNewLIR.this.car(l)))) {
                                inTable2 = true;
                            }
                        }
                        ++this.nest;
                    }
                    this.pp1(ConvToNewLIR.this.car(l), indent + 1, inTable2);
                    l = ConvToNewLIR.this.cdr(l);
                }
                this.outParens();
                this.outString(")");
                return;
            }
            if (l == null) {
                this.outString("[null]");
            } else {
                if (this.nest > 0) {
                    this.outParens();
                } else {
                    this.outSpace();
                }
                this.outString(l.toString());
            }
        }

        public void print(ImList l) {
            this.nest = 1;
            this.pp1(l, 1, false);
            this.outStringln("");
            this.out.flush();
        }
    }

    private class LiteralStringConverter
    extends PlainStringConverter {
        private LiteralStringConverter() {
        }

        private boolean is_special(int c) {
            return c < 32 || c > 126 || c == 34;
        }

        public ImList charSeq(String s) {
            return this.charSeq(s, s.length() + 1);
        }

        public ImList charSeq(String s, long len) {
            int i;
            ImList tmp = ImList.Empty;
            StringBuffer b = new StringBuffer();
            for (i = 0; i < s.length() && (long)i < len; ++i) {
                char c = s.charAt(i);
                if (this.is_special(c)) {
                    if (b.length() > 0) {
                        tmp = ConvToNewLIR.this.prefix(ConvToNewLIR.this.quote(b.toString()), tmp);
                        b.delete(0, b.length());
                    }
                    tmp = ConvToNewLIR.this.prefix(String.valueOf((int)c), tmp);
                    continue;
                }
                b.append(c);
            }
            if (b.length() > 0) {
                tmp = ConvToNewLIR.this.prefix(ConvToNewLIR.this.quote(b.toString()), tmp);
                b.delete(0, b.length());
            }
            while ((long)i < len) {
                tmp = ConvToNewLIR.this.prefix(ConvToNewLIR.ZERO, tmp);
                ++i;
            }
            return ConvToNewLIR.this.prefix("I8", ConvToNewLIR.this.reverse(tmp));
        }
    }

    private class PlainStringConverter
    extends StringConverter {
        public ImList charSeq(String s) {
            ImList tmp = ImList.Empty;
            tmp = new ImList(ConvToNewLIR.ZERO, tmp);
            for (int i = s.length() - 1; i >= 0; --i) {
                tmp = ConvToNewLIR.this.prefix(String.valueOf((int)s.charAt(i)), tmp);
            }
            return ConvToNewLIR.this.prefix("I8", tmp);
        }

        public ImList charSeq(String s, long len) {
            int i;
            ImList tmp = ImList.Empty;
            for (i = 0; i < s.length() && (long)i < len; ++i) {
                tmp = ConvToNewLIR.this.prefix(String.valueOf((int)s.charAt(i)), tmp);
            }
            while ((long)i < len) {
                tmp = ConvToNewLIR.this.prefix(ConvToNewLIR.ZERO, tmp);
                ++i;
            }
            return ConvToNewLIR.this.prefix("I8", ConvToNewLIR.this.reverse(tmp));
        }
    }

    private abstract class StringConverter {
        abstract ImList charSeq(String var1);

        abstract ImList charSeq(String var1, long var2);
    }

    class AsmParamList {
        ArrayList l = new ArrayList();

        AsmParamList() {
        }

        int size() {
            return this.l.size();
        }

        void add(AsmParam p) {
            this.l.add(p);
        }

        AsmParam get(int i) {
            return (AsmParam)this.l.get(i);
        }
    }

    class AsmParam {
        String io = null;
        String ty = null;
        int pos = -1;

        AsmParam() {
        }

        void setType(String s) {
            this.ty = s.intern();
        }

        void setIo(String s) {
            this.io = s.intern();
        }

        void setPos(int i) {
            this.pos = i;
        }

        String getType() {
            if (this.ty == null) {
                ConvToNewLIR.this.bug("type is not set.");
            }
            return this.ty;
        }

        String getIo() {
            return this.io;
        }

        int getPos() {
            return this.pos;
        }

        boolean isValid() {
            if (this == ConvToNewLIR.this.no_param) {
                return false;
            }
            return this.ty != null;
        }

        AsmParam addTo(AsmParamList l) {
            if (this.isValid()) {
                l.add(this);
            } else {
                ConvToNewLIR.this.debug("adding bad param: " + this);
            }
            return ConvToNewLIR.this.no_param;
        }

        public String toString() {
            if (this.isValid()) {
                return "type = " + this.ty + ", io = " + (this.io == null ? "r" : this.io);
            }
            return "bad parameter spec. \"" + this.ty + this.io + "\"";
        }
    }

    private class ConvContext {
        private boolean isLvalue;
        private boolean emitIfExp;

        public ConvContext() {
            this.isLvalue = false;
            this.emitIfExp = false;
        }

        public ConvContext(ConvContext cc) {
            this.isLvalue = cc.isLvalue;
            this.emitIfExp = cc.emitIfExp;
        }

        public ConvContext(boolean isLvalue, boolean emitIfExp) {
            this.isLvalue = isLvalue;
            this.emitIfExp = emitIfExp;
        }

        public ConvContext lvalue() {
            ConvContext tmp = new ConvContext(this);
            tmp.isLvalue = true;
            return tmp;
        }

        public ConvContext nonLvalue() {
            ConvContext tmp = new ConvContext(this);
            tmp.isLvalue = false;
            return tmp;
        }

        public ConvContext emitIfExp() {
            ConvContext tmp = new ConvContext(this);
            tmp.emitIfExp = true;
            return tmp;
        }

        public ConvContext noIfExp() {
            ConvContext tmp = new ConvContext(this);
            tmp.emitIfExp = false;
            return tmp;
        }

        public boolean isLvalue() {
            return this.isLvalue;
        }

        public boolean isEmitIfExp() {
            return this.emitIfExp;
        }
    }

    class SymStat {
        private int symNum = -1;
        public static final int KEEP = -2;
        public static final int UNUSED = -1;
        private int state = 12;
        public static final int UNKNOWN = 0;
        private static final int INSTALLED = 1;
        private static final int GENERATED = 2;
        private static final int REWRITE = 4;
        private static final int USED = 8;
        private static final int INITIAL_VALUE = 12;
        private Sym sym;

        SymStat(Sym sym) {
            this.sym = sym;
        }

        int numbering() {
            this.symNum = this.isRewrite() ? ConvToNewLIR.this.tempCtr++ : -2;
            return this.symNum;
        }

        int num() {
            return this.symNum;
        }

        void setLirSym() {
            this.state |= 1;
        }

        boolean isLirSym() {
            return (this.state & 1) != 0;
        }

        void needNotInit() {
            this.state |= 2;
        }

        boolean isGenInit() {
            return (this.state & 2) != 0;
        }

        void resetRewrite() {
            this.state &= 0xFFFFFFFB;
        }

        void setRewrite() {
            this.state |= 4;
        }

        boolean isRewrite() {
            return (this.state & 4) != 0;
        }

        Sym getSym() {
            return this.sym;
        }

        boolean isExtern() {
            int v = 4;
            if (this.sym instanceof Subp) {
                v = ((Subp)this.sym).getVisibility();
            } else if (this.sym instanceof Var) {
                v = ((Var)this.sym).getVisibility();
            }
            return v == 1;
        }

        void resetUsed() {
            if (!this.isExtern() || ConvToNewLIR.this.pureExterns.get(this.sym.getName()) != null) {
                // empty if block
            }
            this.state &= 0xFFFFFFF7;
        }

        void setUsed() {
            if (!this.isExtern() || ConvToNewLIR.this.pureExterns.get(this.sym.getName()) != null) {
                // empty if block
            }
            this.state |= 8;
        }

        boolean isUsed() {
            return (this.state & 8) != 0;
        }
    }

    private class StructOffset {
        long total = 0L;
        long bitoff = 0L;
        long bitList = 0L;
        long valid = 0L;

        void align(int n) {
            int tmp = (int)((long)n - this.total % (long)n) % n;
            if (tmp > 0) {
                ConvToNewLIR.this.debug("explist align: " + n + " pad: " + tmp);
                ConvToNewLIR.this.DZSSeq = new ImList(ConvToNewLIR.this.list("ZEROS", String.valueOf(tmp)), ConvToNewLIR.this.DZSSeq);
                this.total += (long)tmp;
            }
        }

        void add(long n) {
            this.total += n;
        }

        void set(long n) {
            this.total = n;
        }

        void padding(long offset) {
            if (this.total > offset) {
                return;
            }
            if (this.total < offset) {
                ConvToNewLIR.this.debug("total: " + this.total + " offset: " + offset + " -> padding " + (offset - this.total));
                ConvToNewLIR.this.DZSSeq = new ImList(ConvToNewLIR.this.list("ZEROS", String.valueOf(offset - this.total)), ConvToNewLIR.this.DZSSeq);
            }
            this.total = offset;
        }

        void flushBitField(long byteoff) {
            ConvToNewLIR.this.debug("*** flushBitf: ofs = " + this.total + ", bit = " + this.bitoff);
            ConvToNewLIR.this.debug("        <-> byteoff = " + byteoff);
            if (this.bitoff != 0L && this.total < byteoff) {
                int nbytes = (int)(this.bitoff + 7L) / 8;
                ImList tmp = ImList.Empty;
                ConvToNewLIR.this.debug("         flushing value " + Long.toHexString(this.bitList));
                ConvToNewLIR.this.debug("          nbytes = " + nbytes);
                ConvToNewLIR.this.debug("         valid bits = " + Long.toHexString(this.valid));
                if (ConvToNewLIR.this.machineParam.isLittleEndian()) {
                    int i;
                    for (i = 0; i < 8 && (this.valid & (long)(255 << i * 8)) == 0L; ++i) {
                        this.bitList >>>= 8;
                    }
                    switch (nbytes) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            tmp = ConvToNewLIR.this.prefix(String.valueOf(this.bitList), tmp);
                            ConvToNewLIR.this.DZSSeq = new ImList(ConvToNewLIR.this.prefix(ConvToNewLIR.this.n2Ixx(nbytes), tmp), ConvToNewLIR.this.DZSSeq);
                            break;
                        }
                        default: {
                            for (i = 0; i < nbytes; ++i) {
                                tmp = ConvToNewLIR.this.prefix(String.valueOf(this.bitList >> i * 8 & 0xFFL), tmp);
                            }
                            tmp = ConvToNewLIR.this.reverse(tmp);
                            ConvToNewLIR.this.DZSSeq = new ImList(ConvToNewLIR.this.prefix("I8", tmp), ConvToNewLIR.this.DZSSeq);
                            break;
                        }
                    }
                } else {
                    for (int i = 7; i > 0 && (this.valid & (long)(255 << i * 8)) == 0L; ++i) {
                        this.bitList <<= 8;
                    }
                    switch (nbytes) {
                        case 4: 
                        case 8: {
                            tmp = ConvToNewLIR.this.prefix(String.valueOf(this.bitList), tmp);
                            ConvToNewLIR.this.DZSSeq = new ImList(ConvToNewLIR.this.prefix(ConvToNewLIR.this.n2Ixx(nbytes), tmp), ConvToNewLIR.this.DZSSeq);
                            break;
                        }
                        default: {
                            int w = nbytes > 4 ? 8 : 4;
                            ConvToNewLIR.this.debug("  value = " + this.bitList);
                            for (int i = 1; i <= nbytes; ++i) {
                                tmp = ConvToNewLIR.this.prefix(String.valueOf(this.bitList >> (w - i) * 8 & 0xFFL), tmp);
                            }
                            tmp = ConvToNewLIR.this.reverse(tmp);
                            ConvToNewLIR.this.DZSSeq = new ImList(ConvToNewLIR.this.prefix("I8", tmp), ConvToNewLIR.this.DZSSeq);
                        }
                    }
                }
                this.bitList = 0L;
                this.total += (long)nbytes;
                ConvToNewLIR.this.debug(" total = " + this.total);
                ConvToNewLIR.this.debug(" byteoff = " + byteoff);
                this.padding(byteoff);
                this.bitoff = 0L;
                this.valid = 0L;
            }
        }

        void pack(long l, int w, long m) {
            this.bitList |= l;
            this.valid |= m;
            this.bitoff += (long)w;
            ConvToNewLIR.this.debug("pack wid, msk = " + w + ", " + Long.toHexString(m) + " <- val " + Long.toHexString(l));
        }
    }

    private class NumSeq {
        private Type type = null;
        ImList seq = ImList.Empty;

        void add(ImList l) {
            if (l != null) {
                this.seq = new ImList(l, this.seq);
            }
        }

        void addZeros(long n) {
            this.toDZSseq();
            ConvToNewLIR.this.DZSSeq = new ImList(ConvToNewLIR.this.zeros(n), ConvToNewLIR.this.DZSSeq);
            this.seq = ImList.Empty;
        }

        void toDZSseq() {
            if (this.seq == ImList.Empty) {
                return;
            }
            ImList tmp = ConvToNewLIR.this.reverse(this.seq);
            if (this.type != null) {
                tmp = ConvToNewLIR.this.prefix(ConvToNewLIR.this.htype2ltype(this.type), tmp);
            }
            ConvToNewLIR.this.DZSSeq = new ImList(tmp, ConvToNewLIR.this.DZSSeq);
            this.seq = ImList.Empty;
        }

        Type replType(Type ty) {
            Type tmp = this.type;
            this.type = ty;
            return tmp;
        }

        long getElemSize() {
            return this.type.getSizeValue();
        }
    }
}

