/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HirRoot;
import coins.IoRoot;
import coins.driver.CoinsOptions;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.HirSeq;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabelNode;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LabeledStmtImpl;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.NullNode;
import coins.ir.hir.Program;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.sym.Label;
import coins.sym.Subp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class SimplifyHir {
    HirRoot hirRoot;
    IoRoot ioRoot;
    Subp fSubp;
    ArrayList fLabelDefToBeDeleted;
    ArrayList fStmtToBeDeleted;
    ArrayList fLabeledStmt;
    ArrayList fStmtWithMultipleLabels;
    ArrayList fLabelRef;
    HashMap fReplaceLabel;
    boolean fChanged;
    boolean fSomeSubpChanged;
    int fDbgLevel;

    public SimplifyHir(HirRoot pHirRoot, boolean pForceSimplify) {
        Map lOptionMap;
        List lKeyList;
        this.hirRoot = pHirRoot;
        this.ioRoot = this.hirRoot.ioRoot;
        Program lProgram = (Program)this.hirRoot.programRoot;
        this.fDbgLevel = this.ioRoot.dbgHir.getLevel();
        CoinsOptions lOptions = this.ioRoot.getCompileSpecification().getCoinsOptions();
        String lHirOpt = lOptions.getArg("hirOpt");
        if (!pForceSimplify && lHirOpt != null && (lKeyList = (List)(lOptionMap = lOptions.parseArgument(lHirOpt, '/', '.')).get("item_key_list")).contains("noSimplify")) {
            this.ioRoot.dbgHir.print(1, "\nDo not simplify Hir\n");
            return;
        }
        this.ioRoot.dbgHir.print(1, "\nSimplifyHir\n");
        if (this.fDbgLevel >= 4) {
            this.ioRoot.dbgHir.print(4, "HIR before simplification");
            lProgram.print(0, true);
        }
        this.fSomeSubpChanged = false;
        IrList lSubpList = lProgram.getSubpDefinitionList();
        ListIterator lIt = lSubpList.iterator();
        while (lIt.hasNext()) {
            SubpDefinition lSubpDef = (SubpDefinition)lIt.next();
            this.simplifyHir(lSubpDef.getSubpSym());
            if (!this.fChanged) continue;
            this.fSomeSubpChanged = true;
        }
        if (this.fSomeSubpChanged) {
            lProgram.finishHir();
        }
    }

    public void simplifyHir(Subp pSubp) {
        Stmt lStmtBody;
        if (pSubp == null || pSubp.getHirBody() == null) {
            return;
        }
        this.ioRoot.dbgHir.print(2, "simplifyHir", pSubp.getName());
        this.fSubp = pSubp;
        this.fSubp.buildLabelRefList();
        this.fStmtToBeDeleted = new ArrayList();
        this.fLabelDefToBeDeleted = new ArrayList();
        this.fStmtWithMultipleLabels = new ArrayList();
        this.fLabeledStmt = new ArrayList();
        this.fLabelRef = new ArrayList();
        this.fReplaceLabel = new HashMap();
        this.fChanged = false;
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pSubp.getHirBody());
        while (lHirIterator.hasNextStmt()) {
            Stmt lNode = lHirIterator.getNextStmt();
            if (lNode == null) continue;
            this.ioRoot.dbgHir.print(4, " getNextStmt", lNode.toStringShort());
            if (lNode instanceof LabeledStmt) {
                if (this.shouldHaveLabel((LabeledStmt)lNode) || this.fStmtToBeDeleted.contains(lNode) || this.fLabelDefToBeDeleted.contains(lNode)) continue;
                this.fLabeledStmt.add(lNode);
                continue;
            }
            if (lNode instanceof IfStmt) {
                this.deleteUnusedLabelsOfIfStmt((IfStmt)lNode);
                continue;
            }
            if (lNode instanceof LoopStmt) {
                this.deleteUnusedLabelsOfLoopStmt((LoopStmt)lNode);
                continue;
            }
            if (lNode instanceof JumpStmt) {
                Label lJumpLabel = ((JumpStmt)lNode).getLabel();
                Stmt lNextStmt1 = ((JumpStmt)lNode).getNextStmt();
                if (lNextStmt1 instanceof LabeledStmt && ((LabeledStmt)lNextStmt1).getLabel() == lJumpLabel) {
                    this.fStmtToBeDeleted.add(lNode);
                    continue;
                }
                if (lNextStmt1 instanceof BlockStmt && ((BlockStmt)lNextStmt1).getFirstStmt() instanceof LabeledStmt && ((BlockStmt)lNextStmt1).getFirstStmt().getLabel() == lJumpLabel) {
                    this.fStmtToBeDeleted.add(lNode);
                    continue;
                }
                this.fLabelRef.add(lNode.getChild1());
                continue;
            }
            if (!(lNode instanceof SwitchStmt)) continue;
            this.recordLabelRefOfSwitchStmt((SwitchStmt)lNode);
        }
        if (this.ioRoot.dbgHir.getLevel() >= 4) {
            this.ioRoot.dbgHir.print(4, "stmtToBeDeleted", this.fStmtToBeDeleted.toString());
            this.ioRoot.dbgHir.print(4, "labelDefToBeDeleted", this.fLabelDefToBeDeleted.toString());
            this.ioRoot.dbgHir.print(4, "fLabelRef", this.fLabelRef.toString());
        }
        for (Stmt lStmtToBeDeleted : this.fStmtToBeDeleted) {
            lStmtToBeDeleted.deleteThisStmt();
            this.fChanged = true;
        }
        for (LabeledStmt lStmtToBeChanged : this.fLabelDefToBeDeleted) {
            lStmtBody = lStmtToBeChanged.getStmt();
            if (lStmtBody != null) {
                lStmtBody.cutParentLink();
            }
            lStmtToBeChanged.replaceThisStmtWith(lStmtBody);
            this.fChanged = true;
        }
        for (LabeledStmt lLabeledStmt3 : this.fLabeledStmt) {
            Stmt lFirstStmt;
            lStmtBody = lLabeledStmt3.getStmt();
            if (lStmtBody instanceof LabeledStmt) {
                Stmt lStmtBody2 = ((LabeledStmt)lStmtBody).getStmt();
                lLabeledStmt3.merge((LabeledStmt)lStmtBody);
                if (lStmtBody2 != null) {
                    lStmtBody2.cutParentLink();
                }
                lLabeledStmt3.setStmt(lStmtBody2);
                this.fChanged = true;
            } else if (lStmtBody instanceof BlockStmt && (lFirstStmt = ((BlockStmt)lStmtBody).getFirstStmt()) instanceof LabeledStmt) {
                lLabeledStmt3.merge((LabeledStmt)lFirstStmt);
                Stmt lStmtBody3 = ((LabeledStmt)lFirstStmt).getStmt();
                if (lStmtBody3 != null) {
                    lStmtBody3.cutParentLink();
                    lFirstStmt.replaceThisStmtWith(lStmtBody3);
                } else {
                    lFirstStmt.deleteThisStmt();
                }
                this.fChanged = true;
            }
            if (lLabeledStmt3.getLabelDefList().size() <= 1) continue;
            this.fStmtWithMultipleLabels.add(lLabeledStmt3);
        }
        for (LabeledStmt lLabeledStmt4 : this.fStmtWithMultipleLabels) {
            IrList lLabelList = lLabeledStmt4.getLabelDefList();
            Label lFirstLabel = null;
            ListIterator lIter5 = lLabelList.iterator();
            while (lIter5.hasNext()) {
                LabelDef lLabelDef = (LabelDef)lIter5.next();
                Label lLabel5 = lLabelDef.getLabel();
                if (lFirstLabel == null) {
                    lFirstLabel = lLabel5;
                    continue;
                }
                this.fReplaceLabel.put(lLabel5, lFirstLabel);
            }
            IrList lNewLabelList = this.hirRoot.hir.irList();
            lNewLabelList.add(this.hirRoot.hir.labelDef(lFirstLabel));
            lLabeledStmt4.setLabelDefList(lNewLabelList);
        }
        for (LabelNode lLabelNode6 : this.fLabelRef) {
            Label lLabel6 = lLabelNode6.getLabel();
            if (!this.fReplaceLabel.containsKey(lLabel6)) continue;
            Label lLabelForReplace = (Label)this.fReplaceLabel.get(lLabel6);
            this.ioRoot.dbgHir.print(4, "replaceLabel", "of " + lLabelNode6.toStringShort() + " to " + lLabel6.getName());
            LabelNode lNewLabelNode = this.hirRoot.hir.labelNode(lLabelForReplace);
            lLabelNode6.replaceThisNode(lNewLabelNode);
            this.fChanged = true;
        }
        if (this.fChanged) {
            this.ioRoot.dbgHir.print(1, "simplifyHir", "changed HIR of " + pSubp.getName());
            if (this.ioRoot.dbgHir.getLevel() >= 3) {
                pSubp.getHirBody().print(1);
            }
        } else {
            this.ioRoot.dbgHir.print(1, "simplifyHir", "does not change HIR of " + pSubp.getName() + "\n");
        }
    }

    public void deleteUnusedLabelsOfIfStmt(IfStmt pIfStmt) {
        this.ioRoot.dbgHir.print(3, "deleteUnusedLabelsOfIfStmt", pIfStmt.toStringShort());
        this.deleteIfNull(pIfStmt.getElsePart());
        this.deleteIfNull(pIfStmt.getThenPart());
    }

    public void deleteUnusedLabelsOfLoopStmt(LoopStmt pLoopStmt) {
        LabeledStmtImpl lLoopStepLabeledStmt;
        Label lLoopStepLabel;
        this.ioRoot.dbgHir.print(3, "deleteUnusedLabelsOfLoopStmt", pLoopStmt.toStringShort());
        LabeledStmtImpl lLoopBodyPart = (LabeledStmtImpl)pLoopStmt.getLoopBodyPart();
        if (lLoopBodyPart.explicitLabelReference() == null && pLoopStmt.getLoopStartCondition() == null) {
            this.fLabelDefToBeDeleted.add(lLoopBodyPart);
        }
        if ((lLoopStepLabel = pLoopStmt.getLoopStepLabel()) != null && (lLoopStepLabeledStmt = (LabeledStmtImpl)lLoopStepLabel.getHirPosition()).explicitLabelReference() == null) {
            if (lLoopStepLabeledStmt.getStmt() == null) {
                this.fStmtToBeDeleted.add(lLoopStepLabeledStmt);
            } else {
                this.fLabelDefToBeDeleted.add(lLoopStepLabeledStmt);
            }
        }
    }

    public void recordLabelRefOfSwitchStmt(SwitchStmt pSwitchStmt) {
        HirList lJumpTable = (HirList)pSwitchStmt.getChild2().getChild1();
        LabelNode lDefault = (LabelNode)pSwitchStmt.getChild2().getChild2();
        ListIterator lListIterator = lJumpTable.iterator();
        while (lListIterator.hasNext()) {
            HirSeq lConstLabelPair = (HirSeq)lListIterator.next();
            LabelNode lCaseLabelNode = (LabelNode)lConstLabelPair.getChild2();
            this.fLabelRef.add(lCaseLabelNode);
        }
        this.fLabelRef.add(lDefault);
    }

    boolean shouldHaveLabel(LabeledStmt pStmt) {
        HIR lParent = (HIR)pStmt.getParent();
        return lParent instanceof IfStmt || lParent instanceof LoopStmt || lParent instanceof SwitchStmt || lParent instanceof SubpDefinition;
    }

    void deleteIfNull(LabeledStmt pStmt) {
        Stmt lStmt;
        if (pStmt != null && ((lStmt = pStmt.getStmt()) == null || lStmt instanceof NullNode) && ((LabeledStmtImpl)pStmt).explicitLabelReference() == null) {
            this.fStmtToBeDeleted.add(pStmt);
        }
    }
}

