/*
 * Decompiled with CFR 0.152.
 */
package coins.lir2c;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.Module;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.sym.Label;
import coins.backend.sym.SymStatic;
import coins.backend.sym.SymTab;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.lir2c.ConvValue;
import coins.lir2c.Convert;
import coins.lir2c.Decla;
import coins.lir2c.MakeDecl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;

public class LirToC {
    public PrintWriter stdout;
    public OutputStreamWriter out;
    public Module compileUnit;

    public LirToC(Module cU, String dstName) throws IOException {
        this.compileUnit = cU;
        this.stdout = new PrintWriter(new FileOutputStream(dstName), true);
    }

    public LirToC(Module cU, OutputStreamWriter fout) throws IOException {
        boolean autoFlush = true;
        this.compileUnit = cU;
        this.stdout = new PrintWriter((Writer)fout, autoFlush);
    }

    public void invoke() {
        SymTab glname = this.compileUnit.globalSymtab;
        BiList elemList = this.compileUnit.elements;
        Convert conv = new Convert();
        HashMap<String, Object> text_ldef = new HashMap<String, Object>();
        Object obj = new Object();
        ConvValue convValue = new ConvValue();
        this.stdout.println("/* Module Name = \"" + this.compileUnit.name + "\" */\n");
        HashMap isFuncOrDataMap = this.getIsFuncOrDataMap(this.compileUnit);
        BiList glList = glname.symbols();
        BiLink p = glList.first();
        while (!p.atEnd()) {
            Symbol sym = (Symbol)p.elem();
            if (sym instanceof SymStatic) {
                SymStatic symsta = (SymStatic)sym;
                if (symsta.segment.equals(".text") && symsta.linkage.equals("LDEF")) {
                    text_ldef.put(convValue.replace(symsta.name), obj);
                } else if (!symsta.linkage.equals("XREF")) {
                    if (symsta.linkage.equals("LDEF")) {
                        if (!isFuncOrDataMap.containsKey(convValue.replace(symsta.name))) {
                            this.stdout.println("// static (do decralation) " + symsta.toString());
                        }
                    } else if (symsta.linkage.equals("XDEF") && !isFuncOrDataMap.containsKey(convValue.replace(symsta.name))) {
                        this.stdout.println("//(do decralation) " + symsta.toString());
                    }
                } else {
                    String symname = convValue.replace(symsta.name);
                    if (symname.equals("printf")) {
                        this.stdout.println("#include <stdio.h>");
                    } else if (symname.equals("malloc")) {
                        this.stdout.println("#include <stdlib.h>");
                    } else if (symname.equals("sin")) {
                        this.stdout.println("#include <math.h>");
                    }
                }
            }
            p = p.next();
        }
        BiLink q = elemList.first();
        while (!q.atEnd()) {
            if (!(q.elem() instanceof Function) && q.elem() instanceof Data) {
                Decla dec;
                Symbol sym_f_or_d;
                Data data = (Data)q.elem();
                if (text_ldef.containsKey(convValue.replace(data.symbol.name))) {
                    sym_f_or_d = (Symbol)isFuncOrDataMap.get(convValue.replace(data.symbol.name));
                    dec = MakeDecl.makeDeclStatic(sym_f_or_d, data);
                    this.stdout.println("" + dec.toString() + ";");
                } else {
                    sym_f_or_d = (Symbol)isFuncOrDataMap.get(convValue.replace(data.symbol.name));
                    dec = MakeDecl.makeDeclStatic(sym_f_or_d, data);
                    this.stdout.println("" + dec.toString() + ";");
                }
            }
            q = q.next();
        }
        q = elemList.first();
        while (!q.atEnd()) {
            if (q.elem() instanceof Function) {
                Function func = (Function)q.elem();
                this.invoke2(func);
            } else if (q.elem() instanceof Data) {
                // empty if block
            }
            q = q.next();
        }
    }

    public void invoke2(Function func) {
        FlowGraph cfg = func.flowGraph();
        SymStatic sym = func.symbol;
        BiList bbl = cfg.basicBlkList;
        Convert conv = new Convert();
        ConvValue cvalue = new ConvValue();
        this.stdout.println("");
        this.stdout.print(this.getEpilogue(func) + " ");
        this.stdout.print(sym.name + "(");
        this.stdout.print(this.getPrologue(func));
        HashMap argline_hmap = this.getArgMap(func);
        this.stdout.println(") {");
        SymTab loname = func.localSymtab;
        BiList loList = loname.symbols();
        BiLink r = loList.first();
        while (!r.atEnd()) {
            Symbol symtmp = (Symbol)r.elem();
            if (!argline_hmap.containsKey(cvalue.replace(symtmp.name))) {
                String declline = MakeDecl.makeDeclAuto(symtmp) + ";";
                this.stdout.println(declline);
            }
            r = r.next();
        }
        BiLink q = bbl.first();
        while (!q.atEnd()) {
            BasicBlk blk = (BasicBlk)q.elem();
            Label bblk_label = blk.label();
            if (!bblk_label.name().equals(".blk1")) {
                this.stdout.println("\n" + bblk_label.toString().replace('.', '_') + ":");
            }
            BiList lir = blk.instrList();
            r = lir.first();
            while (!r.atEnd()) {
                LirNode lnode = (LirNode)r.elem();
                String results = conv.invoke(lnode);
                if (!(results.endsWith(":") || results.endsWith("}") || results.endsWith(";"))) {
                    if (!results.equals("")) {
                        this.stdout.println(results + ";");
                    } else {
                        this.stdout.println("");
                    }
                } else {
                    this.stdout.println(results);
                }
                r = r.next();
            }
            q = q.next();
        }
        this.stdout.println("}\n");
    }

    public void recurLirNode(LirNode root, PrintWriter stdout) {
        int n = root.nKids();
        stdout.print("(" + n);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                this.recurLirNode(root.kid(i), stdout);
            }
        }
        stdout.print(")");
    }

    public String getEpilogue(Function func) {
        String results = "";
        FlowGraph cfg = func.flowGraph();
        SymStatic sym = func.symbol;
        BiList bbl = cfg.basicBlkList;
        Convert conv = new Convert();
        BiLink q = bbl.first();
        while (!q.atEnd()) {
            BasicBlk blk = (BasicBlk)q.elem();
            BiList lir = blk.instrList();
            BiLink r = lir.first();
            while (!r.atEnd()) {
                LirNode lnode = (LirNode)r.elem();
                int opcode = lnode.opCode;
                if (opcode == 55) {
                    if (lnode.nKids() < 2) {
                        results = "void";
                    } else if (lnode.nKids() == 2) {
                        LirNode child1 = lnode.kid(1);
                        results = conv.lirToTypeStr(child1);
                    }
                }
                r = r.next();
            }
            q = q.next();
        }
        return results;
    }

    public String getPrologue(Function func) {
        String results = "";
        FlowGraph cfg = func.flowGraph();
        SymStatic sym = func.symbol;
        BiList bbl = cfg.basicBlkList;
        Convert conv = new Convert();
        BiLink q = bbl.first();
        while (!q.atEnd()) {
            BasicBlk blk = (BasicBlk)q.elem();
            BiList lir = blk.instrList();
            BiLink r = lir.first();
            while (!r.atEnd()) {
                LirNode lnode = (LirNode)r.elem();
                int opcode = lnode.opCode;
                if (opcode == 54) {
                    int num_src = lnode.nKids();
                    if (num_src < 2) {
                        results = "void";
                    } else {
                        for (int i = 1; i < num_src; ++i) {
                            LirNode child1 = lnode.kid(i);
                            results = results + conv.lirToTypeStr(child1);
                            results = results + " " + conv.dump(child1, false, lnode);
                            if (i == num_src - 1) continue;
                            results = results + ", ";
                        }
                    }
                }
                r = r.next();
            }
            q = q.next();
        }
        return results;
    }

    HashMap getArgMap(Function func) {
        String results = "";
        FlowGraph cfg = func.flowGraph();
        SymStatic sym = func.symbol;
        BiList bbl = cfg.basicBlkList;
        Convert conv = new Convert();
        HashMap<String, Object> argline_hmap = new HashMap<String, Object>();
        Object obj = new Object();
        BiLink q = bbl.first();
        while (!q.atEnd()) {
            BasicBlk blk = (BasicBlk)q.elem();
            BiList lir = blk.instrList();
            BiLink r = lir.first();
            while (!r.atEnd()) {
                int num_src;
                LirNode lnode = (LirNode)r.elem();
                int opcode = lnode.opCode;
                if (opcode == 54 && (num_src = lnode.nKids()) >= 2) {
                    for (int i = 1; i < num_src; ++i) {
                        LirNode child1 = lnode.kid(i);
                        results = conv.dump(child1, false, lnode);
                        argline_hmap.put(results, obj);
                    }
                }
                r = r.next();
            }
            q = q.next();
        }
        return argline_hmap;
    }

    HashMap getIsStaticMap(SymTab gmap) {
        HashMap<String, Object> isStat_hmap = new HashMap<String, Object>();
        String results = "";
        Object obj = new Object();
        ConvValue convValue = new ConvValue();
        BiList glList = gmap.symbols();
        BiLink p = glList.first();
        while (!p.atEnd()) {
            Symbol sym = (Symbol)p.elem();
            if (sym instanceof SymStatic) {
                SymStatic symsta = (SymStatic)sym;
                if (symsta.linkage.equals("LDEF")) {
                    isStat_hmap.put(convValue.replace(symsta.name), obj);
                }
            }
            p = p.next();
        }
        return isStat_hmap;
    }

    HashMap getIsFuncOrDataMap(Module cU) {
        HashMap<String, Object> isF_or_D_hmap = new HashMap<String, Object>();
        String results = "";
        BiList elemList = cU.elements;
        Object obj = new Object();
        ConvValue convValue = new ConvValue();
        SymTab glname = cU.globalSymtab;
        BiLink q = elemList.first();
        while (!q.atEnd()) {
            SymStatic sym;
            if (q.elem() instanceof Function) {
                Function func = (Function)q.elem();
                sym = func.symbol;
                isF_or_D_hmap.put(convValue.replace(sym.name), obj);
            } else if (q.elem() instanceof Data) {
                Data data = (Data)q.elem();
                sym = data.symbol;
                Symbol content_symbol = glname.get(sym.name);
                isF_or_D_hmap.put(convValue.replace(sym.name), content_symbol);
            }
            q = q.next();
        }
        return isF_or_D_hmap;
    }

    public static String getInitializer(Data data) {
        Convert conv = new Convert();
        String results = "";
        if (data.components.length <= 1) {
            results = results + "" + conv.invoke(data.components[0]) + "";
        } else {
            int i;
            results = results + "{";
            for (i = 0; i < data.components.length - 1; ++i) {
                results = results + "" + conv.invoke(data.components[i]) + ",";
            }
            results = results + "" + conv.invoke(data.components[i]);
            results = results + "}";
        }
        return results;
    }
}

