/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.aflow.BBlock;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import coins.aflow.UDChain;
import coins.aflow.UDList;
import coins.ir.IR;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.VarNode;
import coins.lparallel.LoopTable;
import coins.lparallel.LoopUtil;
import coins.sym.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;

class Invariant {
    private FlowResults fResults;
    private LoopTable fLoopTable;
    private HashSet finvHash;
    private SubpFlow fSubpFlow;
    private LoopUtil fUtil;

    Invariant(LoopTable pTable, SubpFlow pSubpFlow, FlowResults pResults, LoopUtil pUtil) {
        this.fResults = pResults;
        this.fSubpFlow = pSubpFlow;
        this.fUtil = pUtil;
        this.fLoopTable = pTable;
        this.finvHash = new HashSet();
        boolean change_flg = true;
        while (change_flg) {
            change_flg = false;
            ListIterator Ie = this.fLoopTable.BBlockList.listIterator();
            block1: while (Ie.hasNext()) {
                BBlock CurrBlock = (BBlock)Ie.next();
                this.fUtil.Trace("inv=" + CurrBlock.getBBlockNumber(), 5);
                SetRefReprList llist = (SetRefReprList)this.fResults.get("BBlockSetRefReprs", CurrBlock);
                this.fUtil.Trace("inv1", 5);
                if (llist == null) continue;
                Iterator Ie1 = llist.iterator();
                while (Ie1.hasNext()) {
                    Exp LeftExp;
                    Exp RightExp;
                    this.fUtil.Trace("inv2", 5);
                    SetRefRepr lSetRefRepr = (SetRefRepr)Ie1.next();
                    IR IRnode = lSetRefRepr.getIR();
                    if (IRnode == null) continue block1;
                    if (IRnode.getOperator() == 36) {
                        IRnode = ((ExpStmt)IRnode).getExp();
                    }
                    if (IRnode == null) continue block1;
                    this.fUtil.Trace("InvariantEXP=" + IRnode.toString(), 5);
                    if (IRnode.getOperator() != 22 && IRnode.getOperator() != 51 && IRnode.getOperator() != 52 && IRnode.getOperator() != 53 && IRnode.getOperator() != 54 && IRnode.getOperator() != 55 && IRnode.getOperator() != 56 || this.IsInvariant((HIR)IRnode)) continue;
                    if (IRnode.getOperator() == 22) {
                        RightExp = ((AssignStmt)IRnode).getRightSide();
                        LeftExp = ((AssignStmt)IRnode).getLeftSide();
                        RightExp = this.fUtil.SkipConv(RightExp);
                        LeftExp = this.fUtil.SkipConv(LeftExp);
                    } else {
                        if (IRnode instanceof HirList) {
                            ListIterator lListIt = ((HirList)IRnode).iterator();
                            while (lListIt.hasNext()) {
                                Object lObj = lListIt.next();
                                if (!(lObj instanceof Exp) || !this.mark_inv((Exp)lObj)) continue;
                                this.setInvariant((HIR)IRnode);
                            }
                            continue;
                        }
                        RightExp = (Exp)IRnode;
                        RightExp = this.fUtil.SkipConv(RightExp);
                        LeftExp = null;
                    }
                    if (this.mark_inv(RightExp)) {
                        this.setInvariant((HIR)IRnode);
                        if (LeftExp != null && LeftExp.getOperator() == 7 && this.fUtil.def_check(this.fLoopTable, (AssignStmt)IRnode)) {
                            change_flg = true;
                            this.setInvariant(LeftExp);
                        }
                    }
                    if (LeftExp == null || LeftExp.getOperator() != 17) continue;
                    boolean inv_flg = this.mark_inv(LeftExp);
                }
            }
        }
    }

    boolean IsInvariant(HIR node) {
        this.fUtil.Trace("IsInvariant:node=" + ((Object)node).toString(), 5);
        return this.finvHash.contains(node);
    }

    private void setInvariant(HIR node) {
        this.fUtil.Trace("Invariant:node=" + ((Object)node).toString(), 5);
        this.finvHash.add(node);
    }

    private boolean mark_inv(HIR pNode) {
        this.fUtil.Trace("mark_inv " + pNode.toStringShort(), 5);
        if (pNode instanceof HirList) {
            boolean lFlag = false;
            ListIterator lListIt = ((HirList)pNode).iterator();
            while (lListIt.hasNext()) {
                Object lObj = lListIt.next();
                if (!(lObj instanceof Exp) || !this.mark_inv((Exp)lObj)) continue;
                lFlag = true;
                this.setInvariant(pNode);
            }
            return lFlag;
        }
        Exp lNode = this.fUtil.SkipConv((Exp)pNode);
        int ChildCount = lNode.getChildCount();
        int op = lNode.getOperator();
        boolean inv_flg = false;
        if (op == 9) {
            return inv_flg;
        }
        if (ChildCount != 0) {
            inv_flg = true;
            for (int i = 1; i <= ChildCount; ++i) {
                if (this.mark_inv((HIR)lNode.getChild(i))) continue;
                inv_flg = false;
            }
            if (op == 17) {
                inv_flg = false;
            }
        } else {
            switch (op) {
                case 5: {
                    inv_flg = true;
                    break;
                }
                case 7: {
                    boolean loop_flg = true;
                    Type symType = ((VarNode)lNode).getVar().getSymType();
                    int TypeKind = symType.getTypeKind();
                    if (TypeKind == 23) {
                        inv_flg = false;
                        break;
                    }
                    this.fUtil.Trace("Invariant:UDList node=" + lNode.toString(), 5);
                    UDList invUDList = (UDList)this.fResults.get("UDList", ((VarNode)lNode).getVar(), this.fSubpFlow);
                    UDChain invUDChain = invUDList.getUDChain(lNode);
                    for (Object Node0 : invUDChain.getDefList()) {
                        if (Node0 == UDChain.UNINITIALIZED) continue;
                        if (Node0 instanceof HIR) {
                            HIR Node2 = (HIR)Node0;
                            if (Node2.getOperator() != 22) continue;
                            Exp ChildNode = ((AssignStmt)Node2).getLeftSide();
                            if (!this.fUtil.loop_body(this.fLoopTable, ChildNode = this.fUtil.SkipConv(ChildNode)) || this.IsInvariant(ChildNode)) continue;
                            loop_flg = false;
                            break;
                        }
                        this.fUtil.Trace("mark_inv non-HIR node " + Node0 + " " + Node0.getClass(), 5);
                    }
                    inv_flg = loop_flg;
                    break;
                }
                default: {
                    inv_flg = false;
                }
            }
        }
        if (inv_flg) {
            this.setInvariant(pNode);
        }
        return inv_flg;
    }
}

