/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.HirRoot;
import coins.aflow.FlowResults;
import coins.aflow.SubpFlow;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.ForStmt;
import coins.ir.hir.HIR;
import coins.lparallel.ArrayAreaAnalyzer;
import coins.lparallel.LoopTable;
import coins.lparallel.LoopUtil;
import coins.lparallel.Reduction;
import coins.lparallel.Ref_Array;
import coins.sym.Var;
import java.util.LinkedList;
import java.util.ListIterator;

public class OpenMPInfo {
    private SubpFlow fSubpFlow;
    private FlowResults fresults;
    private HIR hir;
    private LoopUtil fUtil;
    private HirRoot HirRoot;

    public OpenMPInfo(SubpFlow pSubpFlow, FlowResults presults) {
        this.fSubpFlow = pSubpFlow;
        this.fresults = presults;
        this.hir = this.fresults.flowRoot.hirRoot.hir;
        this.fUtil = new LoopUtil(this.fresults, this.fSubpFlow);
        this.HirRoot = this.fresults.flowRoot.hirRoot;
    }

    public void showLoopAnalResult() {
        ArrayAreaAnalyzer ArrayAnalysis = new ArrayAreaAnalyzer(null, this.fUtil);
        ArrayAnalysis.setFlowResults(null);
        ArrayAnalysis.setLoopExitBBlock(null);
        LinkedList LoopInfo = (LinkedList)this.fresults.get("LoopParallelList", this.fSubpFlow);
        ListIterator Ie = LoopInfo.listIterator();
        while (Ie.hasNext()) {
            LoopTable lTable = (LoopTable)Ie.next();
            this.fUtil.Trace("NestLevel=" + lTable.fNestLevel, 5);
            this.fUtil.Trace("LoopStmt " + lTable.LoopStmt.toStringShort() + " " + lTable, 5);
            if (lTable.getParaFlag(this.fUtil, "showLoopAnalResult")) {
                this.fUtil.Trace("LastPrivate", 5);
                for (Exp VarNode2 : lTable.LastPrivate) {
                    this.fUtil.Trace(VarNode2.toString(), 5);
                }
                this.fUtil.Trace("Private", 5);
                for (Exp VarNode2 : lTable.Private) {
                    this.fUtil.Trace(VarNode2.toString(), 5);
                }
                continue;
            }
            this.fUtil.Trace("VAR:true-dependence", 5);
            ListIterator Ie1 = lTable.varResultList.listIterator();
            while (Ie1.hasNext()) {
                Var var = (Var)Ie1.next();
                this.fUtil.Trace(var.getName(), 5);
            }
            ArrayAnalysis.printaryelmList("true-dependence", lTable.mod_euseResultList);
            ArrayAnalysis.printaryelmList("anti-dependence", lTable.use_modResultList);
            ArrayAnalysis.printaryelmList("output-dependence", lTable.mod_modResultList);
        }
    }

    void setPragmaInfoLoopList(LinkedList LoopInfo, boolean Child) {
        ListIterator Ie = LoopInfo.listIterator();
        while (Ie.hasNext()) {
            LoopTable lTable = (LoopTable)Ie.next();
            if (Child) {
                this.setPragmaInfoLoopList(lTable.InnerLoopList, Child);
            }
            this.setPragmaInfoLoop(lTable);
        }
    }

    void setPragmaInfoLoop(LoopTable pTable) {
        this.fUtil.Trace("---pass:setPragmaInfoLoop", 1);
        LoopTable lTable = pTable;
        this.fUtil.Trace("NestLevel=" + lTable.fNestLevel, 5);
        if (lTable.getParaFlag(this.fUtil, "setParamInfoLoop")) {
            IrList Attr = this.hir.irList();
            ForStmt hirNode = lTable.LoopStmt;
            hirNode.removeInf("coins_omp");
            hirNode.addInf("coins_omp", Attr);
            this.fUtil.Trace("#pragma", 2);
            Attr.add("#pragma omp  parallel for ");
            boolean lastExist = false;
            for (Exp ExpNode : lTable.LastPrivate) {
                if (Attr.contains(ExpNode.getVar())) continue;
                if (!lastExist) {
                    lastExist = true;
                    Attr.add(" lastprivate(");
                } else {
                    Attr.add(",");
                }
                Attr.add(ExpNode.getVar());
            }
            if (lastExist) {
                Attr.add(")");
            }
            boolean privateExist = false;
            for (Exp ExpNode : lTable.Private) {
                if (Attr.contains(ExpNode.getVar())) continue;
                if (!privateExist) {
                    privateExist = true;
                    Attr.add(" private(");
                } else {
                    Attr.add(",");
                }
                Attr.add(ExpNode.getVar());
            }
            if (privateExist) {
                Attr.add(")");
            }
            boolean Exist = false;
            for (Reduction red : lTable.ReductionADDList) {
                if (!Exist) {
                    Exist = true;
                    Attr.add(" reduction(+:");
                } else {
                    Attr.add(",");
                }
                Attr.add(red.DefVarNode.getVar());
            }
            if (Exist) {
                Attr.add(")");
            }
            Exist = false;
            for (Reduction red : lTable.ReductionMULList) {
                if (!Exist) {
                    Exist = true;
                    Attr.add(" reduction(*:");
                } else {
                    Attr.add(",");
                }
                Attr.add(red.DefVarNode.getVar());
            }
            if (Exist) {
                Attr.add(")");
            }
            Exist = false;
            for (Reduction red : lTable.ReductionSUBList) {
                if (!Exist) {
                    Exist = true;
                    Attr.add(" reduction(-:");
                } else {
                    Attr.add(",");
                }
                Attr.add(red.DefVarNode.getVar());
            }
            if (Exist) {
                Attr.add(")");
            }
        }
    }

    void setPragmaInfo() {
        LinkedList LoopInfo = (LinkedList)this.fresults.get("LoopParallelList", this.fSubpFlow);
        this.fUtil.Trace("---pass:setPragmaInfo", 1);
        this.setPragmaInfoLoopList(LoopInfo, true);
    }

    void setErrorInfoLoopList(LinkedList LoopInfo, boolean Child) {
        ListIterator Ie = LoopInfo.listIterator();
        while (Ie.hasNext()) {
            LoopTable lTable = (LoopTable)Ie.next();
            if (Child) {
                this.setErrorInfoLoopList(lTable.InnerLoopList, Child);
            }
            this.setErrorInfoLoop(lTable);
        }
    }

    public void setErrorInfoLoop(LoopTable pTable) {
        LoopTable lTable = pTable;
        this.fUtil.Trace("NestLevel=" + lTable.fNestLevel, 5);
        if (!lTable.getParaFlag(this.fUtil, "setErrorInfo")) {
            Var var;
            ListIterator Ie1;
            IrList Attr = this.makeAttribute(lTable.LoopStmt);
            if (lTable.varUnParalellLastPrivateList.size() != 0) {
                Attr.add("// loop parallelization impossible: UnParalellLastPrivate(");
                Ie1 = lTable.varUnParalellLastPrivateList.listIterator();
                while (Ie1.hasNext()) {
                    var = (Var)Ie1.next();
                    Attr.add(" ");
                    Attr.add(var);
                }
                Attr.add(")");
            }
            if (lTable.varResultList.size() != 0) {
                Attr.add("// loop parallelization impossible: true-dependence:(");
                Ie1 = lTable.varResultList.listIterator();
                while (Ie1.hasNext()) {
                    var = (Var)Ie1.next();
                    Attr.add(" ");
                    Attr.add(var);
                }
                Attr.add(")");
            }
            if (lTable.mod_euseResultList.size() != 0) {
                Attr.add("//true-dependence:(");
                this.setArrayListValue(Attr, lTable.mod_euseResultList);
                Attr.add(")");
            }
            if (lTable.use_modResultList.size() != 0) {
                Attr.add("//anti-dependence:(");
                this.setArrayListValue(Attr, lTable.use_modResultList);
                Attr.add(")");
            }
            if (lTable.mod_modResultList.size() != 0) {
                Attr.add("//output-dependence:(");
                this.setArrayListValue(Attr, lTable.mod_modResultList);
                Attr.add(")");
            }
        }
    }

    public void setErrorInfo() {
        LinkedList LoopInfo = (LinkedList)this.fresults.get("LoopParallelList", this.fSubpFlow);
        this.fUtil.Trace("---pass:setErrorInfo", 1);
        this.setErrorInfoLoopList(LoopInfo, true);
    }

    private void setArrayListValue(IrList Attr, LinkedList ArrayList2) {
        LinkedList<Var> tmplist = new LinkedList<Var>();
        ListIterator Ie = ArrayList2.listIterator();
        while (Ie.hasNext()) {
            Ref_Array ref = (Ref_Array)Ie.next();
            Var v = ref.VarNode.getVar();
            if (tmplist.contains(v)) continue;
            Attr.add(" ");
            Attr.add(v);
            tmplist.add(v);
        }
    }

    IrList makeAttribute(HIR phirNode) {
        IrList list = (IrList)phirNode.getInf("coins_omp");
        if (list == null) {
            list = this.hir.irList();
            phirNode.addInf("coins_omp", list);
        }
        return list;
    }

    private void Trace(String s) {
    }
}

