/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.PassException;
import coins.ir.IrList;
import coins.ir.hir.HIR;
import coins.mdf.DataDependence;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MdfEnvironment;
import coins.sym.FlowAnalSym;
import java.util.LinkedList;
import java.util.ListIterator;

class DeclarePragmas {
    final IrList ifdef;
    final IrList endif;
    final IrList ptest;
    final IrList parallel;

    DeclarePragmas(MdfEnvironment env, MacroFlowGraph mfg) throws PassException {
        HIR hirFact = mfg.hirRoot.hir;
        this.ifdef = hirFact.irList();
        this.ifdef.add("#ifdef _OPENMP");
        this.endif = hirFact.irList();
        this.endif.add("#endif");
        this.ptest = hirFact.irList();
        this.ptest.add("#ifdef PTEST");
        this.parallel = hirFact.irList();
        this.parallel.add("#pragma omp parallel ");
        DataDependence ddep = new DataDependence(env, mfg);
        LinkedList privateVar = ddep.threadPrivateVariable();
        if (privateVar.size() > 0) {
            this.parallel.add("private(");
            boolean first = true;
            ListIterator ite = privateVar.listIterator();
            while (ite.hasNext()) {
                FlowAnalSym s = (FlowAnalSym)ite.next();
                if (first) {
                    this.parallel.add(s.getName());
                    first = false;
                    continue;
                }
                this.parallel.add("," + s.getName());
            }
            this.parallel.add(") ");
        }
        this.parallel.add("firstprivate(");
        this.parallel.add(mfg.taskSym.getName() + "," + mfg.idSym.getName());
        this.parallel.add(")");
    }
}

