/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.IoRoot;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Trace;
import java.io.PrintStream;

public class MdfEnvironment {
    public static final int MsgThr = 100;
    public static final int MinThr = 1000;
    public static final int MdfThr = 1500;
    public static final int OptThr = 2000;
    public static final int AllThr = 10000;
    public static final int DEFAULT_NUM_THREADS = 2;
    public final PrintStream output;
    public final CompileSpecification spec;
    public final CoinsOptions opt;
    public final IoRoot ioRoot;
    public final Trace trace;
    public final String MODULENAME = "MDF";

    public MdfEnvironment(IoRoot root, CompileSpecification coinsSpec) {
        this.ioRoot = root;
        this.output = this.ioRoot.printOut;
        this.spec = coinsSpec;
        this.opt = this.spec.getCoinsOptions();
        this.trace = this.spec.getTrace();
    }

    boolean shouldDo(int threshold) {
        return this.trace.shouldTrace("MDF", threshold);
    }

    void println(String str, int threshold) {
        if (this.shouldDo(threshold)) {
            this.output.println(str);
        }
    }

    void print(String str, int threshold) {
        if (this.shouldDo(threshold)) {
            this.output.print(str);
        }
    }
}

