/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.HirRoot;
import coins.PassException;
import coins.ir.IrList;
import coins.ir.hir.Program;
import coins.ir.hir.SubpDefinition;
import coins.mdf.ChangeStructure;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MdfEnvironment;
import coins.mdf.ReconstructHir;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class MdfModule {
    private final IrList subpDefList;
    private MdfEnvironment env;
    private HirRoot hirRoot;
    public final List flowGraph;

    MdfModule(MdfEnvironment e, HirRoot hRoot) {
        this.env = e;
        this.hirRoot = hRoot;
        this.subpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        this.flowGraph = new LinkedList();
    }

    void generateMfg() throws PassException {
        ListIterator subpDefIterator = this.subpDefList.iterator();
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            if ((!this.env.opt.isSet("mdf-only-main") || !subpDef.getSubpSym().getName().equals("main")) && this.env.opt.isSet("mdf-only-main")) continue;
            this.env.println("MDF : doing " + subpDef.getSubpSym().getName(), 2000);
            this.hirRoot.symRoot.symTableCurrent = subpDef.getSymTable();
            ReconstructHir reconst = new ReconstructHir(this.env, this.hirRoot, subpDef);
            this.env.println("MDF : reconstruct done for " + subpDef.getSubpSym().getName(), 2000);
            MacroFlowGraph mfg = new MacroFlowGraph(this.env, this.hirRoot, subpDef);
            this.flowGraph.add(mfg);
            this.env.println("MDF : generated for " + subpDef.getSubpSym().getName(), 2000);
            ChangeStructure changeStructure = new ChangeStructure(this.env, mfg);
            this.env.println("MDF : changed for " + subpDef.getSubpSym().getName(), 2000);
        }
    }

    void changeStructure() throws PassException {
        for (MacroFlowGraph mfg : this.flowGraph) {
            ChangeStructure changeStructure = new ChangeStructure(this.env, mfg);
        }
    }

    boolean check() {
        ListIterator subpDefIterator = this.subpDefList.iterator();
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            subpDef.setIndexNumberToAllNodes(0);
            if (subpDef.isTree()) continue;
            this.env.output.println("NOT TREE");
            return true;
        }
        return false;
    }
}

