/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.Debug;
import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.driver.CoinsOptions;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.VarNode;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class LoopExpansion {
    protected HirRoot hirRoot;
    protected FlowRoot flowRoot;
    protected SymRoot symRoot;
    protected IoRoot ioRoot;
    protected Map fOptionMap;
    protected CoinsOptions fOptions;
    protected int fNumberOfGeneralRegisters;
    protected int fMaxAllowableNodesInLoopBody;
    protected int fDbgLevel;
    private int fMaxAllowableStmtsInLoopBody;

    public int getMaxAllowableStmtsInLoopBody() {
        return this.fMaxAllowableStmtsInLoopBody;
    }

    public void setMaxAllowableStmtsInLoopBody(int pMaxAllowableStmtCount) {
        this.fMaxAllowableStmtsInLoopBody = pMaxAllowableStmtCount;
    }

    protected LoopExpansion(HirRoot phirRoot) {
        this.hirRoot = phirRoot;
        this.symRoot = phirRoot.symRoot;
        this.ioRoot = phirRoot.ioRoot;
        this.flowRoot = this.hirRoot.getFlowRoot();
        this.flowRoot.setFlowAnalOption(13, true);
        this.fDbgLevel = this.ioRoot.dbgOpt1.getLevel();
        this.fOptions = this.ioRoot.getCompileSpecification().getCoinsOptions();
        String lOptArg = this.fOptions.getArg("hirOpt");
        this.fOptionMap = this.fOptions.parseArgument(lOptArg, '/', '.');
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgOpt1.print(2, "\n Option map " + this.fOptionMap);
        }
        this.fNumberOfGeneralRegisters = this.ioRoot.machineParam.getNumberOfGeneralRegisters();
        this.setMaxAllowableStmtsInLoopBody(6);
    }

    public abstract boolean doSubprogram(SubpDefinition var1);

    protected Debug getDebug() {
        return this.ioRoot.dbgOpt1;
    }

    protected Exp getSimpleExp(Exp pExp) {
        while (pExp.getOperator() == 65 || pExp.getOperator() == 67) {
            pExp = pExp.getExp1();
        }
        return pExp;
    }

    protected boolean isBadElement(HIR hirElement) {
        Type type;
        String lMethodName = "isBadElement";
        if (hirElement.getOperator() == 33) {
            this.getDebug().print(3, "isBadElement", "Call statement is found.");
            return true;
        }
        if (hirElement.getOperator() == 28) {
            this.getDebug().print(3, "isBadElement", "Jump statement is found.");
            return true;
        }
        Sym sym = hirElement.getSym();
        if (sym != null && (type = sym.getSymType()) != null && type.isVolatile()) {
            this.getDebug().print(3, "isBadElement", "Volatile sym is found.");
            return true;
        }
        return false;
    }

    protected boolean hasBadElement(Stmt pStmt) {
        String lMethodName = "hasBadElement";
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pStmt);
        while (lHirIterator.hasNext()) {
            HIR lnode = lHirIterator.next();
            if (lnode == null || !this.isBadElement(lnode)) continue;
            return true;
        }
        return false;
    }

    protected int calcStatementCount(Stmt pStmt) {
        int cnt = 0;
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pStmt);
        while (lHirIterator.hasNextStmt()) {
            Stmt lnode = lHirIterator.getNextStmt();
            if (lnode == null || lnode instanceof LabeledStmt || lnode instanceof BlockStmt) continue;
            ++cnt;
        }
        return cnt;
    }

    protected Var getArrayVar(SubscriptedExp Subs) {
        Exp simpleExp;
        String lMethodName = "getSubscriptedVar";
        Var lVar = null;
        Exp arrayExp = Subs.getArrayExp();
        if (arrayExp instanceof SubscriptedExp) {
            lVar = this.getArrayVar((SubscriptedExp)arrayExp);
        }
        lVar = (simpleExp = this.getSimpleExp(arrayExp)) instanceof Var ? (Var)((Object)simpleExp) : null;
        this.getDebug().print(6, "getSubscriptedVar", "getArrayVar var:" + lVar);
        return lVar;
    }

    protected Set getSubscriptVar(SubscriptedExp Subs) {
        String lMethodName = "getSubscriptedVar";
        HashSet<Var> lVarSet = new HashSet<Var>();
        Exp arrayExp = Subs.getArrayExp();
        if (arrayExp instanceof SubscriptedExp) {
            lVarSet.addAll(this.getSubscriptVar((SubscriptedExp)arrayExp));
        }
        HirIterator lIt = this.hirRoot.hir.hirIterator(Subs.getSubscriptExp());
        while (lIt.hasNext()) {
            Var lVar;
            HIR lNode = lIt.next();
            if (!(lNode instanceof VarNode) || (lVar = ((VarNode)lNode).getVar()) == null) continue;
            lVarSet.add(lVar);
        }
        this.getDebug().print(6, "getSubscriptedVar", "subcripted vars:" + lVarSet);
        return lVarSet;
    }
}

