/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Type;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.util.IntBound;
import coins.util.IntConst;
import java.util.Enumeration;
import java.util.Hashtable;

public class BoundanalysisUwForLir {
    private Function function;
    private Hashtable boundTableUW;

    BoundanalysisUwForLir(Function f) {
        this.function = f;
        this.boundTableUW = new Hashtable();
    }

    public void boundanalysisUw(LirNode ins) {
        this.eval(ins, this.boundTableUW);
    }

    public IntBound eval(LirNode ins, Hashtable tbl) {
        IntBound result = (IntBound)tbl.get(ins);
        if (result != null) {
            return result;
        }
        int code = ins.opCode;
        switch (code) {
            case 2: {
                long v = ((LirIconst)ins).value;
                IntConst c = IntConst.valueOf(Type.bits(ins.type), v);
                return new IntBound(c);
            }
            case 4: 
            case 5: 
            case 6: {
                IntConst min = this.typeToIntConstMin(ins.type);
                IntConst max = this.typeToIntConstMax(ins.type);
                IntBound b = new IntBound(min, max);
                tbl.put(ins, b);
                return b;
            }
            case 9: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = b0.neg();
                tbl.put(ins, b1);
                return b1;
            }
            case 30: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = b0.bnot();
                tbl.put(ins, b1);
                return b1;
            }
            case 17: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = b0.convsx(Type.bits(ins.type));
                tbl.put(ins, b1);
                return b1;
            }
            case 18: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = b0.convzx(Type.bits(ins.type));
                tbl.put(ins, b1);
                return b1;
            }
            case 19: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = b0.convit(Type.bits(ins.type));
                tbl.put(ins, b1);
                return b1;
            }
            case 47: {
                this.eval(ins.kid(0), tbl);
                IntConst min = this.typeToIntConstMin(ins.type);
                IntConst max = this.typeToIntConstMax(ins.type);
                IntBound b = new IntBound(min, max);
                tbl.put(ins, b);
                return b;
            }
            case 10: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.add(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 11: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.sub(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 12: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.mul(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 13: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.divs(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 14: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.divu(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 15: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.mods(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 16: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.modu(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 27: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.band(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 28: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.bor(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 29: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.bxor(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 31: 
            case 32: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.lsh(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 33: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.rshs(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 34: {
                IntBound b0 = this.eval(ins.kid(0), tbl);
                IntBound b1 = this.eval(ins.kid(1), tbl);
                IntBound b2 = b0.rshu(b1);
                tbl.put(ins, b2);
                return b2;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.eval(ins.kid(0), tbl);
                this.eval(ins.kid(1), tbl);
                IntConst c = IntConst.valueOf(Type.bits(ins.type), 1L);
                IntBound b = new IntBound(c);
                tbl.put(ins, b);
                return b;
            }
            case 48: {
                this.eval(ins.kid(1), tbl);
                return null;
            }
        }
        return null;
    }

    private IntConst typeToIntConstMax(int type) {
        int s = Type.bits(type);
        switch (s) {
            case 8: {
                return IntConst.valueOf(8, 255L);
            }
            case 16: {
                return IntConst.valueOf(16, 65535L);
            }
            case 32: {
                return IntConst.valueOf(32, 0xFFFFFFFFL);
            }
            case 64: {
                return IntConst.valueOf(64, -1L);
            }
        }
        return null;
    }

    private IntConst typeToIntConstMin(int type) {
        return IntConst.valueOf(Type.bits(type), 0L);
    }

    public void show() {
        if (this.boundTableUW != null) {
            Enumeration keys = this.boundTableUW.keys();
            while (keys.hasMoreElements()) {
                LirNode nd = (LirNode)keys.nextElement();
                System.out.println("KEY:" + nd.toString());
                IntBound bd = (IntBound)this.boundTableUW.get(nd);
                System.out.println("BOUND:" + bd.toString());
            }
        }
    }

    public IntBound get(LirNode e) {
        return (IntBound)this.boundTableUW.get(e);
    }

    public void put(LirNode e, IntBound b) {
        this.boundTableUW.put(e, b);
    }
}

