/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.simd.SimdEnvironment;
import coins.simd.Util;
import java.util.Hashtable;

class GenerateDag {
    private SimdEnvironment env;
    private Function f;
    private Hashtable instTable;

    GenerateDag(SimdEnvironment e, Function func) {
        this.env = e;
        this.f = func;
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            this.invoke(blk);
            p = p.next();
        }
    }

    void invoke(BasicBlk blk) {
        Util util = new Util();
        LiveVariableAnalysis liveAna = (LiveVariableAnalysis)this.f.require(LiveVariableSlotwise.analyzer);
        this.instTable = new Hashtable();
        BiLink p = blk.instrList().first();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            switch (node.opCode) {
                case 48: {
                    BiList list;
                    this.replace(node.kid(1), node, 1);
                    if (node.kid((int)0).opCode != 6) {
                        this.replace(node.kid(0), node, 0);
                    }
                    if ((list = util.findTargetLir(node, 47, new BiList())).length() == 0) {
                        LirNode n = (LirNode)this.instTable.get(node.kid(0));
                        if (n != null) {
                            this.instTable.remove(node.kid(0));
                        }
                        this.instTable.put(node.kid(0), node.kid(1));
                        break;
                    }
                    if (node.kid((int)0).opCode != 6) break;
                    this.instTable.remove(node.kid(0));
                    break;
                }
            }
            p = p.next();
        }
        BiList liveOut = liveAna.liveOut(blk);
        BiLink p2 = blk.instrList().last();
        while (!p2.atEnd()) {
            LirNode node = (LirNode)p2.elem();
            if (node.opCode == 48) {
                if (node.kid((int)0).opCode == 6 && liveOut.contains(((LirSymRef)node.kid((int)0)).symbol)) {
                    liveOut.remove(((LirSymRef)node.kid((int)0)).symbol);
                } else if (util.findTargetLir(node, 47, new BiList()).length() == 0) {
                    boolean used = false;
                    BiLink q = p2.next();
                    while (!q.atEnd()) {
                        LirNode nn;
                        BiLink pp;
                        BiList list;
                        LirNode n = (LirNode)q.elem();
                        if (n.opCode == 48) {
                            if (n.kid((int)0).opCode == 6) {
                                list = util.findTargetLir(n.kid(1), 6, new BiList());
                                pp = list.first();
                                while (!pp.atEnd()) {
                                    nn = (LirNode)pp.elem();
                                    if (nn.equals(node.kid(0))) {
                                        used = true;
                                        break;
                                    }
                                    pp = pp.next();
                                }
                                if (used || n.kid(0).equals(node.kid(0))) {
                                    break;
                                }
                            } else {
                                list = util.findTargetLir(n, 6, new BiList());
                                pp = list.first();
                                while (!pp.atEnd()) {
                                    nn = (LirNode)pp.elem();
                                    if (nn.equals(node.kid(0))) {
                                        used = true;
                                        break;
                                    }
                                    pp = pp.next();
                                }
                                if (used) {
                                    break;
                                }
                            }
                        } else {
                            list = util.findTargetLir(n, 6, new BiList());
                            pp = list.first();
                            while (!pp.atEnd()) {
                                nn = (LirNode)pp.elem();
                                if (nn.equals(node.kid(0))) {
                                    used = true;
                                    break;
                                }
                                pp = pp.next();
                            }
                            if (used) break;
                        }
                        q = q.next();
                    }
                    if (!used) {
                        p2.unlink();
                    }
                }
            }
            p2 = p2.prev();
        }
        this.f.touch();
    }

    private void replace(LirNode node, LirNode parent, int place) {
        LirNode replaced = (LirNode)this.instTable.get(node);
        if (replaced != null) {
            parent.setKid(place, replaced.makeCopy(this.env.lir));
        } else {
            for (int i = 0; i < node.nKids(); ++i) {
                this.replace(node.kid(i), node, i);
            }
        }
    }
}

