/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.lir.LirNode;
import coins.simd.LirDefUseRel;
import coins.simd.LirOrder;
import coins.simd.ReplaceRegNames;
import coins.simd.SimdOptException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class LirRearrange {
    private LirDefUseRel duRel = new LirDefUseRel();
    private LirOrder order = new LirOrder();
    private Vector out;

    public Vector invoke(Vector lirs, ReplaceRegNames rrn) {
        this.out = new Vector();
        try {
            return this.rearrange(lirs, rrn);
        }
        catch (SimdOptException e) {
            if (e.getMessage().equals("Lir ordering destroyed.")) {
                Vector newlirs = this.chkAndMerge(lirs, this.out);
                try {
                    this.duRel = new LirDefUseRel();
                    this.order = new LirOrder();
                    this.out = new Vector();
                    Vector result = this.rearrange(newlirs, rrn);
                    return result;
                }
                catch (SimdOptException e2) {
                    return lirs;
                }
            }
            return lirs;
        }
    }

    private Vector rearrange(Vector lirs, ReplaceRegNames rrn) throws SimdOptException {
        int size = lirs.size();
        int counter = 0;
        this.duRel.mkDefUseRel(lirs);
        this.addNtmapToDuRel(rrn);
        LinkedList<LirNode> que = new LinkedList<LirNode>();
        this.getRoots(que);
        while (que.size() > 0) {
            Vector children;
            if (counter > 2 * size) {
                throw new SimdOptException("Lir ordering destroyed.");
            }
            Object obj = que.getFirst();
            if (!(obj instanceof LirNode)) continue;
            LirNode e = (LirNode)obj;
            Vector parents = this.getParents(e);
            if (parents == null || this.out.containsAll(parents)) {
                this.out.addElement(e);
                que.removeFirst();
                children = this.getChildren(e);
                this.append(que, children);
                counter = 0;
                continue;
            }
            que.removeFirst();
            children = this.getChildren(e);
            this.append(que, children);
            que.addLast(e);
            ++counter;
        }
        return this.out;
    }

    private void getRoots(List ls) {
        this.duRel.getRoots(ls);
    }

    private Vector getParents(LirNode e) {
        return this.duRel.getParents(e);
    }

    private Vector getChildren(LirNode e) {
        return this.duRel.getChildren(e);
    }

    private void append(List ls, Vector v) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            if (ls.contains(v.elementAt(i))) continue;
            ls.add(v.elementAt(i));
        }
    }

    private void addNtmapToDuRel(ReplaceRegNames rrn) throws SimdOptException {
        Collection s = rrn.getNtmap();
        for (List ls : s) {
            while (ls.size() > 1) {
                LirNode e = (LirNode)ls.get(0);
                ls.remove(0);
                for (int i = 0; i < ls.size(); ++i) {
                    Vector us = this.duRel.getUseLirs(e);
                    Vector ds = this.duRel.getDefLirs((LirNode)ls.get(i));
                    this.addToRel(us, ds);
                }
            }
        }
    }

    private void addToRel(Vector v1, Vector v2) throws SimdOptException {
        if (v1 != null && v2 != null) {
            for (int i = 0; i < v1.size(); ++i) {
                for (int j = 0; j < v2.size(); ++j) {
                    LirNode e2;
                    LirNode e1 = (LirNode)v1.elementAt(i);
                    if (e1 == (e2 = (LirNode)v2.elementAt(j))) continue;
                    this.duRel.add(e1, e2);
                }
            }
        }
    }

    private void mkOrdering(Vector lirs, ReplaceRegNames rrn) throws SimdOptException {
        this.order.put(this.duRel.getRelation());
        this.order.saturate();
    }

    private Vector chkAndMerge(Vector lirs, Vector res) {
        int i;
        Vector<LirNode> vtmp = new Vector<LirNode>();
        for (i = 0; i < lirs.size(); ++i) {
            LirNode e = (LirNode)lirs.elementAt(i);
            if (res.contains(e)) continue;
            if (e.opCode == 56) {
                for (int j = 0; j < e.nKids(); ++j) {
                    vtmp.addElement(e.kid(j));
                }
                continue;
            }
            vtmp.addElement(e);
        }
        for (i = 0; i < res.size(); ++i) {
            vtmp.addElement((LirNode)res.elementAt(i));
        }
        return vtmp;
    }
}

