/*
 * Decompiled with CFR 0.152.
 */
package coins.snapshot;

import coins.aflow.BBlock;
import coins.aflow.BBlockSubtreeIterator;
import coins.backend.util.BiList;
import coins.snapshot.StatementType;

class StatementTag {
    private StatementType hir;
    private StatementType lir;
    private StatementType hir2c;
    private StatementType lir2c;

    StatementTag(BiList instr) {
        this.hir = null;
        this.hir2c = null;
        this.lir = StatementType.lir(instr);
        this.lir2c = StatementType.lir2c(instr);
    }

    StatementTag(BBlockSubtreeIterator ite) {
        this.hir = StatementType.hir(ite);
        this.hir2c = null;
        this.lir = null;
        this.lir2c = null;
    }

    StatementTag(BBlock[] blks) {
        this.hir = StatementType.mdf(blks);
        this.hir2c = null;
        this.lir = null;
        this.lir2c = null;
    }

    public String toString(int space) {
        String ws = "";
        for (int i = 0; i < space; ++i) {
            ws = ws + "  ";
        }
        String str = "";
        if (this.hir != null && !this.hir.toString().equals("")) {
            str = str + ws + "<" + "hir" + ">\n";
            str = str + this.hir.toString(space + 1);
            str = str + ws + "</" + "hir" + ">\n";
        }
        if (this.lir != null && !this.lir.toString().equals("")) {
            str = str + ws + "<" + "lir" + ">\n";
            str = str + this.lir.toString(space + 1);
            str = str + ws + "</" + "lir" + ">\n";
        }
        if (this.hir2c != null && !this.hir2c.toString().equals("")) {
            str = str + ws + "<" + "hir2c" + ">\n";
            str = str + this.hir2c.toString(space + 1);
            str = str + ws + "</" + "hir2c" + ">\n";
        }
        if (this.lir2c != null && !this.lir2c.toString().equals("")) {
            str = str + ws + "<" + "lir2c" + ">\n";
            str = str + this.lir2c.toString(space + 1);
            str = str + ws + "</" + "lir2c" + ">\n";
        }
        return str;
    }

    public String toString() {
        return this.toString(0);
    }
}

