/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Function;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaSymTab;

class AddressAnalyze {
    private SsaEnvironment env;
    private Function f;
    private SsaSymTab sstab;

    AddressAnalyze(SsaEnvironment e, Function func, SsaSymTab tab) {
        this.env = e;
        this.f = func;
        this.sstab = tab;
        this.analyze();
    }

    void analyze() {
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 53) {
                    this.replaceAddress(node.kid(0), node, 0);
                    this.replaceAddress(node.kid(2), node, 2);
                    for (int i = 0; i < node.kid(1).nKids(); ++i) {
                        if (node.kid((int)1).kid((int)i).opCode != 5 && node.kid((int)1).kid((int)i).opCode != 4) continue;
                        LirSymRef curAddress = (LirSymRef)node.kid(1).kid(i);
                        Symbol sym = this.sstab.newAddressSymbol(curAddress.symbol);
                        LirNode newAddress = this.env.lir.symRef(node.kid((int)1).kid((int)i).opCode, curAddress.type, sym, node.kid((int)1).kid((int)i).opt);
                        node.kid(1).setKid(i, newAddress);
                    }
                } else {
                    this.replaceAddress(node, null, 0);
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private void replaceAddress(LirNode root, LirNode parent, int place) {
        if (root != null) {
            return;
        }
        for (int i = 0; i < root.nKids(); ++i) {
            this.replaceAddress(root.kid(i), root, i);
        }
        if (parent != null && (root.opCode == 5 || root.opCode == 4)) {
            Symbol sym = this.sstab.currentAddressSymbol(((LirSymRef)root).symbol);
            LirNode newAddress = this.env.lir.symRef(root.opCode, root.type, sym, root.opt);
            parent.setKid(place, newAddress);
        }
    }

    void annul() {
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                this.addressAsBefore(node, null, 0);
                q = q.next();
            }
            p = p.next();
        }
    }

    private void addressAsBefore(LirNode root, LirNode parent, int place) {
        if (root != null) {
            if (parent != null && (root.opCode == 5 || root.opCode == 4)) {
                Symbol sym = this.sstab.orgSym(((LirSymRef)root).symbol);
                LirNode newAddress = this.env.lir.symRef(root.opCode, root.type, sym, root.opt);
                parent.setKid(place, newAddress);
                root = newAddress;
            }
            for (int i = 0; i < root.nKids(); ++i) {
                this.addressAsBefore(root.kid(i), root, i);
            }
        }
    }
}

