/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Function;
import coins.backend.ana.DominanceFrontiers;
import coins.backend.ana.Dominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import coins.ssa.Util;
import java.util.Hashtable;
import java.util.Stack;

class MemoryAliasAnalyze {
    private SsaEnvironment env;
    public static final int THR = 2000;
    private Function f;
    private Stack stack;
    private Dominators dom;
    private Util util;
    private long nextNum;
    private boolean[] offset;
    private long[] blkRank;
    private Hashtable callMap;

    MemoryAliasAnalyze(SsaEnvironment e, Function function) {
        this.f = function;
        this.env = e;
        this.nextNum = 0L;
        this.callMap = new Hashtable();
        this.stack = new Stack();
        this.blkRank = new long[this.f.flowGraph().idBound()];
        for (int i = 0; i < this.f.flowGraph().idBound(); ++i) {
            this.blkRank[i] = this.nextNum;
        }
        this.stack.push(this.env.lir.iconst(0, this.nextNum++, ImList.Empty));
        this.util = new Util(this.env, this.f);
        this.dom = (Dominators)this.f.require(Dominators.analyzer);
        this.setOffset();
        this.markMem(this.f.flowGraph().entryBlk());
        this.f.touch();
    }

    long blkRank(BasicBlk blk) {
        return this.blkRank[blk.id];
    }

    private void setOffset() {
        this.offset = new boolean[this.f.flowGraph().idBound()];
        DominanceFrontiers df = (DominanceFrontiers)this.f.require(DominanceFrontiers.analyzer);
        for (int i = 0; i < this.offset.length; ++i) {
            this.offset[i] = false;
        }
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 48 && node.kid((int)0).opCode == 47 || node.opCode == 53) {
                    BiLink r = df.frontiers[blk.id].first();
                    while (!r.atEnd()) {
                        BasicBlk frontier = (BasicBlk)r.elem();
                        this.markFrontier(frontier);
                        r = r.next();
                    }
                    break;
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private void markFrontier(BasicBlk blk) {
        if (this.offset[blk.id]) {
            return;
        }
        this.offset[blk.id] = true;
        DominanceFrontiers df = (DominanceFrontiers)this.f.require(DominanceFrontiers.analyzer);
        BiLink r = df.frontiers[blk.id].first();
        while (!r.atEnd()) {
            BasicBlk frontier = (BasicBlk)r.elem();
            this.markFrontier(frontier);
            r = r.next();
        }
    }

    long callThreshold(LirNode call) {
        if (call.opCode != 53) {
            return -1L;
        }
        Long callID = new Long(call.id);
        Long val = (Long)this.callMap.get(callID);
        if (val == null) {
            return -1L;
        }
        return val;
    }

    private void markMem(BasicBlk blk) {
        int count = 0;
        if (this.offset[blk.id]) {
            LirNode suffix = this.env.lir.iconst(0, this.nextNum++, ImList.Empty);
            ++count;
            this.stack.push(suffix);
        }
        BiLink p = blk.instrList().first();
        while (!p.atEnd()) {
            LirNode suffix;
            LirNode node = (LirNode)p.elem();
            if (node.opCode != 59 && node.opCode != 54) {
                switch (node.opCode) {
                    case 53: {
                        this.replaceMem(node.kid(0), node, 0);
                        this.replaceMem(node.kid(1), node, 1);
                        if (node.kid(2).nKids() > 0 && node.kid((int)2).kid((int)0).opCode == 47) {
                            this.replaceMem(node.kid(2).kid(0).kid(0), node.kid(2).kid(0), 0);
                        } else {
                            this.replaceMem(node.kid(2), node, 2);
                        }
                        this.callMap.put(new Long(node.id), new Long(this.nextNum));
                        suffix = this.env.lir.iconst(0, this.nextNum++, ImList.Empty);
                        this.stack.push(suffix);
                        ++count;
                        break;
                    }
                    case 48: {
                        if (node.kid((int)0).opCode == 47) {
                            this.replaceMem(node.kid(0).kid(0), node.kid(0), 0);
                        }
                        this.replaceMem(node.kid(1), node, 1);
                        break;
                    }
                    default: {
                        this.replaceMem(node, null, 0);
                    }
                }
            }
            if (node.opCode == 54) {
                for (int i = 1; i < node.nKids(); ++i) {
                    if (node.kid((int)i).opCode != 47) continue;
                    LirNode suffix2 = this.env.lir.iconst(0, this.nextNum++, ImList.Empty);
                    ++count;
                    LirNode copyNode = node.kid(i).kid(0).makeCopy(this.env.lir);
                    LirNode newMem = this.env.lir.operator(47, node.kid((int)i).type, copyNode, suffix2, node.kid((int)i).opt);
                    node.setKid(i, newMem);
                    this.stack.push(suffix2);
                }
            } else if (node.opCode == 48 && node.kid((int)0).opCode == 47 || node.opCode == 53 && node.kid(2).nKids() > 0 && node.kid((int)2).kid((int)0).opCode == 47) {
                LirNode newMem;
                LirNode copyNode;
                suffix = this.env.lir.iconst(0, this.nextNum++, ImList.Empty);
                ++count;
                if (node.opCode == 48) {
                    copyNode = node.kid(0).kid(0).makeCopy(this.env.lir);
                    newMem = this.env.lir.operator(47, node.kid((int)0).type, copyNode, suffix, node.kid((int)1).opt);
                    node.setKid(0, newMem);
                } else {
                    copyNode = node.kid(2).kid(0).kid(0).makeCopy(this.env.lir);
                    newMem = this.env.lir.operator(47, node.kid((int)2).kid((int)0).type, copyNode, suffix, node.kid((int)2).kid((int)0).opt);
                    node.kid(2).setKid(0, newMem);
                }
                this.stack.push(suffix);
            }
            p = p.next();
        }
        this.blkRank[blk.id] = this.nextNum - 1L;
        p = this.dom.kids[blk.id].first();
        while (!p.atEnd()) {
            this.markMem((BasicBlk)p.elem());
            p = p.next();
        }
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.stack.pop();
            }
        }
    }

    private void replaceMem(LirNode root, LirNode parent, int place) {
        if (root != null) {
            for (int i = 0; i < root.nKids(); ++i) {
                this.replaceMem(root.kid(i), root, i);
            }
            if (parent != null && root.opCode == 47) {
                LirNode suffix = (LirNode)this.stack.peek();
                LirNode newMem = this.env.lir.operator(47, root.type, root.kid(0), suffix.makeCopy(this.env.lir), root.opt);
                this.env.println("MAA : " + root + " ---> " + newMem, 10000);
                parent.setKid(place, newMem);
                root = newMem;
            }
        }
    }

    void annul() {
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                this.memAsBefore(node, null, 0);
                q = q.next();
            }
            p = p.next();
        }
        this.f.touch();
    }

    private void memAsBefore(LirNode root, LirNode parent, int place) {
        if (root != null) {
            if (parent != null && root.opCode == 47) {
                LirNode newMem = this.env.lir.operator(47, root.type, root.kid(0), root.opt);
                this.env.println("MAA : annul " + newMem, 10000);
                parent.setKid(place, newMem);
                root = newMem;
            }
            for (int i = 0; i < root.nKids(); ++i) {
                this.memAsBefore(root.kid(i), root, i);
            }
        }
    }
}

