/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FileName {
    public static final String version = "FileName 0.1";
    public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
    public static final String copyright = "(c) 2003/06/27 All right reserved.";

    public static String getExt(String file) {
        StringTokenizer st = new StringTokenizer(file, ".");
        String[] inputs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            inputs[i] = st.nextToken();
            ++i;
        }
        return inputs[inputs.length - 1];
    }

    public static Object[] expandWildExpression(File pdir, String input) {
        String absname = FileName.toAbsPathName(pdir.getAbsolutePath(), input);
        String name = FileName.getLast(absname);
        int index = name.indexOf(42);
        if (index < 0) {
            Object[] strs = new String[]{absname};
            return strs;
        }
        name = name.replaceAll("\\.", "\\\\.");
        name = name.replaceAll("\\^", "\\\\^");
        name = name.replaceAll("\\$", "\\\\$");
        name = name.replaceAll("\\?", "\\\\?");
        name = name.replaceAll("\\+", "\\\\+");
        name = name.replaceAll("\\|", "\\\\|");
        name = name.replaceAll("\\*", ".*");
        Pattern pattern = Pattern.compile(name);
        String[] files = pdir.list();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            if (!pattern.matcher(files[i]).matches()) continue;
            list.add(FileName.toAbsPathName(pdir.getAbsolutePath(), files[i]));
        }
        return list.toArray();
    }

    public static boolean isRegularFileName(String str) {
        int result = -1;
        result = str.indexOf(42);
        return result < 0;
    }

    public static String toAbsDirName(String parent, String current) {
        String absdir = current.charAt(0) == '/' ? current : parent.concat(current);
        if ((absdir = FileName.toParse(absdir)).charAt(absdir.length() - 1) != '/') {
            absdir = absdir.concat("/");
        }
        return absdir;
    }

    public static String toAbsPathName(String pdir, String input) {
        if (input.charAt(0) == '/') {
            return FileName.toParse(input);
        }
        return FileName.toParse(pdir.concat(input));
    }

    public static String toParse(String path) {
        String[] paths = FileName.trim(path);
        if (paths.length == 0) {
            return "/";
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].equals(".")) continue;
            if (paths[i].equals("..")) {
                if (stack.empty()) continue;
                stack.pop();
                continue;
            }
            stack.push(paths[i]);
        }
        String str = "/";
        while (!stack.empty()) {
            str = ((String)stack.pop()).concat(str);
            str = "/".concat(str);
        }
        return str;
    }

    public static String[] trim(String filename) {
        StringTokenizer st = new StringTokenizer(filename.trim(), "/");
        String[] names = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            names[i] = st.nextToken();
            ++i;
        }
        return names;
    }

    public static String getLongFileName(String[] inputs, int offset) {
        String concatname = new String("");
        while (true) {
            concatname = concatname.concat(inputs[offset]);
            if (offset == inputs.length - 1) break;
            ++offset;
            concatname = concatname.concat(" ");
        }
        return concatname;
    }

    public static String getLast(String str) {
        StringTokenizer st = new StringTokenizer(str.trim(), "/");
        String names = "/";
        int i = 0;
        while (st.hasMoreElements()) {
            names = st.nextToken();
            ++i;
        }
        return names;
    }

    public static void main(String[] args) {
        System.out.println(version);
        System.out.println(author);
        System.out.println(copyright);
    }
}

