/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.file;

import java.io.File;
import java.net.URI;

public class UnixFile
extends File {
    public static final String version = "UnixFile 0.1";
    public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
    public static final String copyright = "(c) 2003/06/27 All right reserved.";
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;

    public UnixFile(File parent, String child) throws NullPointerException {
        super(parent, child);
    }

    public UnixFile(String pathname) throws NullPointerException {
        super(pathname);
    }

    public UnixFile(String parent, String child) throws NullPointerException {
        super(parent, child);
    }

    public UnixFile(URI uri) throws NullPointerException, IllegalArgumentException {
        super(uri);
    }

    public static native int chmod(String var0, int var1);

    public static native int chown(String var0, int var1, int var2);

    public static native int getUid(String var0);

    public static native int getGid(String var0);

    public static native int getMode(String var0);

    public boolean chmod(int mode) throws SecurityException {
        return UnixFile.chmod(this.getAbsolutePath(), mode) != -1;
    }

    public boolean chown(int uid, int gid) {
        return UnixFile.chown(this.getAbsolutePath(), uid, gid) != -1;
    }

    public int getUid() {
        return UnixFile.getUid(this.getAbsolutePath());
    }

    public int getGid() {
        return UnixFile.getGid(this.getAbsolutePath());
    }

    public int getMode() {
        return UnixFile.getMode(this.getAbsolutePath());
    }

    public static void main(String[] args) {
        System.out.println(version);
        System.out.println(author);
        System.out.println(copyright);
        if (args.length == 1) {
            UnixFile file = new UnixFile(args[0]);
            System.out.print(file.getName());
            System.out.print(" uid:" + file.getUid());
            System.out.print(" gid:" + file.getGid());
            System.out.print(" mode:" + Integer.toOctalString(file.getMode()));
            System.out.println();
        }
    }

    static {
        System.loadLibrary("UnixFile");
    }
}

