/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.net;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.wasamon.mjlib.net.HttpHeaderException;

public class HttpUtil {
    public static final String version = "HttpUtil 0.1";
    public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
    public static final String copyright = "(c) 2003/06/27 All right reserved.";

    public static String getHTTPContentHeader(long time, long length, String type) {
        String header = new String();
        byte[] cr = new byte[]{13};
        byte[] lf = new byte[]{10};
        String CR = new String(cr);
        String LF = new String(lf);
        header = header.concat("Last-Modified: ");
        header = header.concat(HttpUtil.getDateString(time));
        header = header.concat(CR);
        header = header.concat(LF);
        header = header.concat("Content-Type: ");
        header = header.concat(type);
        header = header.concat(CR);
        header = header.concat(LF);
        header = header.concat("Content-Length: ");
        header = header.concat(Long.toString(length));
        return header;
    }

    public static String getDateString(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(time);
        String year = Integer.toString(cal.get(1));
        String date = Integer.toString(cal.get(5));
        String hour = Integer.toString(cal.get(11));
        String min = Integer.toString(cal.get(12));
        String sec = Integer.toString(cal.get(13));
        int month = cal.get(2);
        int day = cal.get(7);
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (min.length() == 1) {
            min = "0" + min;
        }
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        String str = HttpUtil.getDayString(day) + ", " + date + " " + HttpUtil.getMonthString(month) + " " + year + " " + hour + ":" + min + ":" + sec + " " + "GMT";
        return str;
    }

    private static String getDayString(int day) {
        switch (day) {
            case 1: {
                return "Sun";
            }
            case 2: {
                return "Mon";
            }
            case 3: {
                return "Tue";
            }
            case 4: {
                return "Wed";
            }
            case 5: {
                return "Thu";
            }
            case 6: {
                return "Fri";
            }
            case 7: {
                return "Sat";
            }
        }
        return "";
    }

    public static boolean isThisYear(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int current = cal.get(1);
        cal.setTimeInMillis(time);
        int target = cal.get(1);
        return current == target;
    }

    public static String getYear(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        return Integer.toString(year);
    }

    public static String getMonth(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(time);
        int month = cal.get(2);
        return HttpUtil.getMonthString(month);
    }

    public static String getDate(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(time);
        String date = Integer.toString(cal.get(5));
        if (date.length() == 1) {
            date = " " + date;
        }
        return date;
    }

    public static String getTime(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(time);
        String hour = Integer.toString(cal.get(11));
        String min = Integer.toString(cal.get(12));
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (min.length() == 1) {
            min = "0" + min;
        }
        return hour + ":" + min;
    }

    private static String getMonthString(int month) {
        switch (month) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Feb";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Apr";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Aug";
            }
            case 8: {
                return "Sep";
            }
            case 9: {
                return "Oct";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dec";
            }
        }
        return "";
    }

    public static long getTime(String header) throws HttpHeaderException {
        String lm = "Last-Modified: ";
        StringTokenizer st = new StringTokenizer(header, "\n");
        String[] inputs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            inputs[i] = st.nextToken();
            ++i;
        }
        for (i = 0; i < inputs.length; ++i) {
            if (!inputs[i].startsWith(lm)) continue;
            return Long.parseLong(inputs[i].substring(lm.length(), inputs[i].length() - 1));
        }
        throw new HttpHeaderException("not found Last-Modified elemnt.");
    }

    public static String getType(String header) throws HttpHeaderException {
        String ct = "Content-Type: ";
        StringTokenizer st = new StringTokenizer(header, ".");
        String[] inputs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            inputs[i] = st.nextToken();
            ++i;
        }
        for (i = 0; i < inputs.length; ++i) {
            if (!inputs[i].startsWith(ct)) continue;
            return inputs[i].substring(ct.length(), inputs[i].length() - 1);
        }
        throw new HttpHeaderException("not found Content-Type elemnt.");
    }

    public static long getLength(String header) throws HttpHeaderException {
        String ct = "Content-Length: ";
        StringTokenizer st = new StringTokenizer(header, ".");
        String[] inputs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            inputs[i] = st.nextToken();
            ++i;
        }
        for (i = 0; i < inputs.length; ++i) {
            if (!inputs[i].startsWith(ct)) continue;
            return Long.parseLong(inputs[i].substring(ct.length(), inputs[i].length() - 1));
        }
        throw new HttpHeaderException("not found Content-Length elemnt.");
    }

    public static void main(String[] args) {
        System.out.println(version);
        System.out.println(author);
        System.out.println(copyright);
        System.out.println(HttpUtil.getDateString(new Date().getTime()));
    }
}

