/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.net;

public class PacketUtil {
    public static final String version = "PacketUtil 0.1";
    public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
    public static final String copyright = "(c) 2003/06/27 All right reserved.";

    public static boolean equals(byte[] d1, byte[] d2) {
        if (d1.length != d2.length) {
            return false;
        }
        for (int i = 0; i < d1.length; ++i) {
            if (d1[i] == d2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] subArray(byte[] data, int offset, int len) {
        if (data.length < offset + len) {
            len = data.length - offset;
        }
        byte[] r = new byte[len];
        for (int i = 0; i < len; ++i) {
            r[i] = data[offset + i];
        }
        return r;
    }

    public static long ntoh_long(byte[] data, int offset) {
        return ((long)data[offset + 0] << 56 & 0xFF00000000000000L) + ((long)data[offset + 1] << 48 & 0xFF000000000000L) + ((long)data[offset + 2] << 40 & 0xFF0000000000L) + ((long)data[offset + 3] << 32 & 0xFF00000000L) + ((long)data[offset + 4] << 24 & 0xFF000000L) + ((long)data[offset + 5] << 16 & 0xFF0000L) + ((long)data[offset + 6] << 8 & 0xFF00L) + ((long)data[offset + 7] & 0xFFL);
    }

    public static long ntoh_long(byte[] data) {
        return PacketUtil.ntoh_long(data, 0);
    }

    public static int ntoh_int(byte[] data, int offset) {
        return (data[offset] << 24) + (data[offset + 1] << 16 & 0xFF0000) + (data[offset + 2] << 8 & 0xFF00) + (data[offset + 3] & 0xFF);
    }

    public static int ntoh_int(byte[] data) {
        return PacketUtil.ntoh_int(data, 0);
    }

    public static short ntoh_short(byte[] data, int offset) {
        return (short)((data[offset] << 8 & 0xFF00) + (data[offset + 1] & 0xFF));
    }

    public static short ntoh_short(byte[] data) {
        return PacketUtil.ntoh_short(data, 0);
    }

    public static byte[] hton_long(byte[] data, int offset, long value) {
        data[offset + 0] = (byte)((value & 0xFF00000000000000L) >> 56);
        data[offset + 1] = (byte)((value & 0xFF000000000000L) >> 48);
        data[offset + 2] = (byte)((value & 0xFF0000000000L) >> 40);
        data[offset + 3] = (byte)((value & 0xFF00000000L) >> 32);
        data[offset + 4] = (byte)((value & 0xFF000000L) >> 24);
        data[offset + 5] = (byte)((value & 0xFF0000L) >> 16);
        data[offset + 6] = (byte)((value & 0xFF00L) >> 8);
        data[offset + 7] = (byte)(value & 0xFFL);
        return data;
    }

    public static byte[] hton_int(byte[] data, int offset, int value) {
        data[offset + 0] = (byte)((value & 0xFF000000) >> 24);
        data[offset + 1] = (byte)((value & 0xFF0000) >> 16);
        data[offset + 2] = (byte)((value & 0xFF00) >> 8);
        data[offset + 3] = (byte)(value & 0xFF);
        return data;
    }

    public static byte[] hton_short(byte[] data, int offset, short value) {
        data[offset + 0] = (byte)((value & 0xFF00) >> 8);
        data[offset + 1] = (byte)(value & 0xFF);
        return data;
    }

    public static byte[] merge(byte[] dest, int offset, byte[] src1, byte[] src2) {
        int i;
        for (i = 0; i < src1.length; ++i) {
            dest[i + offset] = src1[i];
        }
        for (i = 0; i < src2.length; ++i) {
            dest[i + offset + src1.length] = src2[i];
        }
        return dest;
    }

    public static byte[] merge(byte[] dest, byte[] src1, byte[] src2) {
        return PacketUtil.merge(dest, 0, src1, src2);
    }

    public static byte[] concat(byte[] src1, byte[] src2) {
        int i;
        byte[] dest = new byte[src1.length + src2.length];
        for (i = 0; i < src1.length; ++i) {
            dest[i] = src1[i];
        }
        for (i = 0; i < src2.length; ++i) {
            dest[i + src1.length] = src2[i];
        }
        return dest;
    }

    public static void main(String[] args) {
        System.out.println(version);
        System.out.println(author);
        System.out.println(copyright);
    }
}

