/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import net.wasamon.mjlib.net.NetworkException;
import net.wasamon.mjlib.util.GetOpt;
import net.wasamon.mjlib.util.GetOptException;

public class TelnetClient {
    public static final String version = "TelnetClient 0.1";
    public static final String author = "Takefumi MIYOSHI (miyo@wasamon.net)";
    public static final String copyright = "(c) 2003/11/04 All right reserved.";
    private static final byte[] cr_b = new byte[]{13};
    private static final byte[] lf_b = new byte[]{10};
    private static final String CR = new String(cr_b);
    private static final String LF = new String(lf_b);
    private static final String CRLF = new String(CR + LF);
    private static final int DEFALTPORT = 23;
    private Socket socket;
    private BufferedOutputStream out;
    private BufferedInputStream in;
    private String host;
    private int port;

    public TelnetClient(String host, int port) throws NetworkException {
        this.host = host;
        this.port = port;
        try {
            this.socket = new Socket(host, port);
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        catch (UnknownHostException e) {
            throw new NetworkException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            System.out.println("cannot close socket.");
        }
    }

    public String sendln(String smesg) throws NetworkException {
        return this.send(smesg + CR + LF);
    }

    public String send(String smesg) throws NetworkException {
        StringBuffer str = new StringBuffer();
        PrintWriter pw = new PrintWriter(this.out, true);
        pw.print(smesg);
        if (pw.checkError()) {
            throw new NetworkException("cannot send message");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                str.append(s + "\n");
            }
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
        return str.toString();
    }

    private static void usage() {
        System.out.println(version);
        System.out.println(author);
        System.out.println(copyright);
        System.exit(0);
    }

    public static void main(String[] args) throws NetworkException, GetOptException, IOException {
        String[] rarg;
        GetOpt opt = new GetOpt("p:v", "port:,version", args);
        int port = 23;
        if (opt.flag("p")) {
            port = Integer.decode(opt.getValue("p"));
        }
        if (opt.flag("port")) {
            port = Integer.decode(opt.getValue("port"));
        }
        if (opt.flag("v")) {
            TelnetClient.usage();
        }
        if ((rarg = opt.getArgs()).length == 0) {
            TelnetClient.usage();
        }
        String host = opt.getArgs()[0];
        TelnetClient tc = new TelnetClient(host, port);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block0: while (tc.isConnected()) {
            while (true) {
                System.out.print(">");
                String s = in.readLine();
                if (s == null) {
                    tc.close();
                    continue block0;
                }
                System.out.println(tc.sendln(s));
            }
        }
        System.out.println("connection closed.");
        System.exit(0);
    }
}

