/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.print;

import net.wasamon.mjlib.print.FormatException;

public class PrintFormat {
    public static final String version = "PrintFormat 0.2";
    public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
    public static final String copyright = "(c) 2003/06/27 All right reserved.";
    public static final char STRING = 's';
    public static final char DECIMALSTRING = 'd';
    public static final char CHARACTER = 'c';
    public static final char HEXSTRING = 'x';
    public static final char OCTALSTRING = 'o';
    public static final char BINARYSTRING = 'b';
    public static final char PARCENT = '%';

    private static String toString(Object obj, char format) throws FormatException {
        if (obj instanceof String) {
            return PrintFormat.toString((String)obj, format);
        }
        if (obj instanceof Integer) {
            return PrintFormat.toString((Integer)obj, format);
        }
        if (obj instanceof Short) {
            return PrintFormat.toString((Short)obj, format);
        }
        if (obj instanceof Long) {
            return PrintFormat.toString((Long)obj, format);
        }
        if (obj instanceof Byte) {
            return PrintFormat.toString((Byte)obj, format);
        }
        return obj.toString();
    }

    private static String toString(String obj, char format) throws FormatException {
        String str = null;
        switch (format) {
            case 's': {
                str = obj.toString();
                break;
            }
            case 'd': {
                try {
                    str = Integer.decode(obj).toString();
                    break;
                }
                catch (NumberFormatException e) {
                    throw new FormatException();
                }
            }
            case 'x': {
                try {
                    str = Integer.toHexString(Integer.decode(obj));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new FormatException();
                }
            }
            case 'o': {
                try {
                    str = Integer.toOctalString(Integer.decode(obj));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new FormatException();
                }
            }
            case 'b': {
                try {
                    str = Integer.toBinaryString(Integer.decode(obj));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new FormatException();
                }
            }
        }
        if (str == null) {
            throw new FormatException();
        }
        return str;
    }

    private static String toString(Integer obj, char format) throws FormatException {
        String str = null;
        switch (format) {
            case 'd': {
                str = obj.toString();
                break;
            }
            case 'x': {
                str = Integer.toHexString(obj);
                break;
            }
            case 'b': {
                str = Integer.toBinaryString(obj);
            }
        }
        if (str == null) {
            throw new FormatException();
        }
        return str;
    }

    private static String toString(Byte obj, char format) throws FormatException {
        String str = null;
        int val = 0;
        switch (format) {
            case 'd': {
                str = obj.toString();
                break;
            }
            case 'x': {
                val = obj.intValue();
                str = Integer.toHexString(val);
                if (val >= 0) break;
                str = str.substring(6, 8);
                break;
            }
            case 'b': {
                val = obj.intValue();
                str = Integer.toBinaryString(val);
                if (val >= 0) break;
                str = str.substring(24, 32);
            }
        }
        if (str == null) {
            throw new FormatException();
        }
        return str;
    }

    private static String toString(Long obj, char format) throws FormatException {
        String str = null;
        switch (format) {
            case 'd': {
                str = obj.toString();
                break;
            }
            case 'x': {
                str = Long.toHexString(obj);
                break;
            }
            case 'b': {
                str = Long.toBinaryString(obj);
            }
        }
        if (str == null) {
            throw new FormatException();
        }
        return str;
    }

    private static String toString(Short obj, char format) throws FormatException {
        String str = null;
        switch (format) {
            case 'd': {
                str = obj.toString();
                break;
            }
            case 'x': {
                str = Integer.toHexString(obj.shortValue());
                break;
            }
            case 'b': {
                str = Integer.toBinaryString(obj.shortValue());
            }
        }
        if (str == null) {
            throw new FormatException();
        }
        return str;
    }

    private static String makeString(Object obj, int len, char format, boolean rightflag) throws FormatException {
        StringBuffer sb = new StringBuffer(0);
        String str = PrintFormat.toString(obj, format);
        if (rightflag) {
            for (int i = 0; i < len - str.length(); ++i) {
                if (format == 'd' || format == 'b' || format == 'x' || format == 'o') {
                    sb.append('0');
                    continue;
                }
                sb.append(' ');
            }
            sb.append(str);
        } else {
            sb.append(str);
            for (int i = 0; i < len - str.length(); ++i) {
                sb.append(' ');
            }
        }
        if (str == null) {
            throw new FormatException();
        }
        return sb.toString();
    }

    private static int convert(String pattern, int offset, Object[] objs, int index, StringBuffer sb) throws FormatException {
        int p = offset + 1;
        boolean rightflag = false;
        StringBuffer numstr = new StringBuffer(0);
        char c = pattern.charAt(p);
        if (c == '0') {
            rightflag = true;
        }
        while (p < pattern.length()) {
            c = pattern.charAt(p);
            if (Character.isDigit(c)) {
                numstr.append(c);
                ++p;
                continue;
            }
            ++p;
            if (c == '%') {
                sb.append('%');
            } else {
                int len = 0;
                if (!"".equals(numstr.toString())) {
                    try {
                        len = Integer.parseInt(numstr.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new FormatException();
                    }
                }
                String newstr = PrintFormat.makeString(objs[index], len, c, rightflag);
                sb.append(newstr);
            }
            return p;
        }
        throw new FormatException();
    }

    public static String print(String pattern, int value) throws FormatException {
        Integer obj = new Integer(value);
        Object[] objs = new Object[]{obj};
        return PrintFormat.print(pattern, objs);
    }

    public static String print(String pattern, String str) throws FormatException {
        Object[] objs = new Object[]{str};
        return PrintFormat.print(pattern, objs);
    }

    public static String print(String pattern, String str1, String str2) throws FormatException {
        Object[] objs = new Object[]{str1, str2};
        return PrintFormat.print(pattern, objs);
    }

    public static String print(String pattern, byte value) throws FormatException {
        Byte obj = new Byte(value);
        Object[] objs = new Object[]{obj};
        return PrintFormat.print(pattern, objs);
    }

    public static String print(String pattern, long value) throws FormatException {
        Long obj = new Long(value);
        Object[] objs = new Object[]{obj};
        return PrintFormat.print(pattern, objs);
    }

    public static String print(String pattern, Object[] obj) throws FormatException {
        StringBuffer sb = new StringBuffer(0);
        int point = 0;
        int offset = 0;
        while (offset < pattern.length()) {
            char c;
            try {
                c = pattern.charAt(offset);
            }
            catch (IndexOutOfBoundsException e) {
                throw new FormatException(e.toString());
            }
            if (c == '%') {
                try {
                    offset = PrintFormat.convert(pattern, offset, obj, point, sb);
                }
                catch (NullPointerException e) {
                    throw new FormatException();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new FormatException();
                }
                ++point;
                continue;
            }
            sb.append(c);
            ++offset;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws FormatException {
        if (args.length == 0) {
            System.out.println(version);
            System.out.println(author);
            System.out.println(copyright);
            return;
        }
        Object[] objs = new Object[args.length - 1];
        for (int i = 0; i < args.length - 1; ++i) {
            objs[i] = args[i + 1];
        }
        System.out.println(PrintFormat.print(args[0], objs));
    }

    public static byte[] hex_to_a(byte b) {
        byte[] r = new byte[2];
        int i = b >> 4 & 0xF;
        r[0] = i > 9 ? (byte)(96 + (i - 9)) : (byte)(48 + i);
        i = b & 0xF;
        r[1] = i > 9 ? (byte)(96 + (i - 9)) : (byte)(48 + i);
        return r;
    }
}

