/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public abstract class FileRequestFrame
implements ActionListener {
    protected JFrame frame;
    private JButton openButton;
    private JMenuItem openMenuItem;
    private JMenuItem exitMenuItem;
    private JFileChooser chooser;

    public abstract String getFrameName();

    public abstract boolean getExitOnClose();

    public void showGUI() {
        this.frame = new JFrame(this.getFrameName());
        if (this.getExitOnClose()) {
            this.frame.setDefaultCloseOperation(3);
        }
        JPanel p = new JPanel();
        this.openButton = this.makeJButton("Open", this);
        p.add(this.openButton);
        this.frame.getContentPane().add(p);
        this.frame.setVisible(false);
        this.frame.setJMenuBar(this.makeMenuBar());
        this.chooser = new JFileChooser();
        this.chooser.setFileFilter(this.getFileFilter());
        this.frame.pack();
        this.show();
    }

    public abstract FileFilter getFileFilter();

    private JMenuItem makeMenuItem(String label) {
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(this);
        return item;
    }

    private JMenuBar makeMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu m = new JMenu("File");
        this.openMenuItem = this.makeMenuItem("Open");
        m.add(this.openMenuItem);
        m.addSeparator();
        this.exitMenuItem = this.makeMenuItem("Exit");
        m.add(this.exitMenuItem);
        bar.add(m);
        return bar;
    }

    public void show() {
        this.frame.setVisible(true);
    }

    private JButton makeJButton(String label, ActionListener listener) {
        JButton btn = new JButton(label);
        btn.addActionListener(listener);
        return btn;
    }

    public abstract void doFileOpen(File var1);

    public void doOpenFileAndView() {
        File f;
        int retVal = this.chooser.showOpenDialog(this.frame);
        if (retVal == 0 && (f = this.chooser.getSelectedFile()) != null) {
            this.doFileOpen(f);
        }
    }

    public abstract void exit(int var1);

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == null) {
            return;
        }
        if (obj == this.openButton || obj == this.openMenuItem) {
            this.doOpenFileAndView();
        } else if (obj == this.exitMenuItem) {
            this.exit(0);
        }
    }
}

