/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.util;

import java.math.BigInteger;

public class DataUtil {
    public static int toInteger(byte[] d) {
        return DataUtil.toInteger(d, 0, d.length);
    }

    public static int toInteger(byte b) {
        return DataUtil.toInteger(new byte[]{b});
    }

    public static int toInteger(byte[] d, int offset, int length) {
        int v = 0;
        switch (length) {
            case 1: {
                v += (d[0 + offset] & 0xFF) << 0;
                break;
            }
            case 2: {
                v += (d[0 + offset] & 0xFF) << 8;
                v += (d[1 + offset] & 0xFF) << 0;
                break;
            }
            case 4: {
                v += (d[0 + offset] & 0xFF) << 24;
                v += (d[1 + offset] & 0xFF) << 16;
                v += (d[2 + offset] & 0xFF) << 8;
                v += (d[3 + offset] & 0xFF) << 0;
            }
        }
        return v;
    }

    public static char toChar(byte h, byte l) {
        return DataUtil.toChar(new byte[]{h, l}, 0, 2);
    }

    public static char toChar(byte[] d, int offset, int length) {
        char v = '\u0000';
        if (length == 2) {
            v = (char)(v + (char)((d[0 + offset] & 0xFF) << 8));
            v = (char)(v + (char)((d[1 + offset] & 0xFF) << 0));
        } else {
            v = (char)(v + (char)((d[0 + offset] & 0xFF) << 0));
        }
        return v;
    }

    public static byte[] toByteArray(char v) {
        byte[] d = new byte[]{(byte)(v >> 8 & 0xFF), (byte)(v >> 0 & 0xFF)};
        return d;
    }

    public static char toCharL(int a) {
        return (char)a;
    }

    public static char toCharH(int a) {
        return (char)(a >> 16 & 0xFFFF);
    }

    public static byte toByteL(char a) {
        return (byte)(a & 0xFF);
    }

    public static byte toByteH(int a) {
        return (byte)(a >> 8 & 0xFF);
    }

    public static int toInteger(char a, char b) {
        return (a << 16) + b;
    }

    public static String toBigEndianValueString(byte[] data) {
        String s = "0x";
        for (int i = 0; i < data.length; ++i) {
            String tmp = "00";
            tmp = tmp + Integer.toHexString(data[i] & 0xFF);
            s = s + tmp.substring(tmp.length() - 2, tmp.length());
        }
        return s;
    }

    public static byte[] toByteArray(int v) {
        byte[] d = new byte[]{(byte)(v >> 24 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v >> 0 & 0xFF)};
        return d;
    }

    public static byte[] toByteArray(int v, int len) {
        byte[] d = new byte[len];
        for (int i = 0; i < len; ++i) {
            d[i] = (byte)(v >> (len - i - 1) * 8 & 0xFF);
        }
        return d;
    }

    public static int toLSB8(char a) {
        return a & 0xFF;
    }

    public static int toUSB8(char a) {
        return a >> 8 & 0xFF;
    }

    public static int toSiginedInteger(char d) {
        int v = 0;
        v = (d & 0x8000) == 32768 ? d - 65536 : d;
        return v;
    }

    public static int parseInt(String v) throws NumberFormatException {
        int value = 0;
        value = v.startsWith("0x") ? new BigInteger(v.substring(2), 16).intValue() : Integer.parseInt(v);
        return value;
    }

    public static byte[] subArray(byte[] d, int offset, int len) {
        byte[] d0 = new byte[len];
        for (int i = 0; i < len; ++i) {
            d0[i] = d[i + offset];
        }
        return d0;
    }
}

