/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.wasamon.mjlib.util.GetOptException;

public class GetOpt {
    private String[] args = new String[0];
    private Hashtable opts;
    private Hashtable opt_with_arg = new Hashtable();
    private Hashtable opt_flag = new Hashtable();
    private ArrayList unknown;
    private String opt_with_arg_rest = "";
    private boolean result = true;

    public GetOpt(String sp, String lps, String[] ptn) {
        this(sp, lps, ptn, 0);
    }

    public GetOpt(String sp, String lps, String[] ptn, int offset) {
        this.opts = new Hashtable();
        this.unknown = new ArrayList();
        StringTokenizer st = new StringTokenizer(lps, ",");
        String[] lp = new String[st.countTokens()];
        for (int i = 0; i < lp.length; ++i) {
            lp[i] = st.nextToken();
        }
        this.makeOptList(sp, lp);
        this.analyze(ptn, offset);
    }

    public GetOpt(String sp, String lps, String[] ptn, boolean flag) {
        this(sp, lps, ptn);
        int i;
        String[] o = this.getAllOpt();
        String[] a = this.getArgs();
        for (i = 0; i < o.length; ++i) {
            System.out.println("Option " + o[i]);
            if (!this.flag(o[i])) continue;
            try {
                System.out.println(" Value=" + this.getValue(o[i]));
                continue;
            }
            catch (GetOptException e) {
                System.out.println(" Value=");
            }
        }
        if (a != null) {
            for (i = 0; i < a.length; ++i) {
                System.out.println("Argument " + a[i]);
            }
        }
    }

    private void analyze(String[] ptn, int offset) {
        int i = offset;
        for (i = offset; i < ptn.length && ptn[i].charAt(0) == '-' && !ptn[i].equals("-") && !ptn[i].equals("--"); ++i) {
            if (this.opt_with_arg_rest.equals(ptn[i].substring(1))) {
                String flag = ptn[i].substring(1);
                String rest = "";
                ++i;
                while (true) {
                    rest = rest + ptn[i];
                    if (i == ptn.length - 1) break;
                    rest = rest + " ";
                    ++i;
                }
                this.opts.put(flag, rest);
            }
            if (ptn[i].charAt(0) != '-') continue;
            if (ptn[i].charAt(1) == '-') {
                i += this.analy_longopt(ptn[i].substring(2), ptn, i);
                continue;
            }
            i += this.analy_shortopt(ptn[i].substring(1), ptn, i);
        }
        this.args = this.setArgs(ptn, i);
    }

    private boolean makeOptList(String sp, String[] lp) {
        int i = 0;
        while (i < sp.length()) {
            if (sp.length() > i + 1 && sp.charAt(i + 1) == ':') {
                if (sp.length() > i + 2 && sp.charAt(i + 2) == ':') {
                    this.opt_with_arg_rest = sp.substring(i, i + 1);
                    i += 3;
                    continue;
                }
                this.opt_with_arg.put(sp.substring(i, i + 1), new Boolean(true));
                i += 2;
                continue;
            }
            this.opt_flag.put(sp.substring(i, i + 1), new Boolean(true));
            ++i;
        }
        for (i = 0; i < lp.length; ++i) {
            if (lp[i].charAt(lp[i].length() - 1) == ':') {
                this.opt_with_arg.put(lp[i].substring(0, lp[i].length() - 1), new Boolean(true));
                continue;
            }
            this.opt_flag.put(lp[i], new Boolean(true));
        }
        return true;
    }

    private int analy_shortopt(String ptn, String[] arg, int offset) {
        int add = 0;
        for (int i = 0; i < ptn.length(); ++i) {
            String flag = ptn.substring(i, i + 1);
            if (this.opt_flag.containsKey(flag)) {
                this.opts.put(flag, new Boolean(true));
                add += 0;
                continue;
            }
            if (!this.opt_with_arg.containsKey(flag)) continue;
            if (arg.length > offset + 1) {
                this.opts.put(flag, arg[offset + 1]);
                ++add;
                continue;
            }
            this.result = false;
            add += 0;
        }
        return add;
    }

    private int analy_longopt(String ptn, String[] arg, int offset) {
        int add = 0;
        if (this.opt_flag.containsKey(ptn)) {
            this.opts.put(ptn, new Boolean(true));
            add = 0;
        } else if (ptn.matches(".*=.*")) {
            int index = ptn.indexOf("=");
            String ptn2 = ptn.substring(0, index);
            if (this.opt_with_arg.containsKey(ptn2)) {
                this.opts.put(ptn2, ptn.substring(index + 1));
            } else {
                this.result = false;
            }
            add = 0;
        } else if (this.opt_with_arg.containsKey(ptn)) {
            if (arg.length > offset + 1) {
                this.opts.put(ptn, arg[offset + 1]);
                add = 1;
            } else {
                this.opts.put(ptn, "");
                this.result = true;
                add = 0;
            }
        } else {
            this.result = false;
            add = 0;
        }
        return add;
    }

    public boolean isSuccess() {
        return this.result;
    }

    public boolean flag(String key) {
        return this.opts.containsKey(key);
    }

    public String getValue(String key) throws GetOptException {
        Object obj = null;
        if (!this.opts.containsKey(key)) {
            throw new GetOptException("no such options." + key);
        }
        obj = this.opts.get(key);
        if (obj instanceof String) {
            return obj;
        }
        throw new GetOptException("this option doesn't have any value.");
    }

    private String[] getAllOpt() {
        String[] o = new String[this.opts.size()];
        Enumeration keys = this.opts.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            o[i] = (String)keys.nextElement();
            ++i;
        }
        return o;
    }

    public String[] getArgs() {
        return this.args;
    }

    private String[] setArgs(String[] ptn, int offset) {
        int argc = ptn.length - offset;
        String[] args = new String[argc];
        for (int i = 0; i < argc; ++i) {
            args[i] = ptn[i + offset];
        }
        return args;
    }

    private void print_opt_flag() {
        Enumeration keys = this.opt_flag.keys();
        while (keys.hasMoreElements()) {
            System.out.println(keys.nextElement());
        }
    }

    private void print_opt_with_arg() {
        Enumeration keys = this.opt_with_arg.keys();
        while (keys.hasMoreElements()) {
            System.out.println(keys.nextElement());
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        System.out.println("GetOpt test.");
        String sp = "vh";
        String lp = "version:";
        GetOpt go = new GetOpt(sp, lp, args);
        go.print_opt_flag();
        go.print_opt_with_arg();
        String[] o = go.getAllOpt();
        String[] a = go.getArgs();
        for (i = 0; i < o.length; ++i) {
            System.out.println("Option " + o[i]);
        }
        if (a != null) {
            for (i = 0; i < a.length; ++i) {
                System.out.println("Argument " + a[i]);
            }
        } else {
            System.out.println("no argument");
        }
        System.out.println(go.flag("v"));
        System.out.println(go.flag("h"));
        System.out.println(go.flag("version"));
        try {
            System.out.println(go.getValue("version"));
        }
        catch (GetOptException e) {
            System.out.println(e.getMessage());
        }
        System.out.println(go.isSuccess());
    }
}

