/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.wasamon.mjlib.util.PathBalanceTreeConstructorTestLeaf;
import net.wasamon.mjlib.util.PathBalanceTreeConstructorTestNode;

public class PathBalanceTreeConstructor {
    TreeNode root;

    private boolean isPerfectTree(TreeElement n) {
        if (n.isLeaf()) {
            return true;
        }
        int nKids = ((TreeNode)n).nKids();
        boolean flag = true;
        for (int i = 0; i < nKids; ++i) {
            flag &= this.isPerfectTree(((TreeNode)n).kid(i));
        }
        if (flag) {
            return this.countKidsDepth(((TreeNode)n).kid(0)) == this.countKidsDepth(((TreeNode)n).kid(1));
        }
        return false;
    }

    private int countKidsDepth(TreeElement n) {
        if (n.isLeaf()) {
            return ((TreeLeaf)n).value();
        }
        TreeNode node = (TreeNode)n;
        int v0 = node.kid(0) != null ? this.countKidsDepth(node.kid(0)) : 0;
        int v1 = node.kid(1) != null ? this.countKidsDepth(node.kid(1)) : 0;
        return 1 + (v0 > v1 ? v0 : v1);
    }

    private void add(TreeNode node, TreeLeaf leaf) {
        if (node.kid(0) == null) {
            node.setKid(0, leaf);
            return;
        }
        if (node.kid(1) == null) {
            node.setKid(1, leaf);
            return;
        }
        boolean f0 = this.isPerfectTree(node.kid(0));
        boolean f1 = this.isPerfectTree(node.kid(1));
        int depth0 = this.countKidsDepth(node.kid(0));
        int depth1 = this.countKidsDepth(node.kid(1));
        if (f0 == f1) {
            if (depth0 > depth1) {
                if (f0) {
                    TreeNode n = node.newNode();
                    n.setKid(0, leaf);
                    n.setKid(1, node.kid(1));
                    node.setKid(1, n);
                } else {
                    this.add((TreeNode)node.kid(1), leaf);
                }
            } else if (f0) {
                TreeNode n = node.newNode();
                n.setKid(0, leaf);
                n.setKid(1, node.kid(0));
                node.setKid(0, n);
            } else {
                this.add((TreeNode)node.kid(0), leaf);
            }
        } else if (!f1) {
            if (depth0 + 1 > depth1) {
                this.add((TreeNode)node.kid(1), leaf);
            } else {
                this.add((TreeNode)node.kid(0), leaf);
            }
        } else if (depth0 > depth1 + 1) {
            this.add((TreeNode)node.kid(1), leaf);
        } else {
            this.add((TreeNode)node.kid(0), leaf);
        }
    }

    public TreeLeaf[] makeTestData(int size) {
        ArrayList<PathBalanceTreeConstructorTestLeaf> leaves = new ArrayList<PathBalanceTreeConstructorTestLeaf>();
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            leaves.add(new PathBalanceTreeConstructorTestLeaf(Math.abs(r.nextInt()) % 10 + 1));
        }
        return leaves.toArray(new TreeLeaf[leaves.size()]);
    }

    public void run(TreeNode node, TreeLeaf[] leaves) {
        List<TreeLeaf> list = Arrays.asList(leaves);
        Collections.sort(list, new TreeLeafComparatorImpl());
        this.root = node;
        Iterator<TreeLeaf> it = list.iterator();
        while (it.hasNext()) {
            this.add(this.root, it.next());
        }
    }

    public static void main(String[] args) {
        PathBalanceTreeConstructor test = new PathBalanceTreeConstructor();
        test.run(new PathBalanceTreeConstructorTestNode(), test.makeTestData(10));
        System.out.println(test.root);
    }

    class TreeLeafComparatorImpl
    implements Comparator {
        TreeLeafComparatorImpl() {
        }

        public int compare(Object obj0, Object obj1) {
            TreeLeaf l0 = (TreeLeaf)obj0;
            TreeLeaf l1 = (TreeLeaf)obj1;
            if (l0.value() > l1.value()) {
                return -1;
            }
            if (l0.value() < l1.value()) {
                return 1;
            }
            return 0;
        }
    }

    public static interface TreeLeaf
    extends TreeElement {
        public int value();
    }

    public static interface TreeNode
    extends TreeElement {
        public int nKids();

        public TreeElement kid(int var1);

        public void setKid(int var1, TreeElement var2);

        public TreeNode newNode();
    }

    public static interface TreeElement {
        public boolean isLeaf();
    }
}

