/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParser {
    public static final String version = "XMLParser 0.3";
    public static final String author = "Takefumi MIYOSHI (miyo@wasamon.net)";
    public static final String copyright = "(c) 2003-2007 All right reserved";

    public static Node getTopNode(File file) throws XMLParserException {
        try {
            DocumentBuilderFactory bdf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = bdf.newDocumentBuilder();
            Document node = builder.parse(file);
            return node.getFirstChild();
        }
        catch (IOException e) {
            throw new XMLParserException("cannot open the file " + file.getName());
        }
        catch (SAXParseException e) {
            throw new XMLParserException("syntax error in config file.");
        }
        catch (SAXException e) {
            throw new XMLParserException("sax error.");
        }
        catch (ParserConfigurationException e) {
            throw new XMLParserException("failure initializing of xml parser.");
        }
    }

    public static Node getNamedNode(Node node, String name) throws XMLParserException {
        NodeList list = node.getChildNodes();
        Node nd = null;
        for (int i = 0; i < list.getLength(); ++i) {
            nd = list.item(i);
            if (nd.getNodeType() == 3 || !name.equals(nd.getNodeName())) continue;
            return nd;
        }
        throw new XMLParserException(name + " is not found under " + node.getNodeValue());
    }

    public static boolean isNamedNode(Node node, String name) {
        NodeList list = node.getChildNodes();
        Node nd = null;
        for (int i = 0; i < list.getLength(); ++i) {
            nd = list.item(i);
            if (nd.getNodeType() == 3 || !name.equals(nd.getNodeName())) continue;
            return true;
        }
        return false;
    }

    public static Node[] getNamedNodeArray(Node node, String name) {
        NodeList list = node.getChildNodes();
        Node nd = null;
        ArrayList<Node> v = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            nd = list.item(i);
            if (nd.getNodeType() == 3 || !name.equals(nd.getNodeName())) continue;
            v.add(nd);
        }
        return v.toArray(new Node[v.size()]);
    }

    public static String getNodeText(Node node) throws XMLParserException {
        NodeList list = node.getChildNodes();
        Node nd = null;
        for (int i = 0; i < list.getLength(); ++i) {
            nd = list.item(i);
            if (nd.getNodeType() != 3) continue;
            return nd.getNodeValue();
        }
        throw new XMLParserException("not found text");
    }

    public static Node getAttribute(Node node, String name) throws XMLParserException {
        NamedNodeMap attrs = node.getAttributes();
        Node nd = null;
        try {
            nd = attrs.getNamedItem(name);
        }
        catch (NullPointerException e) {
            throw new XMLParserException(name + " is not found under " + node.getNodeName());
        }
        if (nd == null) {
            throw new XMLParserException(name + " is not found under " + node.getNodeName());
        }
        return nd;
    }

    public static boolean isAttribute(Node node, String name) {
        NamedNodeMap attrs = node.getAttributes();
        Node nd = null;
        try {
            nd = attrs.getNamedItem(name);
        }
        catch (NullPointerException e) {
            return false;
        }
        return nd != null;
    }

    public static void main(String[] args) {
        System.out.println(version);
        System.out.println(author);
        System.out.println("Copyright (c) 2003-2007 All right reserved");
    }
}

