/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet;

import coins.IoRoot;
import coins.PassException;
import coins.backend.Root;
import coins.driver.CoinsOptions;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import coins.driver.CompilerDriver;
import coins.driver.Driver;
import coins.driver.Suffix;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.wasamon.mjlib.util.GetOpt;
import net.wasamon.mjlib.util.GetOptException;
import net.wasamon.wallet.WalletGUI;
import net.wasamon.wallet.WalletOptionSpec;
import net.wasamon.wallet.binutils.AssemblerDriver;
import net.wasamon.wallet.binutils.AssemblerException;
import net.wasamon.wallet.binutils.SimpleAssembler;
import net.wasamon.wallet.binutils.SimpleLinker;
import net.wasamon.wallet.binutils.simpleprocessor.SimpleProcessor32InstructionTable;
import net.wasamon.wallet.preprocessor.PreProcessor;
import net.wasamon.wallet.preprocessor.PreProcessorException;

public class WalletDriver
extends Driver {
    private WalletOptionSpec walletSpec;

    public void preprocess(File sourceFile, Suffix suffix, OutputStream out, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        List options = spec.getPreprocessorOptions();
        this.setSystemIncludePathOptions(spec, options);
        options.add(sourceFile.getPath());
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        PreProcessor pp = new PreProcessor();
        try {
            pp.go(sourceFile, new FileInputStream(sourceFile), new PrintStream(out));
        }
        catch (PreProcessorException e) {
            System.err.println(e.getMessage());
            throw new PassException("preprocess", e.getMessage());
        }
        out.close();
    }

    private void loadDefaultSettings(CompileSpecification spec) {
        this.defaultSettings = new Properties();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        File libDir = coinsOptions.getLibDir();
        File settingFile = new File(libDir, "settings");
        if (settingFile.exists()) {
            try {
                this.defaultSettings.load(new FileInputStream(settingFile));
            }
            catch (IOException e) {
                spec.getWarning().warning("Couldn't load the default setting file: " + settingFile.getPath());
            }
        }
    }

    public void compile(File sourceFile, Suffix suffix, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        try {
            super.compile(sourceFile, suffix, in, out, io);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            throw e;
        }
        catch (PassException e) {
            System.err.println(e.getMessage());
            throw e;
        }
    }

    private boolean isUsingWalletToolChain(String value) {
        return value != null && (value.equals("simpleprocessor32") || value.equals("simpleprocessor"));
    }

    public void assemble(File sourceFile, Suffix suffix, InputStream in, File out, IoRoot io) throws IOException, PassException {
        if (this.isUsingWalletToolChain(this.walletSpec.getProcessor())) {
            try {
                AssemblerDriver asm = new AssemblerDriver(new SimpleAssembler());
                asm.go(in, new FileOutputStream(out));
            }
            catch (AssemblerException e) {
                System.err.println(e.getMessage());
                throw new PassException("assemble", e.getMessage());
            }
        } else {
            super.assemble(sourceFile, suffix, in, out, io);
        }
    }

    private File[] getFileArray(List list) {
        ArrayList<File> f = new ArrayList<File>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            File f0 = new File((String)it.next());
            if (!f0.exists()) continue;
            f.add(f0);
        }
        return f.toArray(new File[f.size()]);
    }

    public void link(File out, IoRoot io) throws IOException, PassException {
        if (this.isUsingWalletToolChain(this.walletSpec.getProcessor())) {
            CompileSpecification coinsOptions = io.getCompileSpecification();
            List options = coinsOptions.getLinkerOptions();
            SimpleLinker.go(this.getFileArray(options), out, SimpleProcessor32InstructionTable.getInstance());
        } else {
            super.link(out, io);
        }
    }

    public int doCompile(WalletOptionSpec walletSpec) {
        this.walletSpec = walletSpec;
        int status = 0;
        try {
            CommandLine spec = new CommandLine(walletSpec.getCoinsArgs());
            this.loadDefaultSettings(spec);
            Root.init(spec);
            CompilerDriver driver = new CompilerDriver(spec);
            status = driver.go(this);
        }
        catch (ParseException e) {
            status = 1;
        }
        return status;
    }

    public int doCompile(WalletOptionSpec walletSpec, String[] args) {
        this.walletSpec = walletSpec;
        int status = 0;
        try {
            CommandLine spec = new CommandLine(args);
            this.loadDefaultSettings(spec);
            Root.init(spec);
            CompilerDriver driver = new CompilerDriver(spec);
            status = driver.go(this);
        }
        catch (ParseException e) {
            status = 1;
        }
        return status;
    }

    public static void main(String[] args) {
        try {
            GetOpt opt = new GetOpt("gb:", "", args);
            if (opt.flag("g")) {
                WalletOptionSpec walletSpec = new WalletOptionSpec();
                walletSpec.setCheckNoAlign(true);
                if (opt.flag("b")) {
                    walletSpec.setProcessor(opt.getValue("b"));
                }
                WalletDriver driver = new WalletDriver();
                driver.doCompile(walletSpec, args);
            } else {
                WalletGUI.getInstance().standaloneFlag = true;
                WalletGUI.getInstance().openGUI();
            }
        }
        catch (GetOptException e) {
            System.out.println("argument error.");
        }
    }
}

