/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintStream;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.wasamon.mjlib.ui.JTextAreaOutputStream;
import net.wasamon.wallet.WalletDriver;
import net.wasamon.wallet.WalletOptionSpec;

public class WalletGUI
implements ActionListener {
    WalletOptionSpec walletSpec = new WalletOptionSpec();
    private static WalletGUI instance = new WalletGUI();
    private JFrame frame;
    private JComboBox processorList;
    private JRadioButton outputLIR;
    private JRadioButton outputHIR;
    private JRadioButton outputSnapShot;
    private JRadioButton outputAsm;
    private JRadioButton outputBinary;
    private JButton openFileButton;
    private JButton doCompileButton;
    private JTextField fileNameField;
    private JTextArea logArea;
    JCheckBox checkNoAlign;
    boolean standaloneFlag = false;

    private WalletGUI() {
        this.walletSpec.setProcessor("simpleprocessor32");
        this.walletSpec.setCheckNoAlign(true);
        this.frame = new JFrame("Coins GUI Frontend");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (WalletGUI.this.standaloneFlag) {
                    System.exit(0);
                } else {
                    WalletGUI.this.frame.setVisible(false);
                }
            }
        });
        this.frame.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.add(this.processorSelectPanel());
        p.add(this.outputSelectPanel());
        p.add(this.optionCheckPanel());
        this.frame.getContentPane().add((Component)p, "North");
        p = new JPanel();
        this.fileNameField = new JTextField(30);
        p.add(this.fileNameField);
        this.fileNameField.setEditable(false);
        this.openFileButton = this.makeJButton("Select");
        p.add(this.openFileButton);
        this.doCompileButton = this.makeJButton("Compile");
        p.add(this.doCompileButton);
        this.frame.getContentPane().add((Component)p, "Center");
        this.logArea = new JTextArea(10, 40);
        this.logArea.setWrapStyleWord(true);
        this.logArea.setEditable(false);
        this.frame.getContentPane().add((Component)new JScrollPane(this.logArea, 20, 30), "South");
        this.frame.pack();
        this.frame.setVisible(false);
    }

    public static WalletGUI getInstance() {
        return instance;
    }

    private JPanel processorSelectPanel() {
        JPanel p = new JPanel();
        this.processorList = new JComboBox();
        this.processorList.addItem("simpleprocessor32");
        this.processorList.addItem("simpleprocessor");
        this.processorList.addItem("sh4");
        this.processorList.addItem("x86");
        p.add(this.processorList);
        p.setBorder(new TitledBorder(new LineBorder(Color.gray, 1), "processor", 2, 2));
        this.processorList.addActionListener(this);
        this.processorList.setSelectedIndex(0);
        return p;
    }

    private JRadioButton makeRadioButton(ButtonGroup g, String label) {
        JRadioButton r = new JRadioButton(label);
        r.addActionListener(this);
        r.setSelected(false);
        g.add(r);
        return r;
    }

    private JCheckBox makeCheckBox(String label) {
        JCheckBox b = new JCheckBox(label);
        b.addActionListener(this);
        b.setSelected(false);
        return b;
    }

    private JPanel outputSelectPanel() {
        JPanel p = new JPanel();
        ButtonGroup g = new ButtonGroup();
        this.outputLIR = this.makeRadioButton(g, "LIR");
        p.add(this.outputLIR);
        this.outputSnapShot = this.makeRadioButton(g, "SnapShot");
        p.add(this.outputSnapShot);
        this.outputAsm = this.makeRadioButton(g, "Assembly");
        p.add(this.outputAsm);
        this.outputBinary = this.makeRadioButton(g, "Binary");
        p.add(this.outputBinary);
        this.outputBinary.setSelected(true);
        p.setBorder(new TitledBorder(new LineBorder(Color.gray, 1), "output", 2, 2));
        return p;
    }

    private JPanel optionCheckPanel() {
        JPanel p = new JPanel();
        this.checkNoAlign = this.makeCheckBox("No Align");
        p.add(this.checkNoAlign);
        this.checkNoAlign.setSelected(true);
        p.setBorder(new TitledBorder(new LineBorder(Color.gray, 1), "options", 2, 2));
        return p;
    }

    private JButton makeJButton(String label) {
        JButton b = new JButton(label);
        b.addActionListener(this);
        return b;
    }

    private String openFileDialog() {
        String path = "";
        FileDialog fd = new FileDialog((Frame)this.frame, "Open Source File", 0);
        fd.setVisible(true);
        if (fd.getFile() != null) {
            path = new File(fd.getDirectory(), fd.getFile()).getAbsolutePath();
        }
        return path;
    }

    public void openGUI() {
        if (this.standaloneFlag) {
            System.setOut(new PrintStream(new JTextAreaOutputStream(this.logArea), true));
            System.setErr(new PrintStream(new JTextAreaOutputStream(this.logArea), true));
        }
        this.frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        if (obj != null) {
            if (obj == this.processorList) {
                this.walletSpec.setProcessor((String)this.processorList.getSelectedItem());
            } else if (obj == this.outputLIR) {
                this.walletSpec.setOutputType(2);
            } else if (obj == this.outputHIR) {
                this.walletSpec.setOutputType(3);
            } else if (obj == this.outputSnapShot) {
                this.walletSpec.setOutputType(4);
            } else if (obj == this.outputAsm) {
                this.walletSpec.setOutputType(1);
            } else if (obj == this.outputBinary) {
                this.walletSpec.setOutputType(6);
            } else if (obj == this.openFileButton) {
                String filename = this.openFileDialog();
                this.fileNameField.setText(filename);
                this.walletSpec.setFileName(new String[]{filename});
                this.walletSpec.setOutputFileName(filename, "out");
            } else if (obj == this.doCompileButton) {
                this.doCompileButton.setEnabled(false);
                WalletDriver driver = new WalletDriver();
                int status = driver.doCompile(this.walletSpec);
                this.doCompileButton.setEnabled(true);
                if (status != 0) {
                    System.out.println("\nCompile Failure\n");
                } else {
                    System.out.println("\nCompile Success at " + Calendar.getInstance().getTime() + "\n");
                }
            } else if (obj != this.fileNameField) {
                if (obj == this.checkNoAlign) {
                    this.walletSpec.setCheckNoAlign(this.checkNoAlign.isSelected());
                } else {
                    System.out.println(ev);
                }
            }
        }
    }

    public static void main(String[] args) {
        WalletGUI.getInstance().standaloneFlag = true;
        WalletGUI.getInstance().openGUI();
    }
}

