/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.wallet.binutils.AssemblerDriver;
import net.wasamon.wallet.binutils.AssemblerException;
import net.wasamon.wallet.binutils.InstructionTable;
import net.wasamon.wallet.binutils.Linker;
import net.wasamon.wallet.binutils.ObjectData;
import net.wasamon.wallet.binutils.SimpleAssembler;
import org.w3c.dom.Node;

public class SimpleLinker
implements Linker {
    ArrayList data = new ArrayList();
    static Pattern digitPattern = Pattern.compile("\\-?\\d+");
    static Pattern hexDigitPattern = Pattern.compile("0x[0-9a-fA-F]+");

    public void doLink(InstructionTable inst, File[] sources, OutputStream out) throws IOException {
        try {
            this.readObjectData(sources);
            this.allocate(this.data);
            this.outputDataStream(inst, out, this.data);
        }
        catch (AssemblerException e) {
            throw new IOException(e.getMessage());
        }
        catch (XMLParserException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void setBootStrap(Reader reader) throws IOException, AssemblerException {
        AssemblerDriver asm = new AssemblerDriver(new SimpleAssembler());
        asm.doParse(reader);
        this.data.add(asm.data);
    }

    private void readObjectData(File[] sources) throws XMLParserException {
        int i = 0;
        while (i < sources.length) {
            File source = sources[i];
            Node top = XMLParser.getTopNode(source);
            this.data.add(ObjectData.readFromXML(top));
            ++i;
        }
    }

    private void allocate(ArrayList data) {
        int offset = 0;
        int length = data.size();
        int i = 0;
        while (i < length) {
            offset = ((ObjectData)data.get(i)).setTextRegionOffset(offset);
            ++i;
        }
        i = 0;
        while (i < length) {
            offset = ((ObjectData)data.get(i)).setDataRegionOffset(offset);
            ++i;
        }
    }

    private void outputDataStream(InstructionTable inst, OutputStream out, ArrayList data) throws AssemblerException, IOException {
        int length = data.size();
        int i = 0;
        while (i < length) {
            ((ObjectData)data.get((int)i)).text.genByteStream(this, inst).writeTo(out);
            ++i;
        }
        i = 0;
        while (i < length) {
            ((ObjectData)data.get((int)i)).data.genByteStream(this).writeTo(out);
            ++i;
        }
    }

    private int getValue(String key) {
        int v = -1;
        int length = this.data.size();
        int i = 0;
        while (i < length) {
            ObjectData d = (ObjectData)this.data.get(i);
            v = d.getLabelValue(key);
            if (v >= 0) break;
            ++i;
        }
        return v;
    }

    public int toValue(String s) throws AssemblerException {
        int val;
        block10: {
            val = 0;
            try {
                if (s == null || s.equals("")) {
                    throw new AssemblerException("argument error: " + s);
                }
                if (digitPattern.matcher(s).matches()) {
                    val = DataUtil.parseInt(s);
                    break block10;
                }
                if (hexDigitPattern.matcher(s).matches()) {
                    val = DataUtil.parseInt(s);
                    break block10;
                }
                if (s.charAt(0) == 'r') {
                    val = DataUtil.parseInt(s.substring(1));
                    break block10;
                }
                if (s.charAt(0) == '_') {
                    val = this.getValue(s);
                    if (val < 0) {
                        throw new AssemblerException("argument error: " + s);
                    }
                    break block10;
                }
                if (s.startsWith("c_") || s.startsWith("f_")) {
                    val = this.getValue(s);
                    if (val < 0) {
                        throw new AssemblerException("argument error: " + s);
                    }
                    break block10;
                }
                throw new AssemblerException("argument error: " + s);
            }
            catch (NumberFormatException e) {
                throw new AssemblerException("argument error: " + s);
            }
        }
        return val;
    }

    public static void go(File[] sources, File out, InstructionTable inst) throws IOException {
        try {
            FileOutputStream ostream = new FileOutputStream(out);
            SimpleLinker linker = new SimpleLinker();
            linker.setBootStrap(SimpleLinker.toStringReader(inst.getDefaultBootStrap()));
            linker.doLink(inst, sources, ostream);
            ostream.flush();
            ostream.close();
        }
        catch (AssemblerException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static StringReader toStringReader(String[] str) {
        String tmp = "";
        int i = 0;
        while (i < str.length) {
            tmp = String.valueOf(tmp) + str[i] + "\n";
            ++i;
        }
        return new StringReader(tmp);
    }
}

