/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsPrompt;
import net.wasamon.mics.MicsShell;
import net.wasamon.mics.gui.awt.MicsAWTWindow;
import net.wasamon.mjlib.util.GetOpt;
import net.wasamon.mjlib.util.GetOptException;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class Mics {
    public static final int majorVersion = 0;
    public static final int minorVersion = 5;
    public static final int revision = 2;
    private static Mics instance = new Mics();
    private MicsShell shell;
    private MicsCompositeElement engine = new MicsCompositeElement();
    private final String defaultDir = ".";

    public static Mics getInstance() {
        return instance;
    }

    private Mics() {
    }

    private void setMicsShell(MicsShell micsShell) {
        this.shell = micsShell;
    }

    public MicsShell shell() {
        return this.shell;
    }

    public MicsCompositeElement engine() {
        return this.engine;
    }

    private void init() {
        this.engine.clear();
    }

    public MicsElement[] getMicsElementArray() {
        return this.engine.getMicsElementArray();
    }

    public void setMemoryData(String string, int n, BufferedInputStream bufferedInputStream) throws MicsException {
        DataBuffer dataBuffer = this.engine.getDataBuffer(string);
        dataBuffer.write(n, bufferedInputStream);
    }

    public void reset() throws MicsException {
        this.engine.reset();
    }

    public void execEngine() {
        new Thread(this.engine).start();
    }

    public void execEngineBlock() {
        this.engine.run();
    }

    public void stopEngine() {
        this.engine.stop();
    }

    public void printMemory(String string, int n, int n2) throws MicsException {
        System.out.println(this.engine.getDataBuffer(string).toString(n, n2));
    }

    public void execStepByStep() throws ExecutableElementException, MicsException, DataBufferException {
        this.execStepByStep(1);
    }

    public void execStepByStep(int n) throws MicsException, MicsException, DataBufferException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - 1; ++i) {
            this.engine.step();
        }
        stringBuffer.append(this.engine.getProcStatusString());
        this.engine.step();
        System.out.println(stringBuffer.toString());
    }

    public String getDefaultDir() {
        return ".";
    }

    public void configTargetArchitecture(File file) throws MicsException {
        this.init();
        try {
            Node node = XMLParser.getTopNode(file);
            String string = file.getParent();
            this.engine.initialize_base(null, string, "engine", node);
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration error: " + xMLParserException);
        }
        System.out.println("architecture update as " + file.getName());
    }

    public void shutdown(int n) {
        this.engine.shutdown();
        System.exit(n);
    }

    public static String printVersion() {
        return String.valueOf(0) + "." + String.valueOf(5) + "." + String.valueOf(2);
    }

    public static void main(String[] stringArray) {
        GetOpt getOpt = new GetOpt("f:ge:", "swt", stringArray);
        boolean bl = false;
        File file = null;
        if (getOpt.flag("swt")) {
            System.out.println("SWT shell has not been suported yet.");
            System.exit(0);
        } else if (getOpt.flag("g")) {
            Mics.getInstance().setMicsShell(new MicsPrompt());
        } else {
            Mics.getInstance().setMicsShell(MicsAWTWindow.getInstance());
        }
        try {
            if (getOpt.flag("f")) {
                try {
                    Mics.getInstance().configTargetArchitecture(new File(getOpt.getValue("f")));
                }
                catch (MicsException micsException) {
                    System.out.println("configuration error: " + micsException);
                    System.exit(0);
                }
            }
            if (getOpt.flag("e")) {
                bl = true;
                file = new File(getOpt.getValue("e"));
                if (!file.exists()) {
                    System.out.println("usage: net.wasamon.mics.Mics -e script");
                    System.exit(0);
                }
            }
        }
        catch (GetOptException getOptException) {
            System.out.println("usage: net.wasamon.mics.Mics [-f config.xml]");
            System.exit(0);
        }
        try {
            System.out.println("MICS is Cycle-level Simulator");
            System.out.println("Version: " + Mics.printVersion());
            System.out.println("Copyright (c) 2005-2007 Takefumi MIYOSHI All Rights Reserved.");
            if (!bl) {
                Mics.getInstance().shell.exec();
            } else {
                Mics.getInstance().shell.exec(file);
            }
        }
        catch (MicsException micsException) {
            System.err.println(micsException);
        }
    }

    public void readMemory(String[] stringArray) throws MicsException {
        if (stringArray.length == 4) {
            Mics.getInstance().printMemory(stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        } else {
            System.out.println("memory id addr length");
        }
    }

    public void loadFile(String[] stringArray) throws MicsException {
        try {
            if (stringArray.length != 4) {
                throw new MicsException("load id offset \"file\"");
            }
            Mics.getInstance().setMemoryData(stringArray[1], Integer.parseInt(stringArray[2]), new BufferedInputStream(new FileInputStream(new File(stringArray[3]))));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("no such file " + stringArray[3]);
        }
    }
}

