/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.LinkedList;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ConfigErrorException;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.Mics;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.gui.MicsArchitectureViewer;
import org.w3c.dom.Node;

public class MicsCompositeElement
extends MicsElement
implements Runnable,
ExecutableElement,
DataBuffer,
MicsViewable {
    private Hashtable<String, MicsElement> element;
    private Hashtable<String, DataBuffer> ram;
    private Hashtable<String, Channel> channel;
    private Hashtable<String, ChannelConnectable> channelConnectable;
    private DataBufferElement[] dataBufferElements;
    private MicsArchitectureViewer viewer;
    private MicsEngineElement[] executableElements;
    private boolean activeFlag;
    private boolean executableFlag;
    private int cycle = 0;
    private boolean fDoNextCycle;
    LinkedList<MicsEngineElement> threadList = new LinkedList();

    private void init() {
        this.activeFlag = false;
        this.executableFlag = false;
        this.cycle = 0;
    }

    public MicsCompositeElement() {
        this.init();
    }

    public void clear() {
        this.element = new Hashtable();
        this.ram = new Hashtable();
        this.channel = new Hashtable();
        this.channelConnectable = new Hashtable();
        this.executableElements = null;
        this.init();
    }

    public void reset() {
        if (!this.activeFlag) {
            for (int i = 0; i < this.executableElements.length; ++i) {
                this.executableElements[i].proc.reset();
            }
            this.init();
        } else {
            System.out.println("cannot reset processors while engin is active.");
        }
    }

    public void stop() {
        this.executableFlag = false;
        System.out.println("engine is stopped at " + this.cycle);
        this.activeFlag = false;
    }

    public String getProcStatusString() throws MicsException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.executableElements.length; ++i) {
            stringBuffer.append(this.executableElements[i].proc.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    private void stepCycle() {
        ++this.cycle;
        for (int i = 0; i < this.executableElements.length; ++i) {
            this.executableElements[i].decrement();
        }
    }

    private void updateCycle() {
        for (int i = 0; i < this.executableElements.length; ++i) {
            this.executableElements[i].updateCycle();
        }
    }

    public boolean step() throws MicsException, ExecutableElementException, ConfigErrorException, MicsException, DataBufferException {
        this.stepCycle();
        ExecInfo execInfo = this.exec_first();
        ExecInfo execInfo2 = this.exec_second();
        this.updateCycle();
        return !execInfo.isTerminatable() || !execInfo2.isTerminatable();
    }

    public void run() {
        if (this.activeFlag) {
            System.out.println("cannot start while engin is active.");
            return;
        }
        this.activeFlag = true;
        Calendar calendar = Calendar.getInstance();
        System.out.println("Starting of Execution All at " + calendar.getTime());
        long l = calendar.getTimeInMillis();
        this.executableFlag = true;
        try {
            while (this.step() && this.executableFlag) {
            }
            this.activeFlag = false;
        }
        catch (MicsException micsException) {
            System.out.println("Program Terminated at " + calendar.getTime() + " abnormally.");
            System.out.println(micsException.getMessage() + " at " + this.cycle);
            return;
        }
        calendar = Calendar.getInstance();
        if (this.executableFlag) {
            Mics.getInstance().shell().setMicsEngineEnableState(true);
            System.out.println("Program Terminated at " + calendar.getTime());
            long l2 = calendar.getTimeInMillis() - l;
            System.out.print("Execution Cycle: " + this.cycle + " Time: " + l2 + "ms");
            if (l2 > 0L) {
                System.out.println(" C/S: " + (double)this.cycle / (double)l2 + "kHz");
            } else {
                System.out.println("");
            }
        }
    }

    public synchronized void setDoNextCycle() {
        this.fDoNextCycle = true;
    }

    public ExecInfo exec_first() throws MicsException {
        this.fDoNextCycle = false;
        for (int i = 0; i < this.executableElements.length; ++i) {
            MicsEngineElement micsEngineElement = this.executableElements[i];
            if (micsEngineElement.isExecutable()) {
                ExecInfo execInfo = micsEngineElement.proc.exec_first();
                if (execInfo == null) continue;
                this.fDoNextCycle |= !execInfo.isTerminatable();
                continue;
            }
            this.fDoNextCycle = true;
        }
        return new ExecInfo(!this.fDoNextCycle, 0);
    }

    public ExecInfo exec_second() throws MicsException {
        boolean bl = false;
        for (int i = 0; i < this.executableElements.length; ++i) {
            MicsEngineElement micsEngineElement = this.executableElements[i];
            if (micsEngineElement.isExecutable()) {
                ExecInfo execInfo = micsEngineElement.proc.exec_second();
                if (execInfo == null) continue;
                micsEngineElement.addCycle(execInfo.getCycle());
                if (execInfo.isTerminatable()) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        return new ExecInfo(!bl, 0);
    }

    public String[] getConnectedElements() {
        return null;
    }

    public String getImagePath() {
        return null;
    }

    private void initializeElement(String string, Node[] nodeArray) throws MicsException {
        this.clear();
        ArrayList<MicsEngineElement> arrayList = new ArrayList<MicsEngineElement>();
        ArrayList<MicsElement> arrayList2 = new ArrayList<MicsElement>();
        ArrayList<Channel> arrayList3 = new ArrayList<Channel>();
        ArrayList<ChannelConnectable> arrayList4 = new ArrayList<ChannelConnectable>();
        ArrayList<DataBuffer> arrayList5 = new ArrayList<DataBuffer>();
        ArrayList<DataBufferElement> arrayList6 = new ArrayList<DataBufferElement>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node object = nodeArray[i];
            String string2 = "";
            try {
                string2 = this.getAttributeAsString(object, "class");
                String string3 = this.getAttributeAsString(object, "id");
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                MicsElement micsElement = (MicsElement)clazz.newInstance();
                micsElement.initialize_base(this, string, string3, object);
                arrayList2.add(micsElement);
                if (micsElement instanceof ExecutableElement) {
                    arrayList.add(new MicsEngineElement((ExecutableElement)((Object)micsElement)));
                }
                if (micsElement instanceof Channel) {
                    arrayList3.add((Channel)((Object)micsElement));
                }
                if (micsElement instanceof ChannelConnectable) {
                    arrayList4.add((ChannelConnectable)((Object)micsElement));
                }
                if (!(micsElement instanceof DataBuffer)) continue;
                arrayList5.add((DataBuffer)((Object)micsElement));
                int n = 0;
                if (arrayList6.size() > 0) {
                    DataBufferElement dataBufferElement = (DataBufferElement)arrayList6.get(arrayList6.size() - 1);
                    n = dataBufferElement.offset + dataBufferElement.data.size();
                }
                arrayList6.add(new DataBufferElement((DataBuffer)((Object)micsElement), n));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                throw new MicsException("no such class: " + string2);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                throw new MicsException("cannot instantiation: " + string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new MicsException("illegal access: " + string2);
            }
        }
        for (MicsElement micsElement : arrayList2) {
            this.element.put(micsElement.id(), micsElement);
        }
        this.executableElements = arrayList.toArray(new MicsEngineElement[arrayList.size()]);
        for (Channel channel : arrayList3) {
            this.channel.put(channel.id(), channel);
        }
        for (ChannelConnectable channelConnectable : arrayList4) {
            this.channelConnectable.put(channelConnectable.id(), channelConnectable);
        }
        for (DataBuffer dataBuffer : arrayList5) {
            this.ram.put(dataBuffer.id(), dataBuffer);
        }
        this.dataBufferElements = arrayList6.toArray(new DataBufferElement[arrayList6.size()]);
    }

    public void initialize(String string, Node node) throws MicsException {
        this.initializeElement(string, this.getNamedNodeArray(node, "element"));
        this.viewer = Mics.getInstance().shell().getMicsArchitectureViewerData(this);
    }

    public MicsElement[] getMicsElementArray() {
        return this.element.values().toArray(new MicsElement[this.element.size()]);
    }

    public MicsElement getMicsElement(String string) throws MicsException {
        return this.element.get(string);
    }

    public DataBuffer getDataBuffer(String string) throws MicsException {
        DataBuffer dataBuffer = this.ram.get(string);
        if (!(dataBuffer != null && string.equals(dataBuffer.id()) || this.composite == null)) {
            dataBuffer = this.composite.getDataBuffer(string);
        }
        return dataBuffer;
    }

    public Channel getChannel(String string) throws MicsException {
        Channel channel = this.channel.get(string);
        if (!(channel != null && string.equals(channel.id()) || this.composite == null)) {
            channel = this.composite.getChannel(string);
        }
        return channel;
    }

    public ChannelConnectable getChannelConnectable(String string) throws MicsException {
        ChannelConnectable channelConnectable = this.channelConnectable.get(string);
        if (!(channelConnectable != null && string.equals(channelConnectable.id()) || this.composite == null)) {
            channelConnectable = this.composite.getChannelConnectable(string);
        }
        return channelConnectable;
    }

    public void shutdown() {
        if (this.element != null) {
            for (MicsElement micsElement : this.element.values()) {
                micsElement.shutdown();
            }
        }
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        DataBufferElement dataBufferElement = this.searchDataBuffer(n);
        if (dataBufferElement != null) {
            dataBufferElement.data.dump(n - dataBufferElement.offset, n2, outputStream);
        }
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        return null;
    }

    public int size() {
        if (this.dataBufferElements.length == 0) {
            return 0;
        }
        DataBufferElement dataBufferElement = this.dataBufferElements[this.dataBufferElements.length - 1];
        return dataBufferElement.offset + dataBufferElement.data.size();
    }

    public String toString(int n, int n2) {
        DataBufferElement dataBufferElement = this.searchDataBuffer(n);
        if (dataBufferElement != null) {
            return dataBufferElement.data.toString(n - dataBufferElement.offset, n2);
        }
        return null;
    }

    public void write(MicsDataPacket micsDataPacket) {
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        DataBufferElement dataBufferElement = this.searchDataBuffer(n);
        if (dataBufferElement != null) {
            dataBufferElement.data.write(n - dataBufferElement.offset, inputStream);
        }
    }

    private DataBufferElement searchDataBuffer(int n) {
        for (int i = 0; i < this.dataBufferElements.length - 1; ++i) {
            DataBufferElement dataBufferElement = this.dataBufferElements[i];
            DataBufferElement dataBufferElement2 = this.dataBufferElements[i + 1];
            if (dataBufferElement.offset > n || n >= dataBufferElement2.offset) continue;
            return dataBufferElement;
        }
        if (this.dataBufferElements.length > 0) {
            return this.dataBufferElements[this.dataBufferElements.length - 1];
        }
        return null;
    }

    public void show() {
        if (this.viewer != null) {
            this.viewer.show();
        }
    }

    private class MicsEngineElement
    extends Thread {
        private ExecutableElement proc;
        int step;
        int tmpCycle;

        public MicsEngineElement(ExecutableElement executableElement) {
            this.proc = executableElement;
        }

        public void decrement() {
            if (this.step > 0) {
                --this.step;
            }
        }

        public void addCycle(int n) {
            this.tmpCycle += n;
        }

        public void updateCycle() {
            if (this.isExecutable()) {
                this.step = this.tmpCycle;
                this.tmpCycle = 0;
            }
        }

        public boolean isExecutable() {
            return this.step == 0;
        }

        public void run() {
            try {
                ExecInfo execInfo = this.proc.exec_first();
                if (execInfo != null && !execInfo.isTerminatable()) {
                    MicsCompositeElement.this.setDoNextCycle();
                }
            }
            catch (MicsException micsException) {
                System.err.println(micsException);
            }
        }
    }

    private class DataBufferElement {
        DataBuffer data;
        int offset;

        public DataBufferElement(DataBuffer dataBuffer, int n) {
            this.data = dataBuffer;
            this.offset = n;
        }
    }
}

