/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import net.wasamon.mics.Mics;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsShell;
import net.wasamon.mics.gui.MicsArchitectureViewer;

public class MicsPrompt
implements MicsShell {
    private static String[] parseInput(String string) throws IOException {
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void exec(File file) throws MicsException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
            this.exec(new BufferedReader(inputStreamReader), "");
            inputStreamReader.close();
            Mics.getInstance().shutdown(0);
        }
        catch (IOException iOException) {
            throw new MicsException(iOException);
        }
    }

    public void exec() throws MicsException {
        try {
            this.exec(new BufferedReader(new InputStreamReader(System.in)), "MICS> ");
            System.out.println();
            Mics.getInstance().shutdown(0);
        }
        catch (IOException iOException) {
            throw new MicsException(iOException);
        }
    }

    private void exec(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = "";
        System.out.print(string);
        while ((string2 = bufferedReader.readLine()) != null && MicsPrompt.execLine(string2)) {
            System.out.print(string);
        }
        bufferedReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execLine(String string) throws IOException {
        boolean bl;
        block25: {
            String[] stringArray = MicsPrompt.parseInput(string);
            bl = true;
            try {
                if (stringArray.length == 0 || stringArray == null) break block25;
                if (stringArray[0].equals("version")) {
                    System.out.println(Mics.printVersion());
                    break block25;
                }
                if (stringArray[0].equals("quit")) {
                    bl = false;
                    break block25;
                }
                if (stringArray[0].equals("load")) {
                    Mics.getInstance().loadFile(stringArray);
                    break block25;
                }
                if (stringArray[0].equals("l")) {
                    Mics.getInstance().loadFile(stringArray);
                    break block25;
                }
                if (stringArray[0].equals("echo")) {
                    for (int i = 1; i < stringArray.length; ++i) {
                        System.out.print(stringArray[i] + " ");
                    }
                    System.out.println();
                    break block25;
                }
                if (stringArray[0].equals("run")) {
                    System.out.println("run");
                    Mics.getInstance().execEngine();
                    break block25;
                }
                if (stringArray[0].equals("xrun")) {
                    Mics.getInstance().execEngineBlock();
                    break block25;
                }
                if (stringArray[0].equals("step") || stringArray[0].equals("s")) {
                    if (stringArray.length == 2) {
                        Mics.getInstance().execStepByStep(Integer.parseInt(stringArray[1]));
                    } else {
                        Mics.getInstance().execStepByStep();
                    }
                    break block25;
                }
                if (stringArray[0].equals("reset")) {
                    Mics.getInstance().reset();
                    break block25;
                }
                if (stringArray[0].equals("config")) {
                    if (stringArray.length > 1) {
                        Mics.getInstance().configTargetArchitecture(new File(stringArray[1]));
                    } else {
                        MicsPrompt.println("no input file");
                    }
                    break block25;
                }
                if (stringArray[0].equals("mem")) {
                    Mics.getInstance().readMemory(stringArray);
                    break block25;
                }
                if (stringArray[0].equals("m")) {
                    Mics.getInstance().readMemory(stringArray);
                    break block25;
                }
                if (stringArray[0].equals("list")) {
                    MicsElement[] micsElementArray = Mics.getInstance().getMicsElementArray();
                    for (int i = 0; i < micsElementArray.length; ++i) {
                        MicsPrompt.println(micsElementArray[i].getInfo());
                    }
                    break block25;
                }
                if (stringArray[0].equals("help")) {
                    MicsPrompt.println("version     print version");
                    MicsPrompt.println("quit        quit this program");
                    MicsPrompt.println("list        print all architecture elements");
                    MicsPrompt.println("load        load data to memory");
                    MicsPrompt.println("l           load data to memory");
                    MicsPrompt.println("run         run your program");
                    MicsPrompt.println("xrun        run your program and block user controll");
                    MicsPrompt.println("step        run your program step by step");
                    MicsPrompt.println("s           run your program step by step");
                    MicsPrompt.println("reset       reset program counter");
                    MicsPrompt.println("config      config architecture");
                    MicsPrompt.println("mem         print memory data");
                    MicsPrompt.println("m           print memory data");
                    MicsPrompt.println("echo        print argument and new line");
                    break block25;
                }
                MicsPrompt.println("unknwon command: " + stringArray[0]);
            }
            catch (MicsException micsException) {
                System.out.println(micsException.getMessage());
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("argument syntax error.");
            }
        }
        return bl;
    }

    public static void println(String string) {
        System.out.println(string);
    }

    public void setMicsEngineEnableState(boolean bl) {
    }

    public MicsArchitectureViewer getMicsArchitectureViewerData(MicsCompositeElement micsCompositeElement) {
        return null;
    }
}

