/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui;

import java.util.Hashtable;
import java.util.Iterator;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;

public abstract class MicsArchitectureViewer {
    private Hashtable data = new Hashtable();
    protected Node selectedNode;

    protected MicsArchitectureViewer(MicsCompositeElement micsCompositeElement) {
        this.data.clear();
        MicsElement[] micsElementArray = micsCompositeElement.getMicsElementArray();
        int n = 0;
        for (int i = 0; i < micsElementArray.length; ++i) {
            MicsElement micsElement = micsElementArray[i];
            this.data.put(micsElement.id(), new Node(micsElement, n * 30));
            ++n;
        }
    }

    public void paint() {
        if (this.data == null) {
            return;
        }
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).paintEdge();
        }
        for (Node node : this.data.values()) {
            if (node.isSelected()) {
                node.paintNode(true);
                continue;
            }
            node.paintNode(false);
        }
    }

    public void setSelectedNode(int n, int n2) {
        Iterator iterator = this.data.values().iterator();
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.selectedNode = null;
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.isContain(n, n2)) continue;
            node.setSelected(true);
            this.selectedNode = node;
            break;
        }
    }

    public abstract ViwerCanvas canvas();

    public abstract void show();

    public class Node {
        public MicsElement element;
        String name;
        String image = null;
        boolean fSelected = false;
        public int X;
        public int Y;
        public int SIZE = 30;
        private int marginY = 15;
        private int ascent;

        public Node(MicsElement micsElement, int n) {
            this.element = micsElement;
            MicsElement.Appearance appearance = micsElement.getAppearance();
            this.X = appearance.x == null ? 20 + n : appearance.x;
            this.Y = appearance.y == null ? 20 + n : appearance.y;
            this.name = micsElement.id() + ":" + this.getShortName(micsElement.getClass().getName());
            this.image = appearance.image;
        }

        private String getShortName(String string) {
            int n = string.lastIndexOf(46);
            if (n < 0) {
                return string;
            }
            return string.substring(n);
        }

        public int getCenterX() {
            return this.X + this.SIZE / 2;
        }

        public int getCenterY() {
            return this.Y + this.SIZE / 2;
        }

        public void paintEdge() {
            MicsArchitectureViewer.this.canvas().setColorBlack();
            String[] stringArray = this.element.getConnectedElements();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Node node = (Node)MicsArchitectureViewer.this.data.get(stringArray[i]);
                    if (node == null) continue;
                    MicsArchitectureViewer.this.canvas().drawLine(this.getCenterX(), this.getCenterY(), node.getCenterX(), node.getCenterY());
                }
            }
        }

        public void paintNode(boolean bl) {
            if (bl) {
                MicsArchitectureViewer.this.canvas().setFGColor();
            } else {
                MicsArchitectureViewer.this.canvas().setBGColor();
            }
            if (this.image != null) {
                MicsArchitectureViewer.this.canvas().drawImage(this.image, this.X, this.Y, this.SIZE, this.SIZE);
            } else {
                MicsArchitectureViewer.this.canvas().fillRect(this.X, this.Y, this.SIZE, this.SIZE);
            }
            MicsArchitectureViewer.this.canvas().setFGColor();
            MicsArchitectureViewer.this.canvas().drawString(this.name, this.X, this.Y + this.ascent + this.marginY + this.SIZE);
            if (bl) {
                MicsArchitectureViewer.this.canvas().setColorRed();
            }
            MicsArchitectureViewer.this.canvas().drawRect(this.X, this.Y, this.SIZE, this.SIZE);
            MicsArchitectureViewer.this.canvas().drawRect(this.X - 1, this.Y - 1, this.SIZE + 2, this.SIZE + 2);
            int n = MicsArchitectureViewer.this.canvas().width();
            int n2 = MicsArchitectureViewer.this.canvas().height();
            if (this.X + this.SIZE + 1 > n || this.Y + this.SIZE + 1 > n2) {
                int n3 = this.X + this.SIZE + 1 > n ? this.X + this.SIZE + 100 : n;
                int n4 = this.Y + this.SIZE + 1 > n2 ? this.Y + this.SIZE + 100 : n2;
                MicsArchitectureViewer.this.canvas().setSize(n3, n4);
            }
        }

        public boolean isContain(int n, int n2) {
            return n > this.X && n < this.X + this.SIZE && n2 > this.Y && n2 < this.Y + this.SIZE;
        }

        public void setPosition(int n, int n2) {
            this.X = n;
            this.Y = n2;
        }

        public boolean isSelected() {
            return this.fSelected;
        }

        public void setSelected(boolean bl) {
            this.fSelected = bl;
        }
    }

    public static interface ViwerCanvas {
        public void setColorBlack();

        public void setColorRed();

        public void setFGColor();

        public void setBGColor();

        public void drawLine(int var1, int var2, int var3, int var4);

        public void drawImage(String var1, int var2, int var3, int var4, int var5);

        public void drawRect(int var1, int var2, int var3, int var4);

        public void fillRect(int var1, int var2, int var3, int var4);

        public void drawString(String var1, int var2, int var3);

        public int width();

        public int height();

        public void setSize(int var1, int var2);
    }
}

