/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui.awt;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.gui.MicsArchitectureViewer;
import net.wasamon.mics.gui.awt.MemoryLoader;
import net.wasamon.mjlib.util.DataUtil;

public class AWTArchitectureViewer
extends MicsArchitectureViewer
implements ActionListener {
    private Frame frame;
    private ArchitectureCanvas canvas;
    private ScrollPane pane;
    private MicsElement selectedElement;
    private Button btnLoad;
    private Button btnView;
    private TextField fieldAddr;
    private Button btnPrint;

    public AWTArchitectureViewer(MicsCompositeElement micsCompositeElement) {
        super(micsCompositeElement);
        this.frame = micsCompositeElement.id() != null && !micsCompositeElement.id().equals("") ? new Frame("Architecture Viewer: " + micsCompositeElement.id()) : new Frame("Architecture Viewer");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AWTArchitectureViewer.this.frame.setVisible(false);
            }
        });
        this.frame.setBounds(10, 10, 600, 400);
        this.frame.add((Component)this.getToolBar(), "North");
        this.canvas = new ArchitectureCanvas();
        this.pane = new ScrollPane(1);
        this.pane.add(this.canvas);
        this.frame.add((Component)this.pane, "Center");
        this.selectedElement = null;
        this.btnView.setEnabled(false);
        this.btnLoad.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.fieldAddr.setEnabled(false);
        this.canvas.imageTable.clear();
    }

    public MicsElement getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElement(MicsElement micsElement) {
        if (micsElement != null && this.selectedElement != micsElement) {
            System.out.println(micsElement.getInfo());
            if (micsElement instanceof DataBuffer) {
                this.btnLoad.setEnabled(true);
                this.btnPrint.setEnabled(true);
                this.fieldAddr.setEnabled(true);
            } else {
                this.btnLoad.setEnabled(false);
            }
            if (micsElement instanceof MicsViewable) {
                this.btnView.setEnabled(true);
            } else {
                this.btnView.setEnabled(false);
            }
            this.selectedElement = micsElement;
        }
    }

    private Panel getToolBar() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.btnLoad = new Button("Load");
        this.btnLoad.addActionListener(this);
        panel.add(this.btnLoad);
        this.btnView = new Button("View");
        this.btnView.addActionListener(this);
        panel.add(this.btnView);
        Panel panel2 = new Panel();
        this.fieldAddr = new TextField("0", 5);
        this.fieldAddr.addActionListener(this);
        this.btnPrint = new Button("Print");
        this.btnPrint.addActionListener(this);
        panel2.add(this.fieldAddr);
        panel2.add(this.btnPrint);
        panel.add(panel2);
        return panel;
    }

    public void show() {
        this.selectedElement = null;
        this.btnView.setEnabled(false);
        this.btnLoad.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.fieldAddr.setEnabled(false);
        this.frame.setVisible(true);
        this.canvas.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null) {
            if (object == this.btnView) {
                MicsElement micsElement = this.getSelectedElement();
                if (micsElement != null && micsElement instanceof MicsViewable) {
                    ((MicsViewable)((Object)micsElement)).show();
                }
            } else if (object == this.btnLoad) {
                MicsElement micsElement = this.getSelectedElement();
                if (micsElement != null && micsElement instanceof DataBuffer) {
                    MemoryLoader.getInstance().show((DataBuffer)((Object)micsElement));
                }
            } else if (object == this.btnPrint) {
                int n = 0;
                try {
                    n = DataUtil.parseInt(this.fieldAddr.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Illegal address format.");
                }
                System.out.println("Read Memory: " + this.getSelectedElement().id());
                System.out.println("From = " + n);
                System.out.println(((DataBuffer)((Object)this.getSelectedElement())).toString(n, 4));
            }
        }
    }

    public MicsArchitectureViewer.ViwerCanvas canvas() {
        return this.canvas;
    }

    class ArchitectureCanvas
    extends Canvas
    implements MouseListener,
    MouseMotionListener,
    MicsArchitectureViewer.ViwerCanvas {
        private Hashtable imageTable = new Hashtable();
        private Image buf = null;
        private int bufWidth;
        private int bufHeight;
        private Graphics g;
        private int selectedOffsetY;
        private int selectedOffsetX;

        public ArchitectureCanvas() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (this.buf == null) {
                this.buf = this.createImage(this.getWidth(), this.getHeight());
                this.bufWidth = this.getWidth();
                this.bufHeight = this.getHeight();
            } else if (this.bufWidth != this.getWidth() || this.bufHeight != this.getHeight()) {
                this.buf = null;
                this.buf = this.createImage(this.getWidth(), this.getHeight());
            }
            Graphics graphics2 = this.buf.getGraphics();
            graphics2.setColor(Color.WHITE);
            graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.g = graphics2;
            AWTArchitectureViewer.this.paint();
            graphics.drawImage(this.buf, 0, 0, this);
            AWTArchitectureViewer.this.pane.doLayout();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AWTArchitectureViewer.this.setSelectedNode(mouseEvent.getX(), mouseEvent.getY());
            this.repaint();
            if (AWTArchitectureViewer.this.selectedNode != null) {
                this.selectedOffsetX = ((AWTArchitectureViewer)AWTArchitectureViewer.this).selectedNode.X - mouseEvent.getX();
                this.selectedOffsetY = ((AWTArchitectureViewer)AWTArchitectureViewer.this).selectedNode.Y - mouseEvent.getY();
                AWTArchitectureViewer.this.setSelectedElement(((AWTArchitectureViewer)AWTArchitectureViewer.this).selectedNode.element);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (AWTArchitectureViewer.this.selectedNode != null) {
                AWTArchitectureViewer.this.selectedNode.setPosition(mouseEvent.getX() + this.selectedOffsetX, mouseEvent.getY() + this.selectedOffsetY);
                this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void drawImage(String string, int n, int n2, int n3, int n4) {
            if (!this.imageTable.containsKey(string)) {
                Image image;
                File file = new File(string);
                if (file.exists()) {
                    image = this.getToolkit().getImage(file.getAbsolutePath());
                    System.out.println(file.getAbsolutePath());
                } else {
                    image = this.getToolkit().getImage(this.getClass().getClassLoader().getResource(string));
                }
                this.imageTable.put(string, image);
            }
            this.g.drawImage((Image)this.imageTable.get(string), n, n2, n3, n4, this);
        }

        public void drawLine(int n, int n2, int n3, int n4) {
            this.g.drawLine(n, n2, n3, n4);
        }

        public void drawRect(int n, int n2, int n3, int n4) {
            this.g.drawRect(n, n2, n3, n4);
        }

        public void drawString(String string, int n, int n2) {
            this.g.drawString(string, n, n2);
        }

        public void fillRect(int n, int n2, int n3, int n4) {
            this.g.fillRect(n, n2, n3, n4);
        }

        public int height() {
            return this.getBounds().height;
        }

        public void setBGColor() {
            this.g.setColor(Color.gray);
        }

        public void setColorBlack() {
            this.g.setColor(Color.black);
        }

        public void setColorRed() {
            this.g.setColor(Color.red);
        }

        public void setFGColor() {
            this.g.setColor(Color.black);
        }

        public int width() {
            return this.getBounds().width;
        }
    }
}

